#include "stdafx.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
//#include <fcntl.h>
//#include <unistd.h>
//#include <errno.h>
//#include <pthread.h>
//#include <tgmath.h>
//#include <sys/io.h>

#include "psparser.h"

#define MAX_CHANNEL   16
#define MAX_PES_LENG  (256*1024)
//#define MAX_INDEX     (30*60*480)    // 30 frames * 60 sec. * 480 min. = 4 hour
//#define MAX_BUF_SIZE  (MAX_INDEX*16) // considering of idx1 chunk
#define MAX_BUF_SIZE	64	//This module uses 4 bytes only

typedef struct	ADPCMState	ADPCMState ;
typedef 	ADPCMState	*ADPCMStatePtr ;


/* ADPCMState struct */
struct ADPCMState {
    int  stepIndex ;
    int  prediction ;
} ;

#define ADPCM_BUFFER_SIZE    512
#define ADPCM_BLOCK_SIZE     252

/* define the maximum number of bits for a PCM value */
#define	MAXBITS	16


typedef struct
{
    BYTE	*src_frame_buf;
    int		src_frame_size;
    
    BYTE	*dst_frame_buf;
    int		dst_frame_size;
    int		dst_frame_buf_max_length;

    BYTE 	*gbuf;
    BYTE 	*pgbuf;
    
    // ADPCM
    ADPCMState	state;
    BYTE	*adpcmbuf;
    int		remained_bytes;
} PSPARSER_INFO;


#if 1
static unsigned long movi_list(PSPARSER_INFO *ps);
static void init_gbuf(PSPARSER_INFO *ps);
static void putint(PSPARSER_INFO *ps, long size, unsigned long dw);
static void put4cc(PSPARSER_INFO *ps, char *str);
static void write_gbuf(PSPARSER_INFO *ps, long size);
static void adpcm_block_process(PSPARSER_INFO *ps);
static int DecodeADPCMC( int adpcmSample, ADPCMStatePtr decodeStatePtr );
#endif	//#if 0

DWORD PSParser_New (void)
{
	PSPARSER_INFO *ps = (PSPARSER_INFO *) new (PSPARSER_INFO);
	if (!ps)
		return ((DWORD) 0);

	memset ((BYTE *) ps, 0, sizeof(PSPARSER_INFO));

	ps->src_frame_size = 0;
    	ps->src_frame_buf = new BYTE[MAX_PES_LENG];
    	if (ps->src_frame_buf == NULL)
	    	goto err_exit;

	ps->dst_frame_size = 0;
    	ps->dst_frame_buf = (BYTE *) NULL;
	ps->dst_frame_buf_max_length = 0;

	ps->gbuf = new BYTE[MAX_BUF_SIZE];
    	if (ps->gbuf == NULL)
		goto err_exit;
		
	ps->adpcmbuf = (BYTE *) new BYTE[ADPCM_BUFFER_SIZE];
	if (ps->adpcmbuf == NULL)
		goto err_exit;
		
	ps->state.prediction = 0;
  	ps->state.stepIndex = 0;
  	ps->remained_bytes = 0;

	return ((DWORD) ps);

err_exit:
	if (ps->src_frame_buf)
		delete [] ps->src_frame_buf;
		
	if (ps->gbuf)
		delete [] ps->gbuf;
	
	if (ps->adpcmbuf)
		delete [] ps->adpcmbuf;
		
	if (ps)
		delete ps;
		
	return ((DWORD) 0);
}


void PSParser_Free (DWORD hHandle)
{
	if (!hHandle)
		return;
		
	PSPARSER_INFO *ps = (PSPARSER_INFO *) hHandle;

	if (ps)
	{
		if (ps->src_frame_buf)
			delete [] ps->src_frame_buf;

		if (ps->gbuf)
			delete [] ps->gbuf;
			
		if (ps->adpcmbuf)
			delete [] ps->adpcmbuf;

		delete ps;		
	}	
}


int PSParser_Parse (DWORD hHandle, BYTE *src, int src_len, BYTE *dst, int *dst_len, int *frame_type)
// [return] if error return -1, else return source number
//          frame_type: 0=>video 1=>audio
{
	int type;
	
	if (!hHandle)
		return -1;
		
	if (!src || !src_len || !dst || !*dst_len)
		return -1;
	
	if (src_len > MAX_PES_LENG)
		return -1;

	PSPARSER_INFO *ps = (PSPARSER_INFO *) hHandle;
	
	memcpy (ps->src_frame_buf, src, src_len);
	ps->src_frame_size = src_len;
	ps->dst_frame_buf = dst;
	ps->dst_frame_size = 0;
	ps->dst_frame_buf_max_length = *dst_len;
	
	unsigned char *pes = ps->src_frame_buf;	
      	unsigned long buf = (pes[0]<<16) | (pes[1]<<8) | (pes[2]);
	
	if (buf!=0x000001 || ((pes[3]>>4)!=0xC && (pes[3]>>4)!=0xE))
	        return FALSE;
	
	int source = pes[3] & 0x0F;
	*frame_type = ((pes[3]>>4)==0xC);
	type = movi_list(ps);
	
	if (ps->dst_frame_size > ps->dst_frame_buf_max_length)
		goto exit;
	else
	{
		*(DWORD *) dst = ps->dst_frame_size;
		*dst_len = ps->dst_frame_size + 4;
	}
		
	return source;

exit:
	return -1;
}


static unsigned long movi_list(PSPARSER_INFO *ps)
// [return] 0: audio	1: video
{
  	unsigned char *src, *dst;
  	int i, hdr_size;
  	int video_packet_flag, adpcm_flag;
  	int loop, remained = 0;
  	unsigned char *pes = ps->src_frame_buf;
      	int           size = ps->src_frame_size;

  	
  	/* remove last zeros if video */
  	video_packet_flag = (pes[3]>>4)==0xE;
  	if (video_packet_flag)
  	{
    		for (i=size-1; i>=0; i--)
    		{
      			if (pes[i])
        			break;
        	}
    		size = i + 1;
  	}

  	/* sub pes packet header */
  	hdr_size = 9 + pes[8];
  	size -= hdr_size; 

  	/* calculate loop count */
  	adpcm_flag = !video_packet_flag;
  	if (adpcm_flag)
  	{
    		loop = (ps->remained_bytes + size) / ADPCM_BLOCK_SIZE;
	    	remained = (ps->remained_bytes + size) % ADPCM_BLOCK_SIZE;
    		src = pes + hdr_size;
  	}
  	else
    		loop = 1;

  	/* loop */
  	for (i=0; i<loop; i++)
  	{
    		// adpcm processing
    		if (adpcm_flag)
    		{
      			size = ADPCM_BLOCK_SIZE + 4;
  
      			dst = ps->adpcmbuf + (4 + ps->remained_bytes);
      			memcpy(dst, src, sizeof(char)*(ADPCM_BLOCK_SIZE-ps->remained_bytes));

      			adpcm_block_process(ps);

      			src += (ADPCM_BLOCK_SIZE - ps->remained_bytes);
      			ps->remained_bytes = 0;
    		}

    		init_gbuf(ps);

		// in the future, if the frame rate can set to zero
		// please reference the original source code to modify
    		put4cc(ps, video_packet_flag ? (char*)"00dc" : (char*)"01wb");
    		//putint(ps, 4, size);
   		//write_gbuf(ps, 8);
   		write_gbuf(ps, 4);

    		/* movi data */
    		if (adpcm_flag)
    		{
      			memcpy (ps->dst_frame_buf+ps->dst_frame_size, ps->adpcmbuf, 
      				sizeof(char)*(ADPCM_BLOCK_SIZE+4));
      			ps->dst_frame_size += ADPCM_BLOCK_SIZE+4;
      		}
    		else
    		{
      			memcpy (ps->dst_frame_buf+ps->dst_frame_size, pes+hdr_size, 
      				sizeof(char)*size);
      			ps->dst_frame_size += size;
      		}

  	} // end for loop

  	if (adpcm_flag)
  	{
    		memcpy(ps->adpcmbuf + (4 + ps->remained_bytes), src, sizeof(char)*remained);
    		ps->remained_bytes = remained;
  	}

  	return video_packet_flag;
}

static void init_gbuf(PSPARSER_INFO *ps)
{
  	ps->pgbuf = ps->gbuf;
}


static void putint(PSPARSER_INFO *ps, long size, unsigned long dw)
{
  	int i;

  	for (i=0; i<size; i++)
    		*ps->pgbuf++ = (BYTE) ((dw >> (i<<3)) & 0xff);
}


static void put4cc(PSPARSER_INFO *ps, char *str)
{
  	int i;

  	for (i=0; i<4; i++)
    		*ps->pgbuf++ = (BYTE)str[i];
}


static void write_gbuf(PSPARSER_INFO *ps, long size)
{
  	memcpy (ps->dst_frame_buf+ps->dst_frame_size, ps->gbuf, sizeof(char)*size);
  	ps->dst_frame_size += size;
}



/* ------------------------------------------------------------------------ */
/*                                                                          */
/* IMA/DVI ADPCM Decoidng Functions                                         */
/*                                                                          */
/* ------------------------------------------------------------------------ */

/*
 * Adaptive Differential Pulse Code Modulation C tests
 * Copyright (C) ARM Limited 1998-1999. All rights reserved.
 */

static const int indexTable[ 16 ] = {
	-1, -1, -1, -1, 2, 4, 6, 8,
	-1, -1, -1, -1, 2, 4, 6, 8
} ;
/* define an array of index adjustments to the step index value */

#define	MAXSTEPINDEX	88
/* define the maximum value to access the top element of stepSizeTable below */

static const int stepSizeTable[ MAXSTEPINDEX + 1 ] = {
	    7,     8,     9,    10,    11,    12,    13,    14,    16,    17,
	   19,    21,    23,    25,    28,    31,    34,    37,    41,    45,
	   50,    55,    60,    66,    73,    80,    88,    97,   107,   118,
	  130,   143,   157,   173,   190,   209,   230,   253,   279,   307,
	  337,   371,   408,   449,   494,   544,   598,   658,   724,   796,
	  876,   963,  1060,  1166,  1282,  1411,  1552,  1707,  1878,  2066,
	 2272,  2499,  2749,  3024,  3327,  3660,  4026,  4428,  4871,  5358,
	 5894,  6484,  7132,  7845,  8630,  9493, 10442, 11487, 12635, 13899,
	15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794, 32767
} ;
/* define an array containing the step sizes that are available */

/**** DecodeADPCMC ******************************************************************
 *
 * Version & Date
 * -------   ----
 * 1.0.0, 30/06/1998
 *
 * Description
 * -----------
 * decode the current adpcm value to its (approximate) pcm value given a required
 * internal structure
 *
 * Inputs
 * ------
 *   adpcmSample
 *   - the adpcm sample to decode based on the previous decoded sample
 *     the sample should be unsigned 4-bit and thus be a value between 0 and 15 only 
 *     with the top bit indicating the sign
 *   decodeStatePtr
 *   - a pointer to an ADPCMState structure that contains the index to lookup
 *     in the step size table and the prediction for the current decoded sample
 *     (which is equivalent to the previous decoded sample)
 *     for the first call in a sequence the stepIndex and prediction should be 0
 *     thereafter they should be maintained between function calls with the values
 *     that are placed in the structure during each function call
 * Outputs
 * -------
 *   decodeStatePtr
 *   - the updated state structure containing the values necessary for the next 
 *     instance of the function call
 * Return Values
 * ------ ------
 *     int	- the adpcm sample decoded to its (approximate) pcm value
 *
 * Notes
 * -----
 * if the structure is not intialised for the first function call in a sequence
 * or is not maintained with the values returned between function calls the result
 * will not be correct
 *
 * History (with dates)
 * -------  ---- -----
 * 1.0.0, 30/06/1998    first release
 *
 ************************************************************************************/


static void adpcm_block_process(PSPARSER_INFO *ps)
{
  	unsigned char *pbuf, c;
  	int i;

  	pbuf = ps->adpcmbuf;

  	*(pbuf++) = (ps->state.prediction) & 0xff;
  	*(pbuf++) = (ps->state.prediction>>8) & 0xff;
  	*(pbuf++) = ps->state.stepIndex;
  	*(pbuf++) = 0;

  	for (i=0; i<ADPCM_BLOCK_SIZE; i++)
  	{
    		DecodeADPCMC( ((*pbuf>>4) & 0xf), &(ps->state) ) ;
    		DecodeADPCMC( ((*pbuf) & 0xf), &(ps->state) ) ;

    		c = *pbuf;
    		*pbuf = ((c&0xf)<<4) | ((c>>4)&0xf);
    		pbuf++;
  	}
}


static int DecodeADPCMC( int adpcmSample, ADPCMStatePtr decodeStatePtr )
{
	int	step ;
	int	delta ;
	int	predictionAdjustment ;
	
	if( ( adpcmSample < 0 ) || ( adpcmSample > 15 ) ) {
		fprintf( stderr, "[DecodeADPCMC] Error in ADPCM sample, aborting.\n\n" ) ;
		// function name given since intended as internal error for programmer
		return 0 ;
	}
	
	if( !decodeStatePtr ) {
		fprintf( stderr, "[DecodeADPCMC] Error in ADPCMState, aborting.\n\n" ) ;
		// function name given since intended as internal error for programmer
		return 0 ;
	}
		
	step = stepSizeTable[ decodeStatePtr->stepIndex ] ;
	
	delta = adpcmSample ;

	decodeStatePtr->stepIndex += indexTable[ delta ] ;
	// range check the stepIndex 
	if( decodeStatePtr->stepIndex < 0 ) {
		decodeStatePtr->stepIndex = 0 ;
	}
	else if( decodeStatePtr->stepIndex > MAXSTEPINDEX ) {
		decodeStatePtr->stepIndex = MAXSTEPINDEX ;
	}

	// remove sign from delta - pull to 3-bit 
	if( delta > 7 ) {
		delta -= 8 ;
	}
	
	predictionAdjustment = ( 2*delta + 1 )* step/8 ;
	if( adpcmSample > 7 ) {
		decodeStatePtr->prediction -= predictionAdjustment ;
	}
	else {
		decodeStatePtr->prediction += predictionAdjustment ;
	}
	
	// range check the prediction so that fits in number of bits
	if( decodeStatePtr->prediction > ( 1 << ( MAXBITS - 1 ) ) - 1 ) {
		decodeStatePtr->prediction = ( 1 << ( MAXBITS - 1 ) ) - 1 ;
	}
	else if( decodeStatePtr->prediction < -( 1 << ( MAXBITS - 1 ) ) ) {
		decodeStatePtr->prediction = -( 1 << ( MAXBITS - 1 ) ) ;
	}

	return decodeStatePtr->prediction ;

}

