

#ifndef _CVT_HMP4_H_
#define _CVT_HMP4_H_

#include "Idecoder.h"
#include "DECVWEB.h"

typedef struct tagOLD_HEADER_1
{
    BYTE    sync1; 
    BYTE    size_hh;
    BYTE    sync2;           
    BYTE    size_hl;
    BYTE    sync3;                 
    BYTE    time_hh;
    BYTE    sync4;                      
    BYTE    time_hl;
    BYTE    flag;                       
    BYTE    time_lh;
    BYTE    res1;                       
    BYTE    time_ll;
    BYTE    sync5;                     
    BYTE    res2;                      

} OLD_HEADER_1, * LPOLD_HEADER_1;

typedef struct tagWebVdo_ExtendInfo
{
    WORD    year;
    BYTE    month;
    BYTE    day;
    BYTE    hour;
    BYTE    minute;
    BYTE    second;
    BYTE    timestamp_parm; 
    DWORD   reserved;
}WEBVDO_EXTENDINFO, *LPWEBVDO_EXTENDINFO;

class CVTHMP4 : public Idecoder
{
public:
    static Idecoder *CreateDecoder(void);
    
    CVTHMP4 ();
    ~CVTHMP4 ();

    BOOL     Convert (void);
	BOOL     FrameAvail (char *pBuf, char **frm, DWORD *size, 
		                 BOOL *pNew, DWORD *dwTimeStamp);
	void     Init ( LPCTSTR src_filename, HWND hWnd );
	void     Exit ( void );
	void     ScaleBMP(BYTE *pBMPBuf);

private:
	DECVWEB  *m_pDec;
	BOOL	 m_bFirst;
	char	 readbuf[100*1024+1], decbuf[200*1024+2];

private:
	long     match_vweb_header_pattern ( BYTE * data, long len, BOOL * new_header );
};

#endif  //_CVT_HMP4_H_
