#include "stdafx.h"
#include "resource.h"
#include "Idecoder.h"
#include "nwj.h"

#define JPEG_NEW_HEADER_SIZE         14
#define JPEG_CHDR_SIZE               12

Idecoder *CVTJPEG::CreateDecoder(void)
{
    CVTJPEG *pp = new CVTJPEG;
    return pp;
}


//===========================================================
CVTJPEG::CVTJPEG()
{
}

CVTJPEG::~CVTJPEG()
{
}

void CVTJPEG::Init ( LPCTSTR src_filename, HWND hWnd )
{
	CString s;

    m_SrcFilename  = src_filename;
  
	m_iBufCount    = 0;
	m_iHeadPos     = 0;
	m_iIsCodecOk   = 0;
	m_BitRate      = 30;

	m_hFile = CreateFile(m_SrcFilename, GENERIC_READ, 0, NULL, 
		                 OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	
	if(m_hFile == INVALID_HANDLE_VALUE)
	{
		s=src_filename;
		s+=" !";
		AfxMessageBox(s);
		return;
	}

	JDEC_Init();
	m_pDec = NULL;
	m_pDec = JDEC_New (320, 240);

	if (!m_pDec)
	{
		CloseHandle(m_hFile);
		return;
	}
	JDEC_Draw_Init(m_pDec, hWnd);
	JDEC_show(m_pDec, TRUE);
}

void CVTJPEG::Exit ( void )
{
	if (!m_pDec) return;

	CloseHandle(m_hFile);

	JDEC_Draw_Exit (m_pDec);
	JDEC_Free (m_pDec);
	JDEC_Exit ();
}

BOOL CVTJPEG::Convert (void)
{
	CString  s;
	char     *from, *frame;
	int      count, receive=0, i;
	BOOL     bNewFrame, doit=FALSE;
	DWORD    dwTimeStamp, remain=0;
	DWORD    readcount=0, frame_size, bmp_size, width, height;
	BYTE     *pbmp=NULL;

	m_iIsCodecOk = 1;

	if( ReadFile(m_hFile, &readbuf, 102400, &readcount, NULL) && (readcount != 0))
	{
		memcpy(decbuf+m_iBufCount, readbuf, readcount);
		m_iBufCount+=readcount;
		while  (FrameAvail(decbuf, &frame, &frame_size, &bNewFrame, &dwTimeStamp))
		{
			i = JDEC_Receive_Data(m_pDec, frame_size, frame, &receive);
			if (i == 0)
				AfxMessageBox("Get data error");
			else
			{
				int mem_size;

				JDEC_get_size(m_pDec, &width, &height);
				bmp_size = sizeof ( BITMAPFILEHEADER ) + sizeof(BITMAPINFOHEADER)  +  width * height * 3;
				mem_size = sizeof ( BITMAPFILEHEADER ) + sizeof(BITMAPINFOHEADER)  +  1024 * 768 * 3;

				if (!pbmp) pbmp = new unsigned char[mem_size];
				if (!pbmp)
				{
					m_iIsCodecOk = 0;
					break;
				}

				// Get BMP !
				if (!JDEC_get_decompressed_bitmap_ex2(m_pDec, pbmp, bmp_size))
					AfxMessageBox("Get BMP error");
				
				
				from = decbuf + frame_size;
				count = m_iBufCount - frame_size;
				if (count > 0)
					memcpy(decbuf, from, count);
				m_iBufCount = count;
			}
		}//  (FrameAvailJPEG
		doit=TRUE;
	}

	if (doit==FALSE) m_iIsCodecOk=0;
    
	if (pbmp)
		delete pbmp;

	return m_iIsCodecOk;
}

BOOL CVTJPEG::FrameAvail (char *pBuf, char **frm, DWORD *size, 
		                  BOOL *pNew, DWORD *dwTimeStamp)
{
	if (m_iBufCount < (JPEG_NEW_HEADER_SIZE+JPEG_CHDR_SIZE))
		return FALSE;

	BOOL new_header, jfif;
	long offset;
	BYTE frame_size[4];
	BYTE time_stamp[4];
	int nFrameSize;

	offset = match_jpeg_header_pattern((BYTE*)pBuf, m_iBufCount, &jfif, &new_header );
	
    if ( offset < 0 )
    {
		//offset < 0 because not enough data in the buffer. receive more and check again.
		//m_iHeadPos = 0;
		//m_iBufCount = 0;
		return FALSE;
    }
	else if (offset > 0)
	{
	    m_iBufCount -= offset;
		memcpy(pBuf, pBuf+offset, m_iBufCount);
	}
	*dwTimeStamp = 0;

	if (jfif)
	{
		offset = search_jfif_eof((BYTE *)pBuf, m_iBufCount);
		if (offset < 0)
			return FALSE;
		nFrameSize = offset + 2;
	}
	else
	{
		if (new_header)
		{
			frame_size[0] = pBuf[16];
			frame_size[1] = pBuf[17];
			frame_size[2] = pBuf[3];
			frame_size[3] = pBuf[1];
			nFrameSize = (int)(*(DWORD*)frame_size);				
			nFrameSize += JPEG_NEW_HEADER_SIZE + JPEG_CHDR_SIZE;

			time_stamp[0] = pBuf[11];
			time_stamp[1] = pBuf[9];
			time_stamp[2] = pBuf[7];
			time_stamp[3] = pBuf[5];
		    *dwTimeStamp = (DWORD)(*(DWORD*)time_stamp);
		}
		else
			nFrameSize = (int)(*(WORD*)pBuf) + JPEG_CHDR_SIZE;

		if ( nFrameSize <= 0 )
		{
			m_iBufCount = 0;
			return FALSE;
		}
	}

	if (m_iBufCount >= nFrameSize)
	{
		*frm = pBuf;
		*size = nFrameSize;

		*pNew = new_header ? TRUE : FALSE;
		return TRUE;
	}
	else
		return FALSE;
}

//===========================================================
long CVTJPEG::search_jfif_eof(const BYTE * data, long len )
{
    long    i;

    for ( i = 0; i < len - 1; i ++ )
    {
        if ( data [ i ] != 0xFF ) continue;
        if ( data [ i + 1 ] != 0xD9 ) continue;
        return ( i );
    }
    return ( -1 );
}

long CVTJPEG::match_jpeg_header_pattern(const BYTE * data, long len, BOOL * jfif, 
										BOOL * new_header )
{
    long    i;

    for ( i = 0; i < len - JPEG_CHDR_SIZE + 1; i ++ )
    {
        if ( data [ i ] != 0xFF ) continue;

        if ( data [ i + 1 ]   != 0xD8 ||
             data [ i + 10 ]  != 0xFF ||
             data [ i + 11 ]  != 0xD9     )
        {
            if ( data [ i + 1 ]  != 0xD8 ||
                 data [ i + 2 ]  != 0xFF ||
                 data [ i + 3 ]  != 0xE0 ||
                 data [ i + 4 ]  != 0x00 ||
                 data [ i + 5 ]  != 0x10 ||
                 data [ i + 6 ]  != 0x4A ||
                 data [ i + 7 ]  != 0x46 ||
                 data [ i + 8 ]  != 0x49 ||
                 data [ i + 9 ]  != 0x46 )
            {
                i ++;
                continue;
            }
            else
            {
                if ( len - i < 623 + 2 ) continue;
                if ( data [ i + 158 ] != 0xFF ||
                     data [ i + 159 ] != 0xC0 ||
                     data [ i + 20  ] != 0xFF ||
                     data [ i + 21  ] != 0xDB ||
                     data [ i + 609 ] != 0xFF ||
                     data [ i + 610 ] != 0xDA ) continue;

                * jfif = TRUE;
				* new_header = FALSE;
                return ( i );
            }
        }

		if ( i < JPEG_NEW_HEADER_SIZE )
		{
			*new_header = FALSE;
		}
		else
		{
			if ( (data [ i - 14 ] == 0xF6) && (data [ i - 12 ] == 0xFF) &&
				 (data [ i - 10 ] == 0xF9) && (data [ i - 8 ] == 0xDD) &&
				 (data [ i - 2 ] == 0xC5) )
			{
				*new_header = TRUE;
				i -= JPEG_NEW_HEADER_SIZE;
			}
			else
				*new_header = FALSE;
		}
        * jfif = FALSE;
        return ( i );
    }
    return ( -1 );
}