#include "stdafx.h"
#include "DEC263.h"
#include "resource.h"
#include "Idecoder.h"
#include "nw5.h"
#include "nw4.h"

#define H263_NEW_HEADER_SIZE   14	// new frame header
#define H263_HEADER_SIZE		5	// old frame header
#define SKL4_NEW_HEADER_SIZE   18       // new frame header

Idecoder *CVTSMP4::CreateDecoder(void)
{
    CVTSMP4 *pp = new CVTSMP4;
    return pp;
}


//===========================================================
// Public member
CVTSMP4::CVTSMP4()
{
}

CVTSMP4::~CVTSMP4()
{
}

void CVTSMP4::Init ( LPCTSTR src_filename, HWND hWnd )
{
	CString s;

    m_SrcFilename  = src_filename;
    

	m_iBufCount    = 0;
	m_iHeadPos     = 0;
	m_iIsCodecOk   = 0;
	m_BitRate      = 30;

	m_hFile = CreateFile(m_SrcFilename, GENERIC_READ, 0, NULL, 
		                 OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	
	if(m_hFile == INVALID_HANDLE_VALUE)
	{
		s=src_filename;
		s+=" !";
		AfxMessageBox(s);
		return;
	}

	decsk4_initialize();
	m_pDec = NULL;
	m_pDec = decsk4_new ();

	if (!m_pDec)
	{
		CloseHandle(m_hFile);
		return;
	}
	decsk4_draw_init(m_pDec, hWnd);
}

void CVTSMP4::Exit ( void )
{
	if (!m_pDec) return;

	CloseHandle(m_hFile);

	decsk4_draw_exit (m_pDec);
	decsk4_free (m_pDec);
	decsk4_terminate();
}

BOOL CVTSMP4::Convert (void)
{
	DWORD readcount=0, dwTimeStamp, odwTimeStamp = 0, remain = 0;
	DWORD bmp_size, width, height;
	unsigned char *pbmp=NULL;
	CString s;
	BOOL doit=FALSE;
	
	pbmp = NULL;
	dwTimeStamp = 0;

	m_iIsCodecOk = 1;

	if( ReadFile(m_hFile, readbuf, sizeof(readbuf), &readcount, NULL) && (readcount != 0))
	{
		char *frame;
		DWORD frame_size;
		BOOL  new_frame;

		memcpy(decbuf+m_iBufCount, readbuf, readcount);
		m_iBufCount+=readcount;

		while (FrameAvail(decbuf, &frame, &frame_size, &new_frame, &dwTimeStamp))
		{
			if (decsk4_receive_data(m_pDec, frame_size, frame, 1) > 0)
			{
				decsk4_get_size(m_pDec, &width, &height);

				if (!pbmp)
				{
					int mem_size;

					bmp_size = sizeof ( BITMAPFILEHEADER ) + sizeof(BITMAPINFOHEADER)  +  width * height * 3;
					mem_size = sizeof ( BITMAPFILEHEADER ) + sizeof(BITMAPINFOHEADER)  +  1024 * 768 * 3;

					pbmp = new unsigned char[mem_size];
					if (!pbmp)
					{
						m_iIsCodecOk = 0;
						break;
					}
				}

				if (!decsk4_get_decompressed_bitmap_ex2(m_pDec, pbmp, bmp_size))
					AfxMessageBox("Get BMP error!");
				

			}//if (desk4_receive_data
			int left = m_iBufCount - frame_size;
			if (left > 0)
			{
				memcpy(decbuf, frame+frame_size, left);
				m_iBufCount = left;
			}
			else
				m_iBufCount = 0;
		} // while FrameAvail
		doit=TRUE;
	} // ReadFile(

	if (doit==FALSE) m_iIsCodecOk=0;

	if (pbmp)
		delete pbmp;
	
	return m_iIsCodecOk;
}

BOOL CVTSMP4::FrameAvail (char *pBuf, char **frm, DWORD *size, 
		                 BOOL *pNew, DWORD *dwTimeStamp)
{
	if (m_iBufCount - m_iHeadPos < (H263_NEW_HEADER_SIZE+H263_HEADER_SIZE))
		return FALSE;

	BOOL new_header;
	long offset;
	BYTE frame_size[4];
	int nFrameSize;

    offset = match_mpeg4_header_pattern((BYTE*)(pBuf+m_iHeadPos), m_iBufCount, &new_header );

    if ( offset < 0 )
    {
		//offset < 0 because not enough data in the buffer. receive more and check again.
		//m_iHeadPos = 0;
		//m_iBufCount = 0;
		return FALSE;
    }
	else if (offset >= 0)
	{
		BYTE *pb;
        if (new_header)
        {
            pb = (BYTE*) pBuf+m_iHeadPos+offset; //-18;
            frame_size[0] = pb[14];
            frame_size[1] = pb[15];
            frame_size[2] = pb[3];
            frame_size[3] = pb[1];
            nFrameSize = (int)(*(DWORD*)frame_size);
            nFrameSize += SKL4_NEW_HEADER_SIZE;
        }
        else
        {
            pb = (BYTE*) pBuf+m_iHeadPos+offset;
            nFrameSize = (int)(*(WORD*)pb);
        }

	    m_iBufCount -= offset;
		memcpy(pBuf, pBuf+m_iHeadPos+offset, m_iBufCount);
		m_iHeadPos = 0;
	}

	*dwTimeStamp = 0;


	if ( nFrameSize <= 0 )		// to avoid getting the wrong header
	{
		m_iBufCount = 0;
		m_iHeadPos = 0;
		return FALSE;
	}
	if (m_iBufCount >= (int)nFrameSize)
	{
		*frm = pBuf + m_iHeadPos;
		*size = nFrameSize;
		
		*pNew = new_header ? TRUE : FALSE;

		return TRUE;
	}
	else
		return FALSE;	
}

long CVTSMP4::match_mpeg4_header_pattern ( BYTE * data, long len, BOOL * new_header )
{
    long    i;

    for ( i = 0; i <= len - H263_HEADER_SIZE; i ++ )
    {
        // match ss ss PSC ==> ss ss 00 00 ( 1xxx xxxx )
        if ( data [ i + 0 ] != 0x00 ) continue;
        if ( data [ i + 1 ] != 0x00 ) continue;
        if ( data [ i + 2 ] != 0x01 ) continue;
//        if ( (data [ i + 5 ] & 0xF0) != 0xB0 ) continue;

        // match !
                // check if having new header
                if ( i < SKL4_NEW_HEADER_SIZE )
                {
                        *new_header = FALSE;
                }
                else
                {
                        if ( (data [ i - 18 ] == 0xF6) && (data [ i - 16 ] == 0xFF) &&
                             (data [ i - 14 ] == 0xF9) && (data [ i - 12 ] == 0xDD) &&
                             (data [ i - 6 ] == 0xC5) )
                        {
                                *new_header = TRUE;
                                i -= 18;
                        }
                        else
                                *new_header = FALSE;
                }
        return ( i );
    }

    // no match
    return ( -1 );
}
