//
//  Filename: dcoder.h
//  Version : V1.0
//  Date    : Sep 20, 2006
//  Note    : Idecoder Data Structure / Function Abstraction
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#ifndef _DECODER_H_
#define _DECODER_H_

#include <Vfw.h>
#include "frmdef.h"
#include "DEC263.h"
#include "JDEC.h"
#include "DECMP4.h"
#include "DECSK4.h"
#include "DECVWEB.h"

class decoder
{
public:
    decoder();
    virtual ~decoder() = 0;

    virtual void Init ( HWND hWnd );
	virtual void Exit ( void );
	virtual void ShowVideo ( int ShowVideo );
	virtual BOOL Decompress(char *frame, int frame_size, LPADV_HEADER pHeader);
    virtual BOOL GetBitmap(LPADV_HEADER pHeader, BYTE *pBMPBuf, DWORD dwBMPBufSize,
						   LPBITMAPINFOHEADER pBMPInfo);
	virtual void GetFrameSize(DWORD *width, DWORD *height);

	void ExpandBMP(BYTE *pBMPBuf);

};

class DECH263 : public decoder
{

public:

    DECH263();
    ~DECH263();

    void Init ( HWND hWnd );
	void Exit ( void );
	void ShowVideo ( int ShowVideo );
	BOOL Decompress(char *frame, int frame_size, LPADV_HEADER pHeader);
	BOOL GetBitmap(LPADV_HEADER pHeader, BYTE *pBMPBuf, DWORD dwBMPBufSize,
				   LPBITMAPINFOHEADER pBMPInfo);
	void GetFrameSize(DWORD *width, DWORD *height);

	static decoder *CreateDecoder(void);

	DEC263 *m_pDec;
};

class DECJPEG : public decoder
{

public:

    DECJPEG();
    ~DECJPEG();

    void Init ( HWND hWnd );
	void Exit ( void );
	void ShowVideo ( int ShowVideo );
	BOOL Decompress(char *frame, int frame_size, LPADV_HEADER pHeader);
	BOOL GetBitmap(LPADV_HEADER pHeader, BYTE *pBMPBuf, DWORD dwBMPBufSize,
		           LPBITMAPINFOHEADER pBMPInfo);
	void GetFrameSize(DWORD *width, DWORD *height);

	static decoder *CreateDecoder(void);

	JDEC *m_pDec;
};

class DECMPEG : public decoder
{

public:

    DECMPEG();
    ~DECMPEG();

    void Init ( HWND hWnd );
	void Exit ( void );
	void ShowVideo ( int ShowVideo );
	BOOL Decompress(char *frame, int frame_size, LPADV_HEADER pHeader);
	BOOL GetBitmap(LPADV_HEADER pHeader, BYTE *pBMPBuf, DWORD dwBMPBufSize,
		           LPBITMAPINFOHEADER pBMPInfo);
	void GetFrameSize(DWORD *width, DWORD *height);

	static decoder *CreateDecoder(void);

	DECMP4 *m_pDec;
};

class DECHMP4 : public decoder
{

public:

    DECHMP4();
    ~DECHMP4();

    void Init ( HWND hWnd );
	void Exit ( void );
	void ShowVideo ( int ShowVideo );
	BOOL Decompress(char *frame, int frame_size, LPADV_HEADER pHeader);
	BOOL GetBitmap(LPADV_HEADER pHeader, BYTE *pBMPBuf, DWORD dwBMPBufSize,
		           LPBITMAPINFOHEADER pBMPInfo);
	void GetFrameSize(DWORD *width, DWORD *height);
	BOOL Process41RTFrame(LPADV_HEADER pHeader);
	void PackNewHeader(ADV_HEADER *pHeader, int *pSize);
	void ScaleBMP(BYTE *pBMPBuf);

	static decoder *CreateDecoder(void);

	DECVWEB *m_pDec;
	BYTE	*m_PSParserBuf;
	DWORD	m_PSParser;
};

class DECSMP4 : public decoder
{

public:

    DECSMP4();
    ~DECSMP4();

    void Init ( HWND hWnd );
	void Exit ( void );
	void ShowVideo ( int ShowVideo );
	BOOL Decompress(char *frame, int frame_size, LPADV_HEADER pHeader);
	BOOL GetBitmap(LPADV_HEADER pHeader, BYTE *pBMPBuf, DWORD dwBMPBufSize,
		           LPBITMAPINFOHEADER pBMPInfo);
	void GetFrameSize(DWORD *width, DWORD *height);

	static decoder *CreateDecoder(void);

	DECSK4 *m_pDec;
};

#endif //#ifndef _dcoder_H_
