#include "stdafx.h"
#include "recfile2.h"
#include "frmdef.h"
#include "resource.h"
#include "decoder.h"
#include "Idecoder.h"
#include "d01.h"


typedef struct tagDecoder
{
    decoder*  (*pCreate)(void);
}CRTDECODER, *LPCRTDECODER;

static CRTDECODER g_Decoder[] = {
{DECH263::CreateDecoder},
{DECJPEG::CreateDecoder},
{DECMPEG::CreateDecoder},
{DECHMP4::CreateDecoder},
{DECSMP4::CreateDecoder},
};

#define CRTDECODER_COUNT  (sizeof(g_Decoder)/sizeof(CRTDECODER))

//===========================================================================

#define BITRATE 30

//===========================================================================
static PAVISTREAM ps = NULL, psCompressed = NULL;

static DWORD g_dwFileStartTime, g_dwFileEndTime;
static int iscodecok = 0;

static BYTE *g_pBMPBuf = NULL;
static DWORD g_dwBMPBufSize = 0;

static LPBITMAPINFOHEADER g_pBMPInfo=NULL;
static int g_nFrameNo;

static char *pFrameBuf=NULL, *frame=NULL;
static int nDvrFrameSize;
static HWND hWndtmp;
static BOOL first=TRUE;

static AVISTREAMINFO strhdr;
static DWORD odwTimeStamp;
static DWORD TimeStamp;
static DWORD remain = 0;
static AVICOMPRESSOPTIONS opts;
static AVICOMPRESSOPTIONS FAR * aopts[1] = {&opts};

//===========================================================================

Idecoder *CVTD01::CreateDecoder(void)
{
    CVTD01 *pp = new CVTD01;
    return pp;
}


//===========================================================
CVTD01::CVTD01()
{
	m_bNeedIntra = TRUE;
	m_pDec = NULL;
}

CVTD01::~CVTD01()
{
}

void CVTD01::Init ( LPCTSTR src_filename, HWND hWnd )
{
	CString s;
	int err_code;

	m_pDec = NULL;
	m_bNeedIntra = TRUE;

    m_SrcFilename  = src_filename;
	hWndtmp        = hWnd;

	m_iIsCodecOk   = 0;
	m_BitRate      = 30;

	iscodecok = 0;
	g_pBMPBuf = NULL;
	g_dwBMPBufSize = 0;
	g_pBMPInfo=NULL;
	first=TRUE;
	remain = 0;
	pFrameBuf=NULL;
	frame=NULL;

	g_nFrameNo = 0;
	odwTimeStamp = 0;
	TimeStamp = 0;

	pr = rcf_Open2(m_SrcFilename, &err_code);
	if (!pr)
	{
		return ;
	}

	if (!g_pBMPBuf)
	{
		g_dwBMPBufSize = sizeof ( BITMAPFILEHEADER ) + sizeof(BITMAPINFOHEADER)  +  1024 * 768 * 3;
		g_pBMPBuf = new unsigned char[g_dwBMPBufSize];
		if (!g_pBMPBuf)
			return;

		g_pBMPInfo = (LPBITMAPINFOHEADER) new char[g_dwBMPBufSize]; 
		if (!g_pBMPInfo)
		{
			delete g_pBMPBuf;
			g_pBMPBuf = NULL;
			return;
		}
	}

	InitFileInfo(pr);

	pFrameBuf = NULL;
	nDvrFrameSize = 0;

	iscodecok = 1;
}

void CVTD01::Exit ( void )
{
	if(pFrameBuf)
		free(pFrameBuf);
	rcf_Close2(pr);
	

	if (g_pBMPBuf)
	{
		delete g_pBMPBuf;
		g_pBMPBuf = NULL;
	}

	if (g_pBMPInfo)
	{
		delete g_pBMPInfo;
		g_pBMPInfo = NULL;
	}

    if (m_pDec) m_pDec->Exit();
}

void CVTD01::ScaleBMP(BYTE *pBMPBuf)
{
	g_pBMPInfo->biWidth = 640;
	g_pBMPInfo->biSizeImage *= 8/9;
}


BOOL CVTD01::Convert (void)
{
	int frametype;
	__int64 addr;
	CString s;
	DWORD frame_size;
	BOOL b;

	b = rcf_ReadVideoFrame2(pr, &pFrameBuf, &nDvrFrameSize, &addr);
	if(!b)
		return 0;

	pHeader = (LPADV_HEADER) pFrameBuf;  //must re-assign pointer!!

	if (pHeader->source != 0)  // Only Camera 1
	{
		return 1;
	}

	if (pHeader->flag&ADVH_FLAG_KEY_FRAME)
		m_bNeedIntra = FALSE;
		
	// need intra frame but this frame is not intra frame
	if (m_bNeedIntra && (pHeader->flag & ADVH_FLAG_KEY_FRAME) != ADVH_FLAG_KEY_FRAME )
		return 1;

	frametype = CheckAlgorithm(pHeader->type);
	if(frametype == -1)
		return 0;

	frame = pFrameBuf + sizeof(ADV_HEADER);
	frame_size = pHeader->size;

	if (!InitDecoder(frametype, hWndtmp))
		return 0;

	m_pDec->ShowVideo ( 1 );
	m_pDec->Decompress ( frame, frame_size, pHeader );
	m_pDec->GetBitmap ( pHeader, g_pBMPBuf, g_dwBMPBufSize, g_pBMPInfo );

	Sleep(30);

	return 1;
}

BOOL CVTD01::FrameAvail (char *pBuf, char **frm, DWORD *size, 
		                 BOOL *pNew, DWORD *dwTimeStamp)
{
	return 0;
}


void CVTD01::InitFileInfo(LPRECFILE2 pr)
{

}

//0: H.263, 1: JPEG, 2: Software MPEG4
int CVTD01::CheckAlgorithm(int type)
{
	WORD wFormat = LOWORD(type);

	if (wFormat == ADVH_TYPE_H263)
		return 0;
	else if (wFormat == ADVH_TYPE_JPEG || wFormat == ADVH_TYPE_MJPEG)
		return 1;
	else if (wFormat == ADVH_TYPE_XVD4)
		return 2;
	else if (wFormat == ADVH_TYPE_VWEB || wFormat == ADVH_TYPE_PENTA)
		return 3;
	else if (wFormat == ADVH_TYPE_SKL4)
		return 4;
	else
		return -1;
}

BOOL CVTD01::InitDecoder(int frametype, HWND hWnd)
{
    if (m_pDec) return TRUE;
    if (frametype >= CRTDECODER_COUNT) return FALSE;

	m_pDec = g_Decoder[frametype].pCreate();
    m_pDec->Init ( hWnd );

	return TRUE;
}
