// TestAppDecDLL.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include <process.h>
#include "TestAppDecDLL.h"
#include "TestAppDecDLLDlg.h"
#include "nw3.h"
#include "nwv.h"
#include "nw5.h"
#include "nw4.h"
#include "d01.h"
#include "nwj.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

typedef struct tagDecoder
{
    Idecoder*  (*pCreate)(void);
}CRTIDECODER, *LPCRTIDECODER;

static CRTIDECODER g_IDecoder[] = {
{CVT263::CreateDecoder},
{CVTJPEG::CreateDecoder},
{CVTMPEG4::CreateDecoder},
{CVTSMP4::CreateDecoder},
{CVTHMP4::CreateDecoder},
{CVTD01::CreateDecoder},
};

#define CRTIDECODER_COUNT  (sizeof(g_IDecoder)/sizeof(CRTIDECODER))

/////////////////////////////////////////////////////////////////////////////
// CTestAppDecDLLApp

BEGIN_MESSAGE_MAP(CTestAppDecDLLApp, CWinApp)
	//{{AFX_MSG_MAP(CTestAppDecDLLApp)
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTestAppDecDLLApp construction

CTestAppDecDLLApp::CTestAppDecDLLApp()
{
	m_bStart = FALSE;
	m_bEND = FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CTestAppDecDLLApp object

CTestAppDecDLLApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CTestAppDecDLLApp initialization

BOOL CTestAppDecDLLApp::InitInstance()
{
	// Standard initialization

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	CTestAppDecDLLDlg dlg;
	m_pMainWnd = &dlg;
	//int nResponse = dlg.DoModal();
    m_hThread = (HANDLE) _beginthreadex(NULL, 0x8000, 
				ThreadEntryPoint, (void *)this, 0,
				(UINT*)&m_dwThreadID);

	int nResponse = dlg.Create(IDD_TESTAPPDECDLL_DIALOG);
	Run();
	if (nResponse == IDOK)
	{
	}
	else if (nResponse == IDCANCEL)
	{
	}

	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	return FALSE;
}

unsigned __stdcall CTestAppDecDLLApp::ThreadEntryPoint( void * dummy ) 
{
	CTestAppDecDLLApp *pApp = (CTestAppDecDLLApp *)dummy;
	while (1)
	{ 
		pApp->OnmyIdle();
		if (pApp->m_bEND == TRUE) break;
	}
	_endthreadex(0);
	return 0;
}

BOOL CTestAppDecDLLApp::OnmyIdle(void)
{
	if (!m_bStart)
	{
		Sleep(10);
		return FALSE;
	}
	int ret = 0;
	
	if (!m_bEND) ret = m_pDec->Convert();

	if (ret==0)
	{   
		m_pDec->Exit();
	    StopConvert();
		m_bEND = TRUE;
	}
	return FALSE;
}

void CTestAppDecDLLApp::StartConvert(void)
{
	m_bStart = TRUE;
}

void CTestAppDecDLLApp::StopConvert(void)
{
	m_bStart = FALSE;
}

void CTestAppDecDLLApp::ConvertInit(LPCTSTR src_filename, int filetype, HWND hWnd)
{
	m_bEND = FALSE;

	if (m_pDec) return;

	switch (filetype)
	{
	case FILETYPE_RAW_H263:
		m_pDec = g_IDecoder[0].pCreate(); break;
	case FILETYPE_RAW_JPEG:
		m_pDec = g_IDecoder[1].pCreate(); break;
	case FILETYPE_RAW_MPEG4:
		m_pDec = g_IDecoder[2].pCreate(); break;
	case FILETYPE_RAW_SKL4:
		m_pDec = g_IDecoder[3].pCreate(); break;
	case FILETYPE_RAW_VWEB:
		m_pDec = g_IDecoder[4].pCreate(); break;
	case FILETYPE_DVR:
		m_pDec = g_IDecoder[5].pCreate(); break;
	default:
		return;
	}
    m_pDec->Init(src_filename, hWnd);
}
