//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//  Filename: JDEC.H
//  Version : V1.0
//  Date    : 05/30/1997
//  Note    : JDEC Data Structure / Function Abstraction
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#ifndef _JDEC_H_
#define _JDEC_H_

#ifdef _JDEC_IMPLEMENTATION_
#define JDECAPI __declspec(dllexport)
#else
#define JDECAPI __declspec(dllimport)
#endif

typedef void * JDEC;

#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif  /* __cplusplus */


//+=====================================================+
//*                 JDEC_Init                           *
//+=====================================================+
JDECAPI BOOL JDEC_Init ( void );
// initialize the JDEC module
// [in]-void
// [return]-TRUE if OK


//+=====================================================+
//*                 JDEC_Exit                           *
//+=====================================================+
JDECAPI void JDEC_Exit ( void );
// Terminate the JDEC module
// [in]-void
// [return]-void


//+=====================================================+
//*                 JDEC_New                            *
//+=====================================================+
JDECAPI JDEC * JDEC_New ( int image_width, int image_height );
// New an JDEC Object
// [in]-width and height of the source image
// [return]-JDEC *, NULL if error


//+=====================================================+
//*                 JDEC_Free                           *
//+=====================================================+
JDECAPI void JDEC_Free ( JDEC * pd );
// Free an JDEC Object
// [in]-JDEC *
// [return]-void


//+=====================================================+
//*                 JDEC_Flush                          *
//+=====================================================+
JDECAPI void JDEC_Flush ( JDEC * pd );
// Flush JDEC Buffer
// [in]-JDEC *
// [return]-void


//+=====================================================+
//*                 JDEC_Draw_Init                      *
//+=====================================================+
JDECAPI BOOL JDEC_Draw_Init ( JDEC * pd, HWND hWnd );
// initialize the JDEC drawing module
// [in]-hWnd of the window to be drawn
// [return]-TRUE if OK


//+=====================================================+
//*                 JDEC_Draw_Exit                      *
//+=====================================================+
JDECAPI void JDEC_Draw_Exit ( JDEC * pd );
// Terminate the JDEC Drawing module
// [in]-void
// [return]-void




//+=====================================================+
//*                 JDEC_Receive_Data                   *
//+=====================================================+
JDECAPI long JDEC_Receive_Data ( JDEC * pd, long len, void * data, BOOL *Reserved );
// receive a block of data, if these make a complete compressed frame,
// then decompress this frame.
// [in]-JDEC *, length of the data, data buffer ( byte stuffing )
// [return]-count of the data consumed


//+=====================================================+
//*                 JDEC_Access_SrcRect                 *
//+=====================================================+
JDECAPI RECT * JDEC_Access_SrcRect ( JDEC * pd, RECT * rect );
// Set(Get) the source rect of the decompressed bitmap
// this rectangle is a portion of the original bitmap, this portion of bitmap
// will be stretched (scaled) to dest rect ( see JDEC_Access_DstRect ) which
// specifies the displayed (target) rectangle.
//
// [in]-JDEC *, if rect is not NULL, the source rect will be set as the
//      values specified, if it's NULL, the source rect will not be changed
// [return]-the resultant source rect

//+=====================================================+
//*                 JDEC_get_decompressed_bitmap_ex2    *
//+=====================================================+
JDECAPI DWORD JDEC_get_decompressed_bitmap_ex2 ( JDEC * pd, BYTE * buffer, DWORD buflen );
// get the ptr of decompress bitmap ( RGB888 24 bit format )
// [in]-JDEC *, buffer for returning bitmap, size of buffer
//      buflen must be at least sizeof ( BITMAPFILEHEADER ) + sizeof ( BITMAPINFOHEADER ) +
//             width * height * 3
// [return]-size of the bitmap, 0 if system error


////////////////////////////////////////////////////////////////////////
// New APIs for Plugin 2.96

//Show or hide decoded frame.
JDECAPI void WINAPI JDEC_show(JDEC * pd, BOOL bShow);

//+=====================================================+
//*                 JDEC_get_size    *
//+=====================================================+
JDECAPI void WINAPI JDEC_get_size(JDEC *pd, DWORD *width, DWORD *height);
// Get size of lastest decoded frame.
// [in]-JDEC *
// [out] - width & height of the frame.

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif //_JDEC_H_
