//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//  Filename: FRMDEF.H
//  Version : V1.0
//  Date    : 03/14/2001
//  Note    : FRAME DEFINITION Data Structure / Function Abstract
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#ifndef _FRMDEF_H_
#define _FRMDEF_H_

#ifdef __cplusplus
extern "C" {
#endif

#pragma pack(push,1)

//###################################################
//###################################################
//###################################################
//              ADDITIONAL FRAME DEFINITION
//###################################################
//###################################################
//###################################################

typedef void * ADVF_RES_INFO;



//###################################################
//###################################################
//###################################################
//              ADVANCE FRAME DEFINITION
//###################################################
//###################################################
//###################################################

typedef struct tagADV_HEADER
{
    BYTE    sync[4];
    BYTE    header_size;
    BYTE    header_version;
    WORD    header_crc;
    WORD    source;
    WORD    seq;
    DWORD   size;
    DWORD   time;
    DWORD   flag;
    DWORD   type;
    WORD    data_crc;
    DWORD   pointer[2];
    DWORD   reserved[4];


} ADV_HEADER, * LPADV_HEADER;


//===================================================
// Type
//===================================================
// LOWORD (type) - specify frame type
#define ADVH_TYPE_NULL              0x0000L     // for refresh link
#define ADVH_TYPE_H263              0x0001L
#define ADVH_TYPE_MJPEG             0x0002L
#define ADVH_TYPE_JPEG              0x0003L
#define ADVH_TYPE_G723              0x0004L
#define ADVH_TYPE_GPI               0x0005L
#define ADVH_TYPE_G721              0x0006L
#define ADVH_TYPE_POS               0x0007L
#define ADVH_TYPE_XVD4              0x0008L
#define ADVH_TYPE_VWEB		        0x0009L
#define ADVH_TYPE_PENTA		        0x000AL	    //VP-101
#define ADVH_TYPE_ADPCM             0x000BL     //VP-101, audio frame
#define ADVH_TYPE_ADPCM1	        0x000CL     //VP-504, SW ADPCM audio frame
#define ADVH_TYPE_SKL4              0x000DL     //VP-504, FW1.4

// LOBYTE(HIWORD(type)) - Subtype definition for H263/MJPEG/JPEG
#define ADVH_STYPE_VIDEO_NULL       0x00L
#define ADVH_STYPE_VIDEO_640x480    0x01L
#define ADVH_STYPE_VIDEO_320x240    0x02L
#define ADVH_STYPE_VIDEO_640x240    0x03L
#define ADVH_STYPE_VIDEO_720x480    0x04L	//VP-101
#define ADVH_STYPE_VIDEO_360x240    0x05L	//VP-101
//===================================================

#define ADVH_FLAG_KEY_FRAME         0x00000004L




#pragma pack(pop)


#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif //_FRMDEF_H_
