//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
//  Filename: DEC263.H
//  Note    : DEC263 Function Abstraction
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#ifndef _DEC263_H_
#define _DEC263_H_



#ifdef _DEC263_IMPLEMENTATION_
#define DEC263API __declspec(dllexport)
#else
#define DEC263API __declspec(dllimport)
#endif


#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif  /* __cplusplus */


#define NEW_HEADER_SIZE   14	// new frame header
#define HEADER_SIZE   5	// old frame header

typedef void * DEC263;


//+=====================================================+
//*                 dec263_initialize                   *
//+=====================================================+
DEC263API BOOL dec263_initialize ( void );


//+=====================================================+
//*                 dec263_terminate                    *
//+=====================================================+
DEC263API void dec263_terminate ( void );


//+=====================================================+
//*                 dec263_new                          *
//+=====================================================+
DEC263API DEC263 * dec263_new ( void );
// New an DEC263 Object
// [in]-void
// [return]-DEC263 *, NULL if error


//+=====================================================+
//*                 dec263_free                         *
//+=====================================================+
DEC263API void dec263_free ( DEC263 * pd );
// Free an DEC263 Object
// [in]-DEC263 *
// [return]-void



//+=====================================================+
//*                 dec263_flush                        *
//+=====================================================+
DEC263API void dec263_flush ( DEC263 * pd );
// Flush DEC263 Bit Buffer
// [in]-DEC263 *
// [return]-void


//+=====================================================+
//*                 dec263_draw_init                    *
//+=====================================================+
DEC263API BOOL dec263_draw_init ( DEC263 * pd, HWND hWnd );
// initialize the DEC263 drawing module
// [in]-hWnd of the window to be drawn, if NULL the h263 stream will not be
//      drawn but be decompressed into RGB888 format, user can use
//      dec263_get_decompressed_bitmap () to retrieve the decompressed video.
// [return]-TRUE if OK


//+=====================================================+
//*                 dec263_draw_exit                    *
//+=====================================================+
DEC263API void dec263_draw_exit ( DEC263 * pd );
// Terminate the DEC263 Drawing module
// [in]-void
// [return]-void


//+=====================================================+
//*                 dec263_receive_data                 *
//+=====================================================+
DEC263API int dec263_receive_data ( DEC263 * pd, long len, void * data, int frames );
// receive a block of data, if these make a compressed frame, then decompress
// this frame. continue to decode and play a number of video frames which is
// specified by parameter - frames.
// [in]-DEC263 *, length of the data, data buffer ( byte stuffing ), max
// number of frames to be decoded, -1 for unlimited decoding
// [return]-number of frames decoded


//+=====================================================+
//*                 dec263_get_decompressed_bitmap_ex2  *
//+=====================================================+
DEC263API DWORD dec263_get_decompressed_bitmap_ex2 ( DEC263 * pd, BYTE * buffer, DWORD buflen );
// get the ptr of decompress bitmap ( RGB888 24 bit format )
// [in]-DEC263 *, buffer for returning bitmap, size of buffer
//      buflen must be at least sizeof ( BITMAPFILEHEADER ) + sizeof ( BITMAPINFOHEADER ) +
//             width * height * 3
// [return]-size of the bitmap, 0 if system error


//+=====================================================+
//*                 dec263_get_decompressed_bitmap_jpg  *
//+=====================================================+
DEC263API DWORD dec263_get_decompressed_bitmap_jpg ( DEC263 * pd, BYTE * buffer, DWORD buflen, int quality );
// get the ptr of decompress bitmap as jpeg image
// [in]-DEC263 *, buffer for returning bitmap, size of buffer ( width*height*3 is recommended )
// [return]-size of the bitmap, 0 if system error


//+=====================================================+
//*                 dec263_access_src_rect              *
//+=====================================================+
DEC263API RECT * dec263_access_src_rect ( DEC263 * pd, RECT * rect );
// Set(Get) the source rect of the decompressed bitmap
// this rectangle is a portion of the original bitmap, this portion of bitmap
// will be stretched (scaled) to dest rect ( see dec263_access_dst_rect )
// which specifies the displayed (target) rectangle.
//
// [in]-DEC263 *, if rect is not NULL, the source rect will be set as the
//      values specified, if it's NULL, the source rect will not be changed
// [return]-the resultant source rect


////////////////////////////////////////////////////////////////////////
// New APIs for Plugin 2.96

DEC263API void WINAPI dec263_show(DEC263 * pd, BOOL bShow);
// Show or hide decoded video.
// [in]-DEC263 *, bShow 

DEC263API void WINAPI dec263_get_size(DEC263 *pd, DWORD *width, DWORD *height);
// Get size of last decoded frame.
// [in]-DEC263 *
// [out] - width & height of the frame.

#ifdef __cplusplus
}
#endif  /* __cplusplus */


#endif // _DEC263_H_

