/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.widgets;

import com.android.sdkuilib.internal.widgets.ApkConfigEditDialog;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApkConfigWidget {
    private static final int INDEX_NAME = 0;
    private static final int INDEX_FILTER = 1;
    private Table mApkConfigTable;
    private Button mEditButton;
    private Button mDelButton;

    public ApkConfigWidget(final Composite parent) {
        final Composite apkConfigComp = new Composite(parent, 0);
        apkConfigComp.setLayoutData((Object)new GridData(1808));
        apkConfigComp.setLayout((Layout)new GridLayout(2, false));
        this.mApkConfigTable = new Table(apkConfigComp, 67588);
        this.mApkConfigTable.setHeaderVisible(true);
        this.mApkConfigTable.setLinesVisible(true);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.mApkConfigTable.setLayoutData((Object)data);
        final TableColumn column0 = new TableColumn(this.mApkConfigTable, 0);
        column0.setText("Name");
        column0.setWidth(100);
        final TableColumn column1 = new TableColumn(this.mApkConfigTable, 0);
        column1.setText("Configuration");
        column1.setWidth(100);
        Composite buttonComp = new Composite(apkConfigComp, 0);
        buttonComp.setLayoutData((Object)new GridData(1040));
        GridLayout gl = new GridLayout(1, false);
        buttonComp.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        Button newButton = new Button(buttonComp, 0x800008);
        newButton.setText("New...");
        newButton.setLayoutData((Object)new GridData(768));
        this.mEditButton = new Button(buttonComp, 0x800008);
        this.mEditButton.setText("Edit...");
        this.mEditButton.setLayoutData((Object)new GridData(768));
        this.mDelButton = new Button(buttonComp, 0x800008);
        this.mDelButton.setText("Delete");
        this.mDelButton.setLayoutData((Object)new GridData(768));
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApkConfigEditDialog dlg = new ApkConfigEditDialog(null, null, apkConfigComp.getShell());
                if (dlg.open() == 0) {
                    TableItem item = new TableItem(ApkConfigWidget.this.mApkConfigTable, 0);
                    item.setText(0, dlg.getName());
                    item.setText(1, dlg.getFilter());
                    ApkConfigWidget.this.onSelectionChanged();
                }
            }
        });
        this.mEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApkConfigEditDialog dlg;
                TableItem[] items = ApkConfigWidget.this.mApkConfigTable.getSelection();
                if (items.length != 0 && (dlg = new ApkConfigEditDialog(items[0].getText(0), items[0].getText(1), apkConfigComp.getShell())).open() == 0) {
                    items[0].setText(0, dlg.getName());
                    items[0].setText(1, dlg.getFilter());
                }
            }
        });
        this.mDelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] indices = ApkConfigWidget.this.mApkConfigTable.getSelectionIndices();
                if (indices.length != 0) {
                    TableItem item = ApkConfigWidget.this.mApkConfigTable.getItem(indices[0]);
                    if (MessageDialog.openQuestion((Shell)parent.getShell(), (String)"Apk Configuration deletion", (String)String.format("Are you sure you want to delete configuration '%1$s'?", item.getText(0)))) {
                        ApkConfigWidget.this.mApkConfigTable.remove(indices[0]);
                        ApkConfigWidget.this.onSelectionChanged();
                    }
                }
            }
        });
        this.mApkConfigTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = ApkConfigWidget.this.mApkConfigTable.getClientArea();
                column0.setWidth(r.width * 30 / 100);
                column1.setWidth(r.width * 70 / 100);
            }
        });
        this.mApkConfigTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApkConfigWidget.this.onSelectionChanged();
            }
        });
    }

    public void fillTable(Map<String, String> apkConfigMap) {
        if (apkConfigMap != null) {
            Set<String> keys = apkConfigMap.keySet();
            Object[] keyArray = keys.toArray(new String[keys.size()]);
            Arrays.sort(keyArray);
            for (Object key : keyArray) {
                TableItem item = new TableItem(this.mApkConfigTable, 0);
                item.setText(0, (String)key);
                item.setText(1, apkConfigMap.get(key));
            }
        }
        this.onSelectionChanged();
    }

    public Map<String, String> getApkConfigs() {
        TableItem[] items;
        HashMap<String, String> map = new HashMap<String, String>();
        for (TableItem item : items = this.mApkConfigTable.getItems()) {
            map.put(item.getText(0), item.getText(1));
        }
        return map;
    }

    private void onSelectionChanged() {
        if (this.mApkConfigTable.getSelectionCount() > 0) {
            this.mEditButton.setEnabled(true);
            this.mDelButton.setEnabled(true);
        } else {
            this.mEditButton.setEnabled(false);
            this.mDelButton.setEnabled(false);
        }
    }
}

