/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.tasks;

import com.android.sdklib.internal.repository.ITask;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdkuilib.internal.tasks.ProgressDialog;
import org.eclipse.swt.widgets.Shell;

public final class ProgressTask
implements ITaskMonitor {
    private static final double MAX_COUNT = 10000.0;
    private final ProgressDialog mDialog;
    private boolean mAutomaticallyCloseOnTaskCompletion = true;
    private double mIncCoef = 0.0;
    private double mValue = 0.0;

    public ProgressTask(Shell parent, String title, ITask task) {
        this.mDialog = new ProgressDialog(parent, this.createTaskThread(title, task));
        this.mDialog.setText(title);
        this.mDialog.open();
    }

    public void setDescription(String descriptionFormat, Object ... args) {
        this.mDialog.setDescription(descriptionFormat, args);
    }

    public void setResult(String resultFormat, Object ... args) {
        this.mAutomaticallyCloseOnTaskCompletion = false;
        this.mDialog.setResult(resultFormat, args);
    }

    public void setProgressMax(int max) {
        assert (max > 0);
        this.mDialog.setProgressMax(10000);
        double d = this.mIncCoef = max > 0 ? 10000.0 / (double)max : 0.0;
        assert (this.mIncCoef > 0.0);
    }

    public void incProgress(int delta) {
        assert (this.mIncCoef > 0.0);
        assert (delta > 0);
        this.internalIncProgress((double)delta * this.mIncCoef);
    }

    private void internalIncProgress(double realDelta) {
        this.mValue += realDelta;
        this.mDialog.setProgress((int)this.mValue);
    }

    public int getProgress() {
        assert (this.mIncCoef > 0.0);
        return this.mIncCoef > 0.0 ? (int)((double)this.mDialog.getProgress() / this.mIncCoef) : 0;
    }

    public boolean isCancelRequested() {
        return this.mDialog.isCancelRequested();
    }

    private Thread createTaskThread(String title, final ITask task) {
        if (task != null) {
            return new Thread(title){

                public void run() {
                    task.run((ITaskMonitor)ProgressTask.this);
                    if (ProgressTask.this.mAutomaticallyCloseOnTaskCompletion) {
                        ProgressTask.this.mDialog.setAutoCloseRequested();
                    } else {
                        ProgressTask.this.mDialog.setManualCloseRequested();
                    }
                }
            };
        }
        return null;
    }

    public ITaskMonitor createSubMonitor(int tickCount) {
        assert (this.mIncCoef > 0.0);
        assert (tickCount > 0);
        return new SubTaskMonitor(this, null, this.mValue, (double)tickCount * this.mIncCoef);
    }

    private static class SubTaskMonitor
    implements ISubTaskMonitor {
        private final ProgressTask mRoot;
        private final ISubTaskMonitor mParent;
        private final double mStart;
        private final double mSpan;
        private double mSubValue;
        private double mSubCoef;

        public SubTaskMonitor(ProgressTask root, ISubTaskMonitor parent, double start, double span) {
            this.mRoot = root;
            this.mParent = parent;
            this.mStart = start;
            this.mSpan = span;
            this.mSubValue = start;
        }

        public boolean isCancelRequested() {
            return this.mRoot.isCancelRequested();
        }

        public void setDescription(String descriptionFormat, Object ... args) {
            this.mRoot.setDescription(descriptionFormat, args);
        }

        public void setResult(String resultFormat, Object ... args) {
            this.mRoot.setResult(resultFormat, args);
        }

        public void setProgressMax(int max) {
            assert (max > 0);
            double d = this.mSubCoef = max > 0 ? this.mSpan / (double)max : 0.0;
            assert (this.mSubCoef > 0.0);
        }

        public int getProgress() {
            assert (this.mSubCoef > 0.0);
            return this.mSubCoef > 0.0 ? (int)((this.mSubValue - this.mStart) / this.mSubCoef) : 0;
        }

        public void incProgress(int delta) {
            assert (this.mSubCoef > 0.0);
            this.subIncProgress((double)delta * this.mSubCoef);
        }

        public void subIncProgress(double realDelta) {
            this.mSubValue += realDelta;
            if (this.mParent != null) {
                this.mParent.subIncProgress(realDelta);
            } else {
                this.mRoot.internalIncProgress(realDelta);
            }
        }

        public ITaskMonitor createSubMonitor(int tickCount) {
            assert (this.mSubCoef > 0.0);
            assert (tickCount > 0);
            return new SubTaskMonitor(this.mRoot, this, this.mSubValue, (double)tickCount * this.mSubCoef);
        }
    }

    private static interface ISubTaskMonitor
    extends ITaskMonitor {
        public void subIncProgress(double var1);
    }
}

