/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.prefs.AndroidLocation;
import com.android.sdkuilib.internal.repository.ISettingsPage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class SettingsController {
    private static final String SETTINGS_FILENAME = "androidtool.cfg";
    private final Properties mProperties = new Properties();
    private ISettingsPage mSettingsPage;

    public boolean getForceHttp() {
        return Boolean.parseBoolean(this.mProperties.getProperty("sdkman.force.http"));
    }

    public boolean getAskBeforeAdbRestart() {
        String value = this.mProperties.getProperty("sdkman.ask.adb.restart");
        if (value == null) {
            return true;
        }
        return Boolean.parseBoolean(value);
    }

    public boolean getShowUpdateOnly() {
        String value = this.mProperties.getProperty("sdkman.show.update.only");
        if (value == null) {
            return true;
        }
        return Boolean.parseBoolean(value);
    }

    public void setShowUpdateOnly(boolean enabled) {
        this.setSetting("sdkman.show.update.only", enabled);
    }

    private void setSetting(String key, boolean value) {
        this.mProperties.setProperty(key, Boolean.toString(value));
    }

    public void setSettingsPage(ISettingsPage settingsPage) {
        this.mSettingsPage = settingsPage;
        this.mSettingsPage.loadSettings(this.mProperties);
        settingsPage.setOnSettingsChanged(new ISettingsPage.SettingsChangedCallback(){

            public void onSettingsChanged(ISettingsPage page) {
                SettingsController.this.onSettingsChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSettings() {
        FileInputStream fis = null;
        try {
            String folder = AndroidLocation.getFolder();
            File f = new File(folder, SETTINGS_FILENAME);
            if (f.exists()) {
                fis = new FileInputStream(f);
                this.mProperties.load(fis);
                this.setShowUpdateOnly(this.getShowUpdateOnly());
                this.setSetting("sdkman.ask.adb.restart", this.getAskBeforeAdbRestart());
            }
        }
        catch (AndroidLocation.AndroidLocationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSettings() {
        FileOutputStream fos = null;
        try {
            String folder = AndroidLocation.getFolder();
            File f = new File(folder, SETTINGS_FILENAME);
            fos = new FileOutputStream(f);
            this.mProperties.store(fos, "## Settings for Android Tool");
        }
        catch (AndroidLocation.AndroidLocationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void onSettingsChanged() {
        if (this.mSettingsPage == null) {
            return;
        }
        this.mSettingsPage.retrieveSettings(this.mProperties);
        this.applySettings();
        this.saveSettings();
    }

    public void applySettings() {
        Properties props = System.getProperties();
        props.setProperty("http.proxyHost", this.mProperties.getProperty("http.proxyHost", ""));
        props.setProperty("http.proxyPort", this.mProperties.getProperty("http.proxyPort", ""));
    }
}

