/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.project;

import com.android.sdklib.internal.project.ProjectProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApkConfigurationHelper {
    static final String CONFIG_PREFIX = "apk-config-";

    public static Map<String, String> getConfigs(ProjectProperties properties) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        String configList = properties.getProperty("apk-configurations");
        if (configList != null) {
            String[] configs;
            for (String config : configs = configList.split(",")) {
                config = config.trim();
                String configValue = properties.getProperty(CONFIG_PREFIX + config);
                if (configValue == null) continue;
                configMap.put(config, configValue);
            }
        }
        return configMap;
    }

    public static boolean setConfigs(ProjectProperties properties, Map<String, String> configMap) {
        String configList = properties.getProperty("apk-configurations");
        boolean hasRemovedConfig = false;
        if (configList != null) {
            String[] configs;
            for (String config : configs = configList.split(",")) {
                if (configMap.containsKey(config = config.trim())) continue;
                hasRemovedConfig = true;
                properties.removeProperty(CONFIG_PREFIX + config);
            }
        }
        Set<Map.Entry<String, String>> entrySet = configMap.entrySet();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : entrySet) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(entry.getKey());
            properties.setProperty(CONFIG_PREFIX + entry.getKey(), entry.getValue());
        }
        properties.setProperty("apk-configurations", sb.toString());
        return hasRemovedConfig;
    }
}

