#!/bin/sh

INTERFACE=/mtd1/interfaces
#killall -9 pppd
#killall -9 miniupnpd
#killall -9 inadyn
#killall -9 updatedd

echo "begin resetNetwork" >> /tmp/test
	
TEST_DHCP=`grep < /mtd1/conf/network.conf "^root.Network.BootProto" | cut -d \= -f 2`
UPNPWORK=`grep "^root.Network.UPnP.Enabled" /mtd1/conf/network.conf | cut -d \= -f 2`
UPNPWORKPORTFOWARD=`grep "^root.Network.UPnP.NATTraversal.Enabled" /mtd1/conf/network.conf | cut -d \= -f 2`

if [ "$TEST_DHCP" == "none" ]   #static IP
then
	# stop network service
#	killall -9 dhclient
		
	IP=`grep "^root.Network.IPAddress" /mtd1/conf/network.conf | cut -d \= -f 2`
	MASK=`grep "^root.Network.SubnetMask" /mtd1/conf/network.conf | cut -d \= -f 2`
	BCAST=`grep "^root.Network.DefaultRouter" /mtd1/conf/network.conf | cut -d \= -f 2`
	#BCAST=`ipcalc $IP -m $MASK -b | grep BROADCAST | cut -d \= -f 2` 
        echo "static IP" >> /tmp/test	 
        
	TEST_ADDRESS=`grep < $INTERFACE  "^address" | cut -d \= -f 2`
	
#	TEST_NETMASK=`grep < /mtd1/interfaces  "^netmask" | cut -d \= -f 2`
#	TEST_GATEWAY=`grep < /mtd1/interfaces  "^gateway" | cut -d \= -f 2`
#	sed -i '/Network.Broadcast/s/Broadcast=.*/Broadcast='$BCAST'/' /mtd1/conf/network.conf
#	sed -i '/Network.eth0.Broadcast/s/Broadcast=.*/Broadcast='$BCAST'/' /mtd1/conf/network.conf
#	sed -i '/broadcast/cbroadcast '$BCAST $INTERFACE
	
	echo "$TEST_ADDRESS" >> /tmp/test
	
        if [ "$TEST_ADDRESS" != "" ]; then		
        	echo "address be there" >> /tmp/test
		sed -i '/address/caddress '$IP $INTERFACE
		sed -i '/netmask/cnetmask '$MASK $INTERFACE
		sed -i '/gateway/cgateway '$BCAST $INTERFACE
	else
        	echo "address not there" >>/tmp/test
		sed -i 5s/dhcp/static/ $INTERFACE
		echo "address $IP" >> $INTERFACE
		echo "netmask $MASK" >> $INTERFACE
		echo "gateway $BCAST" >> $INTERFACE
	fi
       # sed -i '9c ' /etc/network/interfaces
       # sed -i '10c ' /etc/network/interfaces
       # sed -i '11c ' /etc/network/interfaces
       # sed -i '12c ' /etc/network/interfaces
        

	sync

	ifdown eth0
	# start network service

	ifup eth0
	routetest=`route -n | grep ^0.0.0.0`
	if [ "$routetest" = "" ] ; then
		route add -net 0.0.0.0 dev eth0
	fi
	
#	get_ip=`/sbin/ifconfig eth0 | grep 'inet addr' | sed 's/^.*addr://g' | sed 's/Bc
#	sh /usr/sbin/network_set.sh ip $get_ip
elif [ "$TEST_DHCP" == "pppoe" ]   #pppoe
then
	killall -9 dhclient	
	/usr/sbin/pppd call your_provider 1> /dev/null 2> /dev/null
else			#DHCP
#	dhclient eth0
	sleep 3
	TEST=`ifconfig | grep "inet addr" | wc -l`
	if [ $TEST = 2 ]
	then
		/usr/sbin/to_dhcp.sh 1 1> /dev/null 2> /dev/null
	else
#		killall -9 dhclient
		IP=`grep "^root.Network.IPAddress" /mtd1/conf/network.conf.default | cut -d \= -f 2`
		MASK=`grep "^root.Network.SubnetMask" /mtd1/conf/network.conf.default | cut -d \= -f 2`
		BCAST=`ipcalc $IP -m $MASK -b | grep BROADCAST | cut -d \= -f 2` 

		sed -i '/Network.Broadcast/s/Broadcast=.*/Broadcast='$BCAST'/' /mtd1/conf/network.conf
		sed -i '/Network.eth0.Broadcast/s/Broadcast=.*/Broadcast='$BCAST'/' /mtd1/conf/network.conf
		sed -i '/broadcast/cbroadcast '$BCAST $INTERFACES
		sed -i '/address/caddress '$IP'' $INTERFACES
		sed -i '/Network.IPAddress/s/IPAddress=.*/IPAddress='$IP'/' /mtd1/conf/network.conf
		sed -i '/Network.eth0.IPAddress/s/IPAddress=.*/IPAddress='$IP'/' /mtd1/conf/network.conf
	
	    sed -i 5s/static/dhcp/ $INTERFACE 		
		sed -i '6,8d' $INTERFACE
		sync

		ifdown eth0
		# start network service

		ifup eth0
		routetest=`route -n | grep ^0.0.0.0`
		if [ "$routetest" = "" ] ; then
			route add -net 0.0.0.0 dev eth0
		fi
		/usr/sbin/DM_post_process.sh
	fi
fi

killall -9 appweb 2> /dev/null
echo "killall appweb">>/tmp/test
if [ "$UPNPWORK" = "yes" -a "$UPNPWORKPORTFOWARD" = "no" ] ; then
	/usr/sbin/miniupnpd -f /etc/upnp/miniupnpd.conf 1> /dev/null 2> /dev/null
elif [ "$UPNPWORK" = "yes" -a "$UPNPWORKPORTFOWARD" = "yes" ] ; then
	/usr/sbin/miniupnpd -f /etc/upnp/miniupnpd.conf -n 1> /dev/null 2> /dev/null
fi

READDDNSSTATUS=`grep "root.DDNS.Enabled=" /mtd1/conf/ddns.conf | cut -d \= -f2`

if [ "$READDDNSSTATUS" = "yes" ]
then

	READDDNSPROVIDERCOMP=`grep "root.DDNS.Provider=" /mtd1/conf/ddns.conf | cut -d \= -f2`
	READDDNSHOST=`grep "root.DDNS.Hostname=" /mtd1/conf/ddns.conf | cut -d \= -f2`
	READDDNSUSERNAMEEMAIL=`grep "root.DDNS.Login=" /mtd1/conf/ddns.conf | cut -d \= -f2`
	READDDNSPASSWORDKEY=`grep "root.DDNS.Password=" /mtd1/conf/ddns.conf | cut -d \= -f2`

	if [ "$READDDNSPROVIDERCOMP" = "1" ]
	then
		echo "dyndns dynamic"
		/usr/sbin/inadyn --dyndns_system dyndns@dyndns.org -u $READDDNSUSERNAMEEMAIL -p $READDDNSPASSWORDKEY -a $READDDNSHOST &

	elif [ "$READDDNSPROVIDERCOMP" = "2" ]
	then
		echo "dyndns custom"
		/usr/sbin/inadyn --dyndns_system custom@dyndns.org -u $READDDNSUSERNAMEEMAIL -p $READDDNSPASSWORDKEY -a $READDDNSHOST &

	elif [ "$READDDNSPROVIDERCOMP" = "3" ]
	then
		echo "No-IP"
		/usr/sbin/updatedd -Y noip $READDDNSUSERNAMEEMAIL:$READDDNSPASSWORDKEY $READDDNSHOST &

	elif [ "$READDDNSPROVIDERCOMP" = "4" ]
	then
		echo "ChangeIP"
		/usr/sbin/updatedd -Y changeip $READDDNSUSERNAMEEMAIL:$READDDNSPASSWORDKEY $READDDNSHOST &
	fi
fi

killall -9 appWeb
echo "killall appweb 2">>/tmp/test