#!/bin/sh

# Copyright (C) 2011 Draytek
# to start/stop WIDE-DHCPv6 client/server

# DEBUG=Df

[ -z $WAN ] && WAN=eth2.2
LAN=br0
DHCP6C=/sbin/dhcp6c
DHCP6S=/sbin/dhcp6s

for DIR in /etc/dhcp6 /var/db; do
  [ ! -d $DIR ] && mkdir -p $DIR 2>/dev/null
done

usage()
{
  echo "usage:" >&2
  echo "  $0 client <start [iapd|iana] | stop>" >&2
  echo "  $0 server <start|stop>" >&2
  exit 1
}

config_dhcp6c_iapd()
{
  echo "interface $WAN {" > $CONF
  echo "  send ia-pd $IAID;" >> $CONF
  echo "  request domain-name-servers,domain-name;" >> $CONF
  echo "  script \"/etc_ro/dhcp6/dhcp6c-script\";" >> $CONF
  echo "};" >> $CONF
  echo >> $CONF
  echo "id-assoc pd $IAID {" >> $CONF
  echo "  prefix-interface $LAN {" >> $CONF
  echo "    sla-id 1;" >> $CONF
  echo "    sla-len 16;" >> $CONF
  echo "  };" >> $CONF
  echo "};" >> $CONF
}

config_dhcp6c_iana()
{
  echo "interface $WAN {" > $CONF
  echo "  send ia-na $IAID;" >> $CONF
  echo "  request domain-name-servers,domain-name;" >> $CONF
  echo "  script \"/etc_ro/dhcp6/dhcp6c-script\";" >> $CONF
  echo "};" >> $CONF
  echo >> $CONF
  echo "id-assoc na $IAID {" >> $CONF
  echo "};" >> $CONF
}

config_dhcp6s()
{
  LAN_ADDR_START=`nvram_get v6_lan_dhcp_addr_start`
  LAN_ADDR_END=`nvram_get v6_lan_dhcp_addr_end`
  DNS1=`nvram_get v6_lan_dhcp_dns1`
  DNS2=`nvram_get v6_lan_dhcp_dns2`

  ([ -z $LAN_ADDR_START ] || [ -z $LAN_ADDR_END ]) && echo "$0: no IP range configured for dhcp6s" >&2 && exit 1
  [ $DNS1 ] && [ $DNS1 == $DNS2 ] && DNS2=

  # TODO: address sanity check

  echo "interface $LAN {" > $CONF
  echo "  address-pool mynetwork 3600; " >> $CONF
  echo "};" >> $CONF
  echo >> $CONF
  echo "pool mynetwork {" >> $CONF
  echo "  range $LAN_ADDR_START to $LAN_ADDR_END;" >> $CONF
  echo "};" >> $CONF

  if [ $DNS1 ]; then
    echo >> $CONF
    echo "option domain-name-servers $DNS1 $DNS2;" >> $CONF
  fi
}

stop_client()
{
  killall dhcp6c 2>/dev/null
  killall radvd 2>/dev/null
}

stop_server()
{
  killall dhcp6s 2>/dev/null
}

start_client_iapd()
{
  stop_client
  config_dhcp6c_iapd
  #  -wSPr = send release, stateless(DUID-LL), want IAPD, start radvd
  OPT=-wSP
  [ "`nvram_get v6_radvd_en`" -eq 1 ] && OPT=${OPT}r
  $DHCP6C $OPT -${DEBUG}c $CONF $WAN
}

start_client_iana()
{
  stop_client
  config_dhcp6c_iana
  $DHCP6C -${DEBUG}c $CONF $WAN
}

# program entry
case $1 in
  "client")
    case $2 in
      "start")
        CONF=/etc/dhcp6/dhcp6c.conf
        IAID=`nvram_get v6_wan_dhcp_iaid`
        [ -z $IAID ] && IAID=0

        case $3 in
          "")
            IA=`nvram_get v6_wan_dhcp_id_assoc`
            if ([ -z $IA ] || [ $IA == "pd" ]); then
              start_client_iapd
            elif [ $IA == "na" ]; then
              start_client_iana
            else
              echo "$0: Unknown DHCPv6 ID association \"$IA\"" >&2
            fi
            ;;

          "iapd")
            start_client_iapd
            ;;

          "iana")
            start_client_iana
            ;;

          *)usage
            ;;
        esac
        ;;

      "stop")
        stop_client
        ;;

      *)usage
        ;;
    esac
    ;;

  "server")
    case $2 in
      "start")
        stop_server
        CONF=/etc/dhcp6/dhcp6s.conf
        config_dhcp6s
        $DHCP6S -${DEBUG}c $CONF $LAN
        ;;

      "stop")
        stop_server
        ;;

      *)usage
        ;;
    esac
    ;;

  *)usage
    ;;
esac
