#!/bin/sh
#

. /sbin/global.sh

yotadebug()
{
	if [ "$1" = "1" ]; then
		logger "$2"
	fi
}
set_l2tp_pptp_static_route()
{
	server=`test -f /var/pptp_l2tp_server && cat /var/pptp_l2tp_server`
	gateway=`test -f /var/pptp_l2tp_gateway && cat /var/pptp_l2tp_gateway`
	# set the static route to let L2TP/PPTP be able to reconnect
	if [ "$server" != "" -a "$gateway" != "" -a "$server" != "$gateway" ]; then
		temp=`route -n | grep "$server" | grep "$gateway"`
		if [ "$temp" = "" ]; then
			route add -host $gateway dev $wan_if
			route add -host $server gw $gateway
			yotadebug $1 "[wan_backup.sh] add L2TP/PPTP static route ($server -> $gateway)"
		fi
	fi
}

debug="$3"

if [ "$2" = "up" ]; then
	PROTO=`nvram_get 2860 wanConnectionMode`

	killall -q pingkeepalive

	killall -q config-l2tp.sh
	killall -q config-pptp.sh
	killall -q -SIGTERM udhcpc
	yotadebug $debug "[wan_backup.sh] kill pingkeepalive, config-l2tp.sh, config-pptp.sh, udhcpc"

	# backup wan dns server
	cp /etc/resolv.conf /etc/resolv.conf.wan

	if [ "$1" = "STATIC" -o "$opmode" = "0" ]; then
		#always treat bridge mode having static wan connection
		ip=`nvram_get 2860 wan2_ipaddr`
		nm=`nvram_get 2860 wan2_netmask`
		gw=`nvram_get 2860 wan2_gateway`
		pd=`nvram_get 2860 wan2_primary_dns`
		sd=`nvram_get 2860 wan2_secondary_dns`

		#lan and wan ip should not be the same except in bridge mode
		if [ "$opmode" != "0" ]; then
			lan_ip=`nvram_get 2860 lan_ipaddr`
			if [ "$ip" = "$lan_ip" ]; then
				echo "wan.sh: warning: WAN's IP address is set identical to LAN"
				exit 0
			fi
		else
			#use lan's ip address instead
			ip=`nvram_get 2860 lan_ipaddr`
			nm=`nvram_get 2860 lan_netmask`
		fi
		ifconfig $wan_if $ip netmask $nm
		route del default
		if [ "$gw" != "" ]; then
		route add default gw $gw
		fi
		config-dns.sh $pd $sd
		yotadebug $debug "[wan_backup.sh] set $wan_if ip($ip), default route($gw), and dns"
	elif [ "$1" = "DHCP" ]; then
		host=`nvram_get 2860 HostName`
		if [ "$host" != "" ]; then
			echo $host > /proc/sys/kernel/hostname
			#add dhcp option 121 (staticroutes)
			udhcpc -i $wan_if -s /sbin/udhcpcbk.sh -H $host -O staticroutes -O routes -p /var/run/udhcpcbk.pid &
		else
			echo draytek > /proc/sys/kernel/hostname
			#add dhcp option 121 (staticroutes)
			udhcpc -i $wan_if -s /sbin/udhcpcbk.sh -O staticroutes -O routes -p /var/run/udhcpcbk.pid &
		fi
		yotadebug $debug "[wan_backup.sh] call udhcpc(backup) to $wan_if"
	elif [ "$1" = "PPPOE" ]; then
		u=`nvram_get 2860 wan2_pppoe_user`
		pw=`nvram_get 2860 wan2_pppoe_pass`
		pppoe_opmode=`nvram_get 2860 wan2_pppoe_opmode`
		if [ "$pppoe_opmode" = "" ]; then
			echo "pppoecd $wan_if -u $u -p $pw"
			pppoecd $wan_if -u "$u" -p "$pw"
			yotadebug $debug "[wan_backup.sh] call pppoecd"
		else
			pppoe_optime=`nvram_get 2860 wan2_pppoe_optime`
			config-pppoebk.sh $u $pw $wan_if $pppoe_opmode $pppoe_optime
			yotadebug $debug "[wan_backup.sh] call config-pppoebk.sh"
		fi
	elif [ "$1" = "L2TP" ]; then
		srv=`nvram_get 2860 wan2_l2tp_server`
		u=`nvram_get 2860 wan2_l2tp_user`
		pw=`nvram_get 2860 wan2_l2tp_pass`
		mode=`nvram_get 2860 wan2_l2tp_mode`
		l2tp_opmode=`nvram_get 2860 wan2_l2tp_opmode`
		l2tp_optime=`nvram_get 2860 wan2_l2tp_optime`

		#add dns file
		pd=`nvram_get 2860 dhcpPriDns`
		sd=`nvram_get 2860 dhcpSecDns`
		config-dns.sh $pd $sd

		if [ "$mode" = "0" ]; then
			ip=`nvram_get 2860 wan2_l2tp_ip`
			nm=`nvram_get 2860 wan2_l2tp_netmask`
			gw=`nvram_get 2860 wan2_l2tp_gateway`
			if [ "$gw" = "" ]; then
				gw="0.0.0.0"
			fi
			config-l2tpbk.sh static $wan_if $ip $nm $gw $srv $u $pw $l2tp_opmode $l2tp_optime &
		else
			config-l2tpbk.sh dhcp $wan_if $srv $u $pw $l2tp_opmode $l2tp_optime &
		fi
		yotadebug $debug "[wan_backup.sh] call config-l2tpbk.sh"
	elif [ "$1" = "PPTP" ]; then
		srv=`nvram_get 2860 wan2_pptp_server`
		u=`nvram_get 2860 wan2_pptp_user`
		pw=`nvram_get 2860 wan2_pptp_pass`
		mode=`nvram_get 2860 wan2_pptp_mode`
		pptp_opmode=`nvram_get 2860 wan2_pptp_opmode`
		pptp_optime=`nvram_get 2860 wan2_pptp_optime`

		#add dns file
		pd=`nvram_get 2860 dhcpPriDns`
		sd=`nvram_get 2860 dhcpSecDns`
		config-dns.sh $pd $sd

		if [ "$mode" = "0" ]; then
			ip=`nvram_get 2860 wan2_pptp_ip`
			nm=`nvram_get 2860 wan2_pptp_netmask`
			gw=`nvram_get 2860 wan2_pptp_gateway`
			if [ "$gw" = "" ]; then
				gw="0.0.0.0"
			fi
			config-pptpbk.sh static $wan_if $ip $nm $gw $srv $u $pw $pptp_opmode $pptp_optime &
		else
			config-pptpbk.sh dhcp $wan_if $srv $u $pw $pptp_opmode $pptp_optime &
		fi
		yotadebug $debug "[wan_backup.sh] call config-pptpbk.sh"
	elif [ "$1" = "Wimax" ]; then
		echo 1 > /var/network/wimaxUp
#		temp=`cat /proc/bus/usb/devices | grep ^P | grep "04e[89]" | grep "67[368][01]"`
#		if [ "$temp" != "" ]; then
#			# [G30089] Samsung Wimax : 0x04e8, 0x6761; 0x04e9, 0x6761; 0x04e8, 0x6731; 0x04e8, 0x6780
#			killall madwimax
#			/bin/madwimax &
#		else
#			gpio u
#		fi
		wimax.sh up
		yotadebug $debug "[wan_backup.sh] restart wimax driver"
	elif [ "$1" = "3G" ]; then
		/sbin/wan.sh 3g_backup
		yotadebug $debug "[wan_backup.sh] call wan.sh 3g_backup"
	else
		echo "wan_backup.sh: unknown wan connection type: $1"
		exit 1
	fi

	# call ethernet udhcpc to make sure L2TP/PPTP wan can recover
	if [ "$PROTO" = "L2TP" -o "$PROTO" = "PPTP" ]; then
		if [ "$PROTO" = "L2TP" ]; then
			mode=`nvram_get 2860 wan_l2tp_mode`
		else
			mode=`nvram_get 2860 wan_pptp_mode`
		fi
		if [ "$mode" = "1" ]; then	# dhcp mode
			if [ ! -f /var/run/udhcpc.pid ]; then
				ifconfig $wan_if down up	# delete static routes added by dhcp server
				yotadebug $debug "[wan_backup.sh] $wan_if down and up"
				
				# this udhcpc with -y will only add ip to ethernet interface
				udhcpc -i $wan_if -s /sbin/udhcpc.sh -O staticroutes -O routes -p /var/run/udhcpc.pid -y &
				yotadebug $debug "[wan_backup.sh] call udhcpc to $wan_if with -y option"
			fi
		fi
		set_l2tp_pptp_static_route $debug	# otherwise L2TP/PPTP might dial through backup wan
	fi
elif [ "$2" = "set" ]; then
	# static route
	/sbin/static_route.sh $1 backup &
	yotadebug $debug "[wan_backup.sh] set static route for backup wan $1"
	# nat
	/sbin/nat.sh dynamic &
	yotadebug $debug "[wan_backup.sh] set dynamic nat rules"
	# restart ddns, ntp, igmpproxy, upnp, pppoe-relay
	touch /var/do_up

	# backup wan2 dns server
	cp /etc/resolv.conf /etc/resolv.conf.bk

	# Backup send sms
	sms_mode=`nvram_get 2860 wan_bk_sms`
	/sbin/send_sms_function.sh $sms_mode
	
	# ipv6 tspc
	killall tspc > /dev/null 2>&1
	yotadebug $debug "[wan_backup.sh] kill tspc"
elif [ "$2" = "check" ]; then
	temp=`cat /var/network/ppp_phy_link_connect`
	if [ "$temp" != "1" ]; then
		exit 0	# no physical link, do nothing
	fi
	if [ "$1" = "L2TP" ]; then
		dialing_process=`ps | grep "[c]onfig-l2tp.sh"`
		main_process=`ps | grep "[l]2tpd"`
	else
		dialing_process=`ps | grep [c]onfig-pptp.sh`
		main_process=`ps | grep "pppd" | grep "/etc/options.pptp"`
	fi
	if [ "$dialing_process" != "" ]; then
		exit 0	# wan is still dialing, do nothing
	fi

	server=`test -f /var/pptp_l2tp_server && cat /var/pptp_l2tp_server`
	gateway=`test -f /var/pptp_l2tp_gateway && cat /var/pptp_l2tp_gateway`

	# wrong status, restart
	if [ "$main_process" = "" -o "$server" = "" -o "$gateway" = "" ]; then
		yotadebug $debug "[wan_backup.sh] L2TP/PPTP wrong status, goahead set_wan"
		/bin/goahead set_wan
		exit 0
	fi

	# set the static route to let L2TP/PPTP be able to reconnect
	if [ "$gateway" != "$server" ]; then
	temp=`route -n | grep "$server" | grep "$gateway"`
	if [ "$temp" = "" ]; then
		route add -host $gateway dev $wan_if
		route add -host $server gw $gateway
		yotadebug $debug "[wan_backup.sh] add L2TP/PPTP static route ($server -> $gateway)"
	fi
	fi

	# start L2TP session
	if [ "$1" = "L2TP" ]; then
		temp=`ps | grep "pppd" | grep "unit 0"`
		if [ "$temp" = "" ]; then
			sleep 1
			temp=`ps | grep "pppd" | grep "unit 0"`
			if [ "$temp" = "" ]; then
				temp=`ps | grep "pppd" |grep "unit 0" | awk '{print $1}'`
				for i in $temp ; do
					kill $i
				done
				l2tp-control "start-session $server"
				yotadebug $debug "[wan_backup.sh] (L2TP) start pppd session"
			fi
		fi
	fi
elif [ "$2" = "down" ]; then
	killall -q config-l2tpbk.sh
	killall -q config-pptpbk.sh

	yotadebug $debug "[wan_backup.sh] kill config-l2tpbk.sh, config-pptpbk.sh"

	# kill backup wan udhcpc
	if [ -f /var/run/udhcpcbk.pid ]; then
		temp=`cat /var/run/udhcpcbk.pid`
		kill -SIGTERM $temp
		yotadebug $debug "[wan_backup.sh] kill udhcpc(backup) : $temp"
	fi

	# kill backup wan pppd
	if [ -f /var/run/ppp1.pid ]; then
		temp=`cat /var/run/ppp1.pid`
		kill $temp
		yotadebug $debug "[wan_backup.sh] kill pppd(backup) : $temp"
	elif [ "$1" = "3G" ]; then	#hso driver
		(ifconfig | grep ppp1 > /dev/null) && ifconfig ppp1 down
		(lsmod | grep hso > /dev/null) && rmmod hso
	fi

	if [ "$1" = "PPPOE" ]; then
		temp=`ps | grep "pppd" | grep "/etc/options.pppoe" | awk '{print $1}'`
		if [ "$temp" != "" ]; then
			kill $temp
			yotadebug $debug "[wan_backup.sh] kill pppd : $temp"
		fi
	elif [ "$1" = "L2TP" ]; then
		killall -q l2tpd
		yotadebug $debug "[wan_backup.sh] kill l2tpd"
	elif [ "$1" = "PPTP" ]; then
		temp=`ps | grep "pppd" | grep "/etc/options.pptp" | awk '{print $1}'`
		if [ "$temp" != "" ]; then
			kill $temp
			yotadebug $debug "[wan_backup.sh] kill pppd : $temp"
		fi
	elif [ "$1" = "Wimax" ]; then
		echo 0 > /var/network/wimaxUp
		wimax.sh down
		yotadebug $debug "[wan_backup.sh] call wimax.sh down"
		# sometimes, this udhcpc is hard to kill
		if [ -f /var/run/udhcpcbk.pid ]; then
			temp=`cat /var/run/udhcpcbk.pid`
			kill -9 $temp
			yotadebug $debug "[wan_backup.sh] kill udhcpc(backup) again : $temp"
		fi
	fi

	# ipv6 tspc
	killall tspc > /dev/null 2>&1
	yotadebug $debug "[wan_backup.sh] kill tspc"
elif [ "$2" = "recover" ]; then
	if [ "$1" = "STATIC" -o "$opmode" = "0" ]; then
		echo "static ip recover"
		#always treat bridge mode having static wan connection
		ip=`nvram_get 2860 wan_ipaddr`
		nm=`nvram_get 2860 wan_netmask`
		gw=`nvram_get 2860 wan_gateway`
		pd=`nvram_get 2860 wan_primary_dns`
		sd=`nvram_get 2860 wan_secondary_dns`

		ifconfig $wan_if $ip netmask $nm
		route del default
		if [ "$gw" != "" ]; then
		route add default gw $gw
		fi
		#Add ping detect target route
		PING_MODE=`nvram_get 2860 wanDetectMode`	
		if [ "$PING_MODE" == 2 ]; then
			PING_IP=`nvram_get 2860 wanDetectPing`
			route add $PING_IP gw $gw dev $wan_if 
		fi
		config-dns.sh $pd $sd
		yotadebug $debug "[wan_backup.sh] set $wan_if ip($ip), default route($gw), and dns"

		# ipv6 static dns
		if [ -f /var/ipv6/dns ]; then
			cat /var/ipv6/dns > /var/ipv6/resolv_temp
			cat /etc/resolv.conf >> /var/ipv6/resolv_temp
			cp /var/ipv6/resolv_temp /etc/resolv.conf
			rm -f /var/ipv6/resolv_temp
			yotadebug $debug "[wan_backup.sh] set ipv6 dns"
		fi
		
		config-wankeepalive.sh
		yotadebug $debug "[wan_backup.sh] call config-wankeepalive.sh"
	elif [ "$1" = "DHCP" ]; then
		echo "dhcp recover"
		config-wankeepalive.sh
		yotadebug $debug "[wan_backup.sh] call config-wankeepalive.sh"
	elif [ "$1" = "PPPOE" ]; then
		echo "pppoe recover"
		# set ppp0 gateway as default route
		PPP_GW=`ifconfig ppp0 | grep "inet addr" | awk 'FS="[ :]+" {print $6}'`
		if [ "$PPP_GW" != "" ]; then
			while route del default ; do
				:
				done
			route add default gw $PPP_GW dev ppp0
		fi
		/sbin/network_util.sh check_3g_dns	# check dns file
	elif [ "$1" = "L2TP" ]; then
		echo "l2tp recover"
		# when L2TP recovers before last pppd die, default route and dns might be changed by backup wan
		server=`test -f /var/ppp0_gw && cat /var/ppp0_gw`
		if [ "$server" != "" ]; then
			# if default route is wrong, restart
			temp=`route -n | grep ^0.0.0.0 | awk '{print $2}'`
			if [ "$temp" != "$server" ]; then
				killall -q pppd
				killall -q l2tpd
				yotadebug $debug "[wan_backup.sh] L2TP recover, restart"
				exit 0
			fi
		fi
	elif [ "$1" = "PPTP" ]; then
		echo "pptp recover"
		# when PPTP recovers before last pppd die, default route and dns might be changed by backup wan
		server=`test -f /var/ppp0_gw && cat /var/ppp0_gw`
		if [ "$server" != "" ]; then
			# if default route is wrong, restart
			temp=`route -n | grep ^0.0.0.0 | awk '{print $2}'`
			if [ "$temp" != "$server" ]; then
				killall -q pppd
				yotadebug $debug "[wan_backup.sh] PPTP recover, restart"
				exit 0
			fi
		fi
	elif [ "$1" = "3G" ]; then
		echo "3g recover"
		ifconfig $wan_if down up	# delete static routes added by dhcp server
		yotadebug $debug "[wan_backup.sh] $wan_if down and up"
	elif [ "$1" = "Wimax" ]; then
		echo "wimax recover"
		ifconfig $wan_if down up	# delete static routes added by dhcp server
		yotadebug $debug "[wan_backup.sh] $wan_if down and up"
		# check default route
		temp=`route -n | grep ^0.0.0.0 | grep wimax0`
		if [ "$temp" = "" ]; then	# no default route
			killall -SIGUSR1 udhcpc	#renew dhcp
			yotadebug $debug "[wan_backup.sh] renew Wimax dhcp"
		fi
		config-wankeepalive.sh
		yotadebug $debug "[wan_backup.sh] call config-wankeepalive.sh"
	else
		echo "wan_backup.sh: unknown wan connection type: $1"
		exit 1
	fi

	# routing
	/sbin/static_route.sh $1 backup &
	yotadebug $debug "[wan_backup.sh] set static route for wan $1"
	# nat
	/sbin/nat.sh dynamic &
	yotadebug $debug "[wan_backup.sh] set dynamic nat rules"
	# restart ddns, ntp, igmpproxy, upnp, pppoe-relay
	touch /var/do_up
fi

