#!/bin/sh
#
# $Id: wan.sh,v 1.18 2009-02-09 13:29:37 michael Exp $
#
# usage: wan.sh
#

. /sbin/global.sh

if [ "$1" == "3g_backup" ]; then
	echo "3G backup wan start"

	# hso driver
	(ifconfig | grep ppp1 > /dev/null) && ifconfig ppp1 down
	(lsmod | grep hso > /dev/null) && rmmod hso
	insmod -q hso inf_num=1

	3g.sh "3g_backup"  
	exit 1
fi

# stop all
#killall -q syslogd
killall -q -SIGTERM udhcpc
killall -q pppd
killall -q l2tpd
killall -q openl2tpd
killall -q config-l2tp.sh
killall -q config-pptp.sh
killall -q pingkeepalive

# hso driver
(ifconfig | grep ppp0 > /dev/null) && ifconfig ppp0 down
(ifconfig | grep ppp1 > /dev/null) && ifconfig ppp1 down
(lsmod | grep hso > /dev/null) && rmmod hso

#clean routing information
ifconfig $wan_if 0.0.0.0

clone_en=`nvram_get 2860 macCloneEnabled`
clone_mac=`nvram_get 2860 macCloneMac`
#MAC Clone: bridge mode doesn't support MAC Clone
if [ "$opmode" != "0" ]; then
	if [ "$clone_en" = "1" -a "$clone_mac" != "" ]; then
		wan_mac="$clone_mac"
	else
		wan_mac=`ralink_init getmac wan`
	fi
	ifconfig $wan_if down
	if [ "$opmode" = "2" ]; then
		rmmod rt2860v2_sta
		insmod rt2860v2_sta mac=$wan_mac
	else
		ifconfig $wan_if hw ether $wan_mac
	fi
	ifconfig $wan_if up
fi

#Reset WAN physical mode
FB_CHK1=$(mii_mgr -g -p 17 -r 2 | grep "0243")
FB_CHK2=$(mii_mgr -g -p 17 -r 3 | grep "0c54")
if [ "$FB_CHK1" != "" -a  "$FB_CHK2" != "" ]; then
	MII_IF="17"
	mii_mgr -s -p 17 -r 0 -v 0x2100
	echo "Fiber WAN fix in 100 full type!!"
else
	wan_phy_mode=`nvram_get 2860 wan_phy`
	#echo "wan_phy_mode $wan_phy_mode"
	if [ "$wan_phy_mode" = 1 ]; then
		#100 full
		mii_mgr -s -p 1 -r 0 -v 0x2100
	elif [ "$wan_phy_mode" = 2 ]; then
		#100 half
		mii_mgr -s -p 1 -r 0 -v 0x2000
	elif [ "$wan_phy_mode" = 3 ]; then
		#10 full
		mii_mgr -s -p 1 -r 0 -v 0x0100
	elif [ "$wan_phy_mode" = 4 ]; then
		#10 half
		mii_mgr -s -p 1 -r 0 -v 0x0000
	else	
		#auto
		mii_mgr -s -p 1 -r 0 -v 0x3100
	fi
fi

if [ "$wanmode" = "STATIC" -o "$opmode" = "0" ]; then
	#always treat bridge mode having static wan connection
	ip=`nvram_get 2860 wan_ipaddr`
	nm=`nvram_get 2860 wan_netmask`
	gw=`nvram_get 2860 wan_gateway`
	pd=`nvram_get 2860 wan_primary_dns`
	sd=`nvram_get 2860 wan_secondary_dns`

	#lan and wan ip should not be the same except in bridge mode
	if [ "$opmode" != "0" ]; then
		lan_ip=`nvram_get 2860 lan_ipaddr`
		if [ "$ip" = "$lan_ip" ]; then
			echo "wan.sh: warning: WAN's IP address is set identical to LAN"
			exit 0
		fi
	else
		#use lan's ip address instead
		ip=`nvram_get 2860 lan_ipaddr`
		nm=`nvram_get 2860 lan_netmask`
	fi
	ifconfig $wan_if $ip netmask $nm
	route del default
	if [ "$gw" != "" ]; then
	route add default gw $gw
	fi
	#Add ping detect target route
	PING_MODE=`nvram_get 2860 wanDetectMode`	
	if [ "$PING_MODE" == 2 ]; then
		PING_IP=`nvram_get 2860 wanDetectPing`
		route add $PING_IP gw $gw dev $wan_if 
	fi
	config-dns.sh $pd $sd
	config-wankeepalive.sh
elif [ "$wanmode" = "DHCP" ]; then
	host=`nvram_get 2860 HostName`
	if [ "$host" != "" ]; then
		echo $host > /proc/sys/kernel/hostname
		#add dhcp option 121 (staticroutes), option 33
		udhcpc -i $wan_if -s /sbin/udhcpc.sh -H $host -O staticroutes -O routes -p /var/run/udhcpc.pid &
	else
		echo draytek > /proc/sys/kernel/hostname
		#add dhcp option 121 (staticroutes), option 33
		udhcpc -i $wan_if -s /sbin/udhcpc.sh -O staticroutes -O routes -p /var/run/udhcpc.pid &
	fi
	touch /var/network/dhcp_wan_start	# G34472, nancy
	config-wankeepalive.sh
elif [ "$wanmode" = "PPPOE" ]; then
	u=`nvram_get 2860 wan_pppoe_user`
	pw=`nvram_get 2860 wan_pppoe_pass`
	pppoe_opmode=`nvram_get 2860 wan_pppoe_opmode`
	if [ "$pppoe_opmode" = "" ]; then
		echo "pppoecd $wan_if -u $u -p $pw"
		pppoecd $wan_if -u "$u" -p "$pw"
	else
		pppoe_optime=`nvram_get 2860 wan_pppoe_optime`
		config-pppoe.sh $u $pw $wan_if $pppoe_opmode $pppoe_optime
	fi
elif [ "$wanmode" = "L2TP" ]; then
	srv=`nvram_get 2860 wan_l2tp_server`
	u=`nvram_get 2860 wan_l2tp_user`
	pw=`nvram_get 2860 wan_l2tp_pass`
	mode=`nvram_get 2860 wan_l2tp_mode`
	l2tp_opmode=`nvram_get 2860 wan_l2tp_opmode`
	l2tp_optime=`nvram_get 2860 wan_l2tp_optime`
	
	#add dns file
	pd=`nvram_get 2860 dhcpPriDns`
	sd=`nvram_get 2860 dhcpSecDns`
	config-dns.sh $pd $sd
	
	if [ "$mode" = "0" ]; then
		ip=`nvram_get 2860 wan_l2tp_ip`
		nm=`nvram_get 2860 wan_l2tp_netmask`
		gw=`nvram_get 2860 wan_l2tp_gateway`
		if [ "$gw" = "" ]; then
			gw="0.0.0.0"
		fi
		config-l2tp.sh static $wan_if $ip $nm $gw $srv $u $pw $l2tp_opmode $l2tp_optime &
	else
		config-l2tp.sh dhcp $wan_if $srv $u $pw $l2tp_opmode $l2tp_optime &
	fi
elif [ "$wanmode" = "PPTP" ]; then
	srv=`nvram_get 2860 wan_pptp_server`
	u=`nvram_get 2860 wan_pptp_user`
	pw=`nvram_get 2860 wan_pptp_pass`
	mode=`nvram_get 2860 wan_pptp_mode`
	pptp_opmode=`nvram_get 2860 wan_pptp_opmode`
	pptp_optime=`nvram_get 2860 wan_pptp_optime`
	
	#add dns file
	pd=`nvram_get 2860 dhcpPriDns`
	sd=`nvram_get 2860 dhcpSecDns`
	config-dns.sh $pd $sd
	
	if [ "$mode" = "0" ]; then
		ip=`nvram_get 2860 wan_pptp_ip`
		nm=`nvram_get 2860 wan_pptp_netmask`
		gw=`nvram_get 2860 wan_pptp_gateway`
		if [ "$gw" = "" ]; then
			gw="0.0.0.0"
		fi
		config-pptp.sh static $wan_if $ip $nm $gw $srv $u $pw $pptp_opmode $pptp_optime &
	else
		config-pptp.sh dhcp $wan_if $srv $u $pw $pptp_opmode $pptp_optime &
	fi
elif [ "$wanmode" = "3G" ]; then
		# hso driver
		insmod -q hso
		temp=`cat /var/3g/wan_dev`
		if [ "$temp" = "/dev/ttyHS0" ]; then
			UP_TIME=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
			if [ $UP_TIME -lt 40 ]; then
				gpio u
			fi
		fi

		SCHE_LCOK=`cat /var/3g/sche_lock`
		if [ "$SCHE_LCOK" == "1" ]; then
			#3G schedule path
			echo "3G lock!!!"
			exit 1
		else		
			3g.sh &
		fi
else
	echo "wan.sh: unknown wan connection type: $wanmode"
	exit 1
fi

# tell 3g_backup that the wan mode is changed
echo 1 > /var/network/backupStandby
