#!/bin/sh
# Draytek
# 
# Add RoutingRules entries into routing table accroding to multi wan mode.
# 

if [ "$1" = "" ]; then
	echo "usage : static_route_multi_wan.sh [multi wanmode]"
	exit 1
fi

if [ "$1" = "VOIP_WAN" ]; then
	VOIP_TYPE=`nvram_get 2860 VOIP_WAN_TYPE`
	if [ "$VOIP_TYPE" = "DHCP" ]; then
		VOIP_IF=eth2.6
	elif [ "$VOIP_TYPE" = "PPPOE" ]; then
		VOIP_IF=ppp6
	fi
	rules=`nvram_get 2860 RoutingRules | sed 's/;/\n/g'`
	for temp in $rules; do
		i=0
		dest=""
		netmask=""
		gateway=""
		type=""
		interface=""
		wan_mode=""
		entry=`echo $temp | sed 's/,/ /g'`
		for temp2 in $entry; do
			if [ "$i" = "0" ]; then
				dest=$temp2
			elif [ "$i" = "1" ]; then
				netmask=$temp2
			elif [ "$i" = "2" ]; then
				if [ "$temp2" != "0.0.0.0" ]; then
					gateway="gw $temp2"
				fi
			elif [ "$i" = "3" ]; then
				type=$temp2
			elif [ "$i" = "4" ]; then
				interface=$temp2
			elif [ "$i" = "5" ]; then
				wan_mode=$temp2
				break
			fi
			i=$(expr $i + 1)
		done

		if [ "$interface" = "$VOIP_IF" ]; then
				# Add static route with specified wan mode
			if [ "$netmask" = "255.255.255.255" ]; then
				route add -host $dest $gateway dev $interface > /dev/null 2>&1
				#echo "route add -host $dest $gateway dev $interface > /dev/null 2>&1"
			else
				route add -net $dest netmask $netmask $gateway dev $interface > /dev/null 2>&1
				#echo "route add -net $dest netmask $netmask $gateway dev $interface > /dev/null 2>&1"
			fi
		fi
	done
fi

if [ "$1" = "MGMT_WAN" ]; then
	MGMT_TYPE=`nvram_get 2860 MGMT_WAN_TYPE`
	if [ "$MGMT_TYPE" = "DHCP" ]; then
		MGMT_IF=eth2.7
	elif [ "$MGMT_TYPE" = "PPPOE" ]; then
		MGMT_IF=ppp7
	fi
	rules=`nvram_get 2860 RoutingRules | sed 's/;/\n/g'`
	for temp in $rules; do
		i=0
		dest=""
		netmask=""
		gateway=""
		type=""
		interface=""
		wan_mode=""
		entry=`echo $temp | sed 's/,/ /g'`
		for temp2 in $entry; do
			if [ "$i" = "0" ]; then
				dest=$temp2
			elif [ "$i" = "1" ]; then
				netmask=$temp2
			elif [ "$i" = "2" ]; then
				if [ "$temp2" != "0.0.0.0" ]; then
					gateway="gw $temp2"
				fi
			elif [ "$i" = "3" ]; then
				type=$temp2
			elif [ "$i" = "4" ]; then
				interface=$temp2
			elif [ "$i" = "5" ]; then
				wan_mode=$temp2
				break
			fi
			i=$(expr $i + 1)
		done

		if [ "$interface" = "$MGMT_IF" ]; then
				# Add static route with specified wan mode
			if [ "$netmask" = "255.255.255.255" ]; then
				route add -host $dest $gateway dev $interface > /dev/null 2>&1
				#echo "route add -host $dest $gateway dev $interface > /dev/null 2>&1"
			else
				route add -net $dest netmask $netmask $gateway dev $interface > /dev/null 2>&1
				#echo "route add -net $dest netmask $netmask $gateway dev $interface > /dev/null 2>&1"
			fi
		fi
	done
fi
