#!/bin/sh
#
lan_ip=`nvram_get 2860 lan_ipaddr`

if [ "$1" == "3g" ]; then
	#set nat rule
	iptables -t nat -D POSTROUTING -s $lan_ip/24 -o eth2.2 -j MASQUERADE
	/sbin/nat.sh 3g_backup
	
	#set 3g gateway
	GW=`ifconfig ppp1 | grep P-t-P | awk '{print $3}' | awk 'FS="[:]+" {print $2}'`
	route del default
	route add default gw $GW dev ppp1
    echo "route add default gw $GW dev ppp1"
	
	#set dns if needed
	if [ -f /var/pptp_l2tp_dns ]; then
		cp /var/pptp_l2tp_dns /etc/resolv.conf
	fi
	
	#clean icmp conntrack cache  by bruce hsu
	echo 0 > /proc/sys/net/netfilter/nf_conntrack_icmp_timeout
	sleep 5
	echo 30 > /proc/sys/net/netfilter/nf_conntrack_icmp_timeout
	
elif [ "$1" == "wan" ]; then
	#set nat rule
	iptables -t nat -D POSTROUTING -s $lan_ip/24 -o ppp1 -j MASQUERADE
	/sbin/nat.sh
	#set wan gateway
	GW=`nvram_get 2860 wan_gateway`
	route del default
	route add default gw $GW dev eth2.2
    echo "route add default gw $GW dev eth2.2"
	
	#set dns if needed
	DNS1=`nvram_get 2860 wan_primary_dns`
	DNS2=`nvram_get 2860 wan_secondary_dns`
	if [ "$DNS1" != "" ]; then
		echo nameserver $DNS1 > /etc/resolv.conf
		if [ "$DNS2" != "" ]; then
		echo nameserver $DNS2 >> /etc/resolv.conf
		
		fi
	fi
	
	#clean icmp conntrack cache  by bruce hsu
	echo 0 > /proc/sys/net/netfilter/nf_conntrack_icmp_timeout
	sleep 5
	echo 30 > /proc/sys/net/netfilter/nf_conntrack_icmp_timeout
fi