#!/bin/sh
#
# $Id: internet.sh,v 1.71 2009-02-25 01:31:35 steven Exp $
#
# usage: internet.sh
#
lockdir=/var/internet.sh.lock
while ! mkdir $lockdir 2>/dev/null; do sleep 1; done
trap 'rm -rf $lockdir' 0 2 9 15

. /sbin/config.sh
. /sbin/global.sh

ApCliSetWAN()
{
    if [ "$wanmode" = "STATIC" ]; then
	  echo "interenet.sh ApCli set STATIC"
	  ip=`nvram_get 2860 wan_ipaddr`
	  nm=`nvram_get 2860 wan_netmask`
	  gw=`nvram_get 2860 wan_gateway`
	  ifconfig $wan_if $ip netmask $nm
	  route del default
	  if [ "$gw" != "" ]; then
	    route add default gw $gw
	  fi
	else
	  echo "interenet.sh ApCli set DHCP"
	  host=`nvram_get 2860 HostName`
	  if [ "$host" == "" ]; then
	    host="VigorFly210"
	  fi
	  udhcpc -i $wan_if -s /sbin/udhcpc.sh -H $host -p /var/run/udhcpc.pid &
	fi
}

if [ "$1" == "SetApCliWAN" ]; then
  ApCliSetWAN
  exit
fi

if [ "$1" == "no-multi-vlan" ]; then
  CONFIG_USER_MULTI_VLAN=""
else
  CONFIG_USER_MULTI_VLAN="y"
fi
lan_ip=`nvram_get 2860 lan_ipaddr`
stp_en=`nvram_get 2860 stpEnabled`
nat_en=`nvram_get 2860 natEnabled`
bssidnum=`nvram_get 2860 BssidNum`
radio_off=`nvram_get 2860 RadioOff`
wi_mc_enable0=`nvram_get 2860 wiMacCloneEnabled0`
wi_mc_mac0=`nvram_get 2860 wiMacCloneMac0`
ioskeepalive_enable=`nvram_get 2860 ioskeepaliveEnabled`

set_vlan_map()
{
	if [ "$CONFIG_RAETH_QOS_PORT_BASED" = "y" ]; then
	# vlan priority tag => skb->priority mapping
	vconfig set_ingress_map $1 0 0
	vconfig set_ingress_map $1 1 1
	vconfig set_ingress_map $1 2 2
	vconfig set_ingress_map $1 3 3
	vconfig set_ingress_map $1 4 4
	vconfig set_ingress_map $1 5 5
	vconfig set_ingress_map $1 6 6
	vconfig set_ingress_map $1 7 7

	# skb->priority => vlan priority tag mapping
	vconfig set_egress_map $1 0 0
	vconfig set_egress_map $1 1 1
	vconfig set_egress_map $1 2 2
	vconfig set_egress_map $1 3 3
	vconfig set_egress_map $1 4 4
	vconfig set_egress_map $1 5 5
	vconfig set_egress_map $1 6 6
	vconfig set_egress_map $1 7 7
	fi
}

ifRaxWdsxDown()
{
	ifconfig ra0 down > /dev/null 2>&1
	ifconfig ra1 down > /dev/null 2>&1
	ifconfig ra2 down > /dev/null 2>&1

	ifconfig wds0 down > /dev/null 2>&1
	ifconfig wds1 down > /dev/null 2>&1
	ifconfig wds2 down > /dev/null 2>&1
	ifconfig wds3 down > /dev/null 2>&1

	ifconfig apcli0 down > /dev/null 2>&1

	ifconfig mesh0 down > /dev/null 2>&1
}

addBrlan()
{
	brctl addbr $Brlan_if
	# Make br-lan enter forwarding state early.
	stp=`nvram_get 2860 stpEnabled`
	if [ "$stp" = "0" ]; then
		brctl setfd $Brlan_if 1
	fi
	#set LAN/WLAN interface
	VLAN_ENABLE=`nvram_get 2860 VLAN_EN`
	if [ "$VLAN_ENABLE" != "1" ];then
		#set default
		#LAN/WLAN
		brctl addif $Brlan_if eth2.1
		brctl addif $Brlan_if eth2.3
		brctl addif $Brlan_if eth2.4
		brctl addif $Brlan_if eth2.5
		brctl addif $Brlan_if ra0
		if [ "$bssidnum" = "2" ]; then
			brctl addif $Brlan_if ra1
		elif [ "$bssidnum" = "3" ]; then
			brctl addif $Brlan_if ra1
			brctl addif $Brlan_if ra2
		fi
	else
		VLAN_NAT=`nvram_get 2860 VLAN_NAT`
		P2_NAT=`echo "$VLAN_NAT" | awk 'FS="[,]+" {print $4}'`
		P3_NAT=`echo "$VLAN_NAT" | awk 'FS="[,]+" {print $5}'`
		P4_NAT=`echo "$VLAN_NAT" | awk 'FS="[,]+" {print $6}'`
		S1_NAT=`echo "$VLAN_NAT" | awk 'FS="[,]+" {print $7}'`
		S2_NAT=`echo "$VLAN_NAT" | awk 'FS="[,]+" {print $8}'`
		S3_NAT=`echo "$VLAN_NAT" | awk 'FS="[,]+" {print $9}'`
		#LAN/WLAN
		brctl addif $Brlan_if eth2.1
		if [ "$P2_NAT" == "1" ]; then
			brctl addif $Brlan_if eth2.3
		fi
		if [ "$P3_NAT" == "1" ]; then
			brctl addif $Brlan_if eth2.4
		fi
		if [ "$P4_NAT" == "1" ]; then
			brctl addif $Brlan_if eth2.5
		fi
		if [ "$S1_NAT" == "1" ]; then
			brctl addif $Brlan_if ra0
		fi
		if [ "$bssidnum" == "2" ]; then
			if [ "$S2_NAT" == "1" ]; then
				brctl addif $Brlan_if ra1
			fi
		elif [ "$bssidnum" == "3" ]; then
			if [ "$S2_NAT" == "1" ]; then
				brctl addif $Brlan_if ra1
			fi
			if [ "$S3_NAT" == "1" ]; then
				brctl addif $Brlan_if ra2
			fi
		fi
	fi
}

addBr0()
{
	brctl addbr br0
	# Make br0 enter forwarding state early.
	stp=`nvram_get 2860 stpEnabled`
	if [ "$stp" = "0" ]; then
		brctl setfd br0 1
	fi
	brctl addif br0 ra0
}

addRax2Br0()
{
	if [ "$bssidnum" = "2" ]; then
		brctl addif br0 ra1
	elif [ "$bssidnum" = "3" ]; then
		brctl addif br0 ra1
		brctl addif br0 ra2
	fi
}

addWds2Br0()
{
	wds_en=`nvram_get 2860 WdsEnable`
	if [ "$wds_en" != "0" ]; then
		ifconfig wds0 up
		ifconfig wds1 up
		ifconfig wds2 up
		ifconfig wds3 up
		brctl addif $Brlan_if wds0
		brctl addif $Brlan_if wds1
		brctl addif $Brlan_if wds2
		brctl addif $Brlan_if wds3
	fi
}

addMesh2Br0()
{
	meshenabled=`nvram_get 2860 MeshEnabled`
	if [ "$meshenabled" = "1" ]; then
		ifconfig mesh0 up
		brctl addif $Brlan_if mesh0
		meshhostname=`nvram_get 2860 MeshHostName`
		iwpriv mesh0 set  MeshHostName="$meshhostname"
	fi
}

addRaix2Br0()
{
	inic_bssnum=`nvram_get inic BssidNum`
	if [ "$CONFIG_RT2880_INIC" == "" -a "$CONFIG_INIC_MII" == "" -a "$CONFIG_INIC_PCI" == "" -a "$CONFIG_INIC_USB" == "" ]; then
		return
	fi
	brctl addif $Brlan_if rai0

	if [ "$inic_bssnum" = "2" ]; then
		ifconfig rai1 up
		brctl addif $Brlan_if rai1
	elif [ "$inic_bssnum" = "3" ]; then
		ifconfig rai1 up
		ifconfig rai2 up
		brctl addif $Brlan_if rai1
		brctl addif $Brlan_if rai2
	elif [ "$inic_bssnum" = "4" ]; then
		ifconfig rai1 up
		ifconfig rai2 up
		ifconfig rai3 up
		brctl addif $Brlan_if rai1
		brctl addif $Brlan_if rai2
		brctl addif $Brlan_if rai3
	elif [ "$inic_bssnum" = "5" ]; then
		ifconfig rai1 up
		ifconfig rai2 up
		ifconfig rai3 up
		ifconfig rai4 up
		brctl addif $Brlan_if rai1
		brctl addif $Brlan_if rai2
		brctl addif $Brlan_if rai3
		brctl addif $Brlan_if rai4
	elif [ "$inic_bssnum" = "6" ]; then
		ifconfig rai1 up
		ifconfig rai2 up
		ifconfig rai3 up
		ifconfig rai4 up
		ifconfig rai5 up
		brctl addif $Brlan_if rai1
		brctl addif $Brlan_if rai2
		brctl addif $Brlan_if rai3
		brctl addif $Brlan_if rai4
		brctl addif $Brlan_if rai5
	elif [ "$inic_bssnum" = "7" ]; then
		ifconfig rai1 up
		ifconfig rai2 up
		ifconfig rai3 up
		ifconfig rai4 up
		ifconfig rai5 up
		ifconfig rai6 up
		brctl addif $Brlan_if rai1
		brctl addif $Brlan_if rai2
		brctl addif $Brlan_if rai3
		brctl addif $Brlan_if rai4
		brctl addif $Brlan_if rai5
		brctl addif $Brlan_if rai6
	elif [ "$inic_bssnum" = "8" ]; then
		ifconfig rai1 up
		ifconfig rai2 up
		ifconfig rai3 up
		ifconfig rai4 up
		ifconfig rai5 up
		ifconfig rai6 up
		ifconfig rai7 up
		brctl addif $Brlan_if rai1
		brctl addif $Brlan_if rai2
		brctl addif $Brlan_if rai3
		brctl addif $Brlan_if rai4
		brctl addif $Brlan_if rai5
		brctl addif $Brlan_if rai6
		brctl addif $Brlan_if rai7
	fi
}

addInicWds2Br0()
{
	if [ "$CONFIG_RT2880_INIC" == "" -a "$CONFIG_INIC_MII" == "" -a "$CONFIG_INIC_PCI" == "" -a "$CONFIG_INIC_USB" == "" ]; then
		return
	fi
	wds_en=`nvram_get inic WdsEnable`
	if [ "$wds_en" != "0" ]; then
		ifconfig wdsi0 up
		ifconfig wdsi1 up
		ifconfig wdsi2 up
		ifconfig wdsi3 up
		brctl addif $Brlan_if wdsi0
		brctl addif $Brlan_if wdsi1
		brctl addif $Brlan_if wdsi2
		brctl addif $Brlan_if wdsi3
	fi
}

addRaL02Br0()
{
	if [ "$CONFIG_RT2561_AP" != "" ]; then
		brctl addif $Brlan_if raL0
	fi
}

genSysFiles()
{
	login=`nvram_get 2860 Login`
	pass=`nvram_get 2860 Password`
	if [ "$login" != "" -a "$pass" != "" ]; then
	echo "$login::0:0:Adminstrator:/:/bin/sh" > /etc/passwd
	echo "$login:x:0:$login" > /etc/group
		chpasswd.sh $login $pass
	fi
	if [ "$CONFIG_PPPOL2TP" == "y" ]; then
	echo "l2tp 1701/tcp l2f" > /etc/services
	echo "l2tp 1701/udp l2f" >> /etc/services
	fi
}

genDevNode()
{
#Linux2.6 uses udev instead of devfs, we have to create static dev node by myself.
if [ "$CONFIG_DWC_OTG" == "m" -a "$CONFIG_HOTPLUG" == "y" ]; then
	#Marked by james.lin to prevent /dev having too many dev nods
	#mounted=`mount | grep mdev | wc -l`
	#if [ $mounted -eq 0 ]; then
	#mount -t ramfs mdev /dev/
	#mkdir /dev/pts
	#mount -t devpts devpts /dev/pts
        #mdev -s

        #mknod   /dev/video0      c       81      0
        #mknod   /dev/spiS0       c       217     0
        #mknod   /dev/i2cM0       c       218     0
        #mknod   /dev/rdm0        c       254     0
        #mknod   /dev/flash0      c       200     0
        #mknod   /dev/swnat0      c       210     0
        #mknod   /dev/hwnat0      c       220     0
        #mknod   /dev/acl0        c       230     0
        #mknod   /dev/ac0         c       240     0
        #mknod   /dev/mtr0        c       250     0
        #mknod   /dev/gpio        c       252     0
	#mknod   /dev/PCM         c       233     0
	#mknod   /dev/I2S         c       234     0
	#fi

	echo "# <device regex> <uid>:<gid> <octal permissions> [<@|$|*> <command>]" > /etc/mdev.conf
        echo "# The special characters have the meaning:" >> /etc/mdev.conf
        echo "# @ Run after creating the device." >> /etc/mdev.conf
        echo "# $ Run before removing the device." >> /etc/mdev.conf
        echo "# * Run both after creating and before removing the device." >> /etc/mdev.conf
        echo "sd[a-z][1-9] 0:0 0660 */sbin/automount.sh \$MDEV" >> /etc/mdev.conf

        #enable usb hot-plug feature
        echo "/sbin/mdev" > /proc/sys/kernel/hotplug

fi
}

# Remove bridge device br0 before driver down
ifconfig br0 down > /dev/null 2>&1
brctl delbr br0 > /dev/null 2>&1
# Ehternet WAN interface down  //bruce
ifconfig eth2.2 down > /dev/null 2>&1
ifconfig eth2.6 down > /dev/null 2>&1
ifconfig eth2.7 down > /dev/null 2>&1
# Close WAN PHY port //bruce
FB_CHK1=$(mii_mgr -g -p 17 -r 2 | grep "0243")
FB_CHK2=$(mii_mgr -g -p 17 -r 3 | grep "0c54")
if [ "$FB_CHK1" != "" -a  "$FB_CHK2" != "" ]; then
	mii_mgr -s -p 17 -r 0 -v 0x2900
else
	mii_mgr -s -p 1 -r 0 -v 0x3900
fi
#killall WAN related application. bruce 2012/09/26
killall -q pppd

# opmode adjustment:
#   if AP client was not compiled and operation mode was set "3" -> set $opmode "1"
#   if Station was not compiled and operation mode was set "2" -> set $opmode "1"
if [ "$opmode" = "3" -a "$CONFIG_RT2860V2_AP_APCLI" != "y" ]; then
	nvram_set 2860 OperationMode 1
	opmode="1"
fi
if [ "$opmode" = "2" -a "$CONFIG_RT2860V2_STA" == "" ]; then
	nvram_set 2860 OperationMode 1
	opmode="1"
fi

genSysFiles
genDevNode

# insmod all
#insmod -q bridge
#insmod -q mii
#insmod -q raeth
ifconfig eth2 0.0.0.0

ifRaxWdsxDown
rmmod rt2860v2_ap > /dev/null 2>&1
rmmod rt2860v2_sta > /dev/null 2>&1
ralink_init make_wireless_config rt2860
if [ "$stamode" = "y" ]; then
	if [ "$opmode" = "2" -a "$wi_mc_enable0" = "1" -a "$wi_mc_mac0" != "" ]; then
		# wireless mac clone
		insmod -q rt2860v2_sta mac=$wi_mc_mac0
	else
		insmod -q rt2860v2_sta
	fi
else
	if [ "$CONFIG_RT2860V2_AP_DFS" = "y" ]; then
		insmod -q rt_timer
	fi
	insmod -q rt2860v2_ap
fi

#vpn-passthru.sh --> nf_nat_pptp, nf_conntrack_pptp....don't exist. Don't need to execute it.

# INIC support
if [ "$CONFIG_INIC_MII" != "" -o "$CONFIG_INIC_PCI" != ""  -o "$CONFIG_INIC_USB" != "" ]; then
        iNIC_Mii_en=`nvram_get inic InicMiiEnable`
        iNIC_USB_en=`nvram_get inic InicUSBEnable`
        ifconfig rai0 down
        ralink_init make_wireless_config inic
if [ "$iNIC_USB_en" == "1" ]; then
        rmmod iNIC_usb
        insmod -q iNIC_usb 
        ifconfig rai0 up
elif [ "$CONFIG_INIC_PCI" != "" ]; then
        rmmod iNIC_pci
        insmod -q iNIC_pci 
        ifconfig rai0 up
fi
fi

# RT2561(Legacy) support
#if [ "$CONFIG_RT2561_AP" != "" ]; then
#	ifconfig raL0 down
#	rmmod rt2561ap
#	ralink_init make_wireless_config rt2561
#	insmod -q rt2561ap
#	ifconfig raL0 up
#fi

# config interface
ifconfig ra0 0.0.0.0
if [ "$ethconv" = "y" ]; then
	iwpriv ra0 set EthConvertMode=dongle
fi
if [ "$radio_off" = "1" ]; then
	iwpriv ra0 set RadioOn=0
fi
if [ "$bssidnum" = "2" ]; then
	ifconfig ra1 0.0.0.0
elif [ "$bssidnum" = "3" ]; then
	ifconfig ra1 0.0.0.0
	ifconfig ra2 0.0.0.0
fi

if [ "$CONFIG_RAETH_ROUTER" = "y" -o "$CONFIG_MAC_TO_MAC_MODE" = "y" -o "$CONFIG_RT_3052_ESW" = "y" ]; then
	#insmod -q 8021q --> this module doesn't exist
	if [ "$CONFIG_USER_MULTI_VLAN" = "y" ]; then
		vconfig add eth2 1
		vconfig add eth2 2
		vconfig add eth2 3
		vconfig add eth2 4
		vconfig add eth2 5
		#voip wan is eth2.6 always!!!
		vconfig add eth2 6
		#mgmt wan is eth2.7 always!!!
		vconfig add eth2 7
		#no need set vlan map QoS,priority...  by bruce 2011/05/22
		#set_vlan_map eth2.1
		#set_vlan_map eth2.2
		#Set WAN MAC
		ifconfig eth2.2 down
		ifconfig eth2.6 down
		ifconfig eth2.7 down
		wan_mac=`ralink_init getmac wan`
		if [ "$wan_mac" != "FF:FF:FF:FF:FF:FF" ]; then
			ifconfig eth2.2 hw ether $wan_mac
			#voip wan 
			ifconfig eth2.6 hw ether $wan_mac
			ifconfig eth2.7 hw ether $wan_mac
		fi
		#Set interface up
		ifconfig eth2.1 0.0.0.0
		ifconfig eth2.2 0.0.0.0
		ifconfig eth2.3 0.0.0.0
		ifconfig eth2.4 0.0.0.0
		ifconfig eth2.5 0.0.0.0
		#voip wan is eth2.6 always!!!
		ifconfig eth2.6 0.0.0.0
		#mgmt wan is eth2.7 always!!!
		ifconfig eth2.7 0.0.0.0
	else
		vconfig add eth2 1
		set_vlan_map eth2.1
		vconfig add eth2 2
		set_vlan_map eth2.2
		#Set WAN MAC
		ifconfig eth2.2 down
		wan_mac=`ralink_init getmac wan`
		if [ "$wan_mac" != "FF:FF:FF:FF:FF:FF" ]; then
			ifconfig eth2.2 hw ether $wan_mac
		fi
		ifconfig eth2.1 0.0.0.0
		ifconfig eth2.2 0.0.0.0
	fi
elif [ "$CONFIG_ICPLUS_PHY" = "y" ]; then
	#remove ip alias
	# it seems busybox has no command to remove ip alias...
	ifconfig eth2:1 0.0.0.0 1>&2 2>/dev/null
fi

ifconfig lo 127.0.0.1
#ifconfig br0 down > /dev/null 2>&1
#brctl delbr br0 > /dev/null 2>&1

# stop all
iptables --flush
iptables --flush -t nat
iptables --flush -t mangle


#
# init ip address to all interfaces for different OperationMode:
#   0 = Bridge Mode
#   1 = Gateway Mode
#   2 = Ethernet Converter Mode
#   3 = AP Client
#
if [ "$opmode" = "0" ]; then
	addBr0
	if [ "$CONFIG_RAETH_ROUTER" = "y" -a "$CONFIG_LAN_WAN_SUPPORT" = "y" ]; then
		echo "##### restore IC+ to dump switch #####"
		config-vlan.sh 0 0
	elif [ "$CONFIG_MAC_TO_MAC_MODE" = "y" ]; then
		echo "##### restore Vtss to dump switch #####"
		config-vlan.sh 1 0
	elif [ "$CONFIG_RT_3052_ESW" = "y" ]; then
		if [ "$CONFIG_P5_RGMII_TO_MAC_MODE" = "y" ]; then
			echo "##### restore RT3052 to dump switch #####"
			config-vlan.sh 2 0
			echo "##### restore Vtss to dump switch #####"
			config-vlan.sh 1 0
		else
			echo "##### restore RT3052 to dump switch #####"
			config-vlan.sh 2 0
		fi
	fi
	brctl addif br0 eth2
	if [ "$CONFIG_RT2860V2_AP_MBSS" = "y" -a "$bssidnum" != "1" ]; then
		addRax2Br0
	fi

	#start mii iNIC after network interface is working
	iNIC_Mii_en=`nvram_get inic InicMiiEnable`
	if [ "$iNIC_Mii_en" == "1" ]; then
	     ifconfig rai0 down
	     rmmod iNIC_mii
	     insmod -q iNIC_mii miimaster=eth2
	     ifconfig rai0 up
	fi

	addWds2Br0
	addMesh2Br0
	addRaix2Br0
	addInicWds2Br0
	addRaL02Br0
	wan.sh
	lan.sh
	echo 0 > /proc/sys/net/ipv4/ip_forward
elif [ "$opmode" = "1" ]; then
	if [ "$CONFIG_RAETH_ROUTER" = "y" -o "$CONFIG_MAC_TO_MAC_MODE" = "y" -o "$CONFIG_RT_3052_ESW" = "y" ]; then
		if [ "$CONFIG_RAETH_ROUTER" = "y" -a "$CONFIG_LAN_WAN_SUPPORT" = "y" ]; then
			if [ "$CONFIG_WAN_AT_P1" = "y" ]; then
				echo '##### config IC+ vlan partition (LWLLL) #####'
				config-vlan.sh 0 LWLLL
			elif [ "$CONFIG_WAN_AT_P0" = "y" ]; then
				echo '##### config IC+ vlan partition (WLLLL) #####'
				config-vlan.sh 0 WLLLL
			else
				echo '##### config IC+ vlan partition (LLLLW) #####'
				config-vlan.sh 0 LLLLW
			fi
		fi
		if [ "$CONFIG_MAC_TO_MAC_MODE" = "y" ]; then
			echo '##### config Vtss vlan partition #####'
			config-vlan.sh 1 1
		fi
		if [ "$CONFIG_RT_3052_ESW" = "y" -a "$CONFIG_LAN_WAN_SUPPORT" = "y" ]; then
			if [ "$CONFIG_P5_RGMII_TO_MAC_MODE" = "y" ]; then
				echo "##### restore RT3052 to dump switch #####"
				config-vlan.sh 2 0
				echo "##### config Vtss vlan partition #####"
				config-vlan.sh 1 1
			else
				FB_CHK1=$(mii_mgr -g -p 17 -r 2 | grep "0243")
				FB_CHK2=$(mii_mgr -g -p 17 -r 3 | grep "0c54")
				if [ "$FB_CHK1" != "" -a  "$FB_CHK2" != "" ]; then
					#CONFIG_WAN_AT_P5
					if [ "$CONFIG_USER_MULTI_VLAN" != "y" ]; then
						echo '##### config RT3052 vlan partition (L0LLLW) #####'
						config-vlan.sh 2 L0LLLW
					else
						echo '##### config RT3052 vlan partition Multi-VLAN #####'
						multi_vlan FB
					fi
				elif [ "$CONFIG_WAN_AT_P1" = "y" ]; then
					if [ "$CONFIG_USER_MULTI_VLAN" != "y" ]; then
						echo '##### config RT3052 vlan partition (LWLLL) #####'
						config-vlan.sh 2 LWLLL
					else
						echo '##### config RT3052 vlan partition Multi-VLAN #####'
						multi_vlan ETH
					fi
				elif [ "$CONFIG_WAN_AT_P0" = "y" ]; then
					echo '##### config RT3052 vlan partition (WLLLL) #####'
					config-vlan.sh 2 WLLLL
				else
					echo '##### config RT3052 vlan partition (LLLLW) #####'
					config-vlan.sh 2 LLLLW
				fi
			fi
		fi
		#br0 interface
		if [ "$CONFIG_USER_MULTI_VLAN" = "y" ]; then
			Brlan_if="br0"
			addBrlan
			#WAN
			#brctl addbr br-wan
			#brctl addif br-wan eth2.2
		else
			Brlan_if="br0"
			addBr0
			brctl addif br0 eth2.1
			if [ "$CONFIG_RT2860V2_AP_MBSS" = "y" -a "$bssidnum" != "1" ]; then
				addRax2Br0
			fi
		fi
		addWds2Br0
		addMesh2Br0
		addRaix2Br0
		addInicWds2Br0
		addRaL02Br0
	fi

	# IC+ 100 PHY (one port only)
	if [ "$CONFIG_ICPLUS_PHY" = "y" ]; then
		echo '##### connected to one port 100 PHY #####'
		if [ "$CONFIG_RT2860V2_AP_MBSS" = "y" -a "$bssidnum" != "1" ]; then
			addBr0
			addRax2Br0
		fi
		addWds2Br0
		addMesh2Br0

		#
		# setup ip alias for user to access web page.
		#
		ifconfig eth2:1 172.32.1.254 netmask 255.255.255.0 up
	fi

	wan.sh
	lan.sh
	nat.sh
elif [ "$opmode" = "2" ]; then
	# if (-1 == initStaProfile())
	#   error(E_L, E_LOG, T("internet.c: profiles in nvram is broken"));
	# else
	#   initStaConnection();
	if [ "$CONFIG_RAETH_ROUTER" = "y" -a "$CONFIG_LAN_WAN_SUPPORT" = "y" ]; then
		echo "##### restore IC+ to dump switch #####"
		config-vlan.sh 0 0
	fi
	if [ "$CONFIG_MAC_TO_MAC_MODE" = "y" ]; then
		echo "##### restore Vtss to dump switch #####"
		config-vlan.sh 1 0
	fi
	if [ "$CONFIG_RT_3052_ESW" = "y" ]; then
		if [ "$CONFIG_P5_RGMII_TO_MAC_MODE" = "y" ]; then
			echo "##### restore RT3052 to dump switch #####"
			config-vlan.sh 2 0
			echo "##### restore Vtss to dump switch #####"
			config-vlan.sh 1 0
		else
			echo "##### restore RT3052 to dump switch #####"
			config-vlan.sh 2 0
		fi
	fi
	wan.sh
	lan.sh
	nat.sh
elif [ "$opmode" = "3" ]; then
	if [ "$CONFIG_RAETH_ROUTER" = "y" -o "$CONFIG_MAC_TO_MAC_MODE" = "y" -o "$CONFIG_RT_3052_ESW" = "y" ]; then
		if [ "$CONFIG_RAETH_ROUTER" = "y" ]; then
			echo "##### restore IC+ to dump switch #####"
			config-vlan.sh 0 0
		fi
		if [ "$CONFIG_MAC_TO_MAC_MODE" = "y" ]; then
			echo "##### restore Vtss to dump switch #####"
			config-vlan.sh 1 0
		fi
		if [ "$CONFIG_RT_3052_ESW" = "y" ]; then
			if [ "$CONFIG_P5_RGMII_TO_MAC_MODE" = "y" ]; then
				echo "##### restore RT3052 to dump switch #####"
				config-vlan.sh 2 0
				echo "##### restore Vtss to dump switch #####"
				config-vlan.sh 1 0
			else
				echo "##### restore RT3052 to dump switch #####"
				config-vlan.sh 2 0
			fi
		fi
		addBr0
		brctl addif br0 eth2
		if [ "$CONFIG_RT2860V2_AP_MBSS" = "y" -a "$bssidnum" != "1" ]; then
			addRax2Br0
		fi
	fi
	wan.sh
	lan.sh
	nat.sh
else
	echo "unknown OperationMode: $opmode"
	exit 1
fi

# INIC support
#if [ "$CONFIG_RT2880_INIC" != "" ]; then
#	ifconfig rai0 down
#	rmmod rt_pci_dev
#	ralink_init make_wireless_config inic
#	insmod -q rt_pci_dev
#	ifconfig rai0 up
#	RaAP&
#	sleep 3
#fi

# in order to use broadcast IP address in L2 management daemon
if [ "$CONFIG_ICPLUS_PHY" = "y" ]; then
	route add -host 255.255.255.255 dev $wan_if
else
	route add -host 255.255.255.255 dev $lan_if
fi


m2uenabled=`nvram_get 2860 M2UEnabled`
if [ "$m2uenabled" = "1" ]; then
	iwpriv ra0 set IgmpSnEnable=1
	echo "iwpriv ra0 set IgmpSnEnable=1"
fi
#restart8021XDaemon(RT2860_NVRAM);
#firewall_init();
#management_init();

mod_exist=$(lsmod | grep [x]t_mac)
if [ "$mod_exist" = "" ]; then
# Add these netfilter xtables support
insmod xt_mac  > /dev/null 2>&1
insmod xt_state  > /dev/null 2>&1
insmod xt_TCPMSS  > /dev/null 2>&1
insmod xt_tcpmss  > /dev/null 2>&1
insmod xt_limit.ko  > /dev/null 2>&1
insmod xt_length.ko > /dev/null 2>&1
insmod xt_layer7.ko > /dev/null 2>&1
insmod xt_helper.ko > /dev/null 2>&1
insmod xt_dscp.ko > /dev/null 2>&1
insmod xt_conntrack.ko > /dev/null 2>&1
insmod xt_MARK.ko > /dev/null 2>&1
insmod xt_DSCP.ko > /dev/null 2>&1

# Add QoS related modules
insmod sch_htb > /dev/null 2>&1
insmod cls_fw > /dev/null 2>&1
insmod cls_basic > /dev/null 2>&1
insmod act_ipt > /dev/null 2>&1

# Add IPv6 netfilter related modules
insmod ip6table_filter > /dev/null 2>&1
insmod ip6t_LOG > /dev/null 2>&1
insmod ip6t_REJECT > /dev/null 2>&1
insmod ip6table_mangle > /dev/null 2>&1
insmod ip6table_raw > /dev/null 2>&1
insmod nf_conntrack_ipv6 > /dev/null 2>&1
fi

h323enabled=`nvram_get 2860 h323Enabled`
if [ -z `lsmod | grep h323` ] && [ "$h323enabled" = "1" ]; then
		insmod nf_conntrack_h323
		insmod nf_nat_h323
		echo "insert H.323 ALG Module"
fi

killall dray_keepalive > /dev/null 2>&1
if [ "$ioskeepalive_enable" = "1" ]; then
	dray_keepalive &
fi
