#!/bin/sh 
# vigorfly200 ipv6 firewall 

IPTABLES=ip6tables

fw6_setrule(){
	local SET_S_IP=
	local SET_D_IP=
	local SET_s_PORT=
	local SET_D_PORT=

	local sip_type
	local sip
	local smask
	local smask_len	
	local dip_type
	local dip
	local dmask
	local dmask_len
	local proto
	local sport1
	local sport2
	local dport1
	local dport2
	local action	
	
	#[name],[sip_type],[sip],[smask],[smask_len],[dip_type],[dip],[dmask],[dmask_lan],[proto],[sport1],[sport2],[dport1],[dport2],[action]	
	local RULE="$1"

	#IP setting
	sip_type=$(echo $RULE | awk 'FS="[,]" {print $2}')
	sip=$(echo $RULE | awk 'FS="[,]" {print $3}')
	smask=$(echo $RULE | awk 'FS="[,]" {print $4}')
	smask_len=$(echo $RULE | awk 'FS="[,]" {print $5}')
	dip_type=$(echo $RULE | awk 'FS="[,]" {print $6}')
	dip=$(echo $RULE | awk 'FS="[,]" {print $7}')
	dmask=$(echo $RULE | awk 'FS="[,]" {print $8}')
	dmask_len=$(echo $RULE | awk 'FS="[,]" {print $9}')

	
	#protocol and port
	proto=$(echo $RULE | awk 'FS="[,]" {print $10}')
	sport1=$(echo $RULE | awk 'FS="[,]" {print $11}')
	sport2=$(echo $RULE | awk 'FS="[,]" {print $12}')
	dport1=$(echo $RULE | awk 'FS="[,]" {print $13}')
	dport2=$(echo $RULE | awk 'FS="[,]" {print $14}')
	action=$(echo $RULE | awk 'FS="[,]" {print $15}')
	
	#sip type: none, single, subnet 
	if [ "$sip_type" = "single" ]; then
		SET_S_IP="-s $sip"
	elif [ "$sip_type" = "subnet" ]; then
		SET_S_IP="-s $smask/$smask_len"
	fi
	#dip type: none, single, subnet 
	if [ "$dip_type" = "single" ]; then
		SET_D_IP="-d $dip"
	elif [ "$dip_type" = "subnet" ]; then
		SET_D_IP="-d $dmask/$dmask_len"
	fi
	
	#protocol tcp or udp has port
	if [ "$proto" = "tcp" -o "$proto" = "udp" ]; then
		#sport:  single, range 
		if [ "$sport1" != "" -a "$sport2" != "" ]; then
			SET_S_PORT="--sport $sport1:$sport2"
		elif [ "$sport1" != "" ]; then  
			SET_S_PORT="--sport $sport1"
		fi
		#dport:  single, range 
		if [ "$dport1" != "" -a "$dport2" != "" ]; then
			SET_D_PORT="--dport $dport1:$dport2"
		elif [ "$dport1" != "" ]; then
			SET_D_PORT="--dport $dport1"
		fi
	fi
	$IPTABLES -A FORWARD $SET_S_IP $SET_D_IP -p $proto $SET_S_PORT $SET_D_PORT -j $action
}

fw6_init() {
	. /sbin/global.sh
	getWan6IfName

	$IPTABLES -F FORWARD
	$IPTABLES -t mangle -F
	$IPTABLES -t raw -F
	
	R6_IDX=1
	RULE6_ALL=`nvram_get 2860 IP6PortFilterRules`
	
	if [ "$RULE6_ALL" != "" ]; then
		RULE6=$(echo $RULE6_ALL | awk 'FS="[;]" {print $'$R6_IDX'}')
		while [ "$RULE6" != "" ]; do
			fw6_setrule "$RULE6"
			R6_IDX=$(expr $R6_IDX + 1)
			RULE6=$(echo $RULE6_ALL | awk 'FS="[;]" {print $'$R6_IDX'}')
		done
	fi
	 
	#default reject tcp/udp new connection from WAN
	#ip6tables -A FORWARD -i sit+ -m state --state NEW -j DROP
	ip6tables -A FORWARD -m state --state ESTABLISHED,RELATED -j ACCEPT
	if [ "$wan6_if" != "" ]; then
		ip6tables -A FORWARD -i $wan6_if -j DROP >/dev/null 2>&1
	fi
}

fw6_stop() {
	$IPTABLES -F FORWARD
	$IPTABLES -t mangle -F
	$IPTABLES -t raw -F
}


if [ "$1" == "start" ]; then
	#ipv6 firewall start
	echo "IPv6 Firewall Start!!!!"
	fw6_init
elif [ "$1" == "stop" ]; then
	#ipv6 firewall stop
	echo "IPv6 Firewall Stop!!!!"
	fw6_stop
else
	echo "IPv6 firewall"
	echo "command: /sbin/firewall.sh [start/stop]"
fi
