#!/bin/sh

. /sbin/global.sh

killall -q dhcprelay
dhcp=`nvram_get 2860 dhcpEnabled`

if [ "$dhcp" = "0" ]; then
    dhcpRelay=`nvram_get 2860 dhcpRelay`
    if [ "$dhcpRelay" = "1" ]; then
        dhcpServer=`nvram_get 2860 dhcpServer`
        wan_up=`cat /var/network/wan_up`
        wan2_up=`cat /var/network/wan2_up`

        if [ "$wan_up" = "1" ]; then
            opmode=`nvram_get 2860 OperationMode`
            wanMode=`nvram_get 2860 wanConnectionMode`

            if [ "$wanMode" = "PPPOE" -o "$wanMode" = "L2TP" -o "$wanMode" = "PPTP" -o "$wanMode" = "3G" ]; then
                if_name="ppp0"
            else 
                if [ "$opmode" = "0" -o "$opmode" = "" ]; then
                    if_name="br0"
                elif [ "$opmode" = "1" ]; then
                    if [ "$wanMode" = "Wimax" ]; then
                        if_name="wimax0"
                    elif [ "$wanMode" = "YotaKey" ]; then
                        if_name="eth0"                    
                    else
                        if_name="eth2.2"
                    fi
                elif [ "$opmode" = "2" ]; then
                    if_name="ra0"
                elif [ "$opmode" = "3" ]; then
                    if_name="apcli0"
                fi
            fi                
        elif [ "$wan2_up" = "1" ]; then
            wan2Mode=`nvram_get 2860 wan2ConnectionMode`

            if [ "$wan2Mode" = "STATIC" -o "$wan2Mode" = "DHCP" ]; then
                if_name="eth2.2"
            elif [ "$wan2Mode" = "Wimax" ]; then
                if_name="wimax0"
            elif [ "$wan2Mode" = "3G" ]; then
                if_name="ppp1"
            elif [ "$wan2Mode" = "PPPOE" -o "$wan2Mode" = "L2TP" -o "$wan2Mode" = "PPTP" ]; then 
                if_name="ppp1"
            fi                 
        fi

        echo "$if_name" > /dev/console
        dhcprelay br0 $if_name $dhcpServer &
    fi
fi
