#!/bin/sh
#
# $Id: config-pptp.sh,v 1.6 2009-01-07 09:48:14 steven Exp $
#
# usage: config-pptp.sh <mode> <mode_params> <server> <user> <password>
#

. /sbin/config.sh
. /sbin/global.sh

usage()
{
	echo "Usage:"
	echo "  $0 <mode> <mode_params> <server> <user> <password>"
	echo "Modes:"
	echo "  static - <mode_params> = <wan_if_name> <wan_ip> <wan_netmask> <gateway>"
	echo "  dhcp - <mode_params> = <wan_if_name>"
	echo "Example:"
	echo "  $0 static eth2.2 10.10.10.254 255.255.255.0 10.10.10.253 192.168.1.1 user pass"
	echo "  $0 dhcp eth2.2 192.168.1.1 user pass"
	exit 1
}

if [ "$5" = "" ]; then
	echo "$0: insufficient arguments"
	usage $0
fi

# for accel-pptp, the pppd needs a period of time to die, nancy
count=0
while [ -f /var/run/ppp1.pid -a  "$count" != "5" ]; do
	sleep 2
	count=$(expr $count + 1)
done

echo "" > /var/pptp_l2tp_gateway

# delete any default route, nancy
while route del default ; do
 :
done

if [ "$1" = "static" ]; then
	if [ "$7" = "" ]; then
		echo "$0: insufficient arguments"
		usage $0
	fi
	ifconfig $2 $3 netmask $4
	route del default
	if [ "$5" != "0.0.0.0" ]; then
		route add default gw $5
		echo "$5" > /var/pptp_l2tp_gateway
	fi
	pptp_srv=$6
	pptp_u=$7
	pptp_pw=$8
	pptp_opmode=$9
	pptp_optime=${10}
elif [ "$1" = "dhcp" ]; then
	# nancy, try fix the problem of 2 config-pptp.sh
	temp=`ps | grep [u]dhcpc | grep $2`
	if [ "$temp" != "" ]; then
		exit 0
	fi
	killall -q -SIGTERM udhcpc
	#add dhcp option 121 (staticroutes), option 33
	udhcpc -i $2 -s /sbin/udhcpc.sh -O staticroutes -O routes -p /var/run/udhcpcbk.pid &
	pptp_srv=$3
	pptp_u=$4
	pptp_pw=$5
	pptp_opmode=$6
	pptp_optime=$7
	# wait until default route is ready
	count=0
	while [ "$count" != "60" ]; do
		sleep 3
		temp=`route -n | grep ^0.0.0.0 | grep $2`
		if [ "$temp" != "" ]; then
			echo "$temp" | awk '{print $2}' > /var/pptp_l2tp_gateway
			break
		fi
		# call udhcpc again if it's not running
		if [ ! -f /var/run/udhcpcbk.pid ]; then
			udhcpc -i $2 -s /sbin/udhcpc.sh -O staticroutes -O routes -p /var/run/udhcpcbk.pid &
		fi
		count=$(expr $count + 1)
	done
else
	echo "$0: unknown connection mode: $1"
	usage $0
fi

# get server ip if using domain name, nancy
temp=`echo $pptp_srv | sed 's/[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}//g'`
if [ "$temp" != "" ]; then
	# get the ip of the domain name
	pptp_srv_temp=`ping -c 1 $pptp_srv | grep PING | sed 's/^.*(//g' | sed 's/).*$//g'`
	if [ "$pptp_srv_temp" != "" ]; then
		echo "PPTP server($pptp_srv) IP : $pptp_srv_temp"
		logger "PPTP server($pptp_srv) IP : $pptp_srv_temp"
		pptp_srv=$pptp_srv_temp
	fi
fi

if [ "$CONFIG_PPTP" == "y" ]; then
accel-pptp.sh $pptp_u $pptp_pw $pptp_srv $pptp_opmode $pptp_optime
else
pptpbk.sh $pptp_u $pptp_pw $pptp_srv $pptp_opmode $pptp_optime
fi
pppd unit 1 file /etc/options.pptp &
