#!/bin/sh

#call-schedule <action> <minute> <hour> <day> <mouth> <year> 


date1="$6-$5-$4 $3:$2:00"
datenow="$(date +%s)"
dateset="$(date -d "$date1" +%s)"

logger "[schedule] $datenow $dateset"

PROTO=`nvram_get 2860 wanConnectionMode`
CHK_3G=`ifconfig | grep ppp0`

if [ $datenow -ge $dateset ] ;then
        case "$1" in
        0)
			logger "[schedule] \"dial 3g\" start"
			echo "[schedule] \"dial 3g\" start"
		   	#proto 3G
			if [ "$PROTO" == "3G" ]; then
				#3G down now
				if [ "$CHK_3G" == "" ]; then
				    #3G should up
					logger "3G should up"	
					/bin/goahead set_wan
				fi
			fi
			#unlock 3G schedule lock
			echo "0" > var/3g/sche_lock
			;;
        1)
			logger "[schedule] \"dial 3g\" end"
			echo "[schedule] \"dial 3g\" end"
		   	#unlock 3G schedule lock
			echo "0" > var/3g/sche_lock
			;;
        2)
			logger "[schedule] \"can't dial 3g\" start"
			echo "[schedule] \"can't dial 3g\" start"
			if [ "$PROTO" == "3G" ]; then
				#3G down now
				if [ "$CHK_3G" != "" ]; then
				    #3G should down
					logger "3G should down"	
					killall pppd
				fi
			fi
			#unlock 3G schedule lock
			echo "1" > var/3g/sche_lock
			;;
        3)
			logger "[schedule] \"can't dial 3g\" end" 
			echo "[schedule] \"can't dial 3g\" end" 
			#unlock 3G schedule lock
			echo "0" > var/3g/sche_lock
			;;
		4)
			logger "[schedule] \"Auto reboot\" action" 
			echo "[schedule] \"Auto reboot\" action" 
			/sbin/send_sms_function.sh $7
			#Auto reboot schedule
			sleep 10
			reboot
			;;
		5)
			logger "[schedule] \"Send SMS\"" 
			echo "[schedule] \"Send SMS\"" 
			#SMS schedule, $7 is profile index
			/sbin/send_sms_function.sh $7
			;;
		6)
			logger "[schedule] \"Wi-Fi UP\""
			echo "[schedule] \"Wi-Fi UP\""
			nvram_set RadioOff 0
			goahead set_internet
			;;
		7)
			logger "[schedule] \"Wi-Fi DOWN\""
			echo "[schedule] \"Wi-Fi DOWN\""
			nvram_set RadioOff 1
			goahead set_internet
			;;
        esac
fi