#!/bin/sh

# Copyright (C) 2012 Draytek
# to start/stop 6to4 tunneling

LAN=br0
CONF=/etc/radvd.conf

usage()
{
  echo "usage:" >&2
  echo "  $0 <start|stop>" >&2
  exit 1
}

config_radvd()
{
  LIFETIME=`nvram_get v6_radvd_lifetime`

  echo "interface $LAN" > $CONF
  echo "{" >> $CONF
  echo "  AdvSendAdvert on;" >> $CONF
  echo "  MinRtrAdvInterval 3;" >> $CONF
  echo "  MaxRtrAdvInterval 10;" >> $CONF
  if [ $LIFETIME ]; then
    echo "  AdvDefaultLifetime $LIFETIME;" >> $CONF
  fi

  echo "  prefix 0:0:0:1::/64" >> $CONF
  echo "  {" >> $CONF
  echo "    AdvOnLink on;" >> $CONF
  echo "    AdvAutonomous on;" >> $CONF
  echo "    AdvRouterAddr on;" >> $CONF
  echo "    AdvValidLifetime 2592000;" >> $CONF
  echo "    AdvPreferredLifetime 604800;" >> $CONF
  echo "    Base6to4Interface $WAN;" >> $CONF
  echo "  };" >> $CONF

  echo "};" >> $CONF
  echo "" >> $CONF
  chmod 600 $CONF
}

start_radvd()
{
  killall radvd 2>/dev/null
  config_radvd
  radvd -C $CONF
}

start_6to4()
{
  if [ $WANIP ]; then
    PREFIX=$(echo $WANIP | awk '{FS="."} {printf "2002:%02x%02x:%02x%02x", $1, $2, $3, $4}')
    ip tunnel add tun6to4 mode sit ttl 255 remote any local $WANIP
    ip link set tun6to4 up
    ip addr add $PREFIX:0::1/16 dev tun6to4
    ip addr add $PREFIX:1::1/64 dev $LAN
    ip -6 route del 2000::/3 2>/dev/null
    ip -6 route add 2000::/3 via ::$RELAY dev tun6to4

    [ "`nvram_get v6_radvd_en`" -eq 1 ] && start_radvd
  fi
}

stop_6to4()
{
  if [ "$(ip tunnel show|grep ^tun6to4)" ]; then
    ip tunnel del tun6to4
    ip -6 route del 2000::/3 2>/dev/null
    for IP in $(ip -6 addr show dev $LAN | awk '/inet6 2002/ {print $2}'); do
      ip -6 addr del $IP dev $LAN
    done
  fi
}

check_before_start()
{
  # exit if WAN IP and RELAY IP keep unchanged
  OLD_WANIP=$(ip tunnel show|grep ^tun6to4|awk '{print $6}')
  LANIP=$(ip -6 addr show dev $LAN | awk '/inet6 2002/ {print $2}')
  if [ "$OLD_WANIP" ]; then
    OLD_RELAY=$(ip -6 route show dev tun6to4|grep ^2000::/3|awk '{print $3}'|sed 's/:://')
    [ "$WANIP" = "$OLD_WANIP" ] && [ "$RELAY" = "$OLD_RELAY" ] && [ $LANIP ] && exit 1
  fi
}

# program entry

case $1 in
  "start")
    WAN=$(route -n | grep ^0.0.0.0 | awk '{print $8}')
    WANIP=$(ip -4 addr show dev $WAN | awk '/inet / {print $2}' | sed 's/\/.*//')
    RELAY=$(nvram_get 6to4_relay)
    [ -z $RELAY ] && RELAY=192.88.99.1

    check_before_start
    stop_6to4
    start_6to4
    ;;

  "stop")
    stop_6to4
    ;;

  *)usage
    ;;
esac
