#!/bin/sh
#
# This function is use to trace 3G connection
#
if [ "$1" == "up" ]; then
	
	#test 3G up time
	T3G_UP=`cat /proc/uptime | awk 'FS="[.]+" {print $1}'`
		
	#count 3G connection times
	if [ -f /var/3g/3g_conn_count ]; then
		T3G_CONN=`cat /var/3g/3g_conn_count`
		T3G_CONN=$(expr $T3G_CONN + 1)
		echo "$T3G_CONN" > /var/3g/3g_conn_count
		# i an here means 3G had disconnect before
		# count fail time
		if [ -f /var/3g/3g_fail_time ]; then
			TOTAL_FAIL=`cat /var/3g/3g_fail_time`	#total fail time
			LAST_FAIL=`tail -n 1 /var/3g/3g_record | awk '{print $1}'`	#last fail point
			#T3G_UP=`cat /proc/uptime | awk 'FS="[.]+" {print $1}'`	#new 3G up point
			NEW_FAIL=$(expr $T3G_UP - $LAST_FAIL)	#new fail time
			TOTAL_FAIL=$(expr $TOTAL_FAIL + $NEW_FAIL)	#new total fail time
			echo "$TOTAL_FAIL" > /var/3g/3g_fail_time
		fi		
		
	else
		echo "1" > /var/3g/3g_conn_count
		echo "$T3G_UP" > /var/3g/3g_start_time  #log 3G first start time
		echo "0" > /var/3g/3g_fail_time    #first time up, 3g fail time is 0
	fi
	
	echo "$T3G_UP 0" >> /var/3g/3g_record
	echo "$T3G_UP 1" >> /var/3g/3g_record
	
	#if 3g_record file has more than 400 lines, delete oldest 2 lines
	LINE=`wc -l /var/3g/3g_record | awk '{print $1}'`
	if [ "$LINE" -gt 400 ]; then
		sed -i '1,2d' /var/3g/3g_record
	fi

else
	#test 3G up time
	T3G_UP=`cat /proc/uptime | awk 'FS="[.]+" {print $1}'`
	echo "$T3G_UP 1" >> /var/3g/3g_record
	echo "$T3G_UP 0" >> /var/3g/3g_record
	
	#if 3g_record file has more than 400 lines, delete oldest 2 lines
	LINE=`wc -l /var/3g/3g_record | awk '{print $1}'`
	if [ "$LINE" -gt 400 ]; then
		sed -i '1,2d' /var/3g/3g_record
	fi
	
fi