<html>
<head>
<title>VoIP Phone</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta http-equiv="Pragma" Content="No-cach">
<meta http-equiv="Expires" Content="-1">
<script type="text/javascript" src="/lang/b28n.js"></script>
<link rel="stylesheet" href="/style/normal_ws.css" type="text/css">
<script type="text/javascript" src="/dtree/tool.js"></script>
<script type="text/javascript" language="JavaScript">
Butterlate.setTextDomain("voip");

var f;
var arySipAccnt = Array(0);
var aryStrDTMF = [_("voip phone inband"), _("voip phone outband"), _("voip phone cisco format"), _("voip phone nortel format")];
var PHONE_HL_ENABLE = (1 << 0);// enable hot line function
var PHONE_SE_ENABLE = (1 << 1);    // enable session timer
var PHONE_T38_ENABLE = (1 << 2);    // enable T.38 relay
var PHONE_CF_ENABLE = (1 << 3);
var PHONE_CW_ENABLE = (1 << 4);    // enable call waiting
var PHONE_CT_ENABLE = (1 << 5);    // enable call transfer
var PHONE_CID_DISABLE = (1 << 7);    // disable caller ID
var PHONE_DND_Enable = (1 << 11);   // enable DND
var PHONE_REG_DIAL_TONE = (1 << 12);
var ACC_NRC_ENABLE = (1 << 1);  
var aryEPFlag = [[PHONE_HL_ENABLE, "HL"], [PHONE_SE_ENABLE, "SE"], [PHONE_CF_ENABLE, "CF"],
				[PHONE_T38_ENABLE, "T38"], [PHONE_CW_ENABLE, "CW"], [PHONE_CT_ENABLE, "CT"], 
				[PHONE_CID_DISABLE, "CID"],	[PHONE_DND_Enable, "DND"]];

var aryStrCodec = ["G.711MU", "G.711A", "G.729A/B", "G.723", "G.726_32"];
var aryPortName = [_("voip phone1"), _("voip phone2")];





function initSIPAccnt()
{
	var sip = '<% showRegSipAcntOption(); %>';
	arySipAccnt.push("");
	for (i=0; i< 6; i++) {
		arytmp = sip.split("|");
		tmp = arytmp[i].split(",");
		arySipAccnt.push(tmp[0]);
	}
}

function addRow(index, frag, values)
{
    var tr = CreateStyledElement("tr", index % 2 ? "config_even" : "config_odd");

    var txt = document.createTextNode(index+1);
    var link = document.createElement("a");
    link.href = "vphone.asp?idx=" + (index+1);
    link.appendChild(txt); // Add Text
    var td = CreateStyledElement("td", "c");
    td.appendChild(link);
    tr.appendChild(td);

	addTextCell(tr, aryPortName[index], "c");

	var str = "";
	for (var i=0; i<aryEPFlag.length; i++) {
		if ((values[0] & aryEPFlag[i][0]) == aryEPFlag[i][0]) str += aryEPFlag[i][1] + ",";
	}
	addTextCell(tr, str, "c");
	addTextCell(tr, aryStrCodec[values[1]], "c");
	var gain = values[2] + "/" + values[3];
	addTextCell(tr, gain, "c");

	addTextCell(tr, arySipAccnt[values[4]], "c");
	addTextCell(tr, aryStrDTMF[values[5]], "c");

    frag.appendChild(tr);       // Add row to fragment
}

function processUpdate(req)
{	
	if (req.responseText) {
//		alert(req.responseText);
		initSIPAccnt();	
		var config = req.responseText.split("|");
		var frag = document.createDocumentFragment();
		for (var i=0; i<config.length; i++) {
			var values = config[i].split(",");
           	addRow(i, frag, values);
        }
        var tbody = document.getElementById('phnlist');
        clearChildNodes(tbody);
		tbody.appendChild(frag);
	}
}

function onChgsltRTPTOS()
{
    if(getVleFromElmt(f.sltRTPTOS, 0)=='255'){
        cpntCtrl(true, f, f.txtRTPTOS, 1);
        var iRTPTOS = getVleFromElmt(f.iRTPTOS, 0);
        setVle2Elmt(f.txtRTPTOS, dataDec2Bin(iRTPTOS), 0);
    }else{
        cpntCtrl(false, f, f.txtRTPTOS, 1);
        var iRTPTOS = getVleFromElmt(f.sltRTPTOS, 0);
        setVle2Elmt(f.txtRTPTOS, dataDec2Bin(iRTPTOS), 0);
    }
}

function checkForm()
{
    var iRTPTOS, iRTPPortStart, iRTPPortEnd;

    iRTPTOS 		= getVleFromElmt(f.txtRTPTOS, 0);
    iRTPPortStart 	= getVleFromElmt(f.iRTPPortStart, 0);
    iRTPPortEnd 	= getVleFromElmt(f.iRTPPortEnd, 0);
    if (!isStrNum(iRTPPortStart) || iRTPPortStart < 1 || iRTPPortStart > 65535) {
    	alert(_("voip phone rtp port start error"));
    	return false;
    }
    if (!isStrNum(iRTPPortEnd) || iRTPPortEnd < 1 || iRTPPortEnd > 65535) {
    	alert(_("voip phone rtp port end error"));
    	return false;
    }    
    if(iRTPTOS == "") {
    	alert(_("voip rtp tos empty"));
    	return false;
    }
    if(dataBin2Dec(iRTPTOS) == -1) {
    	alert(_("voip rtp tos error"));
    	return false;
    }
    setVle2Elmt(f.iRTPTOS, dataBin2Dec(iRTPTOS), 0);
    cpntCtrl(true, f, f.txtRTPTOS, 1);
}

function initTranslation()
{
	var e = document.getElementById("vtitle");
	e.innerHTML = _("parent voip")+" >> "+_("voip phone set");

	e = document.getElementById("vPhnTitle");
	e.innerHTML = _("voip phone list");
	e = document.getElementById("vPhnSip");
	e.innerHTML = _("voip phone sip");
	e = document.getElementById("vHookFlashInfo");
	e.innerHTML = _("voip phone hook flash info");
	e = document.getElementById("vPhnRtp");
	e.innerHTML = _("voip phone rtp");
	e = document.getElementById("vIdx");
	e.innerHTML = _("voip phone index");	
	e = document.getElementById("vPort");
	e.innerHTML = _("voip phone port");	
	e = document.getElementById("vCallFture");
	e.innerHTML = _("voip phone call feature");
	e = document.getElementById("vCodec");
	e.innerHTML = _("voip phone codec");	
	e = document.getElementById("vGain");
	e.innerHTML = _("voip phone gain");	
	e = document.getElementById("vDefSip");
	e.innerHTML = _("voip phone default sip");
	e = document.getElementById("vDtmf");
	e.innerHTML = _("voip phone dtmf relay");	
	e = document.getElementById("vSymRtp");
	e.innerHTML = _("voip phone symmetric rtp");	
	e = document.getElementById("vRtpPortStart");
	e.innerHTML = _("voip phone rtp port start");
	e = document.getElementById("vRtpPortEnd");
	e.innerHTML = _("voip phone rtp port end");	
	e = document.getElementById("vRtpTos");
	e.innerHTML = _("voip phone rtp tos");		
	e = document.getElementById("vSltTos0");
	e.innerHTML = _("voip phone tos slt manual");
	e = document.getElementById("vSltTos1");
	e.innerHTML = _("voip phone tos slt 1");	
	e = document.getElementById("vSltTos2");
	e.innerHTML = _("voip phone tos slt 2");
	e = document.getElementById("vSltTos3");
	e.innerHTML = _("voip phone tos slt 3");
	e = document.getElementById("vSltTos4");
	e.innerHTML = _("voip phone tos slt 4");
	e = document.getElementById("vSltTos5");
	e.innerHTML = _("voip phone tos slt 5");
	e = document.getElementById("vSltTos6");
	e.innerHTML = _("voip phone tos slt 6");
	e = document.getElementById("vSltTos7");
	e.innerHTML = _("voip phone tos slt 7");
	e = document.getElementById("vSltTos8");
	e.innerHTML = _("voip phone tos slt 8");
	e = document.getElementById("vSltTos9");
	e.innerHTML = _("voip phone tos slt 9");
	e = document.getElementById("vSltTos10");
	e.innerHTML = _("voip phone tos slt 10");
	e = document.getElementById("vSltTos11");
	e.innerHTML = _("voip phone tos slt 11");
	e = document.getElementById("vSltTos12");
	e.innerHTML = _("voip phone tos slt 12");
	e = document.getElementById("vSltTos13");
	e.innerHTML = _("voip phone tos slt 13");
	e = document.getElementById("vSltTos14");
	e.innerHTML = _("voip phone tos slt 14");
	e = document.getElementById("vSltTos15");
	e.innerHTML = _("voip phone tos slt 15");
	e = document.getElementById("vSltTos16");
	e.innerHTML = _("voip phone tos slt 16");
	e = document.getElementById("vSltTos17");
	e.innerHTML = _("voip phone tos slt 17");
	e = document.getElementById("vSltTos18");
	e.innerHTML = _("voip phone tos slt 18");
	e = document.getElementById("vSltTos19");
	e.innerHTML = _("voip phone tos slt 19");
	e = document.getElementById("vSltTos20");
	e.innerHTML = _("voip phone tos slt 20");	
		

	e = document.getElementById("vok");
	e.value = _("voip ok");			
}

function initValue()
{
	f = document.frm;
	initTranslation();
	loadXMLDoc("GET", "/goform/getVPhnList", processUpdate, "n/a");
	
	var sip_hk_info = '<% getCfgGeneral(1, "voip_sip_hf_enable", 1); %>';
	var rtp = '<% getCfgGeneral(1, "voip_sip", 1); %>';
//sym_rtp,rtp_start,rtp_end,rtp_tos,stun_server,external_ip,sip_ping_timer
	if (rtp == '') rtp = "0,10050,10500,255,,,";
	var val = rtp.split(",");
	setVle2Elmt( f.iSymRTPEnable, val[0],  0);	
	setVle2Elmt( f.iRTPPortStart, val[1],  0);	
	setVle2Elmt( f.iRTPPortEnd, val[2],  0);	
    var flgManual = 0;
    for(i=0; i<f.sltRTPTOS.length; i++){
        if( f.sltRTPTOS.options[i].value == val[3] ) {
            flgManual = 1;
            break;
        }
    }
    if( flgManual == 1 ) {
		setVle2Elmt( f.sltRTPTOS, val[3],  0);	
    } else {
        setVle2Elmt (f.sltRTPTOS, '255',  0);
    }
    setVle2Elmt( f.iRTPTOS, val[3],  0);
	if(sip_hk_info == "1")
		f.iHookFlashInfoEnable.checked = true;
	else
		f.iHookFlashInfoEnable.checked = false;
	
	onChgsltRTPTOS();
}
</script>
</head>

<body onLoad="initValue()">
<table class="body">
<tr><td>
<h1 id="vtitle">Phone Setting</h1>
<hr size="1" />
<br />

<form name="frm" method="POST" onsubmit="return checkForm();" action="/goform/setVPhnList">
<h2 class="title" id="vPhnTitle">Phone List</h2>
<table width="100%" cellpadding="2" cellspacing="2" class="config">
	<tr>
		<td id="vIdx" class="title">Index</td>
		<td id="vPort" class="title" align="center">Port</td>
		<td id="vCallFture" class="title" align="center">Call Feature</td>
		<td id="vCodec" class="title" align="center">Codec</td>
		<td id="vGain" class="title" align="center">Gain (Mic/Speaker)</td>
		<td id="vDefSip" class="title" align="center">Default SIP Account</td>
		<td id="vDtmf" class="title" align="center">DTMF Relay</td>
	</tr>
	<tbody id="phnlist">
	</tbody>	
</table><br>

<h2 class="title" id="vPhnSip">SIP</h2>
<table width="100%" cellpadding="2" cellspacing="2" class="config">
	<tr><td width="10%"></td>
		<td colspan="2"><input type="checkbox" name="iHookFlashInfoEnable" id="iHookFlashInfoEnable">&nbsp;<span id="vHookFlashInfo">Enable hook-flash event via SIP INFO</span></td>
	</tr>
</table><br>

<h2 class="title" id="vPhnRtp">RTP</h2>
<table width="100%" cellpadding="2" cellspacing="2" class="config">
	<tr><td width="10%"></td>
		<td colspan="2"><input type="checkbox" name="iSymRTPEnable" value=1>&nbsp;<span id="vSymRtp">Symmetric RTP</span></td>
	</tr>
	<tr><td></td>
		<td width="30%" id="vRtpPortStart">Dynamic RTP Port Start</td>
		<td><input type="text" size=6 maxlength=5 name="iRTPPortStart"></td>
	</tr>
	<tr><td></td>
		<td id="vRtpPortEnd">Dynamic RTP Port End</td>
		<td><input type="text" size=6 maxlength=5 name="iRTPPortEnd"></td>
	</tr>
	<tr><td></td>
		<td id="vRtpTos">RTP TOS</td>
		<td><select name="sltRTPTOS" onChange=onChgsltRTPTOS()>
			<option value="255" id="vSltTos0">Manual</option>
			<option value="32" id="vSltTos1">IP precedence 1</option>
			<option value="64" id="vSltTos2">IP precedence 2</option>
			<option value="96" id="vSltTos3">IP precedence 3</option>
			<option value="128" id="vSltTos4">IP precedence 4</option>
			<option value="160" id="vSltTos5">IP precedence 5</option>
			<option value="192" id="vSltTos6">IP precedence 6</option>
			<option value="224" id="vSltTos7">IP precedence 7</option>
			<option value="40" id="vSltTos8">AF Class1 (Low Drop)</option>
			<option value="48" id="vSltTos9">AF Class1 (Medium Drop)</option>
			<option value="56" id="vSltTos10">AF Class1 (High Drop)</option>
			<option value="72" id="vSltTos11">AF Class2 (Low Drop)</option>
			<option value="80" id="vSltTos12">AF Class2 (Medium Drop)</option>
			<option value="88" id="vSltTos13">AF Class2 (High Drop)</option>
			<option value="104" id="vSltTos14">AF Class3 (Low Drop)</option>
			<option value="112" id="vSltTos15">AF Class3 (Medium Drop)</option>
			<option value="120" id="vSltTos16">AF Class3 (High Drop)</option>
			<option value="136" id="vSltTos17">AF Class4 (Low Drop)</option>
			<option value="144" id="vSltTos18">AF Class4 (Medium Drop)</option>
			<option value="152" id="vSltTos19">AF Class4 (High Drop)</option>
			<option value="184" id="vSltTos20">EF Class</option></select>&nbsp;
			<input type="text" name="txtRTPTOS" size=10 maxlength=8>
			<input type="hidden" name="iRTPTOS" size=10 maxlength=3>
		</td>
	</tr>
</table><br>

<table align=center>
	<tr><td><input class=btnw type="submit" value="OK" id="vok"></td>
	</tr>
</table>	
</form>

	</td></tr>
</table>
</body>
</html>
<script type="text/javascript" src="/dtree/tool.js"></script>
<script type="text/javascript" src="/jquery.js"></script>
<script>
	var _fw_upgrade_notify	='<% getCfgGeneral(1, "fw_upgrade_notify", 1); %>';
	var _aryInfo = [<% getUpgradeInfo(); %>];// [0]:exit new fw  [1]:ver
	var _curt_ver = '<% getSdkVersion(); %>';
	var _lanIP = '<% getLanIp(); %>';
	fw_urpgrade_auto_detect(_fw_upgrade_notify,_aryInfo,_curt_ver,_lanIP);
</script>