<html>
<head>
<title>DialPlan Setup</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta http-equiv="Pragma" Content="No-cach">
<meta http-equiv="Expires" Content="-1">
<script type="text/javascript" src="/lang/b28n.js"></script>
<link rel="stylesheet" href="/style/normal_ws.css" type="text/css">
<script type="text/javascript" src="/dtree/tool.js"></script>
<script type="text/javascript" language="JavaScript">
Butterlate.setTextDomain("voip");

var f;
var prefix_num = 20;
var oTMode = Array("None", "Add", "Strip", "Replace");
var oVMode = Array(0, 1, 2, 3);
var oTInterface = Array("VoIP1", "VoIP2", "VoIP3", "VoIP4", "VoIP5", "VoIP6");
var oVInterface = Array(0, 1, 2, 3, 4, 5);
var ruleItemNum = 7;
var MIN_LEN = 0;		//range of Min Len and Max Len
var MAX_LEN = 25;		//range of Min Len and Max Len
/*var voip_dg = [[<% getCfgGeneral(1, "voip_dg1", 1); %>], [<% getCfgGeneral(1, "voip_dg2", 1); %>],
				[<% getCfgGeneral(1, "voip_dg3", 1); %>], [<% getCfgGeneral(1, "voip_dg4", 1); %>],
				[<% getCfgGeneral(1, "voip_dg5", 1); %>], [<% getCfgGeneral(1, "voip_dg6", 1); %>],
				[<% getCfgGeneral(1, "voip_dg7", 1); %>], [<% getCfgGeneral(1, "voip_dg8", 1); %>],
				[<% getCfgGeneral(1, "voip_dg9", 1); %>], [<% getCfgGeneral(1, "voip_dg10", 1); %>],
				[<% getCfgGeneral(1, "voip_dg11", 1); %>], [<% getCfgGeneral(1, "voip_dg12", 1); %>],
				[<% getCfgGeneral(1, "voip_dg13", 1); %>], [<% getCfgGeneral(1, "voip_dg14", 1); %>],
				[<% getCfgGeneral(1, "voip_dg15", 1); %>], [<% getCfgGeneral(1, "voip_dg16", 1); %>],
				[<% getCfgGeneral(1, "voip_dg17", 1); %>], [<% getCfgGeneral(1, "voip_dg18", 1); %>],
				[<% getCfgGeneral(1, "voip_dg19", 1); %>], [<% getCfgGeneral(1, "voip_dg20", 1); %>]];*/
var voip_dg = ['<% getCfgGeneral(1, "voip_dg1", 1); %>', '<% getCfgGeneral(1, "voip_dg2", 1); %>',
				'<% getCfgGeneral(1, "voip_dg3", 1); %>', '<% getCfgGeneral(1, "voip_dg4", 1); %>',
				'<% getCfgGeneral(1, "voip_dg5", 1); %>', '<% getCfgGeneral(1, "voip_dg6", 1); %>',
				'<% getCfgGeneral(1, "voip_dg7", 1); %>', '<% getCfgGeneral(1, "voip_dg8", 1); %>',
				'<% getCfgGeneral(1, "voip_dg9", 1); %>', '<% getCfgGeneral(1, "voip_dg10", 1); %>',
				'<% getCfgGeneral(1, "voip_dg11", 1); %>', '<% getCfgGeneral(1, "voip_dg12", 1); %>',
				'<% getCfgGeneral(1, "voip_dg13", 1); %>', '<% getCfgGeneral(1, "voip_dg14", 1); %>',
				'<% getCfgGeneral(1, "voip_dg15", 1); %>', '<% getCfgGeneral(1, "voip_dg16", 1); %>',
				'<% getCfgGeneral(1, "voip_dg17", 1); %>', '<% getCfgGeneral(1, "voip_dg18", 1); %>',
				'<% getCfgGeneral(1, "voip_dg19", 1); %>', '<% getCfgGeneral(1, "voip_dg20", 1); %>'];
				
function initTranslation()
{
	var e = document.getElementById("vdialplan");
	e.innerHTML = _("parent voip")+" >> "+_("voip dialplan title");

	e = document.getElementById("vdigmap");
	e.innerHTML = _("voip digitmap title");
	e = document.getElementById("venable");
	e.innerHTML = _("voip digitmap enable");
	e = document.getElementById("vpnum");
	e.innerHTML = _("voip digitmap prefix number");		
	e = document.getElementById("vmode");
	e.innerHTML = _("voip digitmap mode");		
	e = document.getElementById("vopnum");
	e.innerHTML = _("voip digitmap op number");		
	e = document.getElementById("vminlen");
	e.innerHTML = _("voip digitmap min len");		
	e = document.getElementById("vmaxlen");
	e.innerHTML = _("voip digitmap max len");		
	e = document.getElementById("vinterface");
	e.innerHTML = _("voip digitmap interface");		
	e = document.getElementById("vnote");
	e.innerHTML = _("voip note");
	e = document.getElementById("vnote1");
	e.innerHTML = _("voip digitmap note");

	e = document.getElementById("vcancel");
	e.value = _("voip cancel");		
	e = document.getElementById("vok");
	e.value = _("voip ok");		
}

function onClickPbEn()
{	
    for(var i = 0; i < prefix_num; i++) {
		var en_name = "pbEn_" + i;
		var digmap_en = document.getElementById(en_name).checked;
		var idx = getIdxbyName(f, en_name);
		cpntCtrl(digmap_en, f, f[idx+1],6);
    }  
}

function addRow(index, frag, values) 
{
    var tr = CreateStyledElement("tr", index % 2 ? "config_even" : "config_odd");
    var td;

    var txt = document.createTextNode(index+1);
    td = CreateStyledElement("td", "c");
    td.appendChild(txt);
    tr.appendChild(td);

	var field = addCheckBoxCell(tr, parseInt(values[0]), "c", "pbEn_" + index);
	field.value = 1;
	field.onclick = function () {
		var idx = getIdxbyName(f, this.name);
		cpntCtrl(this.checked, f, f[idx+1],6);
	
	}
	addInputCell(tr, values[1], "c", "pbPnum_" + index, 11);
	addSelectCell(tr, oTMode, oVMode, parseInt(values[2]), "c", "pbMode_" + index);
	addInputCell(tr, values[3], "c", "pbOp_" + index, 11);
	addInputCell(tr, values[4], "c", "pbMinLen_" + index, 2);
	addInputCell(tr, values[5], "c", "pbMaxLen_" + index, 2);
	addSelectCell(tr, oTInterface, oVInterface, parseInt(values[6]), "c", "pbIntface_" + index);
	
    frag.appendChild(tr);       // Add row to fragment
}

function initValue()
{
	f = document.frm;
	initTranslation();

	var sip = '<% showRegSipAcntOption(); %>';
	var arySipAccnt = Array(0);
	for (i=0; i< 6; i++) {
		arytmp = sip.split("|");
		tmp = arytmp[i].split(",");
		arySipAccnt.push(tmp[0]);
	}
	for(i=0; i<6; i++){
		if(arySipAccnt[i] == ""){
			oTInterface[i] = oTInterface[i] + "-???";
		}else{
			oTInterface[i] = oTInterface[i] + "-" + arySipAccnt[i];
		}
	}
		
	var frag = document.createDocumentFragment();
	for(var i = 0; i < prefix_num; i++) {
		if (voip_dg[i] == "") voip_dg[i] = "0,,0,,0,0,0";
		var values = voip_dg[i].split(",");
       	addRow(i, frag, values);
    }	
    var tbody = document.getElementById('digitmap');
    clearChildNodes(tbody);
    if (!tbody.appendChild(frag)) { // Add Frag to table body
        alert(TR("This browser doesn't support dynamic tables."));
    }
    onClickPbEn();
}

function checkForm()
{
    for(var i=0; i< prefix_num; i++){
    	var pref = getVleFromElmt(f[1+ruleItemNum*i]);
    	var mode = getVleFromElmt(f[2+ruleItemNum*i]);
    	var op = getVleFromElmt(f[3+ruleItemNum*i]);
    	var minlen = parseInt( getVleFromElmt(f[4+ruleItemNum*i]) );
    	var maxlen = parseInt( getVleFromElmt(f[5+ruleItemNum*i]) );
    	
    	re = /^[0-9]+$/;
    	if (!re.test(pref) && pref != "") {
    		alert(TR('The Prefix Number is invalid,  please re-enter!'));
    		return false;
    	}
    	if (!re.test(op) && op != "") {
    		alert(TR('The OP Number is invalid,  please re-enter!'));
    		return false;
    	}
    	if (!re.test(minlen) && minlen != "") {
    		alert(TR('The Min Len is invalid,  please re-enter!'));
    		return false;
    	}
    	if (!re.test(maxlen) && maxlen != "") {
    		alert(TR('The Max Len is invalid,  please re-enter!'));
    		return false;
    	}
    	reg = new RegExp(op);
    	result = pref.search(reg);
    	if((mode == 2) && (result < 0)){
    		alert(TR("In Strip mode, the \"OP Number\" string should be substring of \"Prefix Number\", please check #") + (i+1) + "!");
    		return false;
    	}
    	//check the PrefixNumber, MinLen, MaxLen
    	if( isNaN( minlen ) ) minlen = 0;
    	if( isNaN( maxlen ) ) maxlen = 0;
    	if(minlen > maxlen) {
    		var temp = minlen;
    		minlen = maxlen;
    		maxlen = temp;
    	}
    	if(minlen < MIN_LEN || minlen > MAX_LEN) minlen = MIN_LEN;
    	if(maxlen > MAX_LEN)	maxlen = MAX_LEN;
    	setVle2Elmt(f[4+ruleItemNum*i], minlen, 0);
    	setVle2Elmt(f[5+ruleItemNum*i], maxlen, 0);
    }
    cpntCtrl(true, f, f[1], ruleItemNum*prefix_num);	
}
</script>
</head>

<body onLoad="initValue()">
<table class="body">
<tr><td>
<h1 id="vdialplan">DialPlan Setup</h1>
<hr size="1" />
<br />

<form name="frm" method="POST" onsubmit="return checkForm();" action="/goform/digmap">
<h2 class="title" id="vdigmap">Digit Map Setup</h2>
<table width="100%" cellpadding="2" cellspacing="2" class="config">
	<thead>
		<tr class="config_header">
			<th width=2%>#</th>
			<th width=8% id="venable">Enable</th>
			<th width=18% id="vpnum">Prefix Number</th>
			<th width=15% id="vmode">Mode</th>
			<th width=18% id="vopnum">OP Number</th>
			<th width=10% id="vminlen">Min Len</th>
			<th width=14% id="vmaxlen">Max Len</th>
			<th width=15% id="vinterface">Interface</th>
		</tr>
	</thead>
	<tbody id="digitmap">
	</tbody>
</table>
		
<table align=center width="100%" border="0" cellspacing="1" cellpadding="2">
	<tr>
		<td><b id="vnote">Note:</b><span id="vnote1">Min Len and Max Len should be between 0~25.</span></td>
	</tr>
</table>
<br>

<table align=center>
	<tr><td>
        <input class=btnw type="submit" value="OK" id="vok">&nbsp;&nbsp;
        <input class=btnw type="button" value="Cancel" id="vcancel" onclick="document.location.href='vdialpl.asp'">
		</td>
	</tr>
</table>
</form>	

</td></tr>
</table>

</body>
</html>
<script type="text/javascript" src="/dtree/tool.js"></script>
<script type="text/javascript" src="/jquery.js"></script>
<script>
	var _fw_upgrade_notify	='<% getCfgGeneral(1, "fw_upgrade_notify", 1); %>';
	var _aryInfo = [<% getUpgradeInfo(); %>];// [0]:exit new fw  [1]:ver
	var _curt_ver = '<% getSdkVersion(); %>';
	var _lanIP = '<% getLanIp(); %>';
	fw_urpgrade_auto_detect(_fw_upgrade_notify,_aryInfo,_curt_ver,_lanIP);
</script>	
		