<html>
<head>
<title>LAN General Setup</title><% chkLoginUser(); %>
<meta http-equiv="content-type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="/style/normal_ws.css" type="text/css">
<script type="text/javascript" src="/lang/b28n.js"></script>
<script type="text/javascript" src="/dtree/tool.js"></script>
</head>

<body onLoad="initValue()">
<table class="body">
<tr><td>

<h1 id="v6Title"></h1>
<hr size="1" />
<br />

<form method=post name="frm" action="/goform/set_ipv6_lan" onSubmit="return CheckValue()">

<h2 class="title" id="v6LanIpConfig">LAN IPv6 Configuration</h2>
<table class="config" width="100%" cellspacing="1" cellpadding="2">
	<tr>
		<td class=head><span id=ipv6_address>IPv6 Address</span></td>
		<td><input type="text" name="lanIp" maxlength="39" size="39" value="<% getCfgGeneral(1, "v6_lan_ip", 0); %>">/64</td>
	</tr>
	<tr>
		<td class=head><span id=ipv6_link_local_address>IPv6 Link Local Address</span></td>
		<td><% getLanLinkIpv6(); %></td>
	</tr>
</table>
<br>
<h2 class="title" id=radvd_cfg>RADVD Configuration</h2>
<table class="config" width="100%" cellspacing="1" cellpadding="2">
	<tr>
		<td class=head><input type="checkbox" name="v6_radvd_en" value="1"><span id="enRadvd">Enable</span></td>
	</tr>
	<tr>
		<td class=head><span id=adv_life_time>Advertisement Lifetime</span></td>
		<td><input type="text" name=radvdLifetime maxlength=8><span id="adlimin">(minutes)</span></td>
	</tr>
</table>
<br>
<h2 class="title" id=dhcp_v6_server_cfg>DHCPv6 Server Configuration</h2>
<table class="config" width="100%" cellspacing="1" cellpadding="2">
	<tr>
		<td class=head><input type="checkbox" name="enDhcp" value="1"><span id="enRadvd1">Enable</span></td>
	</tr>
	<tr>
		<td class=head><span id=start_ipv6_address>Start IPv6 Address</span></td>
		<td><input type="text" name="sStIpv6Adrs" maxlength="39" size="39" value="<% getCfgGeneral(1, "v6_lan_dhcp_addr_start", 0); %>"></td>
	</tr>
	<tr>
		<td class=head><span id=end_ipv6_address>End IPv6 Address</span></td>
		<td><input type="text" name="sEdIpv6Adrs" maxlength="39" size="39" value="<% getCfgGeneral(1, "v6_lan_dhcp_addr_end", 0); %>"></td>
	</tr>
	<tr>
		<td class=title id=dns_server_ipv6_addr>DNS Server IPv6 Address</td>
	</tr>
	<tr>
		<td class=head><span id=primary_dns_server>Primary DNS Server</span></td>
		<td><input type="text" name=sPDns maxlength="39" size="39" value="<% getCfgGeneral(1, "v6_lan_dhcp_dns1", 0); %>"></td>
	</tr>
	<tr>
		<td><span id=secondary_dns_server>Secondary DNS Server</span></td>
		<td><input type="text" name=sSDns maxlength="39" size="39" value="<% getCfgGeneral(1, "v6_lan_dhcp_dns2", 0); %>"></td>
	</tr>
</table>

<br>
<table width="100%" cellpadding="2" cellspacing="1">
<tr align="center">
  <td>
    <input type=submit class="btnw" value="OK" id="iApply">
    <input type=reset  class="btnw" value="Cancel" id="iCancel" onClick="window.location.reload()">
  </td>
</tr>
</table>
</form>

</td></tr>
</table>
</body>
</html>
<script type="text/javascript" src="/dtree/tool.js"></script>
<script type="text/javascript" src="/jquery.js"></script>
<script>
	var _fw_upgrade_notify	='<% getCfgGeneral(1, "fw_upgrade_notify", 1); %>';
	var _aryInfo = [<% getUpgradeInfo(); %>];// [0]:exit new fw  [1]:ver
	var _curt_ver = '<% getSdkVersion(); %>';
	var _lanIP = '<% getLanIp(); %>';
	fw_urpgrade_auto_detect(_fw_upgrade_notify,_aryInfo,_curt_ver,_lanIP);
</script>
<script type="text/javascript" language="JavaScript">
Butterlate.setTextDomain("ipv6");

var f = document.frm;

function CheckValue()
{
	var lan_ip = getVleFromElmt(f.lanIp, 0);
	var lan_radvd_lifetime = getVleFromElmt(f.radvdLifetime, 0);

	// check lan_ip is valid ipv6 address or empty string
	if (!isIPv6(lan_ip)) {
		alert(_("ipv6 addr invalid"));
		return false;
	}

	if (!isIPv6(f.sStIpv6Adrs.value)) {
		alert(_("ipv6 dhcp start addr invalid"));
		return false;
	}

	if (!isIPv6(f.sEdIpv6Adrs.value)) {
		alert(_("ipv6 dhcp end addr invalid"));
		return false;
	}

	if (!isIPv6(f.sPDns.value)) {
		alert(_("ipv6 dns1 addr invalid"));
		return false;
	}

	if (!isIPv6(f.sSDns.value)) {
		alert(_("ipv6 dns2 addr invalid"));
		return false;
	}

	if(getVleFromElmt(f.enDhcp, 0)==1&&(f.sStIpv6Adrs.value==''||f.sEdIpv6Adrs.value=='')){
		alert(_("ipv6_s2e_error"));
		return false;
	}
	if (!isInt(lan_radvd_lifetime) || (lan_radvd_lifetime != 0 && (lan_radvd_lifetime < 10 || lan_radvd_lifetime > 150))) {
		alert(_("ipv6 lan lifetime invalid"));
		return false;
	}

	return true;
}

function initTranslation()
{
	var e = document.getElementById("v6Title");
	e.innerHTML = _("parent ipv6")+" >> "+_("ipv6 lan title");

	e = document.getElementById("v6LanIpConfig");
	e.innerHTML = _("ipv6 lan ip config");
	//e = document.getElementById("v6LanIp");
	//e.innerHTML = _("ipv6 addr");



	e = document.getElementById("ipv6_link_local_address");
	e.innerHTML = _("ipv6_link_local_address");
	e = document.getElementById("radvd_cfg");
	e.innerHTML = _("radvd_cfg");
	e = document.getElementById("enRadvd");
	e.innerHTML = _("enRadvd");
	e = document.getElementById("enRadvd1");
	e.innerHTML = _("enRadvd");
	e = document.getElementById("adlimin");
	e.innerHTML = _("adv_life_min");	
	e = document.getElementById("adv_life_time");
	e.innerHTML = _("adv_life_time");
	e = document.getElementById("dhcp_v6_server_cfg");
	e.innerHTML = _("dhcp_v6_server_cfg");
	e = document.getElementById("start_ipv6_address");
	e.innerHTML = _("start_ipv6_address");
	e = document.getElementById("ipv6_address");
	e.innerHTML = _("ipv6_address");
	e = document.getElementById("end_ipv6_address");
	e.innerHTML = _("end_ipv6_address");
	e = document.getElementById("dns_server_ipv6_addr");
	e.innerHTML = _("dns_server_ipv6_addr");
	e = document.getElementById("primary_dns_server");
	e.innerHTML = _("primary_dns_server");
	e = document.getElementById("secondary_dns_server");
	e.innerHTML = _("secondary_dns_server");

	e = document.getElementById("iApply");
	e.value = _("ipv6 apply");
	e = document.getElementById("iCancel");
	e.value = _("ipv6 cancel");
}

function initValue()
{
	initTranslation();


	var lan_radvd_en = "<% getCfgGeneral(1, "v6_radvd_en", 1); %>";
	var lan_dhcp_en = "<% getCfgGeneral(1, "v6_lan_dhcp_en", 1); %>";
	var lan_radvd_lifetime = "<% getCfgGeneral(1, "v6_radvd_lifetime", 1); %>";

	setVle2Elmt(f.v6_radvd_en, lan_radvd_en, 0);
	setVle2Elmt(f.enDhcp, lan_dhcp_en, 0);

	if (lan_radvd_lifetime.length == 0)
		lan_radvd_lifetime = "30";		// default : 30 minutes
	else
		lan_radvd_lifetime = (lan_radvd_lifetime / 60);	// convert seconds to minutes
	setVle2Elmt(f.radvdLifetime, lan_radvd_lifetime, 0);
}

</script>
