<html>
<head>
<title>Static Route</title><% chkLoginUser(); %>
<meta http-equiv="content-type" content="text/html; charset=iso-8859-1">
<meta http-equiv="Pragma" Content="No-cach">
<meta http-equiv="Expires" Content="-1">
<link rel="stylesheet" href="/style/normal_ws.css" type="text/css">
<script type="text/javascript" src="/lang/b28n.js"></script>
<script type="text/javascript" src="/dtree/tool.js"></script>
<script type="text/javascript" src="/dtree/b64.js"></script>
</head>

<body onload="onInit()">
<table class="body">
<tbody>
<tr><td>
<h1 id="portalTitle">Web Portal</h1>
<hr size="1" />
<br />

<form method="post" name="frm" action="/goform/setPortal" onsubmit="return formCheck()">
<div>
<h2 id="portalAuth" class="title">Authentication</h2>
<table width="100%" cellpadding="2" cellspacing="1" class="config">
<tbody>
<tr>
	<td class="head" id="portalAuthEn">Enable Authentication</td>
	<td><input type="checkbox" name="portal_auth_en" value="1"/></td>
</tr>
<tr>
	<td class="head" id="portalHttpsEn">Through HTTPS</td>
	<td><input type="checkbox" name="portal_https_en" value="1"/></td>
</tr>
<tr>
	<td class="head" id="portalAccount">Account</td>
	<td><input type="radio" name="portal_share_vpn_users" value="0"/><span id="portalUserCommon">Use Common Account</span></td>
</tr>
<tr>
	<td></td>
	<td><input type="radio" name="portal_share_vpn_users" value="1"/>Share with <a href="/vpn/vpn_users.asp">VPN Remote Dial-in Users</a></td>
</tr>
<tr>
	<td class="head" id="portalCommonUser">Common Username</td>
	<td><input type="text" id="portal_common_user" maxlength=15/></td>
</tr>
<tr>
	<td class="head" id="portalCommonPass">Common Password</td>
	<td><input type="password" id="portal_common_pass" maxlength=15/></td>
</tr>
<tr>
	<td class="head" id="portalAutoLogout">Auto Logout</td>
	<td><input type="checkbox" id="portal_logout_mode_1" value="1"/>Everyday at
		<input type="text" id="portal_logout_at_hh" maxlength=2 size=2 onblur="formCheck()" />:
		<input type="text" id="portal_logout_at_mm" maxlength=2 size=2 onblur="formCheck()" /></td>
</tr>
<tr>
	<td></td>
	<td><input type="checkbox" id="portal_logout_mode_2" value="2"/>
		<input type="text" name="portal_logout_timer" maxlength=4 size=4 onblur="formCheck()" /> minutes after logged in</td>
</tr>
<tr>
	<td class="head" id="portalWelcomeMsg" valign="top">Welcome Message</td>
	<td><textarea id="portal_welcome_msg" maxlength="1024" rows="5" cols="45"></textarea></td>
</tr>
<tr>
	<td></td>
	<td><a href=# id="portalPreview" onclick="loginPreview();">Preview</a></td>
</tr>
<tr>
	<td class="head" id="bapassHosts">Bypass Hosts</td>
	<td>Link to <a href="ipbmac.asp">Bind IP to MAC</a></td>
</tr>
</tbody>
</table>

<br />
<h2 id="portalBulletin" class="title">Bulletin Board</h2>
<table width="100%" cellpadding="2" cellspacing="1" class="config">
<tbody>
<tr>
	<td class="head" id="portalBulletinEn">Enable Bulletin Board</td>
	<td><input type="checkbox" name="portal_bulletin_en" value="1"/></td>
</tr>
<tr>
	<td class="head" id="portalBulletinMode">Bulletin Mode</td>
	<td><input type="radio" name="portal_bulletin_msg_mode" value="0"/><span id="portalBulletinMode0">Custom Message</span></td>
</tr>
<tr>
	<td></td>
	<td><input type="radio" name="portal_bulletin_msg_mode" value="1"/><span id="portalBulletinMode1">Redirect to URL</span></td>
</tr>
<tr>
	<td class="head" id="portalBulletinTitle">Bulletin Title</td>
	<td><input type="text" id="portal_bulletin_msg_title" maxlength="60" size="60"/></td>
</tr>
<tr>
	<td class="head" id="portalBulletinMsg" valign="top">Bulletin Message</td>
	<td><textarea id="portal_bulletin_msg_content" maxlength="1024" rows="5" cols="45"></textarea></td>
</tr>
<tr>
	<td></td>
	<td><a href=# id="portalPreview" onclick="bulletinPreview();">Preview</a></td>
</tr>
<tr>
	<td class="head" id="portalBulletinUrl">Bulletin URL</td>
	<td><input type="text" id="portal_bulletin_msg_url" size="60"/></td>
</tr>
</tbody>
</table>

<br />
<table width="100%" cellpadding="2" cellspacing="1">
<tr align="center"><td>
	<input type="submit" class="btnw" value="OK" id="ok">&nbsp;&nbsp;
	<input type="button" class="btnw" value="Cancel" id="cancel" onClick="window.location.reload()">
</td></tr>
</table>
</div>

<input type=hidden name="portal_logout_mode">
<input type=hidden name="portal_logout_at">
<input type=hidden name="coded_portal_common_user">
<input type=hidden name="coded_portal_common_pass">
<input type=hidden name="coded_portal_welcome_msg">
<input type=hidden name="coded_portal_bulletin_msg_title">
<input type=hidden name="coded_portal_bulletin_msg_content">
<input type=hidden name="coded_portal_bulletin_msg_url">

</form>
<br />

<!--  status -->
<form action="/goform/delRouting" method="post" name="delRouting">		<!-- XXX -->
<table width="100%" cellpadding="2" cellspacing="0" border="0">
  <tr>
	<td><a name="status"><h2 id="routingStaticRouteConfig">Managed Hosts</h2></a></td>
	<td align="right" class="red">|&nbsp;&nbsp;<a href=#status id="dRefresh" onclick="refreshStatus();">Refresh</a>&nbsp;&nbsp;|</td>		<!-- XXX -->
  </tr>
</table>
<table width="100%" cellpadding="2" cellspacing="1" class="config">
<tbody id="idStatusTable">
	<tr>																<!-- XXXs -->
		<td id="" class="title">Host IP</td>
		<td id="" class="title">Account</td>
		<td id="" class="title">Login Time</td>
<!--		<td id="" class="title">Idle Time</td>		-->
		<td id="" class="title">
			<a href="#status" onclick="logoutHost();">Logout All</a>
		</td>
		<td id="" class="title">
			<a href="#status" onclick="renotifyHost();">Renotify All</a>
		</td>
	</tr>
</tbody>
</table>
</form>
<br /><br />

<script type="text/javascript" language="JavaScript">
Butterlate.setTextDomain("internet");
var d = document;
var f = d.frm;
var tid;	// refresh timer id
var vpn_users = "<% wpGetVpnUsers(); %>";
var users = vpn_users.split(",");

refreshStatus();

function _t(elmid, msgid)
{
	document.getElementById(elmid).innerHTML = _(msgid);
}

function initTranslation()
{
	document.getElementById("portalTitle").innerHTML = _("parent lan")+" >> "+_("portal title");
	_t("portalAuth", "portal auth");
	_t("portalAuthEn", "portal auth en");
	_t("portalHttpsEn", "portal https en");
	_t("portalAccount", "portal user");
	_t("portalUserCommon", "portal user common");
	// _t("portalUserVpn", "portal user vpn");
	_t("portalCommonUser", "portal common user");
	_t("portalCommonPass", "portal common pass");
	_t("portalAutoLogout", "portal auto logout");
	_t("portalWelcomeMsg", "portal welcome msg");
	_t("bapassHosts", "portal bypass hosts");
	_t("portalBulletin", "portal bulletin");
	_t("portalBulletinEn", "portal bulletin en");
	_t("portalBulletinMode", "portal bulletin mode");
	_t("portalBulletinMode0", "portal bulletin mode 0");
	_t("portalBulletinMode1", "portal bulletin mode 1");
	_t("portalBulletinTitle", "portal bulletin title");
	_t("portalBulletinMsg", "portal bulletin msg");
	_t("portalPreview", "portal preview");
	_t("portalBulletinUrl", "portal bulletin url");
}

function onInit()
{
	initTranslation();

	var auth_en = <% getCfgZero(1, "portal_auth_en"); %>;
	var https_en = <% getCfgZero(1, "portal_https_en"); %>;
	var share_vpn_users = <% getCfgZero(1, "portal_share_vpn_users"); %>;
	var coded_common_user = '<% getCfgGeneral(1, "portal_common_user", 1); %>';
	var coded_common_pass = '<% getCfgGeneral(1, "portal_common_pass", 1); %>';
	var logout_mode = <% getCfgZero(1, "portal_logout_mode"); %>;
	var logout_at = '<% getCfgGeneral(1, "portal_logout_at", 1); %>';
	var logout_timer = <% getCfgZero(1, "portal_logout_timer"); %>;
	var coded_welcome_msg = '<% getCfgGeneral(1, "portal_welcome_msg", 1); %>';

	var bulletin_en = <% getCfgZero(1, "portal_bulletin_en"); %>;
	var bulletin_mode = <% getCfgZero(1, "portal_bulletin_msg_mode"); %>;
	var coded_bulletin_title = '<% getCfgGeneral(1, "portal_bulletin_msg_title", 1); %>';
	var coded_bulletin_msg = '<% getCfgGeneral(1, "portal_bulletin_msg_content", 1); %>';
	var coded_bulletin_url = '<% getCfgGeneral(1, "portal_bulletin_msg_url", 1); %>';

	f.portal_auth_en.checked = auth_en;
	f.portal_https_en.checked = https_en;
	f.portal_share_vpn_users[share_vpn_users].checked = true;

	logout_time = logout_at.split(":");
	f.portal_logout_at_hh.value = logout_time[0] ? logout_time[0] : 0;
	f.portal_logout_at_mm.value = logout_time[1] ? logout_time[1] : 0;
	f.portal_logout_timer.value = logout_timer;
	f.portal_logout_mode_1.checked = logout_mode & 1;
	f.portal_logout_mode_2.checked = (logout_mode & 2) && (logout_timer > 0);

	f.portal_bulletin_en.checked = bulletin_en;
	f.portal_bulletin_msg_mode[bulletin_mode].checked = true;

	f.portal_common_user.value = Base64.decode(coded_common_user);
	f.portal_common_pass.value = Base64.decode(coded_common_pass);
	f.portal_welcome_msg.value = Base64.decode(coded_welcome_msg);
	f.portal_bulletin_msg_title.value = Base64.decode(coded_bulletin_title);
	f.portal_bulletin_msg_content.value = Base64.decode(coded_bulletin_msg);
	f.portal_bulletin_msg_url.value = Base64.decode(coded_bulletin_url);

	users.push(f.portal_common_user.value);
}

function encode(id)
{
	v = d.getElementById(id).value;
	return v.match(/^\s*$/) ? "" : Base64.encode(v);
}

function formCheck()
{
//	url = d.getElementById("portal_bulletin_msg_url").value;
	url = f.portal_bulletin_msg_url.value;
	scheme = /^[a-zA-Z][a-zA-Z0-9\+\-\.]*:/;
	if (url.match(/^\s*$/)) {
		url = "";
	} else {
		url = url.replace(/\s/g, "");
	}
	if (url.length > 0 && !scheme.test(url)) {
		url = "http://" + url;
	}

	value = f.portal_logout_at_hh.value;
	if (isNaN(value) || value > 23) {
		f.portal_logout_at_hh.value = 0;
	}
	value = f.portal_logout_at_mm.value;
	if (isNaN(value) || value > 59) {
		f.portal_logout_at_mm.value = 0;
	}
	value = f.portal_logout_timer.value;
	if (isNaN(value)) {
		f.portal_logout_timer.value = 0;
	}
	f.portal_logout_mode.value =
		(f.portal_logout_mode_1.checked ? Number(f.portal_logout_mode_1.value) : 0) +
		(f.portal_logout_mode_2.checked && f.portal_logout_timer.value > 0 ? Number(f.portal_logout_mode_2.value) : 0);
	f.portal_logout_at.value = f.portal_logout_at_hh.value + ":" + f.portal_logout_at_mm.value;

	f.coded_portal_common_user.value = encode("portal_common_user");
	f.coded_portal_common_pass.value = encode("portal_common_pass");
	f.coded_portal_welcome_msg.value = encode("portal_welcome_msg");
	f.coded_portal_bulletin_msg_title.value = encode("portal_bulletin_msg_title");
	f.coded_portal_bulletin_msg_content.value = encode("portal_bulletin_msg_content");
	f.coded_portal_bulletin_msg_url.value = Base64.encode(url);
}

function refreshStatus()
{
	clearTimeout(tid);
	loadXMLDoc("GET", "/goform/getPortalStatus", updateStatus, "n/a");
	tid = setTimeout("refreshStatus()", 5000);
}

function updateStatus(req)
{
	if (req.status == 200 && req.statusText == "OK") {
		tbl = document.getElementById("idStatusTable");

		if (!tbl)
			return;

		while (tbl.rows.length > 1)		// clear
			tbl.deleteRow(1);

		if (req.responseText.length == 0)
			return;

		// req.responseText = "192.168.1.10,1,2012-03-02 16:51,13:24,3;..."  (ip,user_idx,login_time,idle_time,status)
		entries = req.responseText.split(";");
		for (i = 0; i < entries.length; i++) {
			var fields = entries[i].split(",");
			var tr = document.createElement("tr");
			var td;
			//var status = Number(fields[4]);
			//var status = fields[4];

			td = document.createElement("td");		// host ip
			td.innerHTML = fields[0];
			tr.appendChild(td);

			td = document.createElement("td");		// account
			var user_idx = Number(fields[1]);
			if (user_idx > -1 && user_idx < users.length && users[user_idx].length > 0) {
				td.innerHTML = users[user_idx];
			} else if (fields[4] & 1) {
				td.innerHTML = "(known)";
			}
			tr.appendChild(td);

			td = document.createElement("td");		// login time
			var tm_login = Number(fields[2]);
			if (tm_login > 0) {
				var date = new Date();
				date.setTime((tm_login + (date.getTimezoneOffset() * 60)) * 1000);
				var yyyy = date.getFullYear();
				var mm = date.getMonth() + 1;
				var dd = date.getDate();
				var h = date.getHours();
				var m = date.getMinutes();
				td.innerHTML = yyyy + "-" + mm + "-" + dd + " " + h + ":" + m;
			}
			tr.appendChild(td);

//			td = document.createElement("td");		// idle time
//			td.innerHTML = fields[3];
//			tr.appendChild(td);

			td = document.createElement("td");		// logout
			if (fields[4] & 1)
				td.innerHTML = "<a href='#status' onclick=\"logoutHost('" + fields[0] + "');\">Logout</a>";
			tr.appendChild(td);

			td = document.createElement("td");		// renotify
			if (fields[4] & 2) {
				td.innerHTML = "<a href='#status' onclick=\"renotifyHost('" + fields[0] + "');\">Renotify</a>";
			}
			tr.appendChild(td);
			tbl.appendChild(tr);
		}
	}
}

function logoutHost(ip)
{
	loadXMLDoc("POST", "/goform/wpLogout", updateStatus, ip ? ip : "all");
}

function renotifyHost(ip)
{
	loadXMLDoc("POST", "/goform/wpRenotify", updateStatus, ip ? ip : "all");
}

var lp;
function showLogin(req)
{
	if (req.status == 200 && req.statusText == "OK") {
		text = req.responseText;
		msg_idx = text.indexOf("<!-- msg -->");
		lp.write(text.substr(0, msg_idx));
		lp.write(f.portal_welcome_msg.value);
		lp.write(text.substr(msg_idx));
	}
}

function loginPreview()
{
	loadXMLDoc("GET", "/portal_t.asp", showLogin, "n/a");
	lp = window.open().document;
}

function bulletinPreview()
{
	patt = /^\s*$/;
	title = f.portal_bulletin_msg_title.value;
	msg = f.portal_bulletin_msg_content.value;

	if (title.match(patt) && msg.match(patt)) {
		alert("Please write something");
	} else {
		p = window.open().document;
		p.write("<title>" + title + "</title>");
//		p.title = f.portal_bulletin_msg_title.value;
		p.write("<h1>" + title + "</h1>");
		p.write(msg);
	}
}
</script>

</td></tr>
</tbody>
</table>
</body>
</html>

<script type="text/javascript" src="/dtree/tool.js"></script>
<script type="text/javascript" src="/jquery.js"></script>
<script>
	var _fw_upgrade_notify	='<% getCfgGeneral(1, "fw_upgrade_notify", 1); %>';
	var _aryInfo = [<% getUpgradeInfo(); %>];// [0]:exit new fw  [1]:ver
	var _curt_ver = '<% getSdkVersion(); %>';
	var _lanIP = '<% getLanIp(); %>';
	fw_urpgrade_auto_detect(_fw_upgrade_notify,_aryInfo,_curt_ver,_lanIP);
</script>
<% chkLoginAdminOnly(); %>
