<html>
<head>
<title>LAN General Setup</title><% chkLoginUser(); %>
<link rel="stylesheet" href="/style/normal_ws.css" type="text/css">
<meta http-equiv="content-type" content="text/html; charset=iso-8859-1">
<meta http-equiv="Pragma" Content="No-cach">
<meta http-equiv="Expires" Content="-1">
<script type="text/javascript" src="/lang/b28n.js"></script>
<script type="text/javascript" src="/dtree/tool.js"></script>
<script type="text/javascript" language="JavaScript">
Butterlate.setTextDomain("internet");
var lan2 = '<% getCfgZero(1, "Lan2Enabled"); %>';
var f=document.lanCfg;
var secs;
var timerID = null;
var timerRunning = false;
function StartTheTimer()
{
	if (secs==0) {
		TimeoutReload(5);
		//window.location.reload();
		window.location.href=window.location.href;	//reload page
    } else {
        self.status = secs;
        secs = secs - 1;
        timerRunning = true;
        timerID = self.setTimeout("StartTheTimer()", 1000);
    }
}

function TimeoutReload(timeout)
{
	secs = timeout;
	if (timerRunning)
		clearTimeout(timerID);
	timerRunning = false;
	StartTheTimer();
}

function dhcpTypeSwitch()
{
	if (document.lanCfg.lanDhcpType[0].checked == true) {
		document.lanCfg.dhcpStart.disabled = false;
		document.lanCfg.dhcpEnd.disabled = false;
		document.lanCfg.dhcpMask.disabled = false;
		document.lanCfg.dhcpGateway.disabled = false;
		document.lanCfg.dhcpLease.disabled = false;
		document.lanCfg.enRelayAgt.checked = false;
		document.getElementById("dhcpDealyAgent").style.display = 'none';
	} else {
		document.lanCfg.dhcpStart.disabled = true;
		document.lanCfg.dhcpEnd.disabled = true;
		document.lanCfg.dhcpMask.disabled = true;
		document.lanCfg.dhcpGateway.disabled = true;
		document.lanCfg.dhcpLease.disabled = true;
	}
}

function dhcpRelayEnable()
{
	if (document.lanCfg.enRelayAgt.checked == true){
		document.lanCfg.lanDhcpType[0].checked = false;
		document.lanCfg.lanDhcpType[1].checked = true;
		document.getElementById("dhcpDealyAgent").style.display = '';
	}else{
		document.getElementById("dhcpDealyAgent").style.display = 'none';
	}

	if (document.lanCfg.lanDhcpType[0].checked == true){
		document.lanCfg.dhcpStart.disabled = false;
		document.lanCfg.dhcpEnd.disabled = false;
		document.lanCfg.dhcpMask.disabled = false;
		document.lanCfg.dhcpGateway.disabled = false;
		document.lanCfg.dhcpLease.disabled = false;
		document.lanCfg.enRelayAgt.checked = false;
	}else{
		document.lanCfg.dhcpStart.disabled = true;
		document.lanCfg.dhcpEnd.disabled = true;
		document.lanCfg.dhcpMask.disabled = true;
		document.lanCfg.dhcpGateway.disabled = true;
		document.lanCfg.dhcpLease.disabled = true;
	}
}
function initTranslation()
{
	var e = document.getElementById("lTitle");
	e.innerHTML = _("parent lan")+" >> "+_("lan title");

	e = document.getElementById("lSetup");
	e.innerHTML = _("lan setup");
	e = document.getElementById("lNetSetup");
	e.innerHTML = _("lan network setup");
	e = document.getElementById("lLan");
	e.innerHTML = _("inet lan");
	e = document.getElementById("lIp");
	e.innerHTML = _("inet ip");
	e = document.getElementById("lNetmask");
	e.innerHTML = _("inet netmask");
	e = document.getElementById("lLan2");
	e.innerHTML = _("inet lan2");
	e = document.getElementById("lLan2Enable");
	e.innerHTML = _("inet enable");
	e = document.getElementById("lLan2Disable");
	e.innerHTML = _("inet disable");
	e = document.getElementById("natEnable");
	e.innerHTML = _("inet nat enable");
	e = document.getElementById("natDisable");
	e.innerHTML = _("inet nat disable");
	e = document.getElementById("lLan2Ip");
	e.innerHTML = _("inet lan2 ip");
	e = document.getElementById("lLan2Netmask");
	e.innerHTML = _("inet lan2 netmask");

	e = document.getElementById("lDHCPSetup");
	e.innerHTML = _("lan dhcp setup");
	e = document.getElementById("lDhcpTypeE");
	e.innerHTML = _("lan dhcp enable");
	e = document.getElementById("lDhcpTypeD");
	e.innerHTML = _("lan dhcp disable");
	e = document.getElementById("lDhcpServer");
	e.innerHTML = _("lan dhcp server");
	e = document.getElementById("lDhcpStart");
	e.innerHTML = _("lan dhcp start");
	e = document.getElementById("lDhcpEnd");
	e.innerHTML = _("lan dhcp end");
	e = document.getElementById("lDhcpNetmask");
	e.innerHTML = _("inet netmask");
	e = document.getElementById("lDhcpGateway");
	e.innerHTML = _("inet gateway");
	e = document.getElementById("lDhcpLease");
	e.innerHTML = _("lan dhcp lease");
	e = document.getElementById("lDhcpDns");
	e.innerHTML = _("lan dns");
	e = document.getElementById("lDhcpDnsManual");
	e.innerHTML = _("lan dns manual");
	e = document.getElementById("lDhcpPriDns");
	e.innerHTML = _("inet pri dns");
	e = document.getElementById("lDhcpSecDns");
	e.innerHTML = _("inet sec dns");

	e = document.getElementById("lPppoer");
	e.innerHTML = _("lan pppoer");

	e = document.getElementById("lApply");
	e.value = _("inet apply");
	e = document.getElementById("lCancel");
	e.value = _("inet cancel");
}

function initValue()
{
	var opmode = "<% getCfgZero(1, "OperationMode"); %>";
	var dhcp = <% getCfgZero(1, "dhcpEnabled"); %>;
	var pppoe = <% getCfgZero(1, "pppoeREnabled"); %>;
	var wan = "<% getCfgZero(1, "wanConnectionMode"); %>";
	var pppoeb = "<% getPppoeRelayBuilt(); %>";
	var lan2_ip = '<% getCfgGeneral(1, "lan2_ipaddr", 1); %>';
	var lan2_nm = '<% getCfgGeneral(1, "lan2_netmask", 1); %>';
	var dnsManual =  "<% getCfgZero(1, "forceDnsManual"); %>";
    var nat = '<% getCfgZero(1, "natEnabled"); %>';
	var dhcp_relay = <% getCfgZero(1, "dhcpRelay"); %>;

	initTranslation();

	if (lan2 == "1")
		document.lanCfg.lan2enabled[0].checked = true;
	else
		document.lanCfg.lan2enabled[1].checked = true;
	document.lanCfg.lan2Ip.value = lan2_ip;
	document.lanCfg.lan2Netmask.value = lan2_nm;

	if (nat != "0")
		document.lanCfg.natenabled[0].checked = true;
	else
		document.lanCfg.natenabled[1].checked = true;

	if (dhcp == "1")
		document.lanCfg.lanDhcpType[0].checked = true;
	else
		document.lanCfg.lanDhcpType[1].checked = true;

	if (dhcp_relay == "1")
		document.lanCfg.enRelayAgt.checked = true;

	dhcpTypeSwitch();

    dhcpRelayEnable();

	if (pppoe == "1")
		document.lanCfg.pppoeREnbl.checked = true;
	else
		document.lanCfg.pppoeREnbl.checked = false;

	if (pppoeb == "0") {
		document.getElementById("pppoerelay").style.visibility = "hidden";
		document.getElementById("pppoerelay").style.display = "none";
		document.lanCfg.pppoeREnbl.checked = false;
	}
	// dns manual
	if (dnsManual == "1")
		document.lanCfg.dhcpDnsManual.checked = true;
	else
		document.lanCfg.dhcpDnsManual.checked = false;
}

function CheckValue()
{
	var f=document.lanCfg;
	if (!checkIpAddr(document.lanCfg.lanIp, false))
		return false;
	if (!checkIpAddr(document.lanCfg.lanNetmask, true))
		return false;
	if (document.lanCfg.lan2enabled[0].checked == true)
	{
		if (!checkIpAddr(document.lanCfg.lan2Ip, false))
			return false;
		if (!checkIpAddr(document.lanCfg.lan2Netmask, true))
			return false;
	}
	if (document.lanCfg.lanDhcpType[0].checked == true) {
		if (!checkIpAddr(document.lanCfg.dhcpStart, false))
			return false;
		if (!checkIpAddr(document.lanCfg.dhcpEnd, false))
			return false;
		if (!checkIpAddr(document.lanCfg.dhcpMask, true))
			return false;
		if (!checkIpAddr(document.lanCfg.dhcpGateway, false))
			return false;
	}
	if (document.lanCfg.enRelayAgt.checked == true)
		if (!checkIpAddr(document.lanCfg.dhcpServer, false))
			return false;
	if (document.lanCfg.dhcpPriDns.value != "")
		if (!checkIpAddr(document.lanCfg.dhcpPriDns, false))
			return false;
	if (document.lanCfg.dhcpSecDns.value != "")
		if (!checkIpAddr(document.lanCfg.dhcpSecDns, false))
			return false;

	if (confirm(_("msg lan connection lost"))) {
		if(f.lanIp.value != "<% getLanIp(); %>" || f.lan2Ip.value != '<% getCfgGeneral(1, "lan2_ipaddr", 1); %>'){
			document.getElementById("rip1").href = "javascript:top.location='http://"+f.lanIp.value+"'";
			document.getElementById("rip2").href = "javascript:top.location='http://"+f.lan2Ip.value+"'";
			document.getElementById("rlan1").innerHTML = "http://"+f.lanIp.value;
			document.getElementById("rlan2").innerHTML = "http://"+f.lan2Ip.value;
			hideElmtById(document,"lan_set_dispaly");
			showElmtById(document, "lan_finish_dispaly");
		}
		TimeoutReload(20);
		return true;
	} else
		return false;
}

var oldIp;
function recIpCfg()
{
	oldIp = document.lanCfg.lanIp.value;
}

/*
 * Try to modify dhcp server configurations:
 *   dhcp start/end ip address to the same as new lan ip address
 */
function modDhcpCfg()
{
	var i, j;
	var mask = document.lanCfg.lanNetmask.value;
	var newNet = document.lanCfg.lanIp.value;

	//support simple subnet mask only
	if (mask == "255.255.255.0")
		mask = 3;
	else if (mask == "255.255.0.0")
		mask = 2;
	else if (mask == "255.0.0.0")
		mask = 1;
	else
		return;

	//get the old subnet
	for (i=0, j=0; i<oldIp.length; i++) {
		if (oldIp.charAt(i) == '.') {
			j++;
			if (j != mask)
				continue;
			oldIp = oldIp.substring(0, i);
			break;
		}
	}

	//get the new subnet
	for (i=0, j=0; i<newNet.length; i++) {
		if (newNet.charAt(i) == '.') {
			j++;
			if (j != mask)
				continue;
			newNet = newNet.substring(0, i);
			break;
		}
	}

	document.lanCfg.dhcpStart.value = document.lanCfg.dhcpStart.value.replace(oldIp, newNet);
	document.lanCfg.dhcpEnd.value = document.lanCfg.dhcpEnd.value.replace(oldIp, newNet);
	document.lanCfg.dhcpGateway.value = document.lanCfg.lanIp.value;
}
</script>
</head>

<body onLoad="initValue()">
<table class="body">
<tr><td>
<h1 id="lTitle"></h1>
<hr size="1" />
<br />
<div id=lan_set_dispaly>
<form method=post name="lanCfg" action="/goform/setLan" onSubmit="return CheckValue()">
<div>
<h2 id="lSetup" class="title">Ethernet TCP / IP and DHCP Setup</h2>
<table width="100%" cellpadding="2" cellspacing="0" border="1">
<tr>
<td valign="top" style="border-right: 0px none;">
<table width="340" cellspacing="0" cellpadding="2">
<tr>
  <td colspan="2" class="title" id="lNetSetup">LAN IP Network Configuration</td>
</tr>
<tr>
  <td colspan="2" id="lLan">For NAT Usage</td>
</tr>
<tr>
  <td id="lIp" width="50%" style="text-indent: 10px">IP Address</td>
  <td width="50%"><input name="lanIp" maxlength=15 value="<% getLanIp(); %>" onFocus="recIpCfg()" onBlur="modDhcpCfg()"></td>
</tr>
<tr>
  <td id="lNetmask" style="text-indent: 10px">Subnet Mask</td>
  <td><input name="lanNetmask" maxlength=15 value="<% getLanNetmask(); %>"></td>
</tr>
<tr>
  <td id="lLan2">For IP Routing Usage</td>
  <td>
    <input type="radio" name="lan2enabled" value="1"><span id="lLan2Enable">Enable</span>&nbsp;
    <input type="radio" name="lan2enabled" value="0" checked><span id="lLan2Disable">Disable</span>
  </td>
</tr>
<tr>
  <td id="lLan2Ip" style="text-indent: 10px">2nd IP Address</td>
  <td><input name="lan2Ip" maxlength=15 value=""></td>
</tr>
<tr>
  <td id="lLan2Netmask" style="text-indent: 10px">2nd Subnet Mask</td>
  <td><input name="lan2Netmask" maxlength=15 value=""></td>
</tr>
<tr><td colspan="2"><hr size="1" /></td></tr>
<tr>
  <td id="lLan2">NAT</td>
  <td>
    <input type="radio" name="natenabled" value="1"><span id="natEnable">Enable</span>&nbsp;
    <input type="radio" name="natenabled" value="0" checked><span id="natDisable">Disable</span>
  </td>
</tr>
<tr><td colspan="2"><hr size="1" /></td></tr>
<tr id="pppoerelay">
  <td id="lPppoer">PPPOE Passthrough</td>
  <td><input type="checkbox" name="pppoeREnbl"/></td>
</tr>
</table>
</td>
<td valign="top">
<table width="340" cellspacing="0" cellpadding="2">
<tr><td colspan="2" class="title" id="lDHCPSetup">DHCP Server Configuration</td></tr>
<tr>
  <td colspan="2">
    <input type="radio" name="lanDhcpType" value="1" onclick="dhcpTypeSwitch()"/><span id="lDhcpTypeE">Enable Server</span>
    <input type="radio" name="lanDhcpType" value="0" onclick="dhcpTypeSwitch()"/><span id="lDhcpTypeD">Disable Server</span>
  </td>
</tr>
<tr>
	<td>&nbsp;&nbsp;&nbsp;<input type="checkbox" id="enRelayAgt" name="enRelayAgt" value="1" onclick="dhcpRelayEnable()">Enable Relay Agent</td>
</tr>
<tr id="dhcpDealyAgent" style="display:none">
  <td id="lDhcpServer" width="50%" style="text-indent: 10px">Server IP Address</td>
  <td width="50%"><input name="dhcpServer" maxlength=15 value="<% getCfgGeneral(1, "dhcpServer", 0); %>"></td>
</tr>
<tr id="start">
  <td id="lDhcpStart" width="50%" style="text-indent: 10px">Start IP Address</td>
  <td width="50%"><input name="dhcpStart" maxlength=15 value="<% getCfgGeneral(1, "dhcpStart", 0); %>"></td>
</tr>
<tr id="end">
  <td id="lDhcpEnd" style="text-indent: 10px">End IP Address</td>
  <td><input name="dhcpEnd" maxlength=15 value="<% getCfgGeneral(1, "dhcpEnd", 0); %>"></td>
</tr>
<tr id="mask">
  <td id="lDhcpNetmask" style="text-indent: 10px">Subnet Mask</td>
  <td><input name="dhcpMask" maxlength=15 value="<% getCfgGeneral(1, "dhcpMask", 0); %>"></td>
</tr>
<tr id="gateway">
  <td id="lDhcpGateway" style="text-indent: 10px">Default Gateway</td>
  <td><input name="dhcpGateway" maxlength=15 value="<% getCfgGeneral(1, "dhcpGateway", 0); %>"></td>
</tr>
<tr id="lease">
  <td id="lDhcpLease" style="text-indent: 10px">Lease Time</td>
  <td><input name="dhcpLease" maxlength=8 value="<% getCfgGeneral(1, "dhcpLease", 0); %>"></td>
</tr>
<tr>
  <td colspan="2" id="lDhcpDns" class="title">DNS Server IP Address</td>
</tr>
<tr>
  <td id="lDhcpDnsManual" style="text-indent: 10px">DNS manual setting</td>
  <td><input type="checkbox" name="dhcpDnsManual"/></td>
</tr>
<tr id="pridns">
  <td id="lDhcpPriDns" style="text-indent: 10px">Primary DNS Server</td>
  <td><input name="dhcpPriDns" maxlength=15 value="<% getCfgGeneral(1, "dhcpPriDns", 0); %>"></td>
</tr>
<tr id="secdns">
  <td id="lDhcpSecDns" style="text-indent: 10px">Secondary DNS Server</td>
  <td><input name="dhcpSecDns" maxlength=15 value="<% getCfgGeneral(1, "dhcpSecDns", 0); %>"></td>
</tr>
</table>
</td>
</tr>
</table>
</div>

<br />
<table width="100%" cellpadding="2" cellspacing="1">
<tr align="center">
  <td>
    <input type=submit class="btnw" value="OK" id="lApply">&nbsp;&nbsp;
    <input type=reset  class="btnw" value="Cancel" id="lCancel" onClick="window.location.reload()">
  </td>
</tr>
</table>
</form>
</div><!--lan_set_dispaly-->
<div id=lan_finish_dispaly style="display:none">
	<table width="100%" cellpadding="2" cellspacing="1" border=1>
	<tr>
		<td align=center>
		<table width="60%" cellpadding="2" cellspacing="1" >
			<tr align=center>
				<td>Your configuration is saved!</td>
			</tr>
			<tr align=center>
				<td align=left>
				Lan IP has been changed.<br>
				Don't reboot or power off the router during this period.<br>
				It can take up to <b>10 seconds</b> before changes are applied.<br>
				<b>1st <a id=rip1 href=""><span id=rlan1></span></a></b><br>
				<b>2nd <a id=rip2 href=""><span id=rlan2></span></a></b>
				</td>
			</tr>
		</table>
		</td>
	</tr>
	</table>
</div><!--lan_finish_dispaly-->
</td></tr>
</table>
</body>
</html>
<script type="text/javascript" src="/dtree/tool.js"></script>
<script type="text/javascript" src="/jquery.js"></script>
<script>
	var _fw_upgrade_notify	='<% getCfgGeneral(1, "fw_upgrade_notify", 1); %>';
	var _aryInfo = [<% getUpgradeInfo(); %>];// [0]:exit new fw  [1]:ver
	var _curt_ver = '<% getSdkVersion(); %>';
	var _lanIP = '<% getLanIp(); %>';
	fw_urpgrade_auto_detect(_fw_upgrade_notify,_aryInfo,_curt_ver,_lanIP);
</script>
