<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN">
<html>
<head>
<meta http-equiv="X-UA-Compatible" content="IE=EmulateIE7" />
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta http-equiv="Pragma" Content="No-cach">
<meta http-equiv="Expires" Content="-1">
<link rel="stylesheet" href="/style/normal_ws.css" type="text/css">
<link rel="stylesheet" type="text/css" media="screen" href="/jg/canvaschart.css" />
<style type="text/css">
.chart .legend ul li { list-style: none; }
</style>
<script type="text/javascript" src="/jquery.js"></script>
<script type="text/javascript" src="/jg/chart.js"></script>
<script type="text/javascript" src="/jg/wz_jsgraphics.js"></script>
<script type="text/javascript" src="/jg/jgchartpainter.js"></script>
<script type="text/javascript" src="/jg/canvaschartpainter.js"></script>
<script type="text/javascript" src="/lang/b28n.js"></script>
<script type="text/javascript" src="/dtree/tool.js"></script>
<script type="text/javascript">
Butterlate.setTextDomain("admin");

var bg = parent;
var now = new Date();
var nowdt = now.getDate();
var nowhh = now.getHours();
var nowmm = now.getMinutes();
var aryLables = new Array();
var aryDay = ["(SU)", "(M)", "(TU)", "(W)", "(TH)", "(F)", "(SA)"];
var POINTS_NUM = 361;	// 361 points always.

var aryWan = new Array(POINTS_NUM);
var arybakWan = new Array(POINTS_NUM);
var aryWanWeekly = new Array(POINTS_NUM);
var arybakWanWeekly = new Array(POINTS_NUM);

for (var i=0; i<361; i++) {
	aryWan[i] = 0;
	arybakWan[i] = 0;
	aryWanWeekly[i] = 0;
	arybakWanWeekly[i] = 0;
}

$(function(){
	if (nowhh < 10) nowhh = "0" + nowhh;
	if (nowmm < 10) nowmm = "0" + nowmm;
	$('[name=sltMode]').val(bg.iConnGraphMode);
	$('[name=sltTime]').val(bg.iConnGraphTime);
	$('[name=sltRefreshTime]').val(bg.iConnGraphRefTime);
	initTranslation();
	loadXMLDoc("POST", "/goform/connGraphRecord", graphUpdate, "n/a");
});

function graphUpdate(req)
{
	parseAllData(req.responseText);
	onChgMode();
	onChgTime();
}

function parseAllData(str)
{
	var fileds = str.split("|");
	wan_record = fileds[0] || '0,0';
	wan2_record = fileds[1] || '0,0';
	uptime = fileds[2];
	wan2_conn_count = fileds[3] || '0';
	wan2_fail_time = fileds[4] || '0';

	initPoints();
}

function initPoints()
{
	var LAST_IDX = POINTS_NUM - 1, data, intv, i, j, e, tim, on, n, pre;

	data = wan_record.split('\n');

	intv = 3600 * 30 / (POINTS_NUM - 1);	// 3600 s/h * 30h / 360 time segments.
	for (i=data.length-1, n=360; i>=0; i--) {
		e = data[i];
		e = e.split(',');
		if (e.length != 2)
			continue;
		tim = e[0];
		on = e[1];
		pre = n;
		n = LAST_IDX - Math.ceil((uptime - tim) / intv);
		for (j=pre; j>n; j--)
			aryWan[j] = on;
	}

	intv = 7.5 * 24 * 3600 / (POINTS_NUM - 1);	// 7.5 days * 24 h/day * 3600 s/h / 360 time segments.
	for (i=data.length-1, n=360; i>=0; i--) {
		e = data[i];
		e = e.split(',');
		if (e.length != 2)
			continue;
		tim = e[0];
		on = e[1];
		pre = n;
		n = LAST_IDX - Math.ceil((uptime - tim) / intv);
		for (j=pre; j>n; j--)
			aryWanWeekly[j] = on;
	}

	data = wan2_record.split('\n');

	intv = 3600 * 30 / (POINTS_NUM - 1);
	for (i=data.length-1, n=360; i>=0; i--) {
		e = data[i];
		e = e.split(',');
		if (e.length != 2)
			continue;
		tim = e[0];
		on = e[1];
		pre = n;
		n = LAST_IDX - Math.ceil((uptime - tim) / intv);
		for (j=pre; j>n; j--)
			arybakWan[j] = on;
	}

	intv = 7.5 * 24 * 3600 / (POINTS_NUM - 1);
	for (i=data.length-1, n=360; i>=0; i--) {
		e = data[i];
		e = e.split(',');
		if (e.length != 2)
			continue;
		tim = e[0];
		on = e[1];
		pre = n;
		n = LAST_IDX - Math.ceil((uptime - tim) / intv);
		for (j=pre; j>n; j--)
			arybakWanWeekly[j] = on;
	}
}

function initTranslation()
{
	$('#gTitle').html(_("parent diagonostics")+" >> "+_("connection graph title"));
	$('#showchart').html(_("connection graph show chart"));
	$('#optWan').html(_("connection graph mode wan"));
	$('#optBakWan').html(_("connection graph mode backup wan"));
	$('#optDaily').html(_("connection graph time daily"));
	$('#optWeekly').html(_("connection graph time weekly"));
	$('#refTime').html(_("connection graph refresh time"));
	$('#arefresh').html(_("admin refresh"));
}

function initLabels(_time)
{
	var time = _time;
	aryLables = [];
	if (time == 0) {		//Daily
		for (i=30,j=0; i>=0; i--) {
			if (i%6 == 0) {
				tmp = (nowhh - j*6);
				if(tmp < 0)
					tmp = tmp + 24;
				aryLables[i] = tmp + ':' + nowmm;
				j++;
			} else
				aryLables[i] = "";
		}
	} else if (time == 1) {	//Weekly
		tmp = new Date();
		tmpdt = nowdt;
		for (i=15; i>=0; i--) {
			if (i == 15)
				aryLables[i] = nowhh + ':' + nowmm;
			else if (i%2 == 1) {
				tmp.setDate(tmpdt - 1);
				tmpmth = tmp.getMonth()+1;
				tmpdt = tmp.getDate();
				tmpday = tmp.getDay();
				aryLables[i] = tmpmth + '/' + tmpdt + aryDay[tmpday];
			} else
				aryLables[i] = "";
		}
	}
}

function showChart(_idx, _time)
{
	var idx = _idx;
	var time = _time;
	var c = new Chart(document.getElementById('chart'));
	c.setDefaultType(CHART_LINE);
	c.setGridDensity(aryLables.length, 3);
	c.setVerticalRange(0, 2);
	c.setHorizontalLabels(aryLables);
	var showColor, aryShow;
	if (idx == 0) {
		showColor = '#EECC66';
		if (time == 0)
			aryShow = aryWan;
		else if (time == 1)
			aryShow = aryWanWeekly;
		c.setShowLegend(false);
		c.add('', showColor, aryShow);
	} else if (idx == 1) {
		showColor = '#00CC00';
		if (time == 0)
			aryShow = arybakWan;
		else if (time == 1)
			aryShow = arybakWanWeekly;
		c.setShowLegend(true);
		var legend1 = "Connect " + wan2_conn_count + (wan2_conn_count > 1 ? " times" : " time");
		var legend2 = "Disconnect " + wan2_fail_time + "s";
		c.add(legend1, showColor, aryShow);
		c.add(legend2, '', []);
	}
	c.draw();
}

function onChgMode()
{
	var mode = $('[name=sltMode]').val();
	var time = $('[name=sltTime]').val();
	if(mode && time) {
		bg.iConnGraphMode = mode;
		bg.iConnGraphTime = time;
		initLabels(time);
		showChart(mode, time);
	}
}

function onChgTime()
{
	var refresh;
	var ref = $('[name=sltRefreshTime]').val();
	if (ref) {
		bg.iConnGraphRefTime = ref;
		clearTimeout(refresh);
		refresh = setTimeout(onRefresh, ref);
	}
}

function onRefresh()
{
	var mode = $('[name=sltMode]').val();
	var time = $('[name=sltTime]').val();
	if (mode && time) {
		bg.iConnGraphMode = mode;
		bg.iConnGraphTime = time;
	}
	document.location = "/adm/conngraph.asp";
}
</script>
</head>

<body>
<table class="body">
<tr><td>
<h1 id="gTitle">Connection Graph</h1>
<hr size="1" />
<br />

<div>
  <table width="100%" cellpadding="0" cellspacing="0" border="0" style="margin-bottom:2px">
    <tr>
      <td>
        <span id="showchart">Show Chart:</span>&nbsp;
        <select name="sltMode" size="1" onChange=onChgMode()>
          <option id="optWan" value="0">WAN1</option>
          <option id="optBakWan" value="1">WAN2</option>
        </select>&nbsp;
        <select name="sltTime" size="1" onChange=onChgMode()>
          <option id="optDaily" value="0">Daily</option>
          <option id="optWeekly" value="1">Weekly</option>
        </select>
      </td>
      <td align=right>
        <span id="refTime">Refresh Min(s):</span>&nbsp;
        <select name="sltRefreshTime" size="1" onChange=onChgTime()>
          <option value="300000">5</option>
          <option value="600000">10</option>
          <option value="1800000">30</option>
        </select>
      </td>
      <td class=red align=right>|&nbsp;<a href="javascript: onRefresh()" id="arefresh">Refresh</a>&nbsp;|</td>
    </tr>
  </table>

  <div id="chart" class="chart" style="width: 700px; height: 300px;"></div>
</div>

</td></tr>
</table>

</body>
</html>
<script type="text/javascript" src="/dtree/tool.js"></script>
<script type="text/javascript" src="/jquery.js"></script>
<script>
	var _fw_upgrade_notify	='<% getCfgGeneral(1, "fw_upgrade_notify", 1); %>';
	var _aryInfo = [<% getUpgradeInfo(); %>];// [0]:exit new fw  [1]:ver
	var _curt_ver = '<% getSdkVersion(); %>';
	var _lanIP = '<% getLanIp(); %>';
	fw_urpgrade_auto_detect(_fw_upgrade_notify,_aryInfo,_curt_ver,_lanIP);
</script>
