#include <net/if.h>
#include <netinet/ip_icmp.h>
#include "libbb.h"
#include <unistd.h>

#define DEFDATALEN 56
#define MAXIPLEN 60
#define MAXICMPLEN 76

int pingsock = -1;

void sendping4(len_and_sockaddr *lsa, int sock_idx)
{
	struct sockaddr_in pingaddr;
	struct icmp *pkt;
	char packet[DEFDATALEN + MAXIPLEN + MAXICMPLEN];

	pingaddr = lsa->u.sin;

	pkt = (struct icmp *) packet;
	memset(pkt, 0, sizeof(packet));
	pkt->icmp_type = ICMP_ECHO;
	pkt->icmp_cksum = in_cksum((unsigned short *) pkt, sizeof(packet));

	sendto(sock_idx, packet, DEFDATALEN + ICMP_MINLEN, 0,
				(struct sockaddr *) &pingaddr, sizeof(pingaddr));
}

void close_pingkeepalive(void)
{
	//fprintf(stderr, "close pingkeepalive socket\n");

	if (pingsock > 0)
		close(pingsock);

	pingsock = -1;
	exit(0);
}

int pingkeepalive_main(int argc, char **argv) MAIN_EXTERNALLY_VISIBLE;
int pingkeepalive_main(int argc, char **argv)
{
	int ping_period = 60;
	int host_ready = 0;
	int ch;
	char* ping_hostname;
	len_and_sockaddr *lsa;

    /*
     * Close file lock (200)
     *  We may use the file descriptor 200 as the lock file with "flock" in internet.sh,
     *  but this process will hold the lock in the endless loop and never release it.
     *  However, this process don't need such lock.  So we just close it.
     *  It's fine even if the fd is not opened.
     */
    close(200);

	while ((ch = getopt(argc, argv, "p:")) != -1) {
		switch (ch) {
			case 'p':
				ping_period = atoi(optarg);
				break;
			default:
				bb_show_usage();
				exit(0);
		}
	}

	argc -= optind;
	argv += optind;

	if (argc == 0) {
		bb_show_usage();
		exit(0);
	}

	ping_hostname = *argv;
	if (!ping_hostname)
		bb_show_usage();

	if (signal(SIGTERM, close_pingkeepalive) == SIG_ERR) {
		fprintf("pingkeepalive: failed to set signal: %s", strerror(errno));
		exit(0);
	}

   	for (;;) {
        if (!host_ready) {
			lsa = host_and_af2sockaddr(ping_hostname, 0, AF_INET);
			if (!lsa)
				goto fail;

			pingsock = create_icmp_socket();
			if (pingsock < 0)
				goto fail;

			host_ready = 1;
        }

        if (pingsock > 0)
			sendping4(lsa, pingsock);

		fail:
			sleep(ping_period);

    }

	return 0;
}
