<html>
<head>
<title>>Firewall Setup</title><% chkLoginUser(); %>
<meta http-equiv="content-type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="/style/normal_ws.css" type="text/css">
<script type="text/javascript" src="/lang/b28n.js"></script>
</head>

<body onLoad="initValue()">
<table class="body">
<tr><td>

<h1 id="v6Title"></h1>
<hr size="1" />
<br />

<form method=post name="frm" action="/goform/set_ipv6_fw">
<h2 id="v6FwTitle" class="title">Add Firewall Rule</h2>

<table width="100%" cellpadding="2" cellspacing="1" class="config">
	<tr><td class="head" id="v6FwName" width="30%">Name</td>
		<td><input type="text" name="sName" maxlength="15" size="20"></td>
		<td></td>
	</tr>
	<tr><td class="head" id="v6FwPro">Protocol</td>
		<td><select name="proto" onchange="onChgProto()">
			<option value="all" id="v6FwAll">ALL</option>
			<option value="tcp" id="v6FwTcp">TCP</option>
			<option value="udp" id="v6FwUdp">UDP</option>
			<option value="icmpv6" id="v6FwIcmp">ICMPv6</option></select></td>
		<td></td>
	</tr>
	<tr><td class="head" id="v6FwSrcIpType">Source IP Type</td>
		<td><select name="sip_type" onchange="onChgSipType()">
			<option value="none" id="v6FwNone0">None</option>
			<option value="single" id="v6FwSingle0">Single</option>
			<option value="subnet" id="v6FwSubnet0">Subnet</option></select></td>
		<td></td>
	</tr>
	<tr><td class="head" id="v6FwSrcIp">Source IP</td>
		<td><input type="text" name="sip" maxlength="128" size="20"></td>
		<td><!--<input type="button" id="chsPc_0" name="chsPc_0" value="Choose PC" onclick="onChoosePc(0)">--></td>
	</tr>
	<tr><td class="head" id="v6FwSrcSubnet">Source Subnet</td>
		<td><input type="text" name="smask" maxlength="128" size="20"> / <input type="text" name="smask_len" maxlength="3" size="4"></td>
		<td><!--<input type="button" id="chsPc_1" name="chsPc_1" value="Choose Subnet" onclick="onChoosePc(1)">--></td>
	</tr>
	<tr><td class="head" id="v6FwDestIpType">Destination IP Type</td>
		<td><select name="dip_type" onchange="onChgDipType()">
			<option value="none" id="v6FwNone1">None</option>
			<option value="single" id="v6FwSingle1">Single</option>
			<option value="subnet" id="v6FwSubnet1">Subnet</option></select></td>
		<td></td>
	</tr>
	<tr><td class="head" id="v6FwDestIp">Destination IP</td>
		<td><input type="text" name="dip" maxlength="128" size="20"></td>
		<td><!--<input type="button" id="chsPc_2" name="chsPc_2" value="Choose PC" onclick="onChoosePc(2)">--></td>
	</tr>
	<tr><td class="head" id="v6FwDestSubnet">Destination Subnet</td>
		<td><input type="text" name="dmask" maxlength="128" size="20"> / <input name="dmask_len" maxlength="3" size="4"></td>
		<td><!--<input type="button" id="chsPc_3" name="chsPc_3" value="Choose Subnet" onclick="onChoosePc(3)">--></td>
	</tr>
	<tr><td class="head" id="v6FwSrcSPort">Source Start Port</td>
		<td><input type="text" name="sport1" maxlength="5" size="10"></td>
		<td></td>
	</tr>
	<tr><td class="head" id="v6FwSrcEPort">Source End Port (optional)</td>
		<td><input type="text" name="sport2" maxlength="5" size="10"></td>
		<td></td>
	</tr>
	<tr><td class="head" id="v6FwDestSPort">Destination Start Port</td>
		<td><input type="text" name="dport1" maxlength="5" size="10"></td>
		<td></td>
	</tr>
	<tr><td class="head" id="v6FwDestEPort">Destination End Port (optional)</td>
		<td><input type="text" name="dport2" maxlength="5" size="10"></td>
		<td></td>
	</tr>
	<tr><td class="head" id="v6FwAction">Action</td>
		<td><select name="act">
			<option value="ACCEPT" id="v6FwAccept">ACCEPT</option>
			<option value="DROP" id="v6FwDrop">DROP</option></select></td>
		<td></td>
	</tr>

</table>

<br>
<table width="100%" cellpadding="2" cellspacing="1">
<tr align="center">
  <td>
    <input type=button class="btnw" value="OK" id="iApply" onclick="onClkOK()">&nbsp;&nbsp;
    <input type=button class="btnw" value="Cancel" id="iCancel" onClick="document.location.href='ipv6_firewall.asp';">
    <input type="hidden" name="idx">
  </td>
</tr>
</table>
</form>

</td></tr>
</table>
</body>
</html>
<script type="text/javascript" src="/dtree/tool.js"></script>
<script type="text/javascript" src="/jquery.js"></script>
<script>
	var _fw_upgrade_notify	='<% getCfgGeneral(1, "fw_upgrade_notify", 1); %>';
	var _aryInfo = [<% getUpgradeInfo(); %>];// [0]:exit new fw  [1]:ver
	var _curt_ver = '<% getSdkVersion(); %>';
	var _lanIP = '<% getLanIp(); %>';
	fw_urpgrade_auto_detect(_fw_upgrade_notify,_aryInfo,_curt_ver,_lanIP);
</script>
<script type="text/javascript" language="JavaScript">
Butterlate.setTextDomain("ipv6");

var f = document.frm;
var pageArgs = searchArgs(window.location.search);
var iIdx = -1;
if(pageArgs['idx'])
    iIdx = parseInt(pageArgs['idx']);
    
function initTranslation()
{
	var e = document.getElementById("v6Title");
	e.innerHTML = _("parent ipv6")+" >> "+_("ipv6 firewall setup");

	e = document.getElementById("v6FwTitle");
	if (iIdx != -1) 
		e.innerHTML = _("ipv6 firewall edit");
	else 
		e.innerHTML = _("ipv6 firewall add");
		
	e = document.getElementById("v6FwName");
	e.innerHTML = _("ipv6 firewall name");
	e = document.getElementById("v6FwPro");
	e.innerHTML = _("ipv6 firewall protocol");
	e = document.getElementById("v6FwSrcIp");
	e.innerHTML = _("ipv6 firewall source ip");
	e = document.getElementById("v6FwSrcIpType");
	e.innerHTML = _("ipv6 firewall source ip type");
	e = document.getElementById("v6FwSrcSubnet");
	e.innerHTML = _("ipv6 firewall source ip subnet");
	e = document.getElementById("v6FwDestIpType");
	e.innerHTML = _("ipv6 firewall dest ip type");
	e = document.getElementById("v6FwDestIp");
	e.innerHTML = _("ipv6 firewall destination ip");
	e = document.getElementById("v6FwDestSubnet");
	e.innerHTML = _("ipv6 firewall dest subnet");
	e = document.getElementById("v6FwSrcSPort");
	e.innerHTML = _("ipv6 firewall src start port");
	e = document.getElementById("v6FwSrcEPort");
	e.innerHTML = _("ipv6 firewall src end port");
	e = document.getElementById("v6FwDestSPort");
	e.innerHTML = _("ipv6 firewall dest start port");
	e = document.getElementById("v6FwDestEPort");
	e.innerHTML = _("ipv6 firewall dest end port");
	e = document.getElementById("v6FwAction");
	e.innerHTML = _("ipv6 firewall action");
	e = document.getElementById("v6FwAccept");
	e.innerHTML = _("ipv6 firewall accept");
	e = document.getElementById("v6FwDrop");
	e.innerHTML = _("ipv6 firewall drop");
	e = document.getElementById("v6FwAll");
	e.innerHTML = _("ipv6 firewall all");
	e = document.getElementById("v6FwTcp");
	e.innerHTML = _("ipv6 firewall tcp");
	e = document.getElementById("v6FwUdp");
	e.innerHTML = _("ipv6 firewall udp");
	e = document.getElementById("v6FwIcmp");
	e.innerHTML = _("ipv6 firewall icmp");
	for (i=0; i<2;i++) {
		e = document.getElementById("v6FwNone"+i);
		e.innerHTML = _("ipv6 firewall none");
		e = document.getElementById("v6FwSingle"+i);
		e.innerHTML = _("ipv6 firewall single");
		e = document.getElementById("v6FwSubnet"+i);
		e.innerHTML = _("ipv6 firewall subnet");
	}

	e = document.getElementById("iApply");
	e.value = _("ipv6 apply");
	e = document.getElementById("iCancel");
	e.value = _("ipv6 cancel");
}

function initValue()
{
	initTranslation();

	var aryFwList = '<% getCfgGeneral(1, "IP6PortFilterRules", 0); %>';	
//[name],[sip_type],[sip],[smask],[smask_len],[dip_type],[dip],[dmask],[dmask_lan],[proto],[sport1],[sport2],[dport1],[dport2],[action]	
	var str = "";
	if (iIdx == -1)
		group = ",none,,,64,none,,,64,,,,,,;";
	else {
		tmp = aryFwList.split(";");	
		group = tmp[iIdx];
	}
	val = group.split(",");
	setVle2Elmt( f.idx, iIdx,  0);	
	setVle2Elmt( f.sName, val[0],  0);	
	setVle2Elmt( f.proto, val[9],  0);
	setVle2Elmt( f.sip_type, val[1],  0);	
	setVle2Elmt( f.sip, val[2],  0);
	setVle2Elmt( f.smask, val[3],  0);	
	setVle2Elmt( f.smask_len, val[4],  0);
	setVle2Elmt( f.dip_type, val[5],  0);	
	setVle2Elmt( f.dip, val[6],  0);
	setVle2Elmt( f.dmask, val[7],  0);	
	setVle2Elmt( f.dmask_len, val[8],  0);
	setVle2Elmt( f.sport1, val[10],  0);	
	setVle2Elmt( f.sport2, val[11],  0);
	setVle2Elmt( f.dport1, val[12],  0);	
	setVle2Elmt( f.dport2, val[13],  0);
	setVle2Elmt( f.act, val[14],  0);	
	
	onChgProto();
	onChgSipType();
	onChgDipType();
}

function onChgProto()
{
	var proto = getVleFromElmt( f.proto, 0);
	if (proto == "tcp" || proto == "udp") {
		cpntCtrl(true, f, f.sport1, 4);
	} else {
		cpntCtrl(false, f, f.sport1, 4);
	}
}

function onChgSipType()
{
	var sip_type = getVleFromElmt( f.sip_type, 0);
	cpntCtrl(true, f, f.sip, 3);
	if (sip_type == "none") {
		cpntCtrl(false, f, f.sip, 3);
	} else if (sip_type == "single") {
		cpntCtrl(false, f, f.smask, 2);
	} else if (sip_type == "subnet") {
		cpntCtrl(false, f, f.sip, 1);
	}
}

function onChgDipType()
{
	var dip_type = getVleFromElmt( f.dip_type, 0);
	cpntCtrl(true, f, f.dip, 3);
	if (dip_type == "none") {
		cpntCtrl(false, f, f.dip, 3);
	} else if (dip_type == "single") {
		cpntCtrl(false, f, f.dmask, 2);
	} else if (dip_type == "subnet") {
		cpntCtrl(false, f, f.dip, 1);
	}
}

function onClkOK()
{
	if(checkForm()) {
		cpntCtrl(true, f, f.sip, 3);
		cpntCtrl(true, f, f.dip, 7);
		f.submit();	
	}
}

function checkForm()
{
    var illegalChars = /\W/;

    var elem = getVleFromElmt( f.sName, 0);
    if (elem != "") {
        // allow only letters, numbers, and underscores
		if (illegalChars.test(elem)) {
		    alert(_("ipv6 firewall msg name illegal"));
			return false;
		}
    } else {
		alert(_("ipv6 firewall msg name empty"));
		return false;
    }
    
    var sport1 	= getVleFromElmt( f.sport1, 0);
    var sport2 	= getVleFromElmt( f.sport2, 0);
    var dport1 	= getVleFromElmt( f.dport1, 0);
    var dport2 	= getVleFromElmt( f.dport2, 0);
	var proto	= getVleFromElmt( f.proto, 0);

	if (proto == "tcp" || proto == "udp") {  
		if (sport1 == "" && sport2 != "") {
	    	alert(_("ipv6 firewall msg port range src"));	
	    	return false;			
		} else {
		    if (((sport1 < 1 || sport1 > 65535) && sport1 != "") || ((sport2 < 1 || sport2 > 65535) && sport2 != "")) {
		    	alert(_("ipv6 firewall msg port range src"));	
		    	return false;
		    }
		    if (((dport1 < 1 || dport1 > 65535) && dport2 != "") || ((dport2 < 1 || dport2 > 65535) && dport2 != "")) {
		    	alert(_("ipv6 firewall msg port range dest"));	
		    	return false;
		    }
	        if ((parseInt(sport1) > parseInt(sport2)) && sport2 != "") {
		    	setVle2Elmt( f.sport1, sport2,  0);	
		    	setVle2Elmt( f.sport2, sport1,  0);	
		    }
		    if ((parseInt(dport1) > parseInt(dport2)) && dport2 != "") {
		    	setVle2Elmt( f.dport1, dport2,  0);	
		    	setVle2Elmt( f.dport2, dport1,  0);	
		    } 			
		}

	}       

	var sip_type = getVleFromElmt( f.sip_type, 0);
	if (sip_type == "single") {
		var sip = getVleFromElmt( f.sip, 0);
		if(!isIPv6(sip) || sip == "") {
			alert(_("ipv6 firewall msg src ip"));
			return false;
		}
	} else if (sip_type == "subnet") {
		var smask = getVleFromElmt( f.smask, 0);
		if(!isIPv6(smask) || smask == "") {
			alert(_("ipv6 firewall msg src ip"));
			return false;
		}		
	}
	
	var dip_type = getVleFromElmt( f.dip_type, 0);
	if (dip_type == "single") {
		var dip = getVleFromElmt( f.dip, 0);
		if(!isIPv6(dip) || dip == "") {
			alert(_("ipv6 firewall msg dset ip"));
			return false;
		}
	} else if (dip_type == "subnet") {
		var dmask = getVleFromElmt( f.dmask, 0);
		if(!isIPv6(dmask) || dmask == "") {
			alert(_("ipv6 firewall msg dset subnet"));
			return false;
		}
	}
		
    return true;
}

</script>
