#ifndef __IP_SET_PROTOCOL_H
#define __IP_SET_PROTOCOL_H

#include <linux/netfilter_ipv4/ip_set.h>
#include <linux/netfilter_ipv4/ip_set_bitmaps.h>

#define SETTYPE_NAME		"protocol"

#define PROTOCOL_DNS 0
#define PROTOCOL_FTP 1
#define PROTOCOL_HTTP 2
#define PROTOCOL_IMAP 3
#define PROTOCOL_IRC 4
#define PROTOCOL_NNTP 5
#define PROTOCOL_POP3 6
#define PROTOCOL_SMB 7
#define PROTOCOL_SMTP 8
#define PROTOCOL_SNMP 9
#define PROTOCOL_SSH 10
#define PROTOCOL_SSL_TLS 11
#define PROTOCOL_TELNET 12
#define PROTOCOL_MSSQL 13
#define PROTOCOL_MYSQL 14
#define PROTOCOL_ORACLE 15
#define PROTOCOL_POSTGRESQL 16
#define PROTOCOL_SYBASE 17
#define PROTOCOL_DB2 18
#define PROTOCOL_INFORMIX 19
#define PROTOCOL_MAX 20

#define PROTOCOL_FROM 0
#define PROTOCOL_TO PROTOCOL_MAX-1
#define PROTOCOL_NUM PROTOCOL_MAX

struct ip_set_protocol {
	void *members;			/* the protocol proper */
	ip_set_ip_t first_ip;		/* host byte order, included in range */
	ip_set_ip_t last_ip;		/* host byte order, included in range */
	u_int32_t size;			/* size of the __IP_SET_PROTOCOL_H proper */
};

struct ip_set_req_protocol_create {
	ip_set_ip_t from;
	ip_set_ip_t to;
};

struct ip_set_req_protocol {
	ip_set_ip_t ip;
};

#endif /* __IP_SET_PROTOCOL_H */
