#!/bin/sh

# Copyright (C) 2009 Draytek

#step1 sleep for awhile
    sleep 5

#step2 set wan2_up
	echo "0" > /var/network/wan2_up

#step3 set wan2_up_time and wan2_util_up_time =0     #for wan2 up time detect
	echo "0" > /var/network/wan2_up_time
	echo "0" > /var/network/wan2_until_up_time
	
#for WAN Status check
OLD_WAN_STATUS=0
	
#step4 loop check wan2 state
 while [ 1 ]
 do
	
	PROTO=$(nvram_get 2860 wan2ConnectionMode)
	
	case $PROTO in
		"None")
			echo "0" > /var/network/wan2_up
			;;
		"DHCP")
			#echo "DHCP wan mode"
			#check phy link and eth2.2 wan ip address
			#  Link-down status is immediately. But Link-up status is needs waiting the switch to 
			#  read the port 3 times and its defined by 802.3 spec.
			TST=$(mii_mgr -g -p 1 -r 1)
			TST=$(mii_mgr -g -p 1 -r 1)
			TST=$(mii_mgr -g -p 1 -r 1 | awk '{print $4}')
			W_LINK=$(/bin/dray_util wan_det $TST)
			if [ "$W_LINK" == 0 ]; then
				#echo "wan2 link down"
				echo "0" > /var/network/wan2_up
				WADDR_INFO=$(ifconfig eth2.2 | grep "inet addr")
				if [ "$WADDR_INFO" != "" ]; then
					#clean DHCP ip
					ifconfig eth2.2 0.0.0.0
				fi
			else
				WADDR_INFO=$(ifconfig eth2.2 | grep "inet addr")
				if [ "$WADDR_INFO" != "" ]; then
					#echo "DHCP get ip, wan2 is up"
					echo "1" > /var/network/wan2_up
					NEW_WAN_STATUS=1
					if [ "$OLD_WAN_STATUS" != "$NEW_WAN_STATUS" ]; then
				        OLD_WAN_STATUS=$NEW_WAN_STATUS					    
					    /bin/dray_util chk_wan_status $OLD_WAN_STATUS
					fi
				else
					#echo "DHCP can't get ip, wan2 is down"
					echo "0" > /var/network/wan2_up
					NEW_WAN_STATUS=2
					if [ "$OLD_WAN_STATUS" != "$NEW_WAN_STATUS" ]; then
					    OLD_WAN_STATUS=$NEW_WAN_STATUS 
					    /bin/dray_util chk_wan_status $OLD_WAN_STATUS
					fi
				fi
			fi
			;;
		"STATIC")
			#echo "Static wan mode"
			#check phy link and arp state
			#  Link-down status is immediately. But Link-up status is needs waiting the switch to 
			#  read the port 3 times and its defined by 802.3 spec.
			TST=$(mii_mgr -g -p 1 -r 1)
			TST=$(mii_mgr -g -p 1 -r 1)
			TST=$(mii_mgr -g -p 1 -r 1 | awk '{print $4}')
			W_LINK=$(/bin/dray_util wan_det $TST)
			if [ "$W_LINK" == 0 ]; then
				#echo "wan2 link down"
				echo "0" > /var/network/wan2_up
			else
				# G24667, check ip
				WADDR_INFO=$(ifconfig eth2.2 | grep "inet addr")
				if [ "$WADDR_INFO" != "" ]; then
					#echo "wan2 link up"
					echo "1" > /var/network/wan2_up
				else
					#echo "wan2 link down"
					echo "0" > /var/network/wan2_up
				fi
			fi
			;;
		"Wimax")
			W_INFO=$(ifconfig | grep "wimax0")
			if [ "$W_INFO" != "" ]; then
				W_INFO=$(ifconfig wimax0 | grep "inet addr")
				if [ "$W_INFO" != "" ]; then
					echo "1" > /var/network/wan2_up
					temp=$(route -n | grep ^0.0.0.0 | grep "eth2.2")
					if [ "$temp" != "" ]; then
						route del default dev eth2.2
					fi
				else
					echo "0" > /var/network/wan2_up
				fi
			else
				echo "0" > /var/network/wan2_up
			fi
			;;
		"3G")	
			W_INFO=$(ifconfig | grep "ppp1")
			if [ "$W_INFO" != "" ]; then
				#echo "ppp1 interface exist, 3gwan is up"
				echo "1" > /var/network/wan2_up
			else
				#echo "ppp1 interface is not exist, 3gwan is down"
				echo "0" > /var/network/wan2_up
			fi
			;;
		*)
			#echo "PPPoE / PPTP / L2TP wan2 mode"
			#check phy link and ppp0 interface
			#  Link-down status is immediately. But Link-up status is needs waiting the switch to 
			#  read the port 3 times and its defined by 802.3 spec.
			TST=$(mii_mgr -g -p 1 -r 1)
			TST=$(mii_mgr -g -p 1 -r 1)
			TST=$(mii_mgr -g -p 1 -r 1 | awk '{print $4}')
			W_LINK=`/bin/dray_util wan_det $TST`
			if [ "$W_LINK" == 0 ]; then
				#echo "wan2 link down"
				echo "0" > /var/network/wan2_up
			else
				#echo "wan2 link up"
				W_INFO=$(ifconfig | grep "ppp1")
				if [ "$W_INFO" != "" ]; then
					#echo "ppp1 interface exist"
					W_IP=$(ifconfig ppp1 | grep "10.64.64.65")	
					# G25034, nancy
					W_IP_DEBUG=$(ifconfig ppp1 | grep "10.64.64.64")
					if [ "$W_IP" != "" -o "$W_IP_DEBUG" != "" ]; then
						#echo "ppp1 don't get real ip, wan2 is down"
						echo "0" > /var/network/wan2_up
				    else
						#echo "ppp1 get real ip, wan2 is up"
						echo "1" > /var/network/wan2_up
					fi
				else
					#echo "ppp1 interface is not exist, wan2 is down"
					echo "0" > /var/network/wan2_up
				fi
			fi
			;;
	esac

	#wan2 up time detect
	WAN2_ST=$(cat /var/network/wan2_up)
	if [ $WAN2_ST = "1" ]; then
		#wan2 is up, update wan2 up time
		NEW_TIME=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
		OLD_TIME=$(cat /var/network/wan2_until_up_time)
		WAN2_UP_TIME=$(expr $NEW_TIME - $OLD_TIME)
		echo "$WAN2_UP_TIME" > /var/network/wan2_up_time
	else
		#wan2 is down, update wan2 until up time
		NEW_TIME=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
		echo "$NEW_TIME" > /var/network/wan2_until_up_time
		echo "0" > /var/network/wan2_up_time
	fi
	#echo "$(cat /var/network/wan2_up_time)"
	#sleep 2 sec and wait
	sleep 2
 done
