#!/bin/sh

# udhcpc script edited by Tim Riker <Tim@Rikers.org>

[ -z "$1" ] && echo "Error: should be called from udhcpc" && exit 1

RESOLV_CONF="/etc/resolv.conf"
[ -n "$broadcast" ] && BROADCAST="broadcast $broadcast"
[ -n "$subnet" ] && NETMASK="netmask $subnet"

case "$1" in
    deconfig)
        /sbin/ifconfig $interface 0.0.0.0
        ;;

    iponly)
    	 # for L2TP/PPTP wan, set ip only before it recovers, nancy
        /sbin/ifconfig $interface $ip $BROADCAST $NETMASK
        logger "udhcpc.sh (iponly) set ip $ip"

        #process dhcp option 121 (classless static route option)
		if [ -n "$staticroutes" ] ; then
		    DEST=""
			LOOP=0
			for i in $staticroutes ; do
			    if [ $LOOP == "0" ] ; then
					DEST=$i
					LOOP=1
				elif [ $LOOP == "1" ] ; then
				    echo "adding route" $DEST "gw" $i
					route add -net $DEST gw $i dev $interface
					LOOP=0
				fi
			done
		fi
		
		#process dhcp option 33 (static route option)
		if [ -n "$routes" ] ; then
			DEST=""
			LOOP=0
			for i in $routes ; do
				if [ $LOOP == "0" ] ; then
					DEST=$i
					LOOP=1
				elif [ $LOOP == "1" ] ; then
					echo "adding route" $DEST "gw" $i
					route add -host $DEST gw $i dev $interface
					LOOP=0
				fi
            done
		fi

        ;;

    renew|bound)
		#MGMT WAN, set ip, dns, policy route
		if [ "$interface" = "eth2.7" ]; then
			#set MGMT WAN IP
			/sbin/ifconfig $interface $ip $BROADCAST $NETMASK
			#set MGMT WAN policy route, i use table 24 as iptv wan routing table
			ip route del default table 24
			if [ -n "$router" ] ; then
				for i in $router ; do
					ip route add default via "$i" dev "$interface" table 24
					logger "adding default route $i"
				done
			fi
			ip rule add from "$ip"/"$subnet" table 24
			#set MGMT dns
			echo -n > /etc/mgmt_resolv.conf
			for i in $dns ; do
				echo adding dns $i
				logger "adding dns $i"
				echo nameserver $i >> /etc/mgmt_resolv.conf
			done
			#set MGMT static route
			/sbin/static_route_multi_wan.sh MGMT_WAN
			exit 0
		fi
		#for PPPoE dual access
		WAN_MODE=`nvram_get 2860 wanConnectionMode`
		if [ "$WAN_MODE" = "PPPOE" ]; then
			echo "WAN mode PPPOE!!!, only set IP!!!"
			/sbin/ifconfig $interface $ip $BROADCAST $NETMASK
			iptables -t nat -D POSTROUTING -s $ip/$subnet -o $interface -j MASQUERADE > /dev/null 2>&1
			iptables -t nat -A POSTROUTING -s $ip/$subnet -o $interface -j MASQUERADE
			echo 	"udhcpc.sh set MASQUERADE $ip/$subnet out if $interface"
			
			#clean icmp conntrack cache  by bruce hsu
			echo 0 > /proc/sys/net/netfilter/nf_conntrack_icmp_timeout
			sleep 5
			echo 30 > /proc/sys/net/netfilter/nf_conntrack_icmp_timeout
				
			# restart igmpproxy daemon
			igmp=`nvram_get 2860 igmpEnabled`
			if [ "$igmp" = "1" ]; then
				config-igmpproxy.sh $interface
			fi
			exit 0
		fi
	
        /sbin/ifconfig $interface $ip $BROADCAST $NETMASK
        logger "udhcpc.sh set ip $ip"

        if [ -n "$router" ] ; then
            echo "deleting routers"
            while route del default gw 0.0.0.0 dev $interface ; do
                :
            done

            metric=0
            for i in $router ; do
				metric=`expr $metric + 1`
				route add default gw $i dev $interface metric $metric

				if [ "$interface" = "wimax0" ]; then
					temp=`route -n | grep ^0.0.0.0 | grep $interface`
					if [ "$temp" = "" ]; then
						route add default dev $interface
						route add default gw $i dev $interface metric $metric
						route del -net 0.0.0.0 netmask 0.0.0.0 dev $interface
					fi
				fi
				logger "adding default route $i"
            done
        fi

        echo -n > $RESOLV_CONF
        [ -n "$domain" ] && echo search $domain >> $RESOLV_CONF
        for i in $dns ; do
            echo adding dns $i
            logger "adding dns $i"
            echo nameserver $i >> $RESOLV_CONF
        done
		
		#clean icmp conntrack cache  by bruce hsu
		echo 0 > /proc/sys/net/netfilter/nf_conntrack_icmp_timeout
		sleep 5
		echo 30 > /proc/sys/net/netfilter/nf_conntrack_icmp_timeout
		
		#process dhcp option 121 (classless static route option)
		if [ -n "$staticroutes" ] ; then
		    DEST=""
			LOOP=0
			for i in $staticroutes ; do
			    if [ $LOOP == "0" ] ; then
					DEST=$i
					LOOP=1
				elif [ $LOOP == "1" ] ; then
				    echo "adding route" $DEST "gw" $i
					route add -net $DEST gw $i dev $interface
					LOOP=0
				fi
			done
		fi
		
		#process dhcp option 33 (static route option)
		if [ -n "$routes" ] ; then
			DEST=""
			LOOP=0
			for i in $routes ; do
				if [ $LOOP == "0" ] ; then
					DEST=$i
					LOOP=1
				elif [ $LOOP == "1" ] ; then
					echo "adding route" $DEST "gw" $i
					route add -host $DEST gw $i dev $interface
					LOOP=0
				fi
            done
		fi
		
		#Add ping detect route
		PING_MODE=`nvram_get 2860 wanDetectMode`	
		if [ "$PING_MODE" == 2 ]; then
			PING_IP=`nvram_get 2860 wanDetectPing`
			route add $PING_IP gw $i dev $interface
			#echo "route add" $PING_IP "gw" $i "dev" $interface			
		fi
		
		
		# notify goahead when the WAN IP has been acquired. --yy
		killall -SIGUSR2 goahead

		# restart igmpproxy daemon
		igmp=`nvram_get 2860 igmpEnabled`
		if [ "$igmp" = "1" ]; then
			config-igmpproxy.sh
		fi
        ;;
esac

exit 0

