#!/bin/sh
#
# $Id: nat.sh,v 1.2 2009-02-09 13:29:22 michael Exp $
#
# usage: nat.sh
#

nat_en=`nvram_get 2860 natEnabled`

# dynamic rules
if [ "$1" = "dynamic" ]; then
	if [ "$nat_en" != "1" ]; then
		exit 0
	fi

	# get interface
	wan_ifname=`route -n | grep ^0.0.0.0 | awk '{print $8}'`
	if [ "$wan_ifname" = "" ]; then
		exit 0
	fi

	# get wan ip
	wan_ip=`ifconfig $wan_ifname | grep "inet addr" | awk '{print $2}' | awk '{FS=":"} {print $2}'`
	if [ "$wan_ip" = "" ]; then
		exit 0
	fi

	# port_forward_dynamic
	iptables -t nat -F port_forward_dynamic > /dev/null 2>&1
	if [ -f /var/network/port_forward_dynamic ]; then
		cat /var/network/port_forward_dynamic | sed 's/wan_ip/'$wan_ip'/g' | while read line
		do
			iptables -t nat -A port_forward_dynamic -j DNAT $line > /dev/null 2>&1
		done
	fi

	# DMZ_dynamic
	iptables -t nat -F DMZ_dynamic > /dev/null 2>&1
	if [ -f /var/network/dmz_dynamic ]; then
		cat /var/network/dmz_dynamic | sed 's/wan_ip/'$wan_ip'/g' | while read line
		do
			iptables -t nat -A DMZ_dynamic -j DNAT $line > /dev/null 2>&1
		done
	fi

	exit 0
fi


. /sbin/global.sh

lan_ip=`nvram_get 2860 lan_ipaddr`
lan_mask=`nvram_get 2860 lan_netmask`

wanbkmode=`nvram_get 2860 wan2ConnectionMode`
wan3g=`nvram_get 2860 3gwan_backup`

echo 1 > /proc/sys/net/ipv4/ip_forward

if [ "$nat_en" = "1" ]; then
	echo 3600 > /proc/sys/net/ipv4/netfilter/ip_conntrack_udp_timeout
	echo 3600 > /proc/sys/net/ipv4/netfilter/ip_conntrack_tcp_timeout_established

	# wan
	# Let L2TP/PPTP be able to add static route through eth2.2, nancy
	if [ "$wanmode" = "L2TP" -o "$wanmode" = "PPTP" ]; then
		iptables -t nat -A POSTROUTING -s $lan_ip/$lan_mask -o $wan_if -j MASQUERADE
	fi

	if [ "$wanmode" = "PPPOE" -o "$wanmode" = "L2TP" -o "$wanmode" = "PPTP" -o "$wanmode" = "3G" ]; then
		wan_ifname="ppp0"
	elif [ "$wanmode" = "Wimax" ]; then
		wan_ifname="wimax0"
	elif [ "$wanmode" = "YotaKey" ]; then
        wan_ifname="eth0"
	else
		wan_ifname="$wan_if"
	fi
	iptables -t nat -A POSTROUTING -s $lan_ip/$lan_mask -o $wan_ifname -j MASQUERADE

	# backup wan
	if [ "$wanbkmode" != "" -a "$wanbkmode" != "None" ]; then	# yota backup
		# Let L2TP/PPTP be able to add static route through eth2.2, nancy
		if [ "$wanbkmode" = "L2TP" -o "$wanbkmode" = "PPTP" ]; then
			iptables -t nat -A POSTROUTING -s $lan_ip/$lan_mask -o $wan_if -j MASQUERADE
		fi
		
		if [ "$wanbkmode" = "PPPOE" -o "$wanbkmode" = "L2TP" -o "$wanbkmode" = "PPTP" -o "$wanbkmode" = "3G" ]; then
			wanbk_ifname="ppp1"
		elif [ "$wanbkmode" = "Wimax" ]; then
			wanbk_ifname="wimax0"
		else
			wanbk_ifname="$wan_if"
		fi
	elif [ "$wan3g" = "1" ]; then	#3G backup
		wanbk_ifname="ppp1"
	else
		exit 0
	fi
	iptables -t nat -A POSTROUTING -s $lan_ip/$lan_mask -o $wanbk_ifname -j MASQUERADE
fi

