#!/bin/sh
#
# $Id: lan.sh,v 1.24.2.1 2009-04-21 12:49:37 michael Exp $
#
# usage: wan.sh
#

. /sbin/global.sh

# stop all
killall -q udhcpd
killall -q lld2d
killall -q radvd
killall -q dnsmasq
rm -rf /var/run/lld2d-*
echo "" > /var/udhcpd.leases

# ip address
ip=`nvram_get 2860 lan_ipaddr`
nm=`nvram_get 2860 lan_netmask`
ifconfig $lan_if down
ifconfig $lan_if $ip netmask $nm
opmode=`nvram_get 2860 OperationMode`
if [ "$opmode" = "0" ]; then
	gw=`nvram_get 2860 wan_gateway`
	pd=`nvram_get 2860 wan_primary_dns`
	sd=`nvram_get 2860 wan_secondary_dns`
	route del default
	route add default gw $gw
	config-dns.sh $pd $sd
fi

ifconfig "$lan_if:9" down > /dev/null 2>&1
ifconfig "eth2:9" down > /dev/null 2>&1
lan2enabled=`nvram_get 2860 Lan2Enabled`
if [ "$lan2enabled" = "1" ]; then
	ip_2=`nvram_get 2860 lan2_ipaddr`
	nm_2=`nvram_get 2860 lan2_netmask`
	if [ "$opmode" = "0" ]; then
		ifconfig "$lan_if:9" "$ip_2" netmask "$nm_2"
		echo "ifconfig "$lan_if:9" "$ip_2" netmask "$nm_2""
	elif [ "$opmode" = "1" ]; then
		ifconfig "$lan_if:9" "$ip_2" netmask "$nm_2"
		echo "ifconfig "$lan_if:9" "$ip_2" netmask "$nm_2""
	elif [ "$opmode" = "2" ]; then
		ifconfig "eth2:9" "$ip_2" netmask "$nm_2"
		echo "ifconfig "eth2:9" "$ip_2" netmask "$nm_2""
	elif [ "$opmode" = "3" ]; then
		ifconfig "$lan_if:9" "$ip_2" netmask "$nm_2"
		echo "ifconfig "$lan_if:9" "$ip_2" netmask "$nm_2""
	fi
fi

#Add "static arp" for "ip routing function, default disabled"     Bruce 2011/12/05
if [ -f /sbin/ip_routing.sh ]; then
	/sbin/ip_routing.sh add
fi
	
# hostname
host=`nvram_get 2860 HostName`
if [ "$host" = "" ]; then
	host="draytek"
	#nvram_set 2860 HostName ralink
fi
#hostname $host
echo "127.0.0.1 localhost.localdomain localhost" > /etc/hosts
echo "$ip $host.draytek.com $host" >> /etc/hosts

# Setup router name. We used to set this value at wan.sh : DHCP mode but this would result in
# other WAN mode router name as : NULL.
echo $host > /proc/sys/kernel/hostname

# Start lpd ---- lpd needs to be started after hostname setup ok.
killall lpd > /dev/null 2>&1
lpd &

# dhcp server
dhcp=`nvram_get 2860 dhcpEnabled`
if [ "$dhcp" = "1" ]; then
	start=`nvram_get 2860 dhcpStart`
	end=`nvram_get 2860 dhcpEnd`
	mask=`nvram_get 2860 dhcpMask`
	dnsManual=`nvram_get 2860 forceDnsManual`
	pd=`nvram_get 2860 dhcpPriDns`
	sd=`nvram_get 2860 dhcpSecDns`
	gw=`nvram_get 2860 dhcpGateway`
	lease=`nvram_get 2860 dhcpLease`
	# use lan ip as dns server, nancy
	if [ "$dnsManual" != "1" ]; then
		pd=$ip
		sd=""
	fi
	# set all config, nancy
	config-udhcpd.sh -a $start $end $lan_if $mask $gw "$pd;$sd;$lease"
	#config-udhcpd.sh -f	# no need to flush because config file is reset above
	#set static IP bind MAC
	IP_MAC_EN=`nvram_get 2860 IPBindMAC_EN`
	IP_MAC_RU=$(nvram_get 2860 IPBindMACRule | sed -e 's/;/ /g')
	if [ "$IP_MAC_EN" == "2" -o "$IP_MAC_EN" == "1" ]; then
		if [ "$IP_MAC_RU" != "" ]; then
			for i in $IP_MAC_RU
			do
				TMP_IP=$(echo $i | awk 'FS="[,]+" {print $1}')
				TMP_MAC=$(echo $i | awk 'FS="[,]+" {print $2}')
				/bin/dray_util chk_subnet "$start" "$mask" "$TMP_IP" "$TMP_MAC"
					
			done
		fi
	fi
	config-udhcpd.sh -r 1
fi

# stp
if [ "$wan_if" = "br0" -o "$lan_if" = "br0" ]; then
	stp=`nvram_get 2860 stpEnabled`
	if [ "$stp" = "1" ]; then
		brctl setfd br0 15
		brctl stp br0 1
	else
		brctl setfd br0 1
		brctl stp br0 0
	fi
fi

# lltd
lltd=`nvram_get 2860 lltdEnabled`
if [ "$lltd" = "1" ]; then
	lld2d $lan_if
fi

# T12863, nancy
#echo 1 > /proc/sys/net/ipv6/conf/all/forwarding 2>/dev/null

# dns proxy
dnsp=`nvram_get 2860 dnsPEnabled`
if [ "$dnsp" = "1" ]; then
	dnsmasq &
fi

