#!/bin/sh
#
#
. /sbin/global.sh

add_iprouting() {
	eval `ipcalc -b -n $ip_2 $nm_2`
	class_lan2=${NETWORK}
	
	route del -net $class_lan2 netmask $nm_2 dev br0
	route add -host $ip_2 dev br0

	killall parprouted
	parprouted br0 eth2.2 &
}

delete_iprouting() {
	route del -host $ip_2 dev br0
	killall parprouted
}


# Add proxy arp for 2nd subnet
lan2enabled=`nvram_get 2860 Lan2Enabled`
if [ "$lan2enabled" = "1" ]; then
	ip_2=`nvram_get 2860 lan2_ipaddr`
	nm_2=`nvram_get 2860 lan2_netmask`
else
	echo "2nd subnet not enable..."
	exit 0
fi

if [ "$1" == "add" ]; then
	add_iprouting
elif  [ "$1" == "del" ]; then
	delete_iprouting
fi
