#!/bin/sh

wanmode=`nvram_get 2860 wanConnectionMode`
ACTION=$1
PRODUCT=$2
DEVIF=$3
#set USB LED
/sbin/usb_led_ctrl.sh
case "$ACTION" in
	add)
		#1. set USB device mode switch first
		#2. check and lock 3G devices and ttyUSB interface
		logger "USB device add ${PRODUCT}"
		INUSE=$(cat /var/3g/wan_3gdev)
		if [ "$INUSE" != "" ]; then
			echo "3G device already exist........."
			exit 1
		fi
		#draytek_hsdpa arguments: vendorID/productID/0 deviceIf(0:undefined, 1~4:ttyUSB0~ttyUSB3) [MessageContent] 
		#deviceIf: the first interrupted interface that found from struct usb_device
		if [ -f /var/3g/force_3gcmd ]; then 
			CMD_3G=$(cat /var/3g/force_3gcmd)
			/bin/draytek_hsdpa ${PRODUCT} ${DEVIF} $CMD_3G
		else
			EXT_CMD_3G=`nvram_get 2860 extend_3gcmd`
			EXT_STORID_3G=`nvram_get 2860 extend_stor_3gid`
			#echo "EXT_STORID_3G: $EXT_STORID_3G"
			#echo "PRODUCT: $PRODUCT"
			if [ "$EXT_CMD_3G" != "" -a "$EXT_STORID_3G" = "$PRODUCT" ]; then
				/bin/draytek_hsdpa ${PRODUCT} ${DEVIF} $EXT_CMD_3G
			else
				/bin/draytek_hsdpa ${PRODUCT} ${DEVIF}
			fi
		fi
	
		#3. if WAN mode is 3G, start 3G connection
		#we should check if ttyUSB interface existed again,
		#otherwise one device will do internet.sh twice (before mode_switch and after mode_switch)	
		DEV3G=$(cat /var/3g/wan_dev)
		if [ "$DEV3G" != "" ]; then
			TEST=$(comgt -d $DEV3G -s /etc_ro/ppp/3g/getstrength.gcom | grep "Can't open device")
		else
			TEST=$(comgt | grep "Unable to locate default")
		fi
	
		if [ "$TEST" != "" ]; then
			echo "3G device not exist........."
			exit 1
		fi
		
		if [ "$wanmode" = "3G" ]; then
			/bin/goahead set_wan
		fi
		;;
	del)
		#clean USB product
		logger "USB device del ${PRODUCT}"
		# remove Sony Ericson MD300 so setup configuration back to default
		if [ ${PRODUCT} == "fce/d0cf/0" ]; then
			nvram_set 2860 wan_init_string2 "ATE0V1X1&D2&C1S0=0"
		fi
		
		# removed device is 3g device
		INUSE=$(cat /var/3g/wan_3gdev)
		[ ${PRODUCT} == "$INUSE" ] && {
			echo "USB 3G device $PRODUCT removed!!!!"
			if [ "$wanmode" = "3G" ]; then
				if [ -f /var/run/ppp0.pid ]; then
					PPP_PID=$(cat /var/run/ppp0.pid)
					echo "Kill pppd $PPP_PID"
					kill $PPP_PID
				else
					echo "killall pppd"
					killall pppd
				fi
			fi
			echo "/dev/ttyUSB0" > /var/3g/wan_dev
			echo "" > /var/3g/wan_3gdev
			
			#reset usb port	for 169u
			if [ ${PRODUCT} == "12d1/140c/0" ]; then
				echo "reset USB port"
				gpio u
			fi
			
			exit 1
		}
		
		#wait a little time to make sure that device is disconnect
		sleep 2
		
		#unknown 3G device case. 
		if [ "$INUSE" != "" ]; then
			DEV=$(cat /var/3g/wan_dev)
	  		if [ "$DEV" != "" ]; then
				TEST=$(comgt -d "$DEV" -s /etc_ro/ppp/3g/getstrength.gcom | grep "Can't open device")
			else
				TEST=$(comgt | grep "Unable to locate default")
			fi
	
			if [ "$TEST" != "" ]; then
				echo "USB 3G device $PRODUCT removed!!!!"
				if [ "$wanmode" = "3G" ]; then
					if [ -f /var/run/ppp0.pid ]; then
						PPP_PID=$(cat /var/run/ppp0.pid)
						echo "Kill pppd $PPP_PID"
						kill $PPP_PID
					else
						echo "killall pppd"
						killall pppd
					fi
				fi
				echo "/dev/ttyUSB0" > /var/3g/wan_dev
				echo "" > /var/3g/wan_3gdev 
				#reset usb port	for 169u
				#reset usb port	for 169u
				if [ ${PRODUCT} == "12d1/140c/0" ]; then
					echo "reset USB port"
					gpio u
				fi
			fi
		fi
		
esac
