#!/bin/sh

dos_clean()
{
	#check if dos chain in PREROUTING chain
	CHK_DOS=$(iptables -t nat -nL PREROUTING | grep dos_defense)
	if [ "$CHK_DOS" != "" ]; then
		#remove dos_defense chain from PREROUTING Chain 
		iptables -t nat -D PREROUTING -j dos_defense
		#flush and kill dos_defense chain
		iptables -t nat -F dos_defense
		iptables -t nat -X dos_defense		
	fi
}

dos_start()
{
	#echo "DoS defense start!!!"
	#step1: clean dos rule. 
	dos_clean
	#step2: check if dos defense enables??
	DOS_FLAG=$(nvram_get 2860 dos_flag)
	if [ "$DOS_FLAG" != "1" ]; then
		#echo "DoS not enable!!!"
		return
	fi	
	#step3: create dos_defense chain
	iptables -t nat -N dos_defense
	#Add this chain into PREROUTING chain (at top place!!!)
	iptables -t nat -I PREROUTING 1 -j dos_defense
	
	#step4: set dos rules: syn flooding
	DOS_SYN=$(nvram_get 2860 dos_syn_flood)
	if [ "$DOS_SYN" == "1" ]; then
		DOS_SYN_TH=$(nvram_get 2860 dos_syn_flood_th)
		iptables -t nat -A dos_defense -p tcp --syn -m limit --limit $DOS_SYN_TH/s -j RETURN
		iptables -t nat -A dos_defense -p tcp --syn -j DROP
	fi
	
	#step5: set dos rules: udp flooding
	DOS_UDP=$(nvram_get 2860 dos_udp_flood)
	if [ "$DOS_UDP" == "1" ]; then
		DOS_UDP_TH=$(nvram_get 2860 dos_udp_flood_th)
		iptables -t nat -A dos_defense -p udp -m limit --limit $DOS_UDP_TH/s -j RETURN
		iptables -t nat -A dos_defense -p udp -j DROP
	fi

	#step6: set dos rules: ping of death
	DOS_PING=$(nvram_get 2860 dos_ping_of_death)
	if [ "$DOS_PING" == "1" ]; then
		iptables -t nat -A dos_defense -p icmp --icmp-type echo-request -m limit --limit 10/s -j RETURN
		iptables -t nat -A dos_defense -p icmp --icmp-type echo-request -j DROP
	fi

	#step7: set dos rules: icmp flooding
	DOS_ICMP=$(nvram_get 2860 dos_icmp_flood)
	if [ "$DOS_ICMP" == "1" ]; then
		DOS_ICMP_TH=$(nvram_get 2860 dos_icmp_flood_th)
		iptables -t nat -A dos_defense -p icmp -m limit --limit $DOS_ICMP_TH/s -j RETURN
		iptables -t nat -A dos_defense -p icmp -j DROP
	fi
	
	#step8: set dos rules: Furtive port scanner
	DOS_PSCAN=$(nvram_get 2860 dos_port_scan)
	if [ "$DOS_PSCAN" == "1" ]; then
		iptables -t nat -A dos_defense -p tcp --tcp-flags SYN,ACK,FIN,RST RST -m limit --limit 1/s -j RETURN
		iptables -t nat -A dos_defense -p tcp --tcp-flags SYN,ACK,FIN,RST RST -j DROP
	fi
	
	#echo "DoS defense done!!!"
}

dos_stop()
{
	#echo "DoS defense stop!!!"
	dos_clean
	#echo "DoS defense done!!!"
}


if [ "$1" == "start" ]; then
	dos_start
elif [ "$1" == "stop" ]; then
	dos_stop
fi