#!/bin/sh
#
# $Id: config-l2tp.sh,v 1.6 2008-12-26 10:36:21 steven Exp $
#
# usage: config-l2tp.sh <mode> <mode_params> <server> <user> <password>
#

. /sbin/config.sh
. /sbin/global.sh

usage()
{
	echo "Usage:"
	echo "  $0 <mode> <mode_params> <server> <user> <password>"
	echo "Modes:"
	echo "  static - <mode_params> = <wan_if_name> <wan_ip> <wan_netmask> <gateway>"
	echo "  dhcp - <mode_params> = <wan_if_name>"
	echo "Example:"
	echo "  $0 static eth2.2 10.10.10.254 255.255.255.0 10.10.10.253 192.168.1.1 user pass"
	echo "  $0 dhcp eth2.2 192.168.1.1 user pass"
	exit 1
}

if [ "$5" = "" ]; then
	echo "$0: insufficient arguments"
	usage $0
fi

echo "" > /var/pptp_l2tp_gateway
echo "1" > /var/network/l2tp_ppp_unit

# delete any default route, nancy
while route del default ; do
 :
done

if [ "$1" = "static" ]; then
	if [ "$7" = "" ]; then
		echo "$0: insufficient arguments"
		usage $0
	fi
	ifconfig $2 $3 netmask $4
	route del default
	if [ "$5" != "0.0.0.0" ]; then
		route add default gw $5
		echo "$5" > /var/pptp_l2tp_gateway
	fi
	l2tp_srv=$6
	l2tp_u=$7
	l2tp_pw=$8
	l2tp_opmode=$9
	l2tp_optime=${10}
elif [ "$1" = "dhcp" ]; then
	# nancy, try fix the problem of 2 config-l2tp.sh
	temp=`ps | grep [u]dhcpc | grep $2`
	if [ "$temp" != "" ]; then
		exit 0
	fi
	killall -q -SIGTERM udhcpc
	#add dhcp option 121 (staticroutes), option 33
	udhcpc -i $2 -s /sbin/udhcpc.sh -O staticroutes -O routes -p /var/run/udhcpcbk.pid &
	l2tp_srv=$3
	l2tp_u=$4
	l2tp_pw=$5
	l2tp_opmode=$6
	l2tp_optime=$7
	# wait until default route is ready
	count=0
	while [ "$count" != "60" ]; do
		sleep 3
		temp=`route -n | grep ^0.0.0.0 | grep $2`
		if [ "$temp" != "" ]; then
			echo "$temp" | awk '{print $2}' > /var/pptp_l2tp_gateway
			break
		fi
		# call udhcpc again if it's not running
		if [ ! -f /var/run/udhcpcbk.pid ]; then
			udhcpc -i $2 -s /sbin/udhcpc.sh -O staticroutes -O routes -p /var/run/udhcpcbk.pid &
		fi
		count=$(expr $count + 1)
	done
else
	echo "$0: unknown connection mode: $1"
	usage $0
fi

# get server ip if using domain name, nancy
temp=`echo $l2tp_srv | sed 's/[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}//g'`
if [ "$temp" != "" ]; then
	# get the ip of the domain name
	l2tp_srv_temp=`ping -c 1 $l2tp_srv | grep PING | sed 's/^.*(//g' | sed 's/).*$//g'`
	if [ "$l2tp_srv_temp" != "" ]; then
		echo "L2TP server ($l2tp_srv) IP : $l2tp_srv_temp"
		logger "L2TP server ($l2tp_srv) IP : $l2tp_srv_temp"
		l2tp_srv=$l2tp_srv_temp
	fi
fi

if [ "$CONFIG_PPPOL2TP" == "y" ]; then
rm -f /var/run/openl2tpd.pid
openl2tp.sh $l2tp_u $l2tp_pw $l2tp_srv $l2tp_opmode $l2tp_optime
openl2tpd
else
l2tpbk.sh $l2tp_u $l2tp_pw $l2tp_srv $l2tp_opmode $l2tp_optime
l2tpd
sleep 1
l2tp-control "start-session $l2tp_srv"
fi


