#!/bin/sh

#if [ "$1" != "" ]; then
#        dev=$1
#else
#        dev=`nvram_get 2860 wan_3g_dev`
#fi

#set device to HUAWEI
#dev=HUAWEI-E220

#sleep 10
#change 3G dongle state to modem
#if [ "$dev" = "MU-Q101" ]; then
#        usb_modeswitch -c /etc_ro/usb/usb_modeswitch_MU-Q101.conf
#elif [ "$dev" = "HUAWEI-E169" ]; then
#        usb_modeswitch -c /etc_ro/usb/usb_modeswitch_HUAWEI-E169.conf
#elif [ "$dev" = "HUAWEI-E220" ]; then
#        usb_modeswitch -c /etc_ro/usb/usb_modeswitch_HUAWEI-E220.conf
#elif [ "$dev" = "BandLuxe-C270" ]; then
#	sdparm --command=eject /dev/sr0
#	sdparm --command=eject /dev/sg0
#elif [ "$dev" = "OPTION-ICON225" ]; then
#	usb_modeswitch -c /etc_ro/usb/usb_modeswitch_OPTION-ICON225.conf
#else
        #other supported devcies
#fi

#wait for state change
#sleep 10

#insmod usbserial module
#if [ "$dev" = "MU-Q101" ]; then
#        vend_id="0x0408"
#        prod_id="0xea02"
#elif [ "$dev" = "HUAWEI-E169" ]; then
#        vend_id="0x12d1"
#        prod_id="0x1001"
#elif [ "$dev" = "HUAWEI-E220" ]; then
#        vend_id="0x12d1"
#        prod_id="0x1003"
#elif [ "$dev" = "BandLuxe-C270" ]; then
#        vend_id="0x1a8d"
#        prod_id="0x1009"

#else
        #other supported devcies
#fi

#if [ "$dev" != "OPTION-ICON225" ]; then
#	rmmod usbserial
#	rmmod hso
#	sleep 3
#	insmod usbserial vendor=$vend_id product=$prod_id
#	sleep 3
#elif [ "$dev" = "OPTION-ICON225" ]; then
#	rmmod usbserial
#	rmmod hso
#	sleep 3
#	insmod hso
#	sleep 3
#fi

#create ppp call script for 3G connection
#if [ "$dev" = "MU-Q101" ]; then
#        modem_f=ttyUSB0
#elif [ "$dev" = "HUAWEI-E169" ]; then
#        modem_f=ttyUSB0
#elif [ "$dev" = "HUAWEI-E220" ]; then
#        modem_f=ttyUSB0
#elif [ "$dev" = "BandLuxe-C270" ]; then
#        modem_f=ttyUSB0
#else
        #other supported devcies
#        modem_f=ttyUSB0
#fi


#if [ "$dev" = "HUAWEI-E220" ]; then
#	if [ -d	/var/lock ]; then
#		pppd call e220
#	else
#		mkdir /var/lock
#		pppd call e220
#	fi	
#elif [ "$dev" != "OPTION-ICON225" ]; then	
#		config-3g-ppp.sh -p pass -u user -m $modem_f -c Generic_conn.scr -d Generic_disconn.scr
#		pppd call 3g
#elif [ "$dev" = "OPTION-ICON225" ]; then
#	echo "APN=internet" > /etc/conninfo.ini
	#echo "PIN=internet >" /etc/conninfo.ini
	#echo "USER="  > /etc/conninfo.ini
	#echo "PASS="  > /etc/conninfo.ini
#	hso_connect.sh up
#fi

#set config value
#nvram_set 2860 wan_pincode "0000"
#nvram_set 2860 wan_apn "internet"
#nvram_set 2860 wan_init_string1 "AT&F"
#nvram_set 2860 wan_init_string2 "ATE0V1X1&D2&C1S0=0"
#nvram_set 2860 wan_dial_string "ATDT*99#"
#nvram_set 2860 wan_username ""
#nvram_set 2860 wan_password ""

#get parameter wait for mode switch 
if [ "$1" == "3g_backup" ]; then
	echo "3G backup wan"
	DEV3G=$(cat /var/3g/wan_dev)
	PIN=$(nvram_get 2860 3gwan_pincode)
else
	sleep 10
	DEV3G=$(cat /var/3g/wan_dev)
	PIN=$(nvram_get 2860 wan_pincode)
fi

#disconnect first
#comgt -d "$DEV3G" -s /etc_ro/ppp/3g/Generic_disconn.scr

#step0: set PIN code if need
if [ "$PIN" != "" ]; then
	PINCODE=$PIN comgt -d "$DEV3G" -s /etc_ro/ppp/3g/setpin.gcom || {
		ERR=$?
		#echo "$config(3g): Please check your SIM card and PIN code setting."
		#set_3g_led 0 0 0
		#return 1
		#ERR=1
	}		
else
	#do not set PIN command if PIN code is NULL
	ERR=0
fi

if [ "$ERR" == "1" ]; then
	echo "Set PIN code error!!!!" 
	rm -f /var/network/3g_info >/dev/null
	exit 1
elif [ "$ERR" == "2" ]; then
	echo "Set PIN code timeout!!!!"
	rm -f /var/network/3g_info >/dev/null
else
	#step1: log data for web display information
	rm -f /var/network/3g_info >/dev/null
	CARDINFO=$(comgt -d "$DEV3G" -s /etc_ro/ppp/3g/getcardinfo.gcom)
	SIG=$(comgt -d $DEV3G -s /etc_ro/ppp/3g/getstrength.gcom)
	echo "==3G Card Info== :">/var/network/3g_info
	echo "$CARDINFO">>/var/network/3g_info
	echo "==3G Signal Strength== :">>/var/network/3g_info
	echo "$SIG">>/var/network/3g_info
fi

#step2: check if 3G device existed
if [ "$DEV3G" != "" ]; then
	if [ "$SIG" != "" ]; then
		# If signal strength string exist already, grep directly. Reduce 2 seconds or so.
		TEST=$(echo "$SIG" | grep "Can't open device")
	else
		TEST=$(comgt -d $DEV3G -s /etc_ro/ppp/3g/getstrength.gcom | grep "Can't open device")
	fi
else
	TEST=$(comgt | grep "Unable to locate default")
fi

if [ "$TEST" != "" ]; then
	echo "3G device not exist........."
	exit 1
fi

#step3: make sure 3g device is locked
INUSE=$(cat /var/3g/wan_3gdev)
if [ "$INUSE" == "" ]; then
	echo "xxxx/xxxx/x" > /var/3g/wan_3gdev  
fi

#check special modem
HWEC156=0	#Huawei EC156 modem
if [ "$INUSE" == "12d1/140c/0" ]; then
	LINECNT=0
	exec 3<&0
	exec 0<'/proc/bus/usb/devices'
	while read line
	do
		if [ "$LINECNT" -eq 0 ]; then
			DEVINFO=`echo $line | grep "Vendor=12d1 ProdID=140c Rev= 0.00"`
			if [ -n "$DEVINFO" ]; then
				LINECNT=1
			fi
		elif [ "$LINECNT" -lt 4 ]; then
			LINECNT=`expr $LINECNT + 1`
			DEVINFO=`echo $line | grep "SerialNumber"`
			if [ -n "$DEVINFO" ]; then
				HWEC156=1
			fi
		else
			break
		fi
	done
fi

# SierraWireless 320U                   # TODO: maybe more Sierra models need this workaround
if [ "$INUSE" == "0f3d/68aa/0" ]; then
    # Sierra modem only accepts +CPIN command through AT Command Port (ttyUSB2 for this modem)
    # however, it can dial only through Modem Port (ttyUSB3 for this modem)
    # we have to assign the Modem Port for pppd dialing
    DEV3G=/dev/ttyUSB3                  # TODO: to detect Modem Port instead of forcing "ttyUSB3"
fi


#step4: get value from config
if [ "$1" == "3g_backup" ]; then
	W_APN=$(nvram_get 2860 3gwan_apn)
	W_INIT_STR1=$(nvram_get 2860 3gwan_init_string1)
	W_INIT_STR2=$(nvram_get 2860 3gwan_init_string2)
	W_DIAL_STR=$(nvram_get 2860 3gwan_dial_string)
	W_USER=$(nvram_get 2860 3gwan_username)
	W_PASSWD=$(nvram_get 2860 3gwan_password)
	W_AUTH=$(nvram_get 2860 3gwan_auth)
else
	W_APN=$(nvram_get 2860 wan_apn)
	W_INIT_STR1=$(nvram_get 2860 wan_init_string1)
	W_INIT_STR2=$(nvram_get 2860 wan_init_string2)
	W_DIAL_STR=$(nvram_get 2860 wan_dial_string)
	W_USER=$(nvram_get 2860 wan_username)
	W_PASSWD=$(nvram_get 2860 wan_password)
	W_AUTH=$(nvram_get 2860 wan_auth)
fi

# hso driver
if [ "$DEV3G" = "/dev/ttyHS0" ]; then
	if [ -f /var/lock/3g-hso ]; then
		exit 0
	fi
	touch /var/lock/3g-hso
	hso_output="/var/hso_connect_output_temp"
	hso_dial_script="/etc_ro/ppp/3g/3g_hso_dial.chat"

	if [ "$1" == "3g_backup" ]; then
		hso_if="ppp1"
		W_MTU=$(nvram_get 2860 wan_bk_mtu)
	else
		hso_if="ppp0"
		W_MTU=$(nvram_get 2860 wan_mtu)
	fi

	logger "Hso : Start connecting"
	
	if [ "$W_APN" != "" ]; then
		echo "ABORT   BUSY" > /var/3g.chat
		echo "ABORT   'NO CARRIER'" >> /var/3g.chat
		echo "ABORT   ERROR" >> /var/3g.chat
		echo "TIMEOUT 10" >> /var/3g.chat
		echo "\"\"      \"$W_INIT_STR1\"" >> /var/3g.chat
		echo "OK      \"$W_INIT_STR2\"" >> /var/3g.chat
		if [ "$W_APN" != "" ]; then
			echo "OK      'AT+CGDCONT=1,\"IP\",\"$W_APN\"'" >> /var/3g.chat
		fi
		echo "OK      \"\"" >> /var/3g.chat

		( /bin/chat -E -s -V -f /var/3g.chat <$DEV3G >$DEV3G ) 2> $hso_output
		temp1=`grep "ERROR" $hso_output`
		temp2=`grep "CME" $hso_output`
		if [ -n "$temp1" -o -n "$temp2" ]; then
			logger "Hso : Failed to initialize connection but still go on..."
			cat $hso_output
			rm -f $hso_output
		fi
		sleep 2
	fi

	hso_pip=""
	hso_counter=""
	while [ -z "$hso_pip" -a "$hso_counter" != "-----" ]
	do
		rm -f $hso_output
		hso_counter2=""
		logger "Hso : Start init modem"
		( /bin/chat -E -s -V -f $hso_dial_script <$DEV3G > $DEV3G ) 2> $hso_output
		sleep 2

		while [ -z "$hso_pip" -a "$hso_counter2" != "---" ]
		do
			logger "Hso : Get ip, device=$DEV3G"

			comgt -d "$DEV3G" -s /etc_ro/ppp/3g/hso_getip.gcom > $hso_output 2>&1
			temp1=`grep "ERROR" "$hso_output"`
			if [ -z "$temp1" ]; then
				cat $hso_output
				hso_pip=`grep "^_OWANDATA" $hso_output | awk '{FS=","}{print $2}'`
				hso_ns1=`grep "^_OWANDATA" $hso_output | awk '{FS=","}{print $4}'`
				hso_ns2=`grep "^_OWANDATA" $hso_output | awk '{FS=","}{print $5}'`
			fi

			if [ -z "$hso_pip" ]; then
				sleep 2
			fi
			hso_counter2="${hso_counter2}-"
		done
		hso_counter="${hso_counter}-"
	done

	if [ -z "$hso_pip" ]; then
		logger "Hso : Failed to get ip"
		cat $hso_output
		rm -f $hso_output
		rm -f /var/lock/3g-hso
		exit 0
	fi

	logger "Hso : Setting IP address to $hso_pip"
	if [ -n "$W_MTU" ]; then
		ifconfig $hso_if mtu $W_MTU
	fi
	ifconfig $hso_if $hso_pip netmask 255.255.255.255 up
	route del default
	route add default dev $hso_if
	echo "nameserver	$hso_ns1" > $hso_output
	echo "nameserver	$hso_ns2" >> $hso_output
	cp $hso_output /etc/resolv.conf

	#clean icmp conntrack cache (because hso driver does not call pppd ip-up, G34270)
	/etc_ro/ppp/ip-up

	logger "3g.sh hso : Done"
	rm -f /var/lock/3g-hso
	exit 0
fi

#step5: set 3g.chat temp file
echo "ABORT   BUSY" > /var/3g.chat
echo "ABORT   'NO CARRIER'" >> /var/3g.chat
echo "ABORT   ERROR" >> /var/3g.chat
echo "REPORT  CONNECT" >> /var/3g.chat
echo "TIMEOUT 10" >> /var/3g.chat

if [ $HWEC156 -eq 1 ]; then
	echo "\"\"      \"$W_INIT_STR2\"" >> /var/3g.chat
	echo "OK      	\"AT+CSQ\"" >> /var/3g.chat
	echo "OK      	\"AT+CPIN?  \"" >> /var/3g.chat
	echo "OK      	\"$W_INIT_STR2\"" >> /var/3g.chat
else
echo "\"\"      \"$W_INIT_STR1\"" >> /var/3g.chat
echo "OK      \"$W_INIT_STR2\"" >> /var/3g.chat
if [ "$W_APN" != "" ]; then
	echo "OK      'AT+CGDCONT=1,\"IP\",\"$W_APN\"'" >> /var/3g.chat
fi
echo "SAY     \"Calling UMTS/GPRS\"" >> /var/3g.chat
echo "TIMEOUT 30" >> /var/3g.chat
fi
echo "OK      \"$W_DIAL_STR\"" >> /var/3g.chat
echo "CONNECT ' '" >> /var/3g.chat

#step6: set ppp number and 3G connecting
AUTH_STR=""
if [ "$W_AUTH" == "0" ]; then
	AUTH_STR="refuse-chap refuse-mschap refuse-mschap-v2 refuse-eap"
fi
if [ "$1" == "3g_backup" ]; then
	#check if pppd existed
	CHK=`ps | grep -v grep | grep "unit 1"`
	if [ "$CHK" != "" ]; then
		PID=$(echo $CHK | awk '{print $1}')
		kill $PID
		echo "pppd unit 1 already existed..."
		sleep 5
	fi
	#connect ppp1
	pppd unit 1 ${W_USER:+user "$W_USER" password "$W_PASSWD"} noaccomp nopcomp novj\
	nobsdcomp noauth lock crtscts 115200 "$DEV3G" call e220 $AUTH_STR
else
	#check if pppd existed
	CHK=`ps | grep -v grep | grep "unit 0"`
	if [ "$CHK" != "" ]; then
		PID=$(echo $CHK | awk '{print $1}')
		kill $PID
		echo "pppd unit 0 already existed..."
		sleep 5
	fi
	#connect ppp0
	pppd unit 0 ${W_USER:+user "$W_USER" password "$W_PASSWD"} noaccomp nopcomp novj\
	nobsdcomp noauth lock crtscts 115200 "$DEV3G" call e220 $AUTH_STR
fi
