<html>
<head>
<title>Basic Wireless Settings</title><% chkLoginUser(); %>
<meta http-equiv="content-type" content="text/html; charset=iso-8859-1">
<meta http-equiv="Pragma" Content="No-cach">
<meta http-equiv="Expires" Content="-1">
<link rel="stylesheet" href="/style/normal_ws.css" type="text/css">
<style type="text/css">
#basicNote {color:#990033; font-weight: bold; font-family: Arial, Helvetica, sans-serif; margin-left: 5px}
</style>
<script type="text/javascript" src="/lang/b28n.js"></script>
<script type="text/javascript" src="/dtree/tool.js"></script>
<script type="text/javascript" language="JavaScript">
Butterlate.setTextDomain("wireless");

var PhyMode  = '<% getCfgZero(1, "WirelessMode"); %>';
var HiddenSSID  = '<% getCfgZero(1, "HideSSID"); %>';
var APIsolated = '<% getCfgZero(1, "NoForwarding"); %>';
var channel_index  = '<% getWlanChannel(); %>';
var fxtxmode = '<% getCfgGeneral(1, "FixedTxMode", 1); %>';
var countrycode = '<% getCfgGeneral(1, "CountryCode", 1); %>';
var ht_mcs = '<% getCfgZero(1, "HT_MCS"); %>';
var txBurst = '<% getCfgZero(1, "TxBurst"); %>';
var opmode = "<% getCfgZero(1, "OperationMode"); %>";
var apcli = "<% getCfgZero(1, "ApCliEnable"); %>";
var TRStream = '<% getCfgZero(1, "HT_TxStream"); %>';
var tx_power = '<% getCfgZero(1, "TxPower"); %>';
var vlan_en = '<% getCfgZero(1, "VLAN_EN"); %>';
var isolated_lan = '<% getCfgZero(1, "WirelessIsolate"); %>';
var channel_width = '<% getCfgZero(1, "HT_BW"); %>';
var sExtChannel = '<% getCfgZero(1, "HT_EXTCHA"); %>';

ChannelList_24G = new Array(14);
ChannelList_24G[0] = "2412MHz (Channel 1)";
ChannelList_24G[1] = "2417MHz (Channel 2)";
ChannelList_24G[2] = "2422MHz (Channel 3)";
ChannelList_24G[3] = "2427MHz (Channel 4)";
ChannelList_24G[4] = "2432MHz (Channel 5)";
ChannelList_24G[5] = "2437MHz (Channel 6)";
ChannelList_24G[6] = "2442MHz (Channel 7)";
ChannelList_24G[7] = "2447MHz (Channel 8)";
ChannelList_24G[8] = "2452MHz (Channel 9)";
ChannelList_24G[9] = "2457MHz (Channel 10)";
ChannelList_24G[10] = "2462MHz (Channel 11)";
ChannelList_24G[11] = "2467MHz (Channel 12)";
ChannelList_24G[12] = "2472MHz (Channel 13)";
ChannelList_24G[13] = "2484MHz (Channel 14)";

ChannelList_5G = new Array(33);
ChannelList_5G[0] = "5180MHz (Channel 36)";
ChannelList_5G[1] = "5200MHz (Channel 40)";
ChannelList_5G[2] = "5220MHz (Channel 44)";
ChannelList_5G[3] = "5240MHz (Channel 48)";
ChannelList_5G[4] = "5260MHz (Channel 52)";
ChannelList_5G[5] = "5280MHz (Channel 56)";
ChannelList_5G[6] = "5300MHz (Channel 60)";
ChannelList_5G[7] = "5320MHz (Channel 64)";
ChannelList_5G[16] = "5500MHz (Channel 100)";
ChannelList_5G[17] = "5520MHz (Channel 104)";
ChannelList_5G[18] = "5540MHz (Channel 108)";
ChannelList_5G[19] = "5560MHz (Channel 112)";
ChannelList_5G[20] = "5580MHz (Channel 116)";
ChannelList_5G[21] = "5600MHz (Channel 120)";
ChannelList_5G[22] = "5620MHz (Channel 124)";
ChannelList_5G[23] = "5640MHz (Channel 128)";
ChannelList_5G[24] = "5660MHz (Channel 132)";
ChannelList_5G[25] = "5680MHz (Channel 136)";
ChannelList_5G[26] = "5700MHz (Channel 140)";
ChannelList_5G[28] = "5745MHz (Channel 149)";
ChannelList_5G[29] = "5765MHz (Channel 153)";
ChannelList_5G[30] = "5785MHz (Channel 157)";
ChannelList_5G[31] = "5805MHz (Channel 161)";
ChannelList_5G[32] = "5825MHz (Channel 165)";

HT5GExtCh = new Array(22);
HT5GExtCh[0] = new Array(1, "5200MHz (Channel 40)"); // channel 36's extension channel
HT5GExtCh[1] = new Array(0, "5180MHz (Channel 36)"); // channel 40's extension channel
HT5GExtCh[2] = new Array(1, "5240MHz (Channel 48)"); // channel 44's extension channel
HT5GExtCh[3] = new Array(0, "5220MHz (Channel 44)"); // channel 48's extension channel
HT5GExtCh[4] = new Array(1, "5280MHz (Channel 56)"); // channel 52's extension channel
HT5GExtCh[5] = new Array(0, "5260MHz (Channel 52)"); // channel 56's extension channel
HT5GExtCh[6] = new Array(1, "5320MHz (Channel 64)"); // channel 60's extension channel
HT5GExtCh[7] = new Array(0, "5300MHz (Channel 60)"); // channel 64's extension channel
HT5GExtCh[8] = new Array(1, "5520MHz (Channel 104)"); // channel 100's extension channel
HT5GExtCh[9] = new Array(0, "5500MHz (Channel 100)"); // channel 104's extension channel
HT5GExtCh[10] = new Array(1, "5560MHz (Channel 112)"); // channel 108's extension channel
HT5GExtCh[11] = new Array(0, "5540MHz (Channel 108)"); // channel 112's extension channel
HT5GExtCh[12] = new Array(1, "5600MHz (Channel 120)"); // channel 116's extension channel
HT5GExtCh[13] = new Array(0, "5580MHz (Channel 116)"); // channel 120's extension channel
HT5GExtCh[14] = new Array(1, "5640MHz (Channel 128)"); // channel 124's extension channel
HT5GExtCh[15] = new Array(0, "5620MHz (Channel 124)"); // channel 128's extension channel
HT5GExtCh[16] = new Array(1, "5680MHz (Channel 136)"); // channel 132's extension channel
HT5GExtCh[17] = new Array(0, "5660MHz (Channel 132)"); // channel 136's extension channel
HT5GExtCh[18] = new Array(1, "5765MHz (Channel 153)"); // channel 149's extension channel
HT5GExtCh[19] = new Array(0, "5745MHz (Channel 149)"); // channel 153's extension channel
HT5GExtCh[20] = new Array(1, "5805MHz (Channel 161)"); // channel 157's extension channel
HT5GExtCh[21] = new Array(0, "5785MHz (Channel 157)"); // channel 161's extension channel

function initExtChannel()
{
	var mChannel = parseInt(document.wireless_basic.sz11gChannel.value);

	switch(mChannel) {
		case 0:
			document.wireless_basic.sExtChannel.options.length = 0;
			document.wireless_basic.sExtChannel.options[0] = new Option( _("basic frequency auto"), "0");
			break;
		case 1:	
		case 2:		
		case 3:		
		case 4:
			document.wireless_basic.sExtChannel.options.length = 0;
			document.wireless_basic.sExtChannel.options[0] = new Option(ChannelList_24G[mChannel+3], "1");	
			break;
		case 5:
		case 6:
		case 7:
			document.wireless_basic.sExtChannel.options.length = 0;
			document.wireless_basic.sExtChannel.options[0] = new Option(ChannelList_24G[mChannel-5], "0");	
			document.wireless_basic.sExtChannel.options[1] = new Option(ChannelList_24G[mChannel+3], "1");
			break;
		case 8:
			document.wireless_basic.sExtChannel.options.length = 0;
			document.wireless_basic.sExtChannel.options[0] = new Option(ChannelList_24G[mChannel-5], "0");	
			if ((countrycode == "JP") || (countrycode == "FR")) {
				document.wireless_basic.sExtChannel.options[1] = new Option(ChannelList_24G[mChannel+3], "1");
			}
			break;
		case 9:
			document.wireless_basic.sExtChannel.options.length = 0;
			document.wireless_basic.sExtChannel.options[0] = new Option(ChannelList_24G[mChannel-5], "0");
			if ((countrycode == "JP") || (countrycode == "FR")) {
			document.wireless_basic.sExtChannel.options[1] = new Option(ChannelList_24G[mChannel+3], "1");
			}
			break;
		case 10:
			document.wireless_basic.sExtChannel.options.length = 0;
			document.wireless_basic.sExtChannel.options[0] = new Option(ChannelList_24G[5], "0");
			if (countrycode == "JP") {
				document.wireless_basic.sExtChannel.options[1] = new Option(ChannelList_24G[13], "1");
			}
			break;
		case 11:
		case 12:
		case 13:
		case 14:
			document.wireless_basic.sExtChannel.options.length = 0;
			document.wireless_basic.sExtChannel.options[0] = new Option(ChannelList_24G[mChannel-5], "0");
			break;
	}
}

function insertChannelOption(vChannel, band)
{
	var y = document.createElement('option');

	if (1*band == 24)
	{
		y.text = ChannelList_24G[1*vChannel - 1];
		y.value = 1*vChannel;
	}
	else if (1*band == 5)
	{
		y.value = 1*vChannel;
		if (1*vChannel <= 140)
			y.text = ChannelList_5G[((1*vChannel) - 36) / 4];
		else
			y.text = ChannelList_5G[((1*vChannel) - 36 - 1) / 4];
	}

	if (1*band == 24)
		var x=document.getElementById("sz11gChannel");
	else if (1*band == 5)
		var x=document.getElementById("sz11aChannel");

	try
	{
		x.add(y,null); // standards compliant
	}
	catch(ex)
	{
		x.add(y); // IE only
	}
}

function Check5GBandChannelException()
{
	var w_mode = document.wireless_basic.wirelessmode.options.selectedIndex;

	if ((1*w_mode == 7) || (1*w_mode == 8))
	{
		var x = document.getElementById("sz11aChannel")
		var current_length = document.wireless_basic.sz11aChannel.options.length;
		var current_index = document.wireless_basic.sz11aChannel.options.selectedIndex;
		var current_channel = document.wireless_basic.sz11aChannel.value;

		if (1*current_index == 0)
		{
			if (1*channel_index != 0)
				current_index = 1;
		}

		for (ch_idx = current_length - 1; ch_idx > 0; ch_idx--)
		{
			x.remove(ch_idx);
		}

		if (document.wireless_basic.n_bandwidth[1].checked == true)
		{
			if ((countrycode == 'NONE') || (countrycode == 'FR') || (countrycode == 'US') ||
				(countrycode == 'IE') || (countrycode == 'JP') || (countrycode == 'HK'))
			{
				for(ch = 36; ch <= 48; ch+=4)
					insertChannelOption(ch, 5);
			}

			if ((countrycode == 'NONE') || (countrycode == 'FR') || (countrycode == 'US') ||
				(countrycode == 'IE') || (countrycode == 'TW') || (countrycode == 'HK'))
			{
				for(ch = 52; ch <= 64; ch+=4)
					insertChannelOption(ch, 5);
			}

			if (countrycode == 'NONE')
			{
				for(ch = 100; ch <= 136; ch+=4)
					insertChannelOption(ch, 5);
			}

			if ((countrycode == 'NONE') || (countrycode == 'US') || (countrycode == 'TW') ||
				(countrycode == 'CN') || (countrycode == 'HK'))
			{
				for(ch = 149; ch <= 161; ch+=4)
					insertChannelOption(ch, 5);
			}

			if ((1*current_channel == 140) || (1*current_channel == 165))
			{
				document.wireless_basic.sz11aChannel.options.selectedIndex = (1*current_index) -1;
			}
			else
			{
				document.wireless_basic.sz11aChannel.options.selectedIndex = (1*current_index);
			}
		}
		else
		{
			if ((countrycode == 'NONE') || (countrycode == 'FR') || (countrycode == 'US') ||
				(countrycode == 'IE') || (countrycode == 'JP') || (countrycode == 'HK'))
			{
				for(ch = 36; ch <= 48; ch+=4)
					insertChannelOption(ch, 5);
			}

			if ((countrycode == 'NONE') || (countrycode == 'FR') || (countrycode == 'US') ||
				(countrycode == 'IE') || (countrycode == 'TW') || (countrycode == 'HK'))
			{
				for(ch = 52; ch <= 64; ch+=4)
					insertChannelOption(ch, 5);
			}

			if (countrycode == 'NONE')
			{
				for(ch = 100; ch <= 140; ch+=4)
					insertChannelOption(ch, 5);
			}

			if ((countrycode == 'NONE') || (countrycode == 'US') || (countrycode == 'TW') ||
				(countrycode == 'CN') || (countrycode == 'HK'))
			{
				for(ch = 149; ch <= 161; ch+=4)
					insertChannelOption(ch, 5);
			}

			if ((countrycode == 'NONE') || (countrycode == 'US') ||
				(countrycode == 'CN') || (countrycode == 'HK'))
			{
					insertChannelOption(165, 5);
			}

			document.wireless_basic.sz11aChannel.options.selectedIndex = (1*current_index);
		}
	}
	else if (1*w_mode == 6)
	{
		var x = document.getElementById("sz11aChannel")
		var current_length = document.wireless_basic.sz11aChannel.options.length;
		var current_index = document.wireless_basic.sz11aChannel.options.selectedIndex;

		for (ch_idx = current_length - 1; ch_idx > 0; ch_idx--)
		{
			x.remove(ch_idx);
		}

		if ((countrycode == 'NONE') || (countrycode == 'FR') || (countrycode == 'US') ||
			(countrycode == 'IE') || (countrycode == 'JP') || (countrycode == 'HK'))
		{
			for(ch = 36; ch <= 48; ch+=4)
				insertChannelOption(ch, 5);
		}

		if ((countrycode == 'NONE') || (countrycode == 'FR') || (countrycode == 'US') ||
			(countrycode == 'IE') || (countrycode == 'TW') || (countrycode == 'HK'))
		{
			for(ch = 52; ch <= 64; ch+=4)
				insertChannelOption(ch, 5);
		}

		if (countrycode == 'NONE')
		{
			for(ch = 100; ch <= 140; ch+=4)
				insertChannelOption(ch, 5);
		}

		if ((countrycode == 'NONE') || (countrycode == 'US') || (countrycode == 'TW') ||
			(countrycode == 'CN') || (countrycode == 'HK'))
		{
			for(ch = 149; ch <= 161; ch+=4)
				insertChannelOption(ch, 5);
		}

		if ((countrycode == 'NONE') || (countrycode == 'US') ||
			(countrycode == 'CN') || (countrycode == 'HK'))
		{
				insertChannelOption(165, 5);
		}

		document.wireless_basic.sz11aChannel.options.selectedIndex = (1*current_index);
	}
}

function initTranslation()
{
	var e = document.getElementById("basicTitle");
	e.innerHTML = _("parent wireless lan")+" >> "+_("basic title");

	e = document.getElementById("basicWirelessNet");
	e.innerHTML = _("basic wireless network");
	e = document.getElementById("basicWirelessEnable");
	e.innerHTML = _("basic enable");
	e = document.getElementById("basicNetMode");
	e.innerHTML = _("basic mode");
	e = document.getElementById("basicHideSSID");
	e.innerHTML = _("basic hssid");
	e = document.getElementById("basicSSID");
	e.innerHTML = _("basic ssid");
	e = document.getElementById("basicIsolatedSSID");
	e.innerHTML = _("basic isolate");
	e = document.getElementById("basicIsolatedLan");
	e.innerHTML = _("basic isolate lan");

	e = document.getElementById("basicHssidTitle");
	e.innerHTML = _("basic hssid title");
	e = document.getElementById("basicHssidIntro");
	e.innerHTML = _("basic hssid intro");
	e = document.getElementById("basicIsolateTitle");
	e.innerHTML = _("basic isolate");
	e = document.getElementById("basicIsolateIntro");
	e.innerHTML = _("basic isolate intro");
	e = document.getElementById("basicSSID4Title");
	e.innerHTML = _("basic ssid4 title");
	e = document.getElementById("basicSSID4Intro");
	e.innerHTML = _("basic ssid4 intro");
	e = document.getElementById("basicIsolateLANTitle");
	e.innerHTML = _("basic isolate lan");
	e = document.getElementById("basicIsolateLANIntro");
	e.innerHTML = _("basic isolate_lan info");

	e = document.getElementById("basicFreqA");
	e.innerHTML = _("basic frequency");
	e = document.getElementById("basicFreqAAuto");
	e.innerHTML = _("basic frequency auto");
	e = document.getElementById("basicFreqB");
	e.innerHTML = _("basic frequency");
	e = document.getElementById("basicFreqBAuto");
	e.innerHTML = _("basic frequency auto");
	e = document.getElementById("basicFreqG");
	e.innerHTML = _("basic frequency");
	e = document.getElementById("basicFreqGAuto");
	e.innerHTML = _("basic frequency auto");
	e = document.getElementById("basicRate");
	e.innerHTML = _("basic rate");
	e = document.getElementById("basicPkt");
	e.innerHTML = _("basic pkt");
	e = document.getElementById("basicPktTxBurst");
	e.innerHTML = _("basic pkt burst");
	e = document.getElementById("basicPktNote");
	e.innerHTML = _("wireless note");
	e = document.getElementById("basicPktStr1");
	e.innerHTML = _("basic pkt str1");
	e = document.getElementById("basicPktStr2");
	e.innerHTML = _("basic pkt str2");
	e = document.getElementById("basicUR");
	e.innerHTML = _("basic ur");
	e = document.getElementById("basicUREnable");
	e.innerHTML = _("wireless enable");
	e = document.getElementById("basicURNote");
	e.innerHTML = _("wireless note");
	e = document.getElementById("basicURStr");
	e.innerHTML = _("basic ur str");
	e = document.getElementById("basicExtChn");
	e.innerHTML = _("basic ext channel");

	e = document.getElementById("bscAntenna");
	e.innerHTML = _("basic antenna");
	e = document.getElementById("basicNote");
	e.innerHTML = _("basic note");
	e = document.getElementById("TRNote");
	e.innerHTML = _("basic antenna note");
	e = document.getElementById("bscTxPower");
	e.innerHTML = _("basic tx power");
	e = document.getElementById("bscChnWth");
	e.innerHTML = _("basic channel width");
	e = document.getElementById("chn_wth_auto");
	e.innerHTML = _("basic channel width auto");
	e = document.getElementById("chn_wth_20");
	e.innerHTML = _("basic channel width 20");

	e = document.getElementById("basicApply");
	e.value = _("wireless apply");
	e = document.getElementById("basicCancel");
	e.value = _("wireless cancel");
}

function initValue()
{
	var ssidArray;
	var HiddenSSIDArray;
	var channel_11a_index;
	var current_channel_length;
	var radio_off = '<% getCfgZero(1, "RadioOff"); %>';
	var mssidb = "<% getMBSSIDBuilt(); %>";
    var wdth;

	initTranslation();
	if (countrycode == '')
		countrycode = 'NONE';

	document.getElementById("div_11a_channel").style.visibility = "hidden";
	document.getElementById("div_11a_channel").style.display = "none";
	document.wireless_basic.sz11aChannel.disabled = true;
	document.getElementById("div_11b_channel").style.visibility = "hidden";
	document.getElementById("div_11b_channel").style.display = "none";
	document.wireless_basic.sz11bChannel.disabled = true;
	document.getElementById("div_11g_channel").style.visibility = "hidden";
	document.getElementById("div_11g_channel").style.display = "none";
	document.wireless_basic.sz11gChannel.disabled = true;
	document.getElementById("div_n_extChannel").style.visibility = "hidden";
	document.getElementById("div_n_extChannel").style.display = "none";
	document.wireless_basic.sExtChannel.disabled = true;

	PhyMode = 1*PhyMode;

	if (channel_width == '0' && sExtChannel == '0') {
		wdth = 1;
		document.wireless_basic.chn_wth[0].checked = false;
		document.wireless_basic.chn_wth[1].checked = true;
	} else {
		wdth = 0;
		document.wireless_basic.chn_wth[0].checked = true;
		document.wireless_basic.chn_wth[1].checked = false;
	}

	var rfic = '<% getCfgGeneral(1, "RFICType", 1); %>';
	if ((rfic == "2") || (rfic == "4"))
	{
        document.wireless_basic.wirelessmode.options[6] = new Option("11a only", "2");
        document.wireless_basic.wirelessmode.options[7] = new Option("11a/n mixed mode", "8");
        document.wireless_basic.wirelessmode.options[8] = new Option("11n only(5G)", "11");
	}
	if ((PhyMode == 0) || (PhyMode == 4) || (PhyMode == 9) || (PhyMode == 6) || (PhyMode == 7))
	{
		if (PhyMode == 0)
			document.wireless_basic.wirelessmode.options.selectedIndex = 3;
		else if (PhyMode == 4)
			document.wireless_basic.wirelessmode.options.selectedIndex = 1;
		else if (PhyMode == 9)
			document.wireless_basic.wirelessmode.options.selectedIndex = 5;
		else if (PhyMode == 6)
			document.wireless_basic.wirelessmode.options.selectedIndex = 2;
		else if (PhyMode == 7)
			document.wireless_basic.wirelessmode.options.selectedIndex = 4;
		if (PhyMode == 9 || PhyMode == 6 || PhyMode == 7) {
			if (wdth == 0) {
				document.getElementById("div_n_extChannel").style.visibility = "visible";
				document.getElementById("div_n_extChannel").style.display = "";
				document.wireless_basic.sExtChannel.disabled = false;
			}
		}

		document.getElementById("div_11g_channel").style.visibility = "visible";
		document.getElementById("div_11g_channel").style.display = "";
		document.wireless_basic.sz11gChannel.disabled = false;
	}
	else if (PhyMode == 1)
	{
		document.wireless_basic.wirelessmode.options.selectedIndex = 0;
		document.getElementById("div_11b_channel").style.visibility = "visible";
		document.getElementById("div_11b_channel").style.display = "";
		document.wireless_basic.sz11bChannel.disabled = false;
	}
	else if ((PhyMode == 2) || (PhyMode == 8) || (PhyMode == 11))
	{
		if (PhyMode == 2)
			document.wireless_basic.wirelessmode.options.selectedIndex = 6;
		else if (PhyMode == 8) {
			document.wireless_basic.wirelessmode.options.selectedIndex = 7;
			if (wdth == 0) {
				document.getElementById("div_n_extChannel").style.visibility = "visible";
				document.getElementById("div_n_extChannel").style.display = "";
				document.wireless_basic.sExtChannel.disabled = false;
			}
		}
		else if (PhyMode == 11) {
			document.wireless_basic.wirelessmode.options.selectedIndex = 8;
			if (wdth == 0) {
				document.getElementById("div_n_extChannel").style.visibility = "visible";
				document.getElementById("div_n_extChannel").style.display = "";
				document.wireless_basic.sExtChannel.disabled = false;
			}
		}
		document.getElementById("div_11a_channel").style.visibility = "visible";
		document.getElementById("div_11a_channel").style.display = "";
		document.wireless_basic.sz11aChannel.disabled = false;
	}

	for (i=1;i<3;i++)
	{
		var ssid = eval("document.wireless_basic.mssid_"+i+".disabled");
		var div = eval("document.getElementById(\"div_hssid"+i+"\").style");

		div.visibility = "hidden";
		div.display = "none";
		ssid = true;
		document.wireless_basic.hssid[i].disabled = true;
	}
	if (mssidb == "1")
	{
		for (i=1;i<3;i++)
		{
			var ssid = eval("document.wireless_basic.mssid_"+i+".disabled");
			var div = eval("document.getElementById(\"div_hssid"+i+"\").style");

			div.visibility = "visible";
			div.display = "";
			ssid = false;
			document.wireless_basic.hssid[i].disabled = false;
		}
	}

	var HiddenSSIDArray = HiddenSSID.split(";");
	for (i=0;i<3;i++)
	{
		if (HiddenSSIDArray[i] == "1")
			document.wireless_basic.hssid[i].checked = true;
		else
			document.wireless_basic.hssid[i].checked = false;
	}

	var APIsolatedArray = APIsolated.split(";");
	for (i=0;i<3;i++)
	{
		if (APIsolatedArray[i] == "1")
			document.wireless_basic.isolated_ssid[i].checked = true;
		else
			document.wireless_basic.isolated_ssid[i].checked = false;
	}

	channel_index = 1*channel_index;

	if ((PhyMode == 0) || (PhyMode == 4) || (PhyMode == 9) || (PhyMode == 6) || (PhyMode == 7))
	{
		document.wireless_basic.sz11gChannel.options.selectedIndex = channel_index;

		current_channel_length = document.wireless_basic.sz11gChannel.options.length;

		if ((channel_index + 1) > current_channel_length)
			document.wireless_basic.sz11gChannel.options.selectedIndex = 0;
	}
	else if (PhyMode == 1)
	{
		document.wireless_basic.sz11bChannel.options.selectedIndex = channel_index;

		current_channel_length = document.wireless_basic.sz11bChannel.options.length;

		if ((channel_index + 1) > current_channel_length)
			document.wireless_basic.sz11bChannel.options.selectedIndex = 0;
	}
	else if ((PhyMode == 2) || (PhyMode == 8) || (PhyMode == 11))
	{
		if (countrycode == 'NONE')
		{
			if (channel_index <= 64)
			{
				channel_11a_index = channel_index;
				channel_11a_index = channel_11a_index / 4;
				if (channel_11a_index != 0)
					channel_11a_index = channel_11a_index - 8;
			}
			else if ((channel_index >= 100) && (channel_index <= 140))
			{
				channel_11a_index = channel_index;
				channel_11a_index = channel_11a_index / 4;
				channel_11a_index = channel_11a_index - 16;
			}
			else if (channel_index >= 149)
			{
				channel_11a_index = channel_index - 1;
				channel_11a_index = channel_11a_index / 4;
				channel_11a_index = channel_11a_index - 17;
			}
			else
			{
				channel_11a_index = 0;
			}
		}
		else if ((countrycode == 'US') || (countrycode == 'HK') || (countrycode == 'FR') || (countrycode == 'IE'))
		{
			if (channel_index <= 64)
			{
				channel_11a_index = channel_index;
				channel_11a_index = channel_11a_index / 4;
				if (channel_11a_index != 0)
					channel_11a_index = channel_11a_index - 8;
			}
			else if (channel_index >= 149)
			{
				channel_11a_index = channel_index - 1;
				channel_11a_index = channel_11a_index / 4;
				channel_11a_index = channel_11a_index - 28;
			}
			else
			{
				channel_11a_index = 0;
			}
		}
		else if (countrycode == 'JP')
		{
			if (channel_index <= 48)
			{
				channel_11a_index = channel_index;
				channel_11a_index = channel_11a_index / 4;
				if (channel_11a_index != 0)
					channel_11a_index = channel_11a_index - 8;
			}
			else
			{
				channel_11a_index = 0;
			}
		}
		else if (countrycode == 'TW')
		{
			if (channel_index <= 64)
			{
				channel_11a_index = channel_index;
				channel_11a_index = channel_11a_index / 4;
				if (channel_11a_index != 0)
					channel_11a_index = channel_11a_index - 12;
			}
			else if (channel_index >= 149)
			{
				channel_11a_index = channel_index - 1;
				channel_11a_index = channel_11a_index / 4;
				channel_11a_index = channel_11a_index - 32;
			}
			else
			{
				channel_11a_index = 0;
			}
		}
		else if (countrycode == 'CN')
		{
			if (channel_index >= 149)
			{
				channel_11a_index = channel_index - 1;
				channel_11a_index = channel_11a_index / 4;
				channel_11a_index = channel_11a_index - 36;
			}
			else
			{
				channel_11a_index = 0;
			}
		}
		else
		{
			channel_11a_index = 0;
		}

		Check5GBandChannelException();

		if (channel_index > 0)
			document.wireless_basic.sz11aChannel.options.selectedIndex = channel_11a_index;
		else
			document.wireless_basic.sz11aChannel.options.selectedIndex = channel_index;
	}

	//ABG Rate
	if ((PhyMode == 0) || (PhyMode == 2) || (PhyMode == 4))
	{
		ht_mcs = 1*ht_mcs;
		document.wireless_basic.abg_rate.options.length = 0;
		document.wireless_basic.abg_rate.options[0] = new Option(_("basic frequency auto"), "0");
		document.wireless_basic.abg_rate.options[1] = new Option("1 Mbps", "1");
		document.wireless_basic.abg_rate.options[2] = new Option("2 Mbps", "2");
		document.wireless_basic.abg_rate.options[3] = new Option("5.5 Mbps", "5");
		document.wireless_basic.abg_rate.options[4] = new Option("6 Mbps", "6");
		document.wireless_basic.abg_rate.options[5] = new Option("9 Mbps", "9");
		document.wireless_basic.abg_rate.options[6] = new Option("11 Mbps", "11");
		document.wireless_basic.abg_rate.options[7] = new Option("12 Mbps", "12");
		document.wireless_basic.abg_rate.options[8] = new Option("18 Mbps", "18");
		document.wireless_basic.abg_rate.options[9] = new Option("24 Mbps", "24");
		document.wireless_basic.abg_rate.options[10] = new Option("36 Mbps", "36");
		document.wireless_basic.abg_rate.options[11] = new Option("48 Mbps", "48");
		document.wireless_basic.abg_rate.options[12] = new Option("54 Mbps", "54");
		if (fxtxmode == "CCK" || fxtxmode == "cck") {
			if (ht_mcs == 0)
				document.wireless_basic.abg_rate.options.selectedIndex = 1;
			else if (ht_mcs == 1)
				document.wireless_basic.abg_rate.options.selectedIndex = 2;
			else if (ht_mcs == 2)
				document.wireless_basic.abg_rate.options.selectedIndex = 3;
			else if (ht_mcs == 3)
				document.wireless_basic.abg_rate.options.selectedIndex = 6;
			else
				document.wireless_basic.abg_rate.options.selectedIndex = 0;
		}
		else {
			if (ht_mcs == 0)
				document.wireless_basic.abg_rate.options.selectedIndex = 4;
			else if (ht_mcs == 1)
				document.wireless_basic.abg_rate.options.selectedIndex = 5;
			else if (ht_mcs == 2)
				document.wireless_basic.abg_rate.options.selectedIndex = 7;
			else if (ht_mcs == 3)
				document.wireless_basic.abg_rate.options.selectedIndex = 8;
			else if (ht_mcs == 4)
				document.wireless_basic.abg_rate.options.selectedIndex = 9;
			else if (ht_mcs == 5)
				document.wireless_basic.abg_rate.options.selectedIndex = 10;
			else if (ht_mcs == 6)
				document.wireless_basic.abg_rate.options.selectedIndex = 11;
			else if (ht_mcs == 7)
				document.wireless_basic.abg_rate.options.selectedIndex = 12;
			else
				document.wireless_basic.abg_rate.options.selectedIndex = 0;
		}
	}
	else if (PhyMode == 1)
	{
		ht_mcs = 1*ht_mcs;
		document.wireless_basic.abg_rate.options.length = 0;
		document.wireless_basic.abg_rate.options[0] = new Option(_("basic frequency auto"), "0");
		document.wireless_basic.abg_rate.options[1] = new Option("1 Mbps", "1");
		document.wireless_basic.abg_rate.options[2] = new Option("2 Mbps", "2");
		document.wireless_basic.abg_rate.options[3] = new Option("5.5 Mbps", "5");
		document.wireless_basic.abg_rate.options[4] = new Option("11 Mbps", "11");
		if (ht_mcs == 0)
			document.wireless_basic.abg_rate.options.selectedIndex = 1;
		else if (ht_mcs == 1)
			document.wireless_basic.abg_rate.options.selectedIndex = 2;
		else if (ht_mcs == 2)
			document.wireless_basic.abg_rate.options.selectedIndex = 3;
		else if (ht_mcs == 3)
			document.wireless_basic.abg_rate.options.selectedIndex = 4;
		else
			document.wireless_basic.abg_rate.options.selectedIndex = 0;
	}
	else
	{
		document.getElementById("div_abg_rate").style.visibility = "hidden";
		document.getElementById("div_abg_rate").style.display = "none";
		document.wireless_basic.abg_rate.disabled = true;
	}
	if (radio_off == 1)
		document.wireless_basic.radioButton.checked = false;
	else
		document.wireless_basic.radioButton.checked = true;

	txBurst = 1*txBurst;
	if (txBurst == 1)
		document.wireless_basic.tx_burst.checked = true;
	else
		document.wireless_basic.tx_burst.checked = false;

	opmode = 1*opmode;
	apcli = 1*apcli;
	if (opmode == 3 && apcli == 1)
		document.wireless_basic.ap_cli.checked = true;
	else
		document.wireless_basic.ap_cli.checked = false;

	initExtChannel();
	var sExt_select = eval("document.getElementById('sExtChannel')");
	setVle2Elmt(sExt_select, sExtChannel);

	document.getElementById('TRStream').value = TRStream;
	document.getElementById('tx_power').value = tx_power;
	onChgAntenna();

	if (vlan_en == '1') {
		document.wireless_basic.isolated_lan[0].disabled = true;
		document.wireless_basic.isolated_lan[1].disabled = true;
		document.wireless_basic.isolated_lan[2].disabled = true;
	} else {
		var IsolateLanArray = isolated_lan.split(",");
		for (i=0;i<3;i++) {
			if (IsolateLanArray[i] == "1")
				document.wireless_basic.isolated_lan[i].checked = true;
			else
				document.wireless_basic.isolated_lan[i].checked = false;
		}
	}
}

function wirelessModeChange()
{
	var wmode, chn_wth;

	document.getElementById("div_11a_channel").style.visibility = "hidden";
	document.getElementById("div_11a_channel").style.display = "none";
	document.wireless_basic.sz11aChannel.disabled = true;
	document.getElementById("div_11b_channel").style.visibility = "hidden";
	document.getElementById("div_11b_channel").style.display = "none";
	document.wireless_basic.sz11bChannel.disabled = true;
	document.getElementById("div_11g_channel").style.visibility = "hidden";
	document.getElementById("div_11g_channel").style.display = "none";
	document.wireless_basic.sz11gChannel.disabled = true;
	document.getElementById("div_abg_rate").style.visibility = "hidden";
	document.getElementById("div_abg_rate").style.display = "none";
	document.wireless_basic.abg_rate.disabled = true;
	document.getElementById("div_n_extChannel").style.visibility = "hidden";
	document.getElementById("div_n_extChannel").style.display = "none";
	document.wireless_basic.sExtChannel.disabled = true;

	wmode = document.wireless_basic.wirelessmode.options.selectedIndex;
	if (document.wireless_basic.chn_wth[0].checked)
		chn_wth = 0;
	else
		chn_wth = 1;

	wmode = 1*wmode;
	if (wmode == 3)
	{
		document.wireless_basic.wirelessmode.options.selectedIndex = 3;
		document.getElementById("div_11g_channel").style.visibility = "visible";
		document.getElementById("div_11g_channel").style.display = "";
		document.wireless_basic.sz11gChannel.disabled = false;
	}
	else if (wmode == 0)
	{
		document.wireless_basic.wirelessmode.options.selectedIndex = 0;
		document.getElementById("div_11b_channel").style.visibility = "visible";
		document.getElementById("div_11b_channel").style.display = "";
		document.wireless_basic.sz11bChannel.disabled = false;
	}
	else if (wmode == 1)
	{
		document.wireless_basic.wirelessmode.options.selectedIndex = 1;
		document.getElementById("div_11g_channel").style.visibility = "visible";
		document.getElementById("div_11g_channel").style.display = "";
		document.wireless_basic.sz11gChannel.disabled = false;
	}
	else if (wmode == 6)
	{
		document.wireless_basic.wirelessmode.options.selectedIndex = 6;
		document.getElementById("div_11a_channel").style.visibility = "visible";
		document.getElementById("div_11a_channel").style.display = "";
		document.wireless_basic.sz11aChannel.disabled = false;

		Check5GBandChannelException();
	}
	else if ((wmode == 7) || (wmode == 8))
	{
		if (wmode == 7)
			document.wireless_basic.wirelessmode.options.selectedIndex = 7;
		else
			document.wireless_basic.wirelessmode.options.selectedIndex = 8;
		document.getElementById("div_11a_channel").style.visibility = "visible";
		document.getElementById("div_11a_channel").style.display = "";
		document.wireless_basic.sz11aChannel.disabled = false;
		if (chn_wth == 0) {
			document.getElementById("div_n_extChannel").style.visibility = "visible";
			document.getElementById("div_n_extChannel").style.display = "";
			document.wireless_basic.sExtChannel.disabled = false;
		}

		Check5GBandChannelException();
	}
	else if ((wmode == 4) || (wmode == 5) || (wmode == 2))
	{
		if (wmode == 2)
			document.wireless_basic.wirelessmode.options.selectedIndex = 2;
		else if (wmode == 4)
			document.wireless_basic.wirelessmode.options.selectedIndex = 4;
		else
			document.wireless_basic.wirelessmode.options.selectedIndex = 5;
		document.getElementById("div_11g_channel").style.visibility = "visible";
		document.getElementById("div_11g_channel").style.display = "";
		document.wireless_basic.sz11gChannel.disabled = false;
		if (chn_wth == 0) {
			document.getElementById("div_n_extChannel").style.visibility = "visible";
			document.getElementById("div_n_extChannel").style.display = "";
			document.wireless_basic.sExtChannel.disabled = false;
		}
	}

	//ABG Rate
	if ((wmode == 3) || (wmode == 1) || (wmode == 6))
	{
		ht_mcs = 1*ht_mcs;
		document.wireless_basic.abg_rate.options.length = 0;
		document.wireless_basic.abg_rate.options[0] = new Option(_("basic frequency auto"), "0");
		document.wireless_basic.abg_rate.options[1] = new Option("1 Mbps", "1");
		document.wireless_basic.abg_rate.options[2] = new Option("2 Mbps", "2");
		document.wireless_basic.abg_rate.options[3] = new Option("5.5 Mbps", "5");
		document.wireless_basic.abg_rate.options[4] = new Option("6 Mbps", "6");
		document.wireless_basic.abg_rate.options[5] = new Option("9 Mbps", "9");
		document.wireless_basic.abg_rate.options[6] = new Option("11 Mbps", "11");
		document.wireless_basic.abg_rate.options[7] = new Option("12 Mbps", "12");
		document.wireless_basic.abg_rate.options[8] = new Option("18 Mbps", "18");
		document.wireless_basic.abg_rate.options[9] = new Option("24 Mbps", "24");
		document.wireless_basic.abg_rate.options[10] = new Option("36 Mbps", "36");
		document.wireless_basic.abg_rate.options[11] = new Option("48 Mbps", "48");
		document.wireless_basic.abg_rate.options[12] = new Option("54 Mbps", "54");
		if (fxtxmode == "CCK" || fxtxmode == "cck") {
			if (ht_mcs == 0)
				document.wireless_basic.abg_rate.options.selectedIndex = 1;
			else if (ht_mcs == 1)
				document.wireless_basic.abg_rate.options.selectedIndex = 2;
			else if (ht_mcs == 2)
				document.wireless_basic.abg_rate.options.selectedIndex = 3;
			else if (ht_mcs == 3)
				document.wireless_basic.abg_rate.options.selectedIndex = 6;
			else
				document.wireless_basic.abg_rate.options.selectedIndex = 0;
		}
		else {
			if (ht_mcs == 0)
				document.wireless_basic.abg_rate.options.selectedIndex = 4;
			else if (ht_mcs == 1)
				document.wireless_basic.abg_rate.options.selectedIndex = 5;
			else if (ht_mcs == 2)
				document.wireless_basic.abg_rate.options.selectedIndex = 7;
			else if (ht_mcs == 3)
				document.wireless_basic.abg_rate.options.selectedIndex = 8;
			else if (ht_mcs == 4)
				document.wireless_basic.abg_rate.options.selectedIndex = 9;
			else if (ht_mcs == 5)
				document.wireless_basic.abg_rate.options.selectedIndex = 10;
			else if (ht_mcs == 6)
				document.wireless_basic.abg_rate.options.selectedIndex = 11;
			else if (ht_mcs == 7)
				document.wireless_basic.abg_rate.options.selectedIndex = 12;
			else
				document.wireless_basic.abg_rate.options.selectedIndex = 0;
		}

		document.getElementById("div_abg_rate").style.visibility = "visible";
		document.getElementById("div_abg_rate").style.display = "";
		document.wireless_basic.abg_rate.disabled = false;
	}
	else if (wmode == 0)
	{
		ht_mcs = 1*ht_mcs;
		document.wireless_basic.abg_rate.options.length = 0;
		document.wireless_basic.abg_rate.options[0] = new Option(_("basic frequency auto"), "0");
		document.wireless_basic.abg_rate.options[1] = new Option("1 Mbps", "1");
		document.wireless_basic.abg_rate.options[2] = new Option("2 Mbps", "2");
		document.wireless_basic.abg_rate.options[3] = new Option("5.5 Mbps", "5");
		document.wireless_basic.abg_rate.options[4] = new Option("11 Mbps", "11");
		if (ht_mcs == 0)
			document.wireless_basic.abg_rate.options.selectedIndex = 1;
		else if (ht_mcs == 1)
			document.wireless_basic.abg_rate.options.selectedIndex = 2;
		else if (ht_mcs == 2)
			document.wireless_basic.abg_rate.options.selectedIndex = 3;
		else if (ht_mcs == 3)
			document.wireless_basic.abg_rate.options.selectedIndex = 4;
		else
			document.wireless_basic.abg_rate.options.selectedIndex = 0;

		document.getElementById("div_abg_rate").style.visibility = "visible";
		document.getElementById("div_abg_rate").style.display = "";
		document.wireless_basic.abg_rate.disabled = false;
	}
}

function onChgAntenna()
{
	if (document.getElementById('TRStream').value == '1')
		document.getElementById('atnArea').style.display = '';
	else
		document.getElementById('atnArea').style.display = 'none';
}

function CheckValue()
{
	var submit_ssid_num;
	var mac;
	//var re = /[A-Fa-f0-9]{2}:[A-Fa-f0-9]{2}:[A-Fa-f0-9]{2}:[A-Fa-f0-9]{2}:[A-Fa-f0-9]{2}:[A-Fa-f0-9]{2}/;

	var re = /^[\w|\-|\s]+$/;

	if (document.wireless_basic.ssid.value == "")
	{
		alert(_("msg ssid input"));
		document.wireless_basic.ssid.focus();
		document.wireless_basic.ssid.select();
		return false;
	}
	if (!re.test(document.wireless_basic.ssid.value)) {
		alert(_("msg ssid format"));
		document.wireless_basic.ssid.focus();
		document.wireless_basic.ssid.select();
    	return false;
	}
	submit_ssid_num = 1;

	if (document.wireless_basic.mssid_2.value != "" && document.wireless_basic.mssid_1.value == "") {
		alert(_("msg ssid2"));
		document.wireless_basic.mssid_1.focus();
		document.wireless_basic.mssid_1.select();
		return false;
	}

	for (i = 1; i < 3; i++)
	{
		if (eval("document.wireless_basic.mssid_"+i).value != "") {
			if (!re.test(eval("document.wireless_basic.mssid_"+i).value)) {
				alert(_("msg ssid format"));
				eval("document.wireless_basic.mssid_"+i).focus();
				eval("document.wireless_basic.mssid_"+i).select();
		    	return false;
			}
			submit_ssid_num++;
		}
	}

	document.wireless_basic.bssid_num.value = submit_ssid_num;

	if (confirm(_("msg lan connection lost")))
		return true;
	else
		return false;
}
</script>
</head>

<body onLoad="initValue()">
<table class="body">
<tr><td>
<h1 id="basicTitle">General Setup</h1>
<hr size="1" />
<br />

<form method="post" name="wireless_basic" action="/goform/wirelessBasic" onSubmit="return CheckValue()">

<div>
<h2 id="basicWirelessNet" class="title">General Setting ( IEEE 802.11 )</h2>
<table width="100%" cellpadding="2" cellspacing="1" class="config">
<tr>
  <td>
    <table width="100%" cellspacing="0" cellpadding="2" border="0" align="center">
      <tr>
        <td colspan="2">
          <input type="checkbox" name="radioButton" />
          <span id="basicWirelessEnable">Enable Wireless LAN</span>
        </td>
      </tr>
    </table>
    <table width="600" cellspacing="0" cellpadding="2" border="0" align="center">
      <tr>
        <td class="head" id="basicNetMode">Mode :</td>
        <td>
	      <select name="wirelessmode" id="wirelessmode" size="1" onChange="wirelessModeChange()">
	        <option value=1>11b Only</option>
	        <option value=4>11g Only</option>
	        <option value=6>11n Only</option>
	        <option value=0>Mixed(11b+11g)</option>
			<option value=7>Mixed(11g+11n)</option>
	        <option value=9>Mixed(11b+11g+11n)</option>
	      </select>
        </td>
      </tr>
    </table>
    <input type="hidden" name="bssid_num" value="1">
	<table width="600" cellspacing="0" cellpadding="0" border="0" align="center">
	  <tr><td colspan="6"><hr size="1"/></td></tr>
	  <tr>
	    <td width="5%" height="25"></td>
	    <td width="15%" align="center" id="basicHideSSID">Hide SSID</td>
	    <td width="45%" align="center" id="basicSSID">SSID</td>
	    <td width="15%" align="center" id="basicIsolatedLan">Isolate LAN</td>
	    <td width="20%" align="center" id="basicIsolatedSSID">Isolate Member</td>
	  </tr>
	  <tr>
	    <td height="25" align="center">1</td>
	    <td align="center"><input type="checkbox" name="hssid" value="0" /></td>
	    <td align="center"><input type="text" name="ssid" size="30" maxlength="32" value="<% getCfgGeneral(1, "SSID1", 0); %>" /></td>
	    <td align="center"><input type="checkbox" name="isolated_lan" value="0" /></td>
	    <td align="center"><input type="checkbox" name="isolated_ssid" value="0" /></td>
	  </tr>
	  <tr id="div_hssid1">
	    <td height="25" align="center">2</td>
	    <td align="center"><input type="checkbox" name="hssid" value="1" /></td>
	    <td align="center">
	      <input type="text" name="mssid_1" size="30" maxlength="32" value="<% getCfgGeneral(1, "SSID2", 0); %>" />
	    </td>
	    <td align="center"><input type="checkbox" name="isolated_lan" value="1" /></td>
	    <td align="center"><input type="checkbox" name="isolated_ssid" value="1" /></td>
	  </tr>
	  <tr id="div_hssid2">
	    <td height="25" align="center">3</td>
	    <td align="center"><input type="checkbox" name="hssid" value="2" /></td>
	    <td align="center"> <input type="text" name="mssid_2" size="30" maxlength="32" value="<% getCfgGeneral(1, "SSID3", 0); %>" /></td>
	    <td align="center"><input type="checkbox" name="isolated_lan" value="2" /></td>
	    <td align="center"><input type="checkbox" name="isolated_ssid" value="2" /></td>
	  </tr>
	</table>
	<br />
	<table width="600" cellspacing="0" cellpadding="0" border="0" align="center">
	  <tr>
	    <td class="title" width="120"><span id="basicHssidTitle">Hide SSID</span>:</td>
	    <td><span id="basicHssidIntro">Prevent SSID from being scanned</span>.</td>
	  </tr>
	  <tr>
	    <td class="title" valign="top"><span id="basicIsolateTitle">Isolate Member</span>:</td>
	    <td><span id="basicIsolateIntro">Wireless clients (stations) with the same SSID cannot access for each other</span>.</td>
	  </tr>
	  <tr>
	  	<td class="title"><span id="basicSSID4Title">SSID4</span>:</td>
	    <td><span id="basicSSID4Intro">Reserved for Universal Repeater mode so it's not listed</span>.</td>
	  </tr>
	  <tr>
	    <td class="title" valign="top"><span id="basicIsolateLANTitle">Isolate LAN</span>:</td>
	    <td><span id="basicIsolateLANIntro">Wireless clients (stations) with the same SSID cannot access wired PCs on LAN. If Multi-VLAN function is enabled, this function can't be used</span>.</td>
	  </tr>

	  <tr><td colspan="2"><hr size="1"/></td></tr>
	</table>
	<table width="600" cellspacing="1" cellpadding="2" border="0" align="center">
	  <tr id="div_11a_channel" name="div_11a_channel">
	    <td class="head"><font id="basicFreqA">Channel :</font></td>
	    <td>
	      <select id="sz11aChannel" name="sz11aChannel" size="1">
		<option value=0 id="basicFreqAAuto">AutoSelect</option>
		<% getWlan11aChannels(); %>
	      </select>
	    </td>
	  </tr>
	  <tr id="div_11b_channel" name="div_11b_channel">
	    <td class="head"><font id="basicFreqB">Channel :</font></td>
	    <td>
	      <select id="sz11bChannel" name="sz11bChannel" size="1">
		<option value=0 id="basicFreqBAuto">AutoSelect</option>
		<% getWlan11bChannels(); %>
	      </select>
	    </td>
	  </tr>
	  <tr id="div_11g_channel" name="div_11g_channel">
	    <td class="head"><font id="basicFreqG">Channel :</font></td>
	    <td>
	      <select id="sz11gChannel" name="sz11gChannel" size="1" onchange="initExtChannel()">
		<option value=0 id="basicFreqGAuto">AutoSelect</option>
		<% getWlan11gChannels(); %>
	      </select>
	    </td>
	  </tr>
	  <tr id="div_abg_rate">
	    <td class="head"><font id="basicRate">Rate :</font></td>
	    <td><select name="abg_rate" size="1"></select></td>
	  </tr>
	  <tr id="div_n_extChannel" name="div_n_extChannel">
	    <td class="head"><font id="basicExtChn">Extension Channel :</font></td>
	    <td><select id="sExtChannel" name="sExtChannel" size="1"></select>
	    </td>
	  </tr>
	  <tr><td colspan="2"><hr size="1" /></td></tr>
	</table>
	<table width="600" cellspacing="0" cellpadding="0" border="0" align="center">
	  <tr><td>
	    <table width="600" cellspacing="0" cellpadding="0" border="0">
	      <tr><td height="25" id="basicPkt">Packet-OVERDRIVE</td></tr>
	      <tr><td height="25">
	        <input type="checkbox" name="tx_burst"/><span id="basicPktTxBurst">Tx Burst</span></td>
	      </tr>
	      <tr><td height="25" class="title" id="basicPktNote">Note :</td></tr>
	      <tr>
	        <td height="25" id="basicPktStr1">1.Tx Burst only supports 11g mode.</td>
	      </tr>
	      <tr>
	        <td height="25" id="basicPktStr2">2.The same technology must also be supported in clients to boost WLAN performance.</td>
	      </tr>
	    </table>
	  </td></tr>
	  <tr><td><hr size="1" /></td></tr>
	</table>

	<table width="600" cellspacing="0" cellpadding="0" border="0" align="center">
	  <tr><td>
	    <table width="600" cellspacing="0" cellpadding="0" border="0">
	      <tr><td height="25" id="basicUR">Universal Repeater</td></tr>
	      <tr><td height="25">
	        <input type="checkbox" name="ap_cli"/><span id="basicUREnable">Enable</span></td>
	      </tr>
	      <tr><td height="25" class="title" id="basicURNote">Note :</td></tr>
	      <tr>
	        <td height="25" id="basicURStr">If Universal Repeater is enabled, one additional wireless interface is treated as WAN port. The wireless AP interface and the ethernet ports are LAN ports.</td>
	      </tr>
	    </table>
	  </td></tr>
	</table>

	<table width="600" cellspacing="1" cellpadding="2" border="0" align="center">
	  <tr><td colspan="2"><hr size="1" /></td></tr>
	  <tr>
	    <td class="head" id="bscAntenna">Antenna :</td>
	    <td>
	      <select id="TRStream" name="TRStream" onChange="onChgAntenna()" style="width:64px">
		    <option value=2>2T2R</option>
		    <option value=1>1T1R</option>
	      </select>
	      <span id="atnArea"><span id="basicNote">Note :</span>&nbsp;<span id="TRNote">1T1R would use the right antenna.</span></span>
	    </td>
	  </tr>
	  <tr>
	    <td class="head" id="bscTxPower" style="width:64px">Tx Power :</td>
	    <td>
	      <select id="tx_power" name="tx_power">
	      	<option value=100>100%</option>
	      	<option value=80>80%</option>
	      	<option value=60>60%</option>
	      	<option value=30>30%</option>
	      	<option value=20>20%</option>
	      	<option value=10>10%</option>
	      </select>
	    </td>
	  </tr>
	  <tr>
	    <td class="head" id="bscChnWth" style="width:64px">Channel Width :</td>
	    <td><input type="radio" id="chn_wth" name="chn_wth" value=0 onclick="wirelessModeChange()">
	    	<span id="chn_wth_auto">Auto 20/40MHZ</span>&nbsp;
	    	<input type="radio" id="chn_wth" name="chn_wth" value=1 onclick="wirelessModeChange()">
	    	<span id="chn_wth_20">20MHZ</span>
	    </td>
	  </tr>
	</table>

  </td>
</tr>
</table>
</div>
<br />

<table width = "100%" border = "0" cellpadding = "2" cellspacing = "1">
  <tr align="center">
    <td>
      <input type=submit class="btnw" value="OK" id="basicApply"> &nbsp; &nbsp;
      <input type=reset  class="btnw" value="Cancel" id="basicCancel" onClick="window.location.reload()">
    </td>
  </tr>
</table>
</form>

</td></tr>
</table>

</body>
</html>
<script type="text/javascript" src="/dtree/tool.js"></script>
<script type="text/javascript" src="/jquery.js"></script>
<script>
	var _fw_upgrade_notify	='<% getCfgGeneral(1, "fw_upgrade_notify", 1); %>';
	var _aryInfo = [<% getUpgradeInfo(); %>];// [0]:exit new fw  [1]:ver
	var _curt_ver = '<% getSdkVersion(); %>';
	var _lanIP = '<% getLanIp(); %>';
	fw_urpgrade_auto_detect(_fw_upgrade_notify,_aryInfo,_curt_ver,_lanIP);
</script>