<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN">
<html>
<head>
<meta http-equiv="X-UA-Compatible" content="IE=EmulateIE7" />
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta http-equiv="Pragma" Content="No-cach">
<meta http-equiv="Expires" Content="-1">
<link rel="stylesheet" href="/style/normal_ws.css" type="text/css">
<link rel="stylesheet" type="text/css" media="screen" href="/jg/canvaschart.css" />
<script type="text/javascript" src="/jquery.js"></script>
<script type="text/javascript" src="/jg/chart.js"></script>
<script type="text/javascript" src="/jg/wz_jsgraphics.js"></script>
<script type="text/javascript" src="/jg/jgchartpainter.js"></script>
<script type="text/javascript" src="/jg/canvaschartpainter.js"></script>
<script type="text/javascript" src="/lang/b28n.js"></script>
<script type="text/javascript" src="/dtree/tool.js"></script>
<script type="text/javascript">
Butterlate.setTextDomain("admin");

var bg = parent;
var now = new Date();
var nowdt = now.getDate();
var nowhh = now.getHours();
var nowmm = now.getMinutes();
var aryLables = new Array();
var aryDay = ["(SU)", "(M)", "(TU)", "(W)", "(TH)", "(F)", "(SA)"];
var POINTS_NUM = 361;	// 361 points always.

var aryWan1Tx = new Array(POINTS_NUM);
var aryWan1Rx = new Array(POINTS_NUM);
var aryWan2Tx = new Array(POINTS_NUM);
var aryWan2Rx = new Array(POINTS_NUM);
var aryWan1TxWeekly = new Array(POINTS_NUM);
var aryWan1RxWeekly = new Array(POINTS_NUM);
var aryWan2TxWeekly = new Array(POINTS_NUM);
var aryWan2RxWeekly = new Array(POINTS_NUM);
var arySession = new Array(POINTS_NUM);
var arySessionWeekly = new Array(POINTS_NUM);

for (var i=0; i<361; i++) {
	aryWan1Tx[i] = 0;
	aryWan1Rx[i] = 0;
	aryWan2Tx[i] = 0;
	aryWan2Rx[i] = 0;
	aryWan1TxWeekly[i] = 0;
	aryWan1RxWeekly[i] = 0;
	aryWan2TxWeekly[i] = 0;
	aryWan2RxWeekly[i] = 0;
	arySession[i] = 0;
	arySessionWeekly[i] = 0;
}

$(function(){
	if (nowhh < 10) nowhh = "0" + nowhh;
	if (nowmm < 10) nowmm = "0" + nowmm;
	$('[name=sltMode]').val(bg.iTrGraphMode);
	$('[name=sltTime]').val(bg.iTrGraphTime);
	$('[name=sltRefreshTime]').val(bg.iTrGraphRefTime);
	initTranslation();
	loadXMLDoc("POST", "/goform/trGraphRecord", graphUpdate, "n/a");
});

function graphUpdate(req)
{
	parseAllData(req.responseText);
	onChgMode();
	onChgTime();
}

function parseAllData(str)
{
	var fileds = str.split("|");
	record_daily = fileds[0] || '0,0,0,0,0';
	record_weekly = fileds[1] || '0,0,0,0,0';

	initPoints();
}

function initPoints()
{
	var data, i, n, e, e_old, wan1_tx, wan1_rx, wan2_tx, wan2_rx;

	data = record_daily.split('\n');

	for (i=data.length-1, n=360; i>=0 && n>=0; i--) {
		e = data[i].split(',');
		if (e.length != 5)
			continue;
		if (i == 0) {
			wan1_tx = 0;
			wan1_rx = 0;
			wan2_tx = 0;
			wan2_rx = 0;
		} else {
			e_old = data[i-1].split(',');
			if (e_old.length != 5)
				continue;
			if (parseInt(e[0]) < parseInt(e_old[0]))
				wan1_tx = parseInt(e[0]);
			else
				wan1_tx = parseInt(e[0]) - parseInt(e_old[0]);
			if (parseInt(e[1]) < parseInt(e_old[1]))
				wan1_rx = parseInt(e[1]);
			else
				wan1_rx = parseInt(e[1]) - parseInt(e_old[1]);
			if (parseInt(e[2]) < parseInt(e_old[2]))
				wan2_tx = parseInt(e[2]);
			else
				wan2_tx = parseInt(e[2]) - parseInt(e_old[2]);
			if (parseInt(e[3]) < parseInt(e_old[3]))
				wan2_rx = parseInt(e[3]);
			else
				wan2_rx = parseInt(e[3]) - parseInt(e_old[3]);
		}
		aryWan1Tx[n] = Math.floor(wan1_tx/32768);
		aryWan1Rx[n] = Math.floor(wan1_rx/32768);
		aryWan2Tx[n] = Math.floor(wan2_tx/32768);
		aryWan2Rx[n] = Math.floor(wan2_rx/32768);
		arySession[n] = parseInt(e[4]);
		n--;
	}

	data = record_weekly.split('\n');

	for (i=data.length-1, n=360; i>=0 && n>=0; i--) {
		e = data[i].split(',');
		if (e.length != 5)
			continue;
		if (i == 0) {
			wan1_tx = 0;
			wan1_rx = 0;
			wan2_tx = 0;
			wan2_rx = 0;
		} else {
			e_old = data[i-1].split(',');
			if (e_old.length != 5)
				continue;
			if (parseInt(e[0]) < parseInt(e_old[0]))
				wan1_tx = parseInt(e[0]);
			else
				wan1_tx = parseInt(e[0]) - parseInt(e_old[0]);
			if (parseInt(e[1]) < parseInt(e_old[1]))
				wan1_rx = parseInt(e[1]);
			else
				wan1_rx = parseInt(e[1]) - parseInt(e_old[1]);
			if (parseInt(e[2]) < parseInt(e_old[2]))
				wan2_tx = parseInt(e[2]);
			else
				wan2_tx = parseInt(e[2]) - parseInt(e_old[2]);
			if (parseInt(e[3]) < parseInt(e_old[3]))
				wan2_rx = parseInt(e[3]);
			else
				wan2_rx = parseInt(e[3]) - parseInt(e_old[3]);
		}
		aryWan1TxWeekly[n] = Math.floor(wan1_tx/32768);
		aryWan1RxWeekly[n] = Math.floor(wan1_rx/32768);
		aryWan2TxWeekly[n] = Math.floor(wan2_tx/32768);
		aryWan2RxWeekly[n] = Math.floor(wan2_rx/32768);
		arySessionWeekly[n] = parseInt(e[4]);
		n--;
	}
}

function initTranslation()
{
	$('#gTitle').html(_("parent diagonostics")+" >> "+_("traffic graph title"));
	$('#showchart').html(_("connection graph show chart"));
	$('#optWan1').html(_("traffic graph mode wan1"));
	$('#optWan2').html(_("traffic graph mode wan2"));
	$('#optSession').html(_("traffic graph mode session"));
	$('#optDaily').html(_("connection graph time daily"));
	$('#optWeekly').html(_("connection graph time weekly"));
	$('#refTime').html(_("connection graph refresh time"));
	$('#arefresh').html(_("admin refresh"));
}

function initLabels(_time)
{
	var time = _time;
	aryLables = [];
	if (time == 0) {		//Daily
		for (i=30,j=0; i>=0; i--) {
			if (i%6 == 0) {
				tmp = (nowhh - j*6);
				if(tmp < 0)
					tmp = tmp + 24;
				aryLables[i] = tmp + ':' + nowmm;
				j++;
			} else
				aryLables[i] = "";
		}
	} else if (time == 1) {	//Weekly
		tmp = new Date();
		tmpdt = nowdt;
		for (i=15; i>=0; i--) {
			if (i == 15)
				aryLables[i] = nowhh + ':' + nowmm;
			else if (i%2 == 1) {
				tmp.setDate(tmpdt - 1);
				tmpmth = tmp.getMonth()+1;
				tmpdt = tmp.getDate();
				tmpday = tmp.getDay();
				aryLables[i] = tmpmth + '/' + tmpdt + aryDay[tmpday];
			} else
				aryLables[i] = "";
		}
	}
}

function showChart(_idx, _time)
{
	var idx = _idx;
	var time = _time;
	var c = new Chart(document.getElementById('chart'));
	c.setDefaultType(CHART_LINE);
	c.setGridDensity(aryLables.length, 11);
	c.setHorizontalLabels(aryLables);
	c.setVerticalRange(0, 0);
	c.setShowLegend(true);
	var showColor, aryShow;
	if (idx == 0) {
		showColor = '#EECC66';
		if (time == 0)
			aryShow = aryWan1Tx;
		else if (time == 1)
			aryShow = aryWan1TxWeekly;
		c.add('TX (Kbps)', showColor, aryShow);
		showColor = '#00CC00';
		if (time == 0)
			aryShow = aryWan1Rx;
		else if (time == 1)
			aryShow = aryWan1RxWeekly;
		c.add('RX (Kbps)', showColor, aryShow);
	} else if (idx == 1) {
		showColor = '#EECC66';
		if (time == 0)
			aryShow = aryWan2Tx;
		else if (time == 1)
			aryShow = aryWan2TxWeekly;
		c.add('TX (Kbps)', showColor, aryShow);
		showColor = '#00CC00';
		if (time == 0)
			aryShow = aryWan2Rx;
		else if (time == 1)
			aryShow = aryWan2RxWeekly;
		c.setShowLegend(true);
		c.add('RX (Kbps)', showColor, aryShow);
	} else if (idx == 2) {
		showColor = '#EECC66';
		if (time == 0)
			aryShow = arySession;
		else if (time == 1)
			aryShow = arySessionWeekly;
		c.add(_("traffic graph mode session"), showColor, aryShow);
	}
	c.draw();
}

function onChgMode()
{
	var mode = $('[name=sltMode]').val();
	var time = $('[name=sltTime]').val();
	if(mode && time) {
		bg.iTrGraphMode = mode;
		bg.iTrGraphTime = time;
		initLabels(time);
		showChart(mode, time);
	}
}

function onChgTime()
{
	var refresh;
	var ref = $('[name=sltRefreshTime]').val();
	if (ref) {
		bg.iTrGraphRefTime = ref;
		clearTimeout(refresh);
		refresh = setTimeout(onRefresh, ref);
	}
}

function onRefresh()
{
	var mode = $('[name=sltMode]').val();
	var time = $('[name=sltTime]').val();
	if (mode && time) {
		bg.iTrGraphMode = mode;
		bg.iTrGraphTime = time;
	}
	document.location = "/adm/trgraph.asp";
}
</script>
</head>

<body>
<table class="body">
<tr><td>
<h1 id="gTitle">Traffic Graph</h1>
<hr size="1" />
<br />

<div>
  <table width="100%" cellpadding="0" cellspacing="0" border="0" style="margin-bottom:2px">
    <tr>
      <td>
        <span id="showchart">Show Chart:</span>&nbsp;
        <select name="sltMode" size="1" onChange=onChgMode()>
          <option id="optWan1" value="0">WAN1 Bandwidth</option>
          <option id="optWan2" value="1">WAN2 Bandwidth</option>
          <option id="optSession" value="2">Sessions</option>
        </select>&nbsp;
        <select name="sltTime" size="1" onChange=onChgMode()>
          <option id="optDaily" value="0">Daily</option>
          <option id="optWeekly" value="1">Weekly</option>
        </select>
      </td>
      <td align=right>
        <span id="refTime">Refresh Min(s):</span>&nbsp;
        <select name="sltRefreshTime" size="1" onChange=onChgTime()>
          <option value="300000">5</option>
          <option value="600000">10</option>
          <option value="1800000">30</option>
        </select>
      </td>
      <td class=red align=right>|&nbsp;<a href="javascript: onRefresh()" id="arefresh">Refresh</a>&nbsp;|</td>
    </tr>
  </table>

  <div id="chart" class="chart" style="width: 700px; height: 300px;"></div>
</div>

</td></tr>
</table>

</body>
</html>
<script type="text/javascript" src="/dtree/tool.js"></script>
<script type="text/javascript" src="/jquery.js"></script>
<script>
	var _fw_upgrade_notify	='<% getCfgGeneral(1, "fw_upgrade_notify", 1); %>';
	var _aryInfo = [<% getUpgradeInfo(); %>];// [0]:exit new fw  [1]:ver
	var _curt_ver = '<% getSdkVersion(); %>';
	var _lanIP = '<% getLanIp(); %>';
	fw_urpgrade_auto_detect(_fw_upgrade_notify,_aryInfo,_curt_ver,_lanIP);
</script>
