#ifndef __IP_SET_PROTOCOL_H
#define __IP_SET_PROTOCOL_H

#include <linux/netfilter_ipv4/ip_set.h>
#include <linux/netfilter_ipv4/ip_set_bitmaps.h>

#define SUPPORT_BPJM 		1
#define BPJM_TEST			0

#define SETTYPE_NAME		"webcategory"

#define WEBCATEGORY_BLACK_NONE 0
#define WEBCATEGORY_ADVERTISEMENT_AND_POP_UPS 1
#define WEBCATEGORY_ALCOHOL_AND_TOBACCO 2
#define WEBCATEGORY_ANONYMIZERS 3
#define WEBCATEGORY_ARTS 4
#define WEBCATEGORY_BUSINESS 5
#define WEBCATEGORY_TRANSPORTATION 6
#define WEBCATEGORY_CHAT 7
#define WEBCATEGORY_FORUMS_AND_NEWSGROUPS 9
#define WEBCATEGORY_COMPROMISED 10
#define WEBCATEGORY_COMPUTERS_AND_TECHNOLOGY 11
#define WEBCATEGORY_CRIMINAL_AND_ACTIVITY 12
#define WEBCATEGORY_DATING_AND_PERSONALS 13
#define WEBCATEGORY_DOWN_SITES 14
#define WEBCATEGORY_EDUCATION 15
#define WEBCATEGORY_ENTERTAINMENT 16
#define WEBCATEGORY_FINANCE 17
#define WEBCATEGORY_GAMBLING 18
#define WEBCATEGORY_GAMES 19
#define WEBCATEGORY_GOVERNMENT 20
#define WEBCATEGORY_HATE_AND_INTOLERANCE 21
#define WEBCATEGORY_HEALTH_AND_MEDICINE 22
#define WEBCATEGORY_ILLEGAL_DRUG 23
#define WEBCATEGORY_JOB_SEARCH 24
#define WEBCATEGORY_STREAMING_MEDIA_AND_DOWNLOADS 26
#define WEBCATEGORY_NEWS 27
#define WEBCATEGORY_NON_PROFITS_AND_NGOS 28
#define WEBCATEGORY_NUDITY 29
#define WEBCATEGORY_PERSONAL_SITES 30
#define WEBCATEGORY_PHISHING_AND_FRAUD 31
#define WEBCATEGORY_POLITICS 32
#define WEBCATEGORY_PORNOGRAPHY_AND_SEXUALLY_EXPLICIT 33
#define WEBCATEGORY_REAL_ESTATE 34
#define WEBCATEGORY_RELIGION 35
#define WEBCATEGORY_RESTAURANTS_AND_DINING 36
#define WEBCATEGORY_SEARCH_ENGINES_AND_PORTALS 37
#define WEBCATEGORY_SHOPPING 38
#define WEBCATEGORY_SOCIAL_NETWORKING 39
#define WEBCATEGORY_SPAM_SITES 40
#define WEBCATEGORY_SPORTS 41
#define WEBCATEGORY_MALWARE 42
#define WEBCATEGORY_TRANSLATORS 44
#define WEBCATEGORY_TRAVEL 45
#define WEBCATEGORY_VIOLENCE 46
#define WEBCATEGORY_WEAPONS 47
#define WEBCATEGORY_WEB_BASED_EMAIL 48
#define WEBCATEGORY_GENERAL 49
#define WEBCATEGORY_LEISURE_AND_RECREATION 50
#define WEBCATEGORY_BOTNETS 61
#define WEBCATEGORY_CULTS 62
#define WEBCATEGORY_FASHION_AND_BEAUTY 63
#define WEBCATEGORY_GREETING_CARDS 64
#define WEBCATEGORY_HACKING 65
#define WEBCATEGORY_ILLEGAL_SOFTWARES 67
#define WEBCATEGORY_IMAGE_SHARING 68
#define WEBCATEGORY_INFORMATION_SECURITY 69
#define WEBCATEGORY_INSTANT_MESSAGING 70
#define WEBCATEGORY_NETWORK_ERRORS 71
#define WEBCATEGORY_PARKED_DOMAINS 72
#define WEBCATEGORY_PEER_TO_PEER 73
#define WEBCATEGORY_PRIVATE_IP_ADDRESS 74
#define WEBCATEGORY_SCHOOL_CHEATING 75
#define WEBCATEGORY_SEX_EDUCATION 76
#define WEBCATEGORY_TASTELESS 77
#define WEBCATEGORY_CHILD_ABUSE_IMAGES 78
#define WEBCATEGORY_UNCATEGORISED_SITES 79
#if SUPPORT_BPJM
#define WEBCATEGORY_YOUTH_PROTECTION 82
#define WEBCATEGORY_MAX 83
#else
#define WEBCATEGORY_MAX 80
#endif

char *category_name[] = {
"None", "Advertisement-and-pop-ups", "Alcohol-and-tobacco", "Anonymizers", "Arts", //0~4
"Business", "Transportation", "Chat", "", "Forums-and-newsgroups", //5~9
"Compromised", "Computers_and_technology", "Criminal-and-activity", "Dating-and-personals", "Down-sites", //10~14
"Education", "Entertainment", "Finance", "Gambling", "Games", //15~19
"Government", "Hate-and-intolerance", "Health-and-medicine", "Illegal-drug", "Job-search", //20~24
"", "Streaming-media-and-downloads", "News", "Non-profits-and-ngos", "Nudity", //25~29
"Personal-sites", "Phishing-and-fraud", "Politics", "Pornography-and-sexually-explicit", "Real-estate", //30~34
"Religion", "Restaurants-and-dining", "Search-engines-and-portals", "Shopping", "Social-networking", //35~39
"Spam-sites", "Sports", "Malware", "", "Translators", //40~44
"Travel", "Violence", "Weapons", "Web-based-email", "General", //45~49
"Leisure_and_recreation", "", "", "", "", //50~54
"", "", "", "", "", //55~59
"", "Botnets", "Cults", "Fashion-and-beauty", "Greeting-cards", //60~64
"Hacking", "", "Illegal-softwares", "Image-sharing", "Information-security", //65~69
"Instant-messaging", "Network-errors", "Parked-domains", "Peer-to-peer", "Private-ip-address", //70~74
"School-cheating", "Sex-education", "Tasteless", "Child-abuse-images", "Uncategorised-sites", //75~79
#if SUPPORT_BPJM
"","","Youth-Protection", //80~82
#endif
}; 

#define WEBCATEGORY_FROM 0
#define WEBCATEGORY_TO WEBCATEGORY_MAX-1
#define WEBCATEGORY_NUM WEBCATEGORY_MAX

struct ip_set_webcategory {
	void *members;			/* the protocol proper */
	ip_set_ip_t first_ip;		/* host byte order, included in range */
	ip_set_ip_t last_ip;		/* host byte order, included in range */
	u_int32_t size;			/* size of the __IP_SET_PROTOCOL_H proper */
};

struct ip_set_req_webcategory_create {
	ip_set_ip_t from;
	ip_set_ip_t to;
};

struct ip_set_req_webcategory {
	ip_set_ip_t ip;
};

#define PROVIDER_COMMTOUCH 1
#define PROVIDER_BPJM 	   2

#define COMMTOUCH_WARNING_MSG_PATH "/etc_ro/web/lang/ct_warning"
#define BPJM_WARNING_MSG_PATH "/etc_ro/web/lang/bpjm_warning"

#endif /* __IP_SET_PROTOCOL_H */
