#!/bin/sh

alert() {

	USERNAME=$(nvram_get 2860 ML_User)
	PASSWORD=$(nvram_get 2860 ML_PW)
	SERVER=$(nvram_get 2860 ML_SmtpServer)
	TO=$(nvram_get 2860 ML_To)
	FROM=$(nvram_get 2860 ML_From)
	
	SBJ="Mail Alert - user login messages"
	
	if [ "$WAY" == "" ]; then
		echo "$LOGINNAME login on" `date` > /tmp/mail_body
	else
		echo "$LOGINNAME login from $WAY on" `date` > /tmp/mail_body
	fi
		
	cat /tmp/mail_body | sendmail -w 30 -S -s "$SBJ" -H "$USERNAME:$PASSWORD@$SERVER:25" -f "$FROM" "$TO"
	
	rm /tmp/mail_body
}

LOGINNAME=$1
if [ "$LOGINNAME" == "" ]; then
	LOGINNAME="User"
fi

WAY=$2
EN=$(nvram_get 2860 ML_Enable)
FLAG=$(nvram_get 2860 ML_Flag)
if [ -z $EN ] || [ -z $FLAG ]; then
	exit;
fi
if [ $EN == "1" ] && [ $FLAG == "1" ]; then
	alert;
else
	exit;
fi


