#include "wapi.h"

#if 1
//For debug
void dumpHex(const unsigned char * buf, int bufLen)
{
	int i;
	DEBUG("dumpHex\n");
	for(i=0;i<bufLen;i++)
	{
		printf("%2x  ",buf[i]);
		if(((i+1)>=16)&&((i+1)%16==0))
		{
			printf("\n");
		}
	}
	printf("\n");

}

//For debug
void dumpStr(const char * buf, int bufLen)
{
	int i;

	DEBUG("dumpStr\n");
	for(i=0;i<bufLen;i++)
	{
		printf("%c",buf[i]);
		if(((i+1)>=16)&&((i+1)%16==0))
		{
			printf("\n");
		}
	}
	printf("\n");
}
#endif

void get_wifi_bin_dir(char *path, size_t size)
{
	FILE *fp;
	char *pstr;
	struct stat statbuf;
	int len = 0;

	fp = fopen(WIFI_CONFIG_ROOT_DIR "/wifi_bin_dir", "r");
	if (fp) {
		pstr = fgets(path, size, fp);
		fclose(fp);
		if (pstr) {
			len = strlen(path);
			if ((len > 0) && ('\n' == path[len-1])) {
				--len;
				path[len] = '\0';
			}
			if (stat(path, &statbuf) == -1) { // dir not exist
				len = 0;
			}
		}
	}
	if (0 == len) {
		strncpy(path, WIFI_BIN_DIR, size);
	}
}

/************************************************************
generate radom number
************************************************************/
void GenerateRandomData(unsigned char * data, unsigned int len)
{
        //SYSTEMTIME stime;                         
        time_t  now;
        struct tm *tnow;
        unsigned int i, num;
 
        now=time(0);
        tnow=localtime(&now);
        //GetLocalTime(&stime);
 
        srand((unsigned int)tnow->tm_sec%1000);
 
        for (i=0; i<len; i++) {
                num = rand();
                data[i] = (unsigned char)num;
        }
}

/*
*  function description: To check file wether exist
*  parameters:
*  filename (input): file name
*  return 1: filename exist; return 0: filename doesn't exist
*/
int isFileExist(const char * filename)
{
	struct stat status;

	if(filename==NULL)
		return 0;

	if ( stat(filename, &status) < 0)
		return 0;

	return 1;
}

/*
*   function description: store str (length is strLen) into tmpFile
*
*  parameters:
*  tmpFile (input): output filename
*  str (input): string to store
*  strLen (input): length of string
*
*  return 0: success; return -1: failed
*/
int storeStr2File(const char * tmpFile, const unsigned char * str, const int strLen)
{
	int fd;

	int ret, toRet;

	//initial
	fd=-1;

	if(tmpFile==NULL)
	{
		ERR_PRINT("%s(%d),tmpFile is null.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}
	if(str==NULL)
	{
		ERR_PRINT("%s(%d),str is null.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}
	
	fd=open(tmpFile, O_WRONLY | O_CREAT | O_TRUNC, S_IRGRP|S_IWGRP);
	if ( fd == -1 ) 
	{
		ERR_PRINT("open %s error.\n", tmpFile);//Added for test
		toRet=FAILED;
		goto err;
	}

	ret=write(fd, (void *)str, strLen);
//	DEBUG("%s(%d),ret=%d, strLen=%d\n",__FUNCTION__,__LINE__,ret, strLen);//Added for test
	if((ret==FAILED)||(ret< strLen))
	{
		ERR_PRINT("%s(%d),error: write file failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	toRet=SUCCESS;

err:
	if(fd!=-1)
		close(fd);
	
	return toRet;
}

/*
*   function description: read str (length is strLen) from tmpFile
*
*  parameters:
*  str (out): string read from tmpFile
*  strLen (input): length of string
*  tmpFile (input): input filename
*
*  return 0: success; return -1: failed
*/
int readFile2Str(unsigned char * str, int * strLen, const char * tmpFile)
{
	int fd;
	int ret, toRet;
	//unsigned char buffer[1500];

	//initial
	fd=-1;

	if(tmpFile==NULL)
	{
		ERR_PRINT("%s(%d),tmpFile is null.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}
	if(str==NULL)
	{
		ERR_PRINT("%s(%d),str is null.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}
	if(strLen==NULL)
	{
		ERR_PRINT("%s(%d),strLen is null.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}
	
	fd=open(tmpFile, O_RDONLY);
	if ( fd == -1 ) 
	{
		ERR_PRINT("open %s error.\n", tmpFile);//Added for test
		toRet=FAILED;
		goto err;
	}

//	ret=read(fd, (void *)buffer, sizeof(buffer));
	ret=read(fd, (void *)str, TMP_BUF_MAX_LEN);
	DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
	if(ret==FAILED)
	{
		ERR_PRINT("%s(%d),error: read file failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

//	memcpy(str, buffer, ret);
	* strLen=ret;

	toRet=SUCCESS;

err:
	if(fd!=-1)
		close(fd);
	
	return toRet;
}

//Just for test now
void WapiGetParameterFromCert(unsigned char*x509Buf,int x509Len,unsigned char*serialNum, int*serialNumLen,unsigned char *issuerName, int*issuerLen,unsigned char *subjectName,int*subjectLen)
{
	int getLength,tempLen;
	int	subjectLength,issuerLength,serialNumLength;
	getLength = 0;
	

//get first length
	getLength ++;
	if((x509Buf[getLength] & 0x80) == 0x80)
	{
		tempLen = (x509Buf[getLength] & 0x7f);
	}
	else
	{
		tempLen = x509Buf[getLength];
	}

	getLength += 1 + tempLen;
	

//get second length
	getLength ++;
	if((x509Buf[getLength] & 0x80) == 0x80)
	{
		tempLen = x509Buf[getLength] & 0x7f;
	}
	else
	{
		tempLen = x509Buf[getLength];
	}

	getLength += 1 + tempLen;

//get version num, skip it

	getLength +=  1;

	tempLen = x509Buf[getLength];

	getLength += 1+ tempLen;

//get serial num
	serialNumLength = 0;
	serialNum[serialNumLength] =  x509Buf[getLength];
	serialNumLength ++;
	getLength ++;
	serialNum[serialNumLength] =  x509Buf[getLength];
	serialNumLength ++;
	tempLen = x509Buf[getLength];
	memcpy(serialNum+serialNumLength,x509Buf+getLength+1,tempLen);
	getLength += tempLen;
	serialNumLength += tempLen;
	*serialNumLen = tempLen+2;

//get signature, skip it
	getLength +=  2;
	tempLen = x509Buf[getLength];
	getLength += 1+ tempLen;

//get issue
	issuerLength = 0;
	issuerName[issuerLength] =  x509Buf[getLength];
	issuerLength ++;
	getLength ++;
	issuerName[issuerLength] =  x509Buf[getLength];
	issuerLength ++;
	tempLen = x509Buf[getLength];
	memcpy(issuerName+issuerLength,x509Buf+getLength+1,tempLen);
	getLength += tempLen;
	issuerLength += tempLen;
	*issuerLen= tempLen+2;
//get time,skip it
	getLength +=  2;
	tempLen = x509Buf[getLength];

	getLength += 1+ tempLen;

//get subject name
	subjectLength= 0;
	subjectName[subjectLength] =  x509Buf[getLength];
	subjectLength ++;
	getLength ++;
	subjectName[subjectLength] =  x509Buf[getLength];
	subjectLength ++;
	tempLen = x509Buf[getLength];
	memcpy(subjectName+subjectLength,x509Buf+getLength+1,tempLen);
	getLength += tempLen;
	subjectLength += tempLen;
	*subjectLen= tempLen+2;
}



/*
*    function description: to change structure WAPI_PKT_T into buffer
*
*    parameters:
*    outBuf (output) : output buffer
*    outBufLen (output): length of output buffer
*    certVerifyReqPkt (input): pointer of structure WAPI_PKT_T
*    useOptionalSeg (input): flag, 1--use Use optional segment (ASU list trusted by ASUE), others--not use Use optional segment
*
*   return 0: success; -1: failed
*/
int certVerifyReqPkt2Buf(unsigned char * outBuf, int * outBufLen, WAPI_PKT_Tp certVerifyReqPkt, int useOptionalSeg)
{
	int ret, toRet;
	int i, tmpLen;
	int wapiPktLenIndex;
	unsigned short asuTrustedbyAsueLen;//for test
	unsigned char tmpChar;
	unsigned short idNum, tmpShort;
	unsigned char tmpBuf[APP2DRV_BUF_LEN];
	WAPI_CERT_VERIFY_REQ_Tp pCertVerifyReq;

	* outBufLen=0;//Initial
	
	tmpLen=0;
	//memcpy((void *)(tmpBuf+tmpLen), (void *)&(certVerifyReqPkt->ver), 2);
	*(unsigned short *)(tmpBuf+tmpLen)=htons(certVerifyReqPkt->ver);
	tmpLen+=2;
	
	memcpy((void *)(tmpBuf+tmpLen), (void *)&(certVerifyReqPkt->type), 1);
	tmpLen+=1;

	tmpChar=(unsigned char)(certVerifyReqPkt->subType);
	memcpy((void *)(tmpBuf+tmpLen), (void *)&tmpChar, 1);
	tmpLen+=1;

	//memcpy((void *)(tmpBuf+tmpLen), (void *)&(certVerifyReqPkt->reserved), 2);
	*(unsigned short *)(tmpBuf+tmpLen)=htons(certVerifyReqPkt->reserved);
	tmpLen+=2;

	//To set wapi pkt length in the end
	wapiPktLenIndex=tmpLen;
	tmpLen+=2;	//skip it now, and set it at the end

	//memcpy((void *)(tmpBuf+tmpLen), (void *)&(certVerifyReqPkt->pktSeqNo), 2);
	*(unsigned short *)(tmpBuf+tmpLen)=htons(certVerifyReqPkt->pktSeqNo);
	tmpLen+=2;

	memcpy((void *)(tmpBuf+tmpLen), (void *)&(certVerifyReqPkt->segSegNo), 1);
	tmpLen+=1;

	memcpy((void *)(tmpBuf+tmpLen), (void *)&(certVerifyReqPkt->segFlag), 1);
	tmpLen+=1;

	//To set cert verify request
	pCertVerifyReq=(WAPI_CERT_VERIFY_REQ_Tp)(certVerifyReqPkt->data);
	memcpy((void *)(tmpBuf+tmpLen), (void *)(pCertVerifyReq->addID), 12);
	tmpLen+=12;

	memcpy((void *)(tmpBuf+tmpLen), (void *)(pCertVerifyReq->aeChallenge), 32);
	tmpLen+=32;

	memcpy((void *)(tmpBuf+tmpLen), (void *)(pCertVerifyReq->asueChallenge), 32);
	tmpLen+=32;

	//memcpy((void *)(tmpBuf+tmpLen), (void *)&(pCertVerifyReq->asueCert.certFlag), 2);
	*(unsigned short *)(tmpBuf+tmpLen)=htons(pCertVerifyReq->asueCert.certFlag);
	tmpLen+=2;

	//memcpy((void *)(tmpBuf+tmpLen), (void *)&(pCertVerifyReq->asueCert.certLen), 2);
	*(unsigned short *)(tmpBuf+tmpLen)=htons( pCertVerifyReq->asueCert.certLen );
	tmpLen+=2;

	memcpy((void *)(tmpBuf+tmpLen), (void *)(pCertVerifyReq->asueCert.certData), pCertVerifyReq->asueCert.certLen);
	tmpLen+=pCertVerifyReq->asueCert.certLen;

	//memcpy((void *)(tmpBuf+tmpLen), (void *)&(pCertVerifyReq->aeCert.certFlag), 2);
	*(unsigned short *)(tmpBuf+tmpLen)=htons(pCertVerifyReq->aeCert.certFlag);
	tmpLen+=2;
	
	//memcpy((void *)(tmpBuf+tmpLen), (void *)&(pCertVerifyReq->aeCert.certLen), 2);
	*(unsigned short *)(tmpBuf+tmpLen)=htons(pCertVerifyReq->aeCert.certLen);
	tmpLen+=2;

	memcpy((void *)(tmpBuf+tmpLen), (void *)(pCertVerifyReq->aeCert.certData), pCertVerifyReq->aeCert.certLen);
	tmpLen+=pCertVerifyReq->aeCert.certLen;
	


	DEBUG("iAS Clientj certVerifyReqPkt->ver=%04x\n", certVerifyReqPkt->ver);
	DEBUG("iAS Clientj certVerifyReqPkt->type=%04x\n",certVerifyReqPkt->type);
	DEBUG("iAS Clientj tmpLen=%d asueCert.certLen=%d\n", tmpLen,pCertVerifyReq->asueCert.certLen);
	DEBUG("iAS Clientj aeCert.certFlag=%d\n", pCertVerifyReq->aeCert.certFlag);
	DEBUG("iAS Clientj aeCert.certLen=%d\n", pCertVerifyReq->aeCert.certLen);
	DEBUG("iAS Clientj aeCert.certLen=%d useOptionalSeg=%d\n", pCertVerifyReq->aeCert.certLen,useOptionalSeg);

	

	if(useOptionalSeg==1)
	{
		//Use optional segment: ASU list trusted by ASUE
		memcpy((void *)(tmpBuf+tmpLen), (void *)&(pCertVerifyReq->asuTrustedbyAsue.type), 1);
		tmpLen+=1;

		//memcpy((void *)(tmpBuf+tmpLen), (void *)&(pCertVerifyReq->asuTrustedbyAsue.length), 2);//????????
		*(unsigned short *)(tmpBuf+tmpLen)=htons(pCertVerifyReq->asuTrustedbyAsue.length);
		tmpLen+=2;

		asuTrustedbyAsueLen=0;//for test
#if 1
		memcpy((void *)(tmpBuf+tmpLen), (void *)&(pCertVerifyReq->asuTrustedbyAsue.reserved), 1);
		tmpLen+=1;
		asuTrustedbyAsueLen+=1;//for test

		idNum=pCertVerifyReq->asuTrustedbyAsue.idNumber;
		//memcpy((void *)(tmpBuf+tmpLen), (void *)&(pCertVerifyReq->asuTrustedbyAsue.idNumber), 2);
		*(unsigned short *)(tmpBuf+tmpLen)=htons(pCertVerifyReq->asuTrustedbyAsue.idNumber);
		tmpLen+=2;
		asuTrustedbyAsueLen+=2;//for test

		for(i=0;i<idNum;i++)
		{
			//memcpy((void *)(tmpBuf+tmpLen), (void *)&(pCertVerifyReq->asuTrustedbyAsue.idListData[i].idFlag), 2);
			*(unsigned short *)(tmpBuf+tmpLen)=htons(pCertVerifyReq->asuTrustedbyAsue.idListData[i].idFlag);
			tmpLen+=2;
			asuTrustedbyAsueLen+=2;//for test

			//memcpy((void *)(tmpBuf+tmpLen), (void *)&(pCertVerifyReq->asuTrustedbyAsue.idListData[i].idLen), 2);
			*(unsigned short *)(tmpBuf+tmpLen)=htons(pCertVerifyReq->asuTrustedbyAsue.idListData[i].idLen);
			tmpLen+=2;
			asuTrustedbyAsueLen+=2;//for test

			memcpy((void *)(tmpBuf+tmpLen), (void *)(pCertVerifyReq->asuTrustedbyAsue.idListData[i].idData), pCertVerifyReq->asuTrustedbyAsue.idListData[i].idLen);
			tmpLen+=pCertVerifyReq->asuTrustedbyAsue.idListData[i].idLen;
			asuTrustedbyAsueLen+=pCertVerifyReq->asuTrustedbyAsue.idListData[i].idLen;//for test
			
			DEBUG("iAS ClientjidLen=%d\n", pCertVerifyReq->asuTrustedbyAsue.idListData[i].idLen);
		}
#endif

		if(pCertVerifyReq->asuTrustedbyAsue.length!=asuTrustedbyAsueLen)
		{
			ERR_PRINT("iAS Clientj%s(%d), err: pCertVerifyReq->asuTrustedbyAsue.length(%d)!=asuTrustedbyAsueLen(%d)\n", __FUNCTION__,__LINE__,pCertVerifyReq->asuTrustedbyAsue.length,asuTrustedbyAsueLen);
			toRet=FAILED;
			goto err;
		}
		DEBUG("iAS Clientj asuTrustedbyAsueLen=%d\n", asuTrustedbyAsueLen);
	}

	if((tmpLen<=0)||(tmpLen>APP2DRV_BUF_LEN))
	{
		ERR_PRINT("iAS Clientj%s(%d): , err: (tmpLen<=0)||(tmpLen>APP2DRV_BUF_LEN)\n", __FUNCTION__,__LINE__);
		toRet=FAILED;
		goto err;
	}

	//To set wapi pkt length here
	//tmpShort=(unsigned short)htons(tmpLen);
	//memcpy((void *)(tmpBuf+wapiPktLenIndex), (void *)&tmpShort, 2);
	*(unsigned short *)(tmpBuf+wapiPktLenIndex)=htons( tmpLen );
	
	memcpy((void *)outBuf, (void *)tmpBuf, tmpLen);
	* outBufLen=tmpLen;
	
	toRet=SUCCESS;

err:
	return toRet;
}

/*
*    function description: change buffer into structure certVerifyReqPkt
*
*    parameters:
*    certVerifyReqPkt(output): structure of certVerifyReqPkt
*    inBuf(input): buffer of input
*    inBufLen(input): length of input buffer
*
*    return 0: success; -1: failed
*/
int buf2CertVerifyReqPkt(WAPI_PKT_Tp certVerifyReqPkt, unsigned char * inBuf, int inBufLen)
{
	int ret, toRet;
	int i, tmpLen;

	WAPI_CERT_VERIFY_REQ_Tp pCertVerifyReq;

	tmpLen=0;
	
	//memcpy((void *)&(certVerifyReqPkt->ver), (void *)(inBuf+tmpLen) , 2);
	certVerifyReqPkt->ver = ntohs(*(unsigned short *)(inBuf+tmpLen));
	tmpLen+=2;
	
	memcpy((void *)&(certVerifyReqPkt->type), (void *)(inBuf+tmpLen), 1);
	tmpLen+=1;
	
	memcpy((void *)&(certVerifyReqPkt->subType), (void *)(inBuf+tmpLen), 1);
	tmpLen+=1;

	//memcpy((void *)&(certVerifyReqPkt->reserved), (void *)(inBuf+tmpLen) , 2);
	certVerifyReqPkt->reserved = ntohs(*(unsigned short *)(inBuf+tmpLen));
	tmpLen+=2;
	

	//memcpy((void *)&(certVerifyReqPkt->length), (void *)(inBuf+tmpLen), 2);
	certVerifyReqPkt->length = ntohs(*(unsigned short *)(inBuf+tmpLen));
	tmpLen+=2;
	
	//memcpy((void *)&(certVerifyReqPkt->pktSeqNo), (void *)(inBuf+tmpLen) , 2);
	certVerifyReqPkt->pktSeqNo = ntohs(*(unsigned short *)(inBuf+tmpLen));
	tmpLen+=2;
	
	memcpy((void *)&(certVerifyReqPkt->segSegNo), (void *)(inBuf+tmpLen), 1);
	tmpLen+=1;

	memcpy((void *)&(certVerifyReqPkt->segFlag), (void *)(inBuf+tmpLen), 1);
	tmpLen+=1;

	if(certVerifyReqPkt->length!=(unsigned short)inBufLen)
	{
		ERR_PRINT("iAS Serverj%s(%d), err: certVerifyReqPkt->length(%04x)!=inBufLen(%04x)\n",__FUNCTION__,__LINE__,certVerifyReqPkt->length,inBufLen);
		toRet=FAILED;
		goto err;
	}

	DEBUG("iAS Serverj ver=%04x\n",certVerifyReqPkt->ver);
	DEBUG("iAS Serverj type=%02x\n",certVerifyReqPkt->type);
	DEBUG("iAS Serverj reserved=%04x\n",certVerifyReqPkt->reserved);
	DEBUG("iAS Serverj length=%02x\n",certVerifyReqPkt->length);
	DEBUG("iAS Serverj pktSeqNo=%04x\n",certVerifyReqPkt->pktSeqNo);


	//To get cert verify request
	pCertVerifyReq=(WAPI_CERT_VERIFY_REQ_Tp)(certVerifyReqPkt->data);
	memcpy((void *)(pCertVerifyReq->addID), (void *)(inBuf+tmpLen), 12);
	tmpLen+=12;

	memcpy((void *)(pCertVerifyReq->aeChallenge), (void *)(inBuf+tmpLen), 32);
	tmpLen+=32;

	memcpy((void *)(pCertVerifyReq->asueChallenge), (void *)(inBuf+tmpLen), 32);
	tmpLen+=32;

	//memcpy((void *)&(pCertVerifyReq->asueCert.certFlag), (void *)(inBuf+tmpLen), 2);
	pCertVerifyReq->asueCert.certFlag = ntohs(*(unsigned short *)(inBuf+tmpLen));
	tmpLen+=2;

	//memcpy((void *)&(pCertVerifyReq->asueCert.certLen), (void *)(inBuf+tmpLen), 2);
	pCertVerifyReq->asueCert.certLen = ntohs(*(unsigned short *)(inBuf+tmpLen));
	DEBUG("%s(%d),iAS Serverj tmpLen=%d asueCert.certLen=%d %02x-%02x\n", __FUNCTION__,__LINE__,tmpLen,pCertVerifyReq->asueCert.certLen , *(unsigned char *)(inBuf+tmpLen) , *(unsigned char *)(inBuf+tmpLen+1) );
	tmpLen+=2;

	memcpy((void *)(pCertVerifyReq->asueCert.certData), (void *)(inBuf+tmpLen), pCertVerifyReq->asueCert.certLen);
	tmpLen+=pCertVerifyReq->asueCert.certLen;

	//memcpy((void *)&(pCertVerifyReq->aeCert.certFlag), (void *)(inBuf+tmpLen), 2);
	pCertVerifyReq->aeCert.certFlag = ntohs(*(unsigned short *)(inBuf+tmpLen));
	tmpLen+=2;
	
	//memcpy((void *)&(pCertVerifyReq->aeCert.certLen), (void *)(inBuf+tmpLen), 2);
	pCertVerifyReq->aeCert.certLen = ntohs(*(unsigned short *)(inBuf+tmpLen));
	tmpLen+=2;
	
	memcpy((void *)(pCertVerifyReq->aeCert.certData), (void *)(inBuf+tmpLen), pCertVerifyReq->aeCert.certLen);
	
	DEBUG("%s(%d),iAS Serverj tmpLen=%d aeCert.certLen=%d\n", __FUNCTION__,__LINE__,tmpLen , pCertVerifyReq->aeCert.certLen );
	tmpLen+=pCertVerifyReq->aeCert.certLen;

	DEBUG("%s(%d),iAS Serverj tmpLen=%d\n", __FUNCTION__,__LINE__,tmpLen);
	DEBUG("%s(%d),iAS Serverj tmpLen=%d %d\n", __FUNCTION__,__LINE__,tmpLen,pCertVerifyReq->aeCert.certLen);
	
	if(inBufLen>tmpLen)
	{
		DEBUG("%s(%d),iAS ServerjTo use optional segment: ASU list trusted by ASUE!\n", __FUNCTION__,__LINE__);
		
		//To use optional segment: ASU list trusted by ASUE
		memcpy((void *)&(pCertVerifyReq->asuTrustedbyAsue.type), (void *)(inBuf+tmpLen), 1);
		tmpLen+=1;

		//memcpy((void *)&(pCertVerifyReq->asuTrustedbyAsue.length), (void *)(inBuf+tmpLen), 2);
		pCertVerifyReq->asuTrustedbyAsue.length = ntohs(*(unsigned short *)(inBuf+tmpLen));
		tmpLen+=2;

		memcpy((void *)&(pCertVerifyReq->asuTrustedbyAsue.reserved), (void *)(inBuf+tmpLen), 1);
		tmpLen+=1;

		//memcpy((void *)&(pCertVerifyReq->asuTrustedbyAsue.idNumber), (void *)(inBuf+tmpLen), 2);
		pCertVerifyReq->asuTrustedbyAsue.idNumber = ntohs(*(unsigned short *)(inBuf+tmpLen));
		tmpLen+=2;

		for(i=0;i<pCertVerifyReq->asuTrustedbyAsue.idNumber;i++)
		{
			//memcpy((void *)&(pCertVerifyReq->asuTrustedbyAsue.idListData[i].idFlag), (void *)(inBuf+tmpLen), 2);
			pCertVerifyReq->asuTrustedbyAsue.idListData[i].idFlag = ntohs(*(unsigned short *)(inBuf+tmpLen));
			tmpLen+=2;

			//memcpy((void *)&(pCertVerifyReq->asuTrustedbyAsue.idListData[i].idLen), (void *)(inBuf+tmpLen), 2);
			pCertVerifyReq->asuTrustedbyAsue.idListData[i].idLen = ntohs(*(unsigned short *)(inBuf+tmpLen));
			tmpLen+=2;

			memcpy((void *)(pCertVerifyReq->asuTrustedbyAsue.idListData[i].idData), (void *)(inBuf+tmpLen), pCertVerifyReq->asuTrustedbyAsue.idListData[i].idLen);
			tmpLen+=pCertVerifyReq->asuTrustedbyAsue.idListData[i].idLen;
			DEBUG("iAS Serverj tmpLen=%d %d\n", tmpLen,pCertVerifyReq->asuTrustedbyAsue.idListData[i].idLen);
		}
	}

	DEBUG("%s(%d),iAS Serverj tmpLen=%d, inBufLen=%d\n", __FUNCTION__,__LINE__,tmpLen, inBufLen);
	if(tmpLen!=inBufLen)
	{
		ERR_PRINT("%s(%d),iAS Serverj err: tmpLen!=inBufLen\n", __FUNCTION__,__LINE__);
		toRet=FAILED;
		goto err;
	}

	toRet=SUCCESS;

err:
	return toRet;
}

/*
*    function description: to change structure WAPI_CERT_VERIFY_RESULT_T into buffer
*
*    parameters:
*    outBuf (output) : output buffer
*    outBufLen (output): length of output buffer
*    certVerifyResult (input): pointer of structure WAPI_CERT_VERIFY_RESULT_T
*
*   return 0: success; -1: failed
*/
int certVerifyResult2Buf(unsigned char * outBuf, int * outBufLen, WAPI_CERT_VERIFY_RESULT_Tp certVerifyResult)
{
	int ret, toRet;
	int tmpLen;
	unsigned char tmpChar;

	* outBufLen=0;//Initial
	
	DEBUG("%s(%d),iAS Serverj\n", __FUNCTION__,__LINE__);
	
	tmpLen=0;

	memcpy((void *)(outBuf+tmpLen),(void *)&(certVerifyResult->type), 1);
	tmpLen+=1;

	//memcpy((void *)(outBuf+tmpLen),(void *)&(certVerifyResult->length), 2);
	*((unsigned short *)(outBuf+tmpLen))= htons( certVerifyResult->length );
	tmpLen+=2;

	memcpy((void *)(outBuf+tmpLen),(void *)(certVerifyResult->rand_1), 32);
	tmpLen+=32;

	memcpy((void *)(outBuf+tmpLen),(void *)(certVerifyResult->rand_2), 32);
	tmpLen+=32;

	tmpChar=(unsigned char)certVerifyResult->result_1;
	memcpy((void *)(outBuf+tmpLen),(void *)&tmpChar, 1);
	tmpLen+=1;

	//memcpy((void *)(outBuf+tmpLen),(void *)&(certVerifyResult->cert_1.certFlag), 2);
	*((unsigned short *)(outBuf+tmpLen))= htons( certVerifyResult->cert_1.certFlag );
	tmpLen+=2;

	//memcpy((void *)(outBuf+tmpLen),(void *)&(certVerifyResult->cert_1.certLen), 2);
	*((unsigned short *)(outBuf+tmpLen))= htons( certVerifyResult->cert_1.certLen );
	DEBUG("%s(%d)iAS Clientj cert_1.certLen=%d\n",__FUNCTION__,__LINE__,certVerifyResult->cert_1.certLen);
	tmpLen+=2;

	memcpy((void *)(outBuf+tmpLen),(void *)(certVerifyResult->cert_1.certData), certVerifyResult->cert_1.certLen);
	tmpLen+=certVerifyResult->cert_1.certLen;

	tmpChar=(unsigned char)certVerifyResult->result_2;
	memcpy((void *)(outBuf+tmpLen),(void *)&tmpChar, 1);
	tmpLen+=1;

	//memcpy((void *)(outBuf+tmpLen),(void *)&(certVerifyResult->cert_2.certFlag), 2);
	*((unsigned short *)(outBuf+tmpLen))= htons( certVerifyResult->cert_2.certFlag );
	tmpLen+=2;

	//memcpy((void *)(outBuf+tmpLen),(void *)&(certVerifyResult->cert_2.certLen), 2);
	*((unsigned short *)(outBuf+tmpLen))= htons( certVerifyResult->cert_2.certLen );
	DEBUG("%s(%d)iAS Clientj cert_2.certLen=%d\n",__FUNCTION__,__LINE__,certVerifyResult->cert_2.certLen);
	tmpLen+=2;

	memcpy((void *)(outBuf+tmpLen),(void *)(certVerifyResult->cert_2.certData), certVerifyResult->cert_2.certLen);
	tmpLen+=certVerifyResult->cert_2.certLen;

	if(tmpLen!=(certVerifyResult->length+3))
	{
		ERR_PRINT("%s(%d), err: tmpLen!=certVerifyResult->length+3\n", __FUNCTION__,__LINE__);
		toRet=FAILED;
		goto err;
	}

	* outBufLen=tmpLen;

	toRet=SUCCESS;
	
err:
	return toRet;
}


/*
*    function description: to change structure WAPI_PKT_T into buffer
*
*    parameters:
*    outBuf (output) : output buffer
*    outBufLen (output): length of output buffer
*    certVerifyResPkt (input): pointer of structure WAPI_PKT_T
*
*   return 0: success; -1: failed
*/
int certVerifyResPkt2Buf(unsigned char * outBuf, int * outBufLen, WAPI_PKT_Tp certVerifyResPkt)
{
	int ret, toRet;
	int tmpLen;
	unsigned char tmpChar;
	WAPI_CERT_VERIFY_RES_Tp pCertVerifyRes;

	char * tmpBuf4CertVerifyResult=NULL;
	int tmpBufLen;

	* outBufLen=0;//Initial

	tmpLen=0;
	
	//memcpy((void *)(outBuf+tmpLen), (void *)&(certVerifyResPkt->ver), 2);
	*((unsigned short *)(outBuf+tmpLen))= htons( certVerifyResPkt->ver );
	tmpLen+=2;

	memcpy((void *)(outBuf+tmpLen), (void *)&(certVerifyResPkt->type), 1);
	tmpLen+=1;

	tmpChar=(unsigned char)(certVerifyResPkt->subType);
	memcpy((void *)(outBuf+tmpLen), (void *)&tmpChar, 1);
	tmpLen+=1;
	
	//memcpy((void *)(outBuf+tmpLen), (void *)&(certVerifyResPkt->reserved), 2);
	*((unsigned short *)(outBuf+tmpLen))= htons( certVerifyResPkt->reserved );
	tmpLen+=2;

	//memcpy((void *)(outBuf+tmpLen), (void *)&(certVerifyResPkt->length), 2);
	*((unsigned short *)(outBuf+tmpLen))= htons( certVerifyResPkt->length );
	tmpLen+=2;
//	DEBUG("%s(%d), certVerifyResPkt->length=%d\n", __FUNCTION__,__LINE__,certVerifyResPkt->length);

	//memcpy((void *)(outBuf+tmpLen), (void *)&(certVerifyResPkt->pktSeqNo), 2);
	*((unsigned short *)(outBuf+tmpLen))= htons( certVerifyResPkt->pktSeqNo );
	tmpLen+=2;

	memcpy((void *)(outBuf+tmpLen), (void *)&(certVerifyResPkt->segSegNo), 1);
	tmpLen+=1;

	DEBUG("iAS Serverj : ver=%d\n",certVerifyResPkt->ver);
	DEBUG("iAS Serverj : type=%d\n", certVerifyResPkt->type);
	DEBUG("iAS Serverj : subType=%d\n", certVerifyResPkt->subType);
	DEBUG("iAS Serverj : reserved=%d\n",certVerifyResPkt->reserved);
	DEBUG("iAS Serverj : length=%d\n", certVerifyResPkt->length);
	DEBUG("iAS Serverj : pktSeqNo=%d\n", certVerifyResPkt->pktSeqNo);
	DEBUG("iAS Serverj : segSegNo=%d\n",certVerifyResPkt->segSegNo);
	DEBUG("iAS Serverj : segFlag=%d\n", __FUNCTION__,__LINE__,certVerifyResPkt->segFlag);
	memcpy((void *)(outBuf+tmpLen), (void *)&(certVerifyResPkt->segFlag), 1);
	tmpLen+=1;

	//To set cert verify response
	pCertVerifyRes=(WAPI_CERT_VERIFY_RES_Tp)(certVerifyResPkt->data);

	memcpy((void *)(outBuf+tmpLen), (void *)(pCertVerifyRes->addID), 12);
	tmpLen+=12;

	//To malloc memory
	tmpBuf4CertVerifyResult=(char *)malloc(CERT_VERIFY_RESULT_MAX_LEN);
	if(tmpBuf4CertVerifyResult==NULL)
	{
		ERR_PRINT("%s(%d),malloc failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	//To change structure cert verify result into buffer
	ret=certVerifyResult2Buf((unsigned char *)tmpBuf4CertVerifyResult, &tmpBufLen, &(pCertVerifyRes->certVerifyResult));
//	DEBUG("%s(%d),ret=%d, tmpBufLen=%d, pCertVerifyRes->certVerifyResult.length=%d\n",__FUNCTION__,__LINE__,ret, tmpBufLen, pCertVerifyRes->certVerifyResult.length);//Added for test
	if(ret==FAILED)
	{
		ERR_PRINT("%s(%d),certVerifyResult2Buf failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	memcpy((void *)(outBuf+tmpLen), (void *)tmpBuf4CertVerifyResult, tmpBufLen);
	tmpLen+=tmpBufLen;

	if(tmpBuf4CertVerifyResult!=NULL)
	{
		free(tmpBuf4CertVerifyResult);
		tmpBuf4CertVerifyResult=NULL;
	}

	//To set signature by server trusted by AE (by ASUE not supported now)!!!
	memcpy((void *)(outBuf+tmpLen), (void *)&(pCertVerifyRes->aeTrustServerSign.type), 1);
	tmpLen+=1;

	DEBUG("iAS Serverj : aeTrustServerSign.lengt=%d\n", pCertVerifyRes->aeTrustServerSign.length);
	//memcpy((void *)(outBuf+tmpLen), (void *)&(pCertVerifyRes->aeTrustServerSign.length), 2);
	*((unsigned short *)(outBuf+tmpLen))= htons( pCertVerifyRes->aeTrustServerSign.length );
	tmpLen+=2;

	//memcpy((void *)(outBuf+tmpLen), (void *)&(pCertVerifyRes->aeTrustServerSign.signId.idFlag), 2);
	*((unsigned short *)(outBuf+tmpLen))= htons( pCertVerifyRes->aeTrustServerSign.signId.idFlag );
	tmpLen+=2;

	//memcpy((void *)(outBuf+tmpLen), (void *)&(pCertVerifyRes->aeTrustServerSign.signId.idLen), 2);
	*((unsigned short *)(outBuf+tmpLen))= htons( pCertVerifyRes->aeTrustServerSign.signId.idLen );
	tmpLen+=2;

	memcpy((void *)(outBuf+tmpLen), (void *)(pCertVerifyRes->aeTrustServerSign.signId.idData), pCertVerifyRes->aeTrustServerSign.signId.idLen);
	tmpLen+=pCertVerifyRes->aeTrustServerSign.signId.idLen;

	//memcpy((void *)(outBuf+tmpLen), (void *)&(pCertVerifyRes->aeTrustServerSign.signAlg.length), 2);
	*((unsigned short *)(outBuf+tmpLen))= htons( pCertVerifyRes->aeTrustServerSign.signAlg.length );
	tmpLen+=2;

	memcpy((void *)(outBuf+tmpLen), (void *)&(pCertVerifyRes->aeTrustServerSign.signAlg.hashAlgFlag), 1);
	tmpLen+=1;

	memcpy((void *)(outBuf+tmpLen), (void *)&(pCertVerifyRes->aeTrustServerSign.signAlg.signAlgFlag), 1);
	tmpLen+=1;

	memcpy((void *)(outBuf+tmpLen), (void *)&(pCertVerifyRes->aeTrustServerSign.signAlg.signAlgParams.flag), 1);
	tmpLen+=1;

	//memcpy((void *)(outBuf+tmpLen), (void *)&(pCertVerifyRes->aeTrustServerSign.signAlg.signAlgParams.length), 2);
	*((unsigned short *)(outBuf+tmpLen))= htons( pCertVerifyRes->aeTrustServerSign.signAlg.signAlgParams.length );
	tmpLen+=2;

	memcpy((void *)(outBuf+tmpLen), (void *)(pCertVerifyRes->aeTrustServerSign.signAlg.signAlgParams.data), pCertVerifyRes->aeTrustServerSign.signAlg.signAlgParams.length);
	tmpLen+=pCertVerifyRes->aeTrustServerSign.signAlg.signAlgParams.length;

	//memcpy((void *)(outBuf+tmpLen), (void *)&(pCertVerifyRes->aeTrustServerSign.signVal.length), 2);
	*((unsigned short *)(outBuf+tmpLen))= htons( pCertVerifyRes->aeTrustServerSign.signVal.length );
	tmpLen+=2;
//	DEBUG("%s(%d), pCertVerifyRes->aeTrustServerSign.signVal.length=%d\n", __FUNCTION__,__LINE__,pCertVerifyRes->aeTrustServerSign.signVal.length);

	memcpy((void *)(outBuf+tmpLen), (void *)(pCertVerifyRes->aeTrustServerSign.signVal.data), pCertVerifyRes->aeTrustServerSign.signVal.length);
	tmpLen+=pCertVerifyRes->aeTrustServerSign.signVal.length;

	if((tmpLen<=0)||(tmpLen>APP2DRV_BUF_LEN))
	{
		ERR_PRINT("%s(%d), err: (tmpLen<=0)||(tmpLen>APP2DRV_BUF_LEN)\n", __FUNCTION__,__LINE__);
		toRet=FAILED;
		goto err;
	}

	//DEBUG("%s(%d),iAS Serverj : DUMP packets\n", __FUNCTION__,__LINE__);
	//printf("=======================================================\n");
	//dumpHex( (const unsigned char *)(outBuf) , tmpLen );
	//printf("=======================================================\n");
	* outBufLen=tmpLen;

	toRet=SUCCESS;

err:
	if(tmpBuf4CertVerifyResult!=NULL)
		free(tmpBuf4CertVerifyResult);
	
	return toRet;
}

/*
*    function description: change buffer into structure certVerifyResPkt
*
*    parameters:
*    certVerifyReqPkt(output): structure of certVerifyResPkt
*    inBuf(input): buffer of input
*    inBufLen(input): length of input buffer
*
*    return 0: success; -1: failed
*/
int buf2CertVerifyResPkt(WAPI_PKT_Tp certVerifyResPkt, unsigned char * inBuf, int inBufLen)
{
	int ret, toRet;
	int i, tmpLen;
	//unsigned char tmpChar;

	WAPI_CERT_VERIFY_RES_Tp pCertVerifyRes;

	tmpLen=0;
	
	//printf("buf2CertVerifyResPkt dumpHex\n");
	//printf("=======================================================\n");
	//dumpHex( (const unsigned char *)(inBuf) , inBufLen );	
	//printf("=======================================================\n");
	
	//memcpy((void *)&(certVerifyResPkt->ver), (void *)(inBuf+tmpLen), 2);
	certVerifyResPkt->ver=htons(*(unsigned short *)(inBuf+tmpLen));
	tmpLen+=2;

	memcpy((void *)&(certVerifyResPkt->type), (void *)(inBuf+tmpLen), 1);
	tmpLen+=1;

	memcpy((void *)&(certVerifyResPkt->subType), (void *)(inBuf+tmpLen), 1);
	tmpLen+=1;

	//memcpy((void *)&(certVerifyResPkt->reserved), (void *)(inBuf+tmpLen), 2);
	certVerifyResPkt->reserved=htons(*(unsigned short *)(inBuf+tmpLen));
	tmpLen+=2;

	//memcpy((void *)&(certVerifyResPkt->length), (void *)(inBuf+tmpLen), 2);
	certVerifyResPkt->length=htons(*(unsigned short *)(inBuf+tmpLen));
	tmpLen+=2;
	DEBUG("%s(%d), certVerifyResPkt->length=%d\n", __FUNCTION__,__LINE__,certVerifyResPkt->length);

	//memcpy((void *)&(certVerifyResPkt->pktSeqNo), (void *)(inBuf+tmpLen), 2);
	certVerifyResPkt->pktSeqNo=htons(*(unsigned short *)(inBuf+tmpLen));
	tmpLen+=2;

	memcpy((void *)&(certVerifyResPkt->segSegNo), (void *)(inBuf+tmpLen), 1);
	tmpLen+=1;

	memcpy((void *)&(certVerifyResPkt->segFlag), (void *)(inBuf+tmpLen), 1);
	tmpLen+=1;

	//To get cert verify response
	pCertVerifyRes=(WAPI_CERT_VERIFY_RES_Tp)(certVerifyResPkt->data);
	memcpy((void *)(pCertVerifyRes->addID), (void *)(inBuf+tmpLen), 12);
	tmpLen+=12;

	memcpy((void *)&(pCertVerifyRes->certVerifyResult.type), (void *)(inBuf+tmpLen), 1);
	tmpLen+=1;

	//memcpy((void *)&(pCertVerifyRes->certVerifyResult.length), (void *)(inBuf+tmpLen), 2);
	pCertVerifyRes->certVerifyResult.length=htons(*(unsigned short *)(inBuf+tmpLen));
	tmpLen+=2;

	memcpy((void *)(pCertVerifyRes->certVerifyResult.rand_1), (void *)(inBuf+tmpLen), 32);
	tmpLen+=32;
	
	memcpy((void *)(pCertVerifyRes->certVerifyResult.rand_2), (void *)(inBuf+tmpLen), 32);
	tmpLen+=32;

	memcpy((void *)&(pCertVerifyRes->certVerifyResult.result_1), (void *)(inBuf+tmpLen), 1);
	tmpLen+=1;

	//memcpy((void *)&(pCertVerifyRes->certVerifyResult.cert_1.certFlag), (void *)(inBuf+tmpLen), 2);
	pCertVerifyRes->certVerifyResult.cert_1.certFlag=htons(*(unsigned short *)(inBuf+tmpLen));
	tmpLen+=2;

	//memcpy((void *)&(pCertVerifyRes->certVerifyResult.cert_1.certLen), (void *)(inBuf+tmpLen), 2);
	pCertVerifyRes->certVerifyResult.cert_1.certLen=htons(*(unsigned short *)(inBuf+tmpLen));
	tmpLen+=2;

	memcpy((void *)(pCertVerifyRes->certVerifyResult.cert_1.certData), (void *)(inBuf+tmpLen), pCertVerifyRes->certVerifyResult.cert_1.certLen);
	tmpLen+=pCertVerifyRes->certVerifyResult.cert_1.certLen;
	memcpy((void *)&(pCertVerifyRes->certVerifyResult.result_2), (void *)(inBuf+tmpLen), 1);
	tmpLen+=1;

	//memcpy((void *)&(pCertVerifyRes->certVerifyResult.cert_2.certFlag), (void *)(inBuf+tmpLen), 2);
	pCertVerifyRes->certVerifyResult.cert_2.certFlag=htons(*(unsigned short *)(inBuf+tmpLen));
	tmpLen+=2;

	//memcpy((void *)&(pCertVerifyRes->certVerifyResult.cert_2.certLen), (void *)(inBuf+tmpLen), 2);
	pCertVerifyRes->certVerifyResult.cert_2.certLen=htons(*(unsigned short *)(inBuf+tmpLen));
	tmpLen+=2;

	memcpy((void *)(pCertVerifyRes->certVerifyResult.cert_2.certData), (void *)(inBuf+tmpLen), pCertVerifyRes->certVerifyResult.cert_2.certLen);
	tmpLen+=pCertVerifyRes->certVerifyResult.cert_2.certLen;

	//////////////////////////////////////////////////////////////////////////////////////
	//Note!!!!!!!!!!!!!!!!!!!!
	//To get signature by server trusted by AE!!! (not support ASU list trusted by ASUE now!!!!)
	memcpy((void *)&(pCertVerifyRes->aeTrustServerSign.type), (void *)(inBuf+tmpLen), 1);
	tmpLen+=1;

	//memcpy((void *)&(pCertVerifyRes->aeTrustServerSign.length), (void *)(inBuf+tmpLen), 2);
	pCertVerifyRes->aeTrustServerSign.length=htons(*(unsigned short *)(inBuf+tmpLen));
	tmpLen+=2;

	//memcpy((void *)&(pCertVerifyRes->aeTrustServerSign.signId.idFlag), (void *)(inBuf+tmpLen), 2);
	pCertVerifyRes->aeTrustServerSign.signId.idFlag=htons(*(unsigned short *)(inBuf+tmpLen));
	tmpLen+=2;

	//memcpy((void *)&(pCertVerifyRes->aeTrustServerSign.signId.idLen), (void *)(inBuf+tmpLen), 2);
	pCertVerifyRes->aeTrustServerSign.signId.idLen=htons(*(unsigned short *)(inBuf+tmpLen));
	tmpLen+=2;

	memcpy((void *)(pCertVerifyRes->aeTrustServerSign.signId.idData), (void *)(inBuf+tmpLen), pCertVerifyRes->aeTrustServerSign.signId.idLen);
	tmpLen+=pCertVerifyRes->aeTrustServerSign.signId.idLen;


	//memcpy((void *)&(pCertVerifyRes->aeTrustServerSign.signAlg.length), (void *)(inBuf+tmpLen), 2);
	pCertVerifyRes->aeTrustServerSign.signAlg.length=htons(*(unsigned short *)(inBuf+tmpLen));
	tmpLen+=2;

	memcpy((void *)&(pCertVerifyRes->aeTrustServerSign.signAlg.hashAlgFlag), (void *)(inBuf+tmpLen), 1);
	tmpLen+=1;

	memcpy((void *)&(pCertVerifyRes->aeTrustServerSign.signAlg.signAlgFlag), (void *)(inBuf+tmpLen), 1);
	tmpLen+=1;

	memcpy((void *)&(pCertVerifyRes->aeTrustServerSign.signAlg.signAlgParams.flag), (void *)(inBuf+tmpLen), 1);
	tmpLen+=1;

	//memcpy((void *)&(pCertVerifyRes->aeTrustServerSign.signAlg.signAlgParams.length), (void *)(inBuf+tmpLen), 2);
	pCertVerifyRes->aeTrustServerSign.signAlg.signAlgParams.length=htons(*(unsigned short *)(inBuf+tmpLen));
	tmpLen+=2;
	
	memcpy((void *)(pCertVerifyRes->aeTrustServerSign.signAlg.signAlgParams.data), (void *)(inBuf+tmpLen), pCertVerifyRes->aeTrustServerSign.signAlg.signAlgParams.length);
	tmpLen+=pCertVerifyRes->aeTrustServerSign.signAlg.signAlgParams.length;

	//memcpy((void *)&(pCertVerifyRes->aeTrustServerSign.signVal.length), (void *)(inBuf+tmpLen), 2);
	pCertVerifyRes->aeTrustServerSign.signVal.length=htons(*(unsigned short *)(inBuf+tmpLen));
	tmpLen+=2;

	memcpy((void *)(pCertVerifyRes->aeTrustServerSign.signVal.data), (void *)(inBuf+tmpLen), pCertVerifyRes->aeTrustServerSign.signVal.length);
	tmpLen+=pCertVerifyRes->aeTrustServerSign.signVal.length;
	//////////////////////////////////////////////////////////////////////////////////////

	DEBUG("iAS Clientj : certVerifyResPkt->ver=%d\n",certVerifyResPkt->ver);
	DEBUG("iAS Clientj : aeTrustServerSign.type=%d\n",certVerifyResPkt->type);
	DEBUG("iAS Clientj : aeTrustServerSign.subType=%d\n",certVerifyResPkt->subType);
	DEBUG("iAS Clientj : aeTrustServerSign.reserved=%d\n",certVerifyResPkt->reserved);
	DEBUG("iAS Clientj :certVerifyResPkt->length=%d\n",certVerifyResPkt->length);
	DEBUG("iAS Clientj : aeTrustServerSign.pktSeqNo=%d\n",certVerifyResPkt->pktSeqNo);
	DEBUG("iAS Clientj : pCertVerifyRes->certVerifyResult.length=%d\n",pCertVerifyRes->certVerifyResult.length);
	DEBUG("iAS Clientj : pCertVerifyRes->certVerifyResult.cert_1.certLen=%d\n", pCertVerifyRes->certVerifyResult.cert_1.certLen);
	DEBUG("iAS Clientj : pCertVerifyRes->certVerifyResult.cert_2.certLen=%d\n", pCertVerifyRes->certVerifyResult.cert_2.certLen);
	DEBUG("iAS Clientj : pCertVerifyRes->aeTrustServerSign.length=%d\n", pCertVerifyRes->aeTrustServerSign.length);
	DEBUG("iAS Clientj : idLen=%d\n", pCertVerifyRes->aeTrustServerSign.signId.idLen);
	DEBUG("iAS Clientj : tmpLen=%d signAlgParams.length=%d\n", tmpLen,pCertVerifyRes->aeTrustServerSign.signAlg.signAlgParams.length);
	

	DEBUG("%s(%d),iAS Clientj :  tmpLen=%d, inBufLen=%d\n", __FUNCTION__,__LINE__,tmpLen, inBufLen);
	if(tmpLen!=inBufLen)
	{
		ERR_PRINT("%s(%d), err: tmpLen!=inBufLen\n", __FUNCTION__,__LINE__);
		toRet=FAILED;
		goto err;
	}

	toRet=SUCCESS;

err:
	
	return toRet;
}

#if 0
/*
*   function description: use privKeyFile to sign inMsg (length is inMsg) into outMsg (length is outMsgLen)
*
*   parameters:
*   inMsg (input): message to sign
*   inMsgLen (input): length of input message
*   privKeyFile (input): file name of private key to sign
*   outMsg (output): output signed message
*   outMsgLen (output): length of output signed message
*
*   return 0: success; return -1: failed
*/
int signMsg(const char * inMsg, const int inMsgLen, const char *privKeyFile, char * outMsg, int * outMsgLen)
{
	int fd;
	int ret, toRet;

	char tmpBuf[100];
	char path[MAX_PATH];
	char cmdline[MAX_PATH];
	//char buffer[1000];

	//Initial
	fd=-1;
	
	if(inMsg==NULL)
	{
		ERR_PRINT("%s(%d),inMsg is null.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	if(privKeyFile==NULL)
	{
		ERR_PRINT("%s(%d),privKeyFile is null.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	////////
	fd=open(TMP_IN_MSG, O_WRONLY | O_CREAT | O_TRUNC);
	if ( fd == -1 ) 
	{
		ERR_PRINT("open %s error.\n", TMP_IN_MSG);//Added for test
		toRet=FAILED;
		goto err;
	}

	ret=write(fd, (void *)inMsg, inMsgLen);
	DEBUG("%s(%d),ret=%d, inMsgLen=%d\n",__FUNCTION__,__LINE__,ret, inMsgLen);//Added for test
	if((ret==FAILED)||(ret< inMsgLen))
	{
		ERR_PRINT("%s(%d),write file failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	if(fd!=-1)
	{
		close(fd);
		fd=-1;
	}
	
	get_wifi_bin_dir(path, sizeof(path));
	strcat(path, "/");

	//To sign TMP_IN_MSG into TMP_OUT_MSG
	sprintf(cmdline, OPENSSL" dgst -sign %s -out %s %s", privKeyFile,TMP_OUT_MSG , TMP_IN_MSG);
	DEBUG("cmdline=%s\n",cmdline);//Added for test
	system(cmdline);
//	sleep(1);
	///////////

	////////
	fd=open(TMP_OUT_MSG, O_RDONLY);
	if ( fd == -1 ) 
	{
		ERR_PRINT("open %s error.\n", TMP_OUT_MSG);//Added for test
		toRet=FAILED;
		goto err;
	}

	ret=read(fd, (void *)tmpBuf, sizeof(tmpBuf));
//	DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
	if(ret==-1)
	{
		ERR_PRINT("%s(%d),read file failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	memcpy(outMsg, tmpBuf, ret);
	*outMsgLen=ret;

	/////////////////

	toRet=SUCCESS;

err:
	if(fd!=-1)
		close(fd);
	
	return toRet;
}
#endif

/*
*   function description: use privKeyFile to sign inMsg (length is inMsg) into outMsg (length is outMsgLen)
*
*   parameters:
*   inMsg (input): message to sign
*   inMsgLen (input): length of input message
*   privKeyFile (input): file name of private key to sign
*   outMsg (output): output signed message
*   outMsgLen (output): length of output signed message
*
*   return 0: success; return -1: failed
*/
//Syc with 92su client, USED NOW!
int signMsg2(const char * inMsg, const int inMsgLen, const char *privKeyFile, char * outMsg, int * outMsgLen)
{
	int ret, toRet;
	int tmpLen;
	char tmpBuf[100];
	char path[MAX_PATH];
	char cmdline[MAX_PATH];
	//char buffer[100];

	* outMsgLen=0;//Initial

	if(inMsg==NULL)
	{
		ERR_PRINT("%s(%d),inMsg is NULL.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	if(inMsgLen<=0)
	{
		ERR_PRINT("%s(%d),inMsgLen<=0.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	if(privKeyFile==NULL)
	{
		ERR_PRINT("%s(%d),privKeyFile is NULL.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	if(outMsg==NULL)
	{
		ERR_PRINT("%s(%d),outMsg is NULL.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	if(outMsgLen==NULL)
	{
		ERR_PRINT("%s(%d),outMsgLen is NULL.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}
	
	DEBUG("%s(%d): storeStr2File TMP_MSG=%s len=%d\n", __FUNCTION__, __LINE__, TMP_MSG , inMsgLen);
	ret=storeStr2File(TMP_MSG, inMsg, inMsgLen);
	if(ret==FAILED)
	{
		ERR_PRINT("%s(%d),storeStr2File failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}
	
	get_wifi_bin_dir(path, sizeof(path));
	strcat(path, "/");
	DEBUG("%s(%d): get_wifi_bin_dir=%s\n", __FUNCTION__, __LINE__, path);//Added for test

	//ecdsatest -signature -m TMP_MSG -k pubKeyFile -o TMP_SIG_OUT
	sprintf(cmdline, ECDSATEST" -signature -m %s -k %s -o %s", TMP_MSG, privKeyFile, TMP_SIG_OUT);
	DEBUG("%s(%d): cmdline=%s\n", __FUNCTION__, __LINE__, cmdline);//Added for test
	//sprintf(cmdline, "%s%s", path, tmpBuf);
	system(cmdline);

//	DEBUG("%s(%d)============\n", __FUNCTION__, __LINE__);//Added for test

	ret=readFile2Str((unsigned char *)tmpBuf, &tmpLen, TMP_SIG_OUT);
//	DEBUG("%s(%d):ret=%d,  tmpLen=%d\n", __FUNCTION__, __LINE__, ret, tmpLen);//Added for test
	if(ret==FAILED)
	{
		ERR_PRINT("%s(%d),readFile2Str failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	if(tmpLen>0)
	{
		DEBUG("%s(%d): readFile2Str %s len=%d\n", __FUNCTION__, __LINE__, TMP_SIG_OUT,tmpLen);
		memcpy((void *)outMsg, (void *)tmpBuf, tmpLen);
	}

	DEBUG("%s(%d): len=%d\n", __FUNCTION__, __LINE__, tmpLen);
	* outMsgLen=tmpLen;

	toRet=SUCCESS;

err:
	
	return toRet;
}

/*
*    function description: verify wapi ecdsa signature
*
*    parameters:
*    msg (input): source message for signature
*    msgLen (input): length of source message
*    msgSig (input): signature of source message
*    msgSigLen (input): length of signature of source messages
*    pubKeyFile (input): cert file which include public key for signature verify
*    verifyOK (output): signature verify result, 0: verify wrong, 1: verify OK
*
*    return 0: success; return -1: failed
*/
//Syc with 92su client, USED NOW!
int verifyMsgSignature2(const char * msg, const int msgLen, const char * msgSig, const int msgSigLen, const char *pubKeyFile, char * verifyOK)
{
	int ret, toRet;
	char tmpBuf[100];
	char path[MAX_PATH];
	char cmdline[MAX_PATH];

	* verifyOK=0;//Initial
	
	ret=storeStr2File(TMP_MSG, msg, msgLen);
	if(ret==FAILED)
	{
		ERR_PRINT("%s(%d),iAS ClientjstoreStr2File failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	ret=storeStr2File(TMP_SIG, msgSig, msgSigLen);
	if(ret==FAILED)
	{
		ERR_PRINT("%s(%d),iAS ClientjstoreStr2File failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}
	
	get_wifi_bin_dir(path, sizeof(path));
	strcat(path, "/");

	//ecdsatest -verify -m TMP_MSG -s TMP_SIG -k pubKeyFile
	sprintf(cmdline, ECDSATEST" -verify -m %s -s %s -k %s", TMP_MSG, TMP_SIG, pubKeyFile);
	//sprintf(cmdline, "%s%s", path, tmpBuf);
	DEBUG("iAS Clientj cmdline=%s\n",cmdline);
	
	system(cmdline);

	if(isFileExist(TMP_SIG_VERIFY_RES)==1)
	{
		* verifyOK=1;	//signature verify OK
	}

	toRet=SUCCESS;

err:
	DEBUG("iAS Clientj toRet=%d\n",toRet);
	return toRet;	
	
}

int genCertVerifyReqPkt2(WAPI_PKT_Tp reqPkt, WAPI_ACCESS_VERIFY_REQ_Tp accessVerifyReq, const char * aeCertFile)
{
	int ret, toRet;
	int i, tmpLen;
	unsigned short pktlen;
	unsigned short testLen;//For test
	unsigned char tmpBuf[100];
	WAPI_CERT_VERIFY_REQ_Tp req;

	//To generate reqPkt header
	reqPkt->ver=1;
	reqPkt->type=1;
	reqPkt->subType=TYPE_CERT_VERIFY_REQ;
	
	//reqPkt->length=sizeof(WAPI_PKT_T);	//set it at the end

	reqPkt->pktSeqNo=1;		//???????
	reqPkt->segSegNo=0;		//???????
	reqPkt->segFlag=0;	//0: no more segment; 1: more segment

	pktlen=12;//header of wapi pkt

	//packet data
	req=(WAPI_CERT_VERIFY_REQ_Tp)(reqPkt->data);
	
	//To generate wapi cert verify request
	//To set ADDID from ADDID_FILE which is get from driver's verify activate request
	ret=readFile2Str(tmpBuf, &tmpLen, ADDID_FILE);
	if((ret==FAILED) || (tmpLen!=12))
	{
		ERR_PRINT("%s(%d),readFile2Str failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}
	memcpy((void *)(req->addID), (void *)tmpBuf, 12);

	//To generate Nae
	GenerateRandomData(tmpBuf, 32);
	memcpy((void *)(req->aeChallenge), (void *)tmpBuf, 32);

	//To set Nasue
	memcpy((void *)(req->asueChallenge), (void *)(accessVerifyReq->asueChallenge), 32);

	pktlen+=76;

	//To set asue cert
	req->asueCert.certFlag=accessVerifyReq->asueCert.certFlag;
	req->asueCert.certLen=accessVerifyReq->asueCert.certLen;
	memcpy((void *)(req->asueCert.certData), (void *)(accessVerifyReq->asueCert.certData), req->asueCert.certLen );

	DEBUG("%s(%d),iAS ClientjasueCert.certLen=%d\n",__FUNCTION__,__LINE__,req->asueCert.certLen);

	//pktlen+=(4+ntohs(req->asueCert.certLen));
	pktlen+=4+req->asueCert.certLen;
	DEBUG("%s(%d),iAS Clientjpktlen=%d\n",__FUNCTION__,__LINE__,pktlen);
	//To set ae cert
	req->aeCert.certFlag=1;
	
	
	ret=readFile2Str(req->aeCert.certData, &tmpLen, aeCertFile);
	req->aeCert.certLen=tmpLen;
	DEBUG("%s(%d), aeCertFile=%s aeCert.certLen=%d\n",__FUNCTION__,__LINE__,aeCertFile,req->aeCert.certLen);//Added for test
	if(ret==FAILED)
	{
		ERR_PRINT("%s(%d),readFile2Str failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	pktlen+=4+req->aeCert.certLen;
//	DEBUG("%s(%d),without ASU list trusted by ASUE, pktlen=%d\n",__FUNCTION__,__LINE__, pktlen);//Added for test

	//To set ASU list trusted by ASUE
	if((accessVerifyReq->flag & 0x08) == 0x08)
	{
		//if B3==1, use optional: ASU list trusted by ASUE
//		DEBUG("%s(%d),use optional: ASU list trusted by ASUE\n",__FUNCTION__,__LINE__);//Added for test
		//memcpy((void *)&(req->asuTrustedbyAsue), (void *)&(accessVerifyReq->asuTrustedbyAsue), accessVerifyReq->asuTrustedbyAsue.length+3);//???????
		req->asuTrustedbyAsue.type=accessVerifyReq->asuTrustedbyAsue.type;
		req->asuTrustedbyAsue.length=accessVerifyReq->asuTrustedbyAsue.length;
		

		testLen=0;//Added for test
		
		req->asuTrustedbyAsue.reserved=accessVerifyReq->asuTrustedbyAsue.reserved;
		testLen+=1;//Added for test
		
		req->asuTrustedbyAsue.idNumber=accessVerifyReq->asuTrustedbyAsue.idNumber;
		testLen+=2;//Added for test
		
		for(i=0;i<accessVerifyReq->asuTrustedbyAsue.idNumber;i++)
		{
			req->asuTrustedbyAsue.idListData[i].idFlag=accessVerifyReq->asuTrustedbyAsue.idListData[i].idFlag;
			testLen+=2;//Added for test

			req->asuTrustedbyAsue.idListData[i].idLen=accessVerifyReq->asuTrustedbyAsue.idListData[i].idLen;
			testLen+=2;//Added for test

			memcpy((void *)(req->asuTrustedbyAsue.idListData[i].idData), (void *)(accessVerifyReq->asuTrustedbyAsue.idListData[i].idData),accessVerifyReq->asuTrustedbyAsue.idListData[i].idLen);
			testLen+=accessVerifyReq->asuTrustedbyAsue.idListData[i].idLen;//Added for test
		}

		if(testLen!=accessVerifyReq->asuTrustedbyAsue.length)
		{
			ERR_PRINT("%s(%d),iAS ClientjtestLen!=accessVerifyReq->asuTrustedbyAsue.length.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}
		
		
		DEBUG("iAS Clientj,req->asuTrustedbyAsue.length=%d\n",req->asuTrustedbyAsue.length);
		pktlen+=(3+accessVerifyReq->asuTrustedbyAsue.length);
	}

	//reqPkt->length=htons(pktlen);//To set it here!!!
	reqPkt->length=pktlen;
	DEBUG("iAS ClientjreqPkt->length=%d\n",reqPkt->length);


	toRet=SUCCESS;
err:

//	DEBUG("%s(%d), toRet=%d\n",__FUNCTION__,__LINE__, toRet);//Added for test
	return toRet;	
}

/*
*   function description: process wapi cert verify request and generate wapi cert verify response
*
*   parameters:
*   req (input): wapi cert verify request to process
*   res (output): wapi cert verify response to generate
*   certVerifyResBufLen(output): length ot buffer of wapi cert verify response
*
*   return 0: success; return -1: failed
*/
int processCertVerifyReq(WAPI_CERT_VERIFY_REQ_Tp req, WAPI_CERT_VERIFY_RES_Tp res, int * certVerifyResBufLen)
{
	int fd_1, fd_2;
	int fd_res;
	int ret, toRet, size;
	int userCertState, apCertState;
	unsigned char   serialNumber[10],issuerName[200],subjectName[200];
	int			serialNumLen,issuerLen,subjectLen;
	unsigned char bufCAX509[CERT_DATA_MAX_LEN];
	int			CAX509Len;
	int tmpLen;


//	char verifyRes;	//For test

	//char buf[1000];
	char tmpBuf[100];
	char path[MAX_PATH];
	char cmdline[MAX_PATH];
	//char tmpBuf2[100];
	unsigned char buffer[5];
	unsigned char *p;
	char * tmpBuf4CertVerifyResult=NULL;
	int tmpBufLen;
	unsigned short signLen, signAlgLen;

	//?????, indicted by OID: 1.2.156.11235.1.1.2.1
	unsigned char eccParamters[11]={0x06,0x09,0x2a,0x81,0x1c,0xd7,0x63,0x01,0x01,0x02,0x01};

	//Initial
	* certVerifyResBufLen=0;
	fd_1=-1;
	fd_2=-1;

	DEBUG("iAS ServerjasueCert.certFlag=%04x aeCert.certFlag=%04x\n",req->asueCert.certFlag,req->aeCert.certFlag);
	if(req->asueCert.certFlag!=1)
	{
		ERR_PRINT("%s(%d),asueCert not X.509.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	if(req->aeCert.certFlag!=1)
	{
		ERR_PRINT("%s(%d),iAS ServerjaeCert not X.509.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	//To store asue cert into temp user cert file
	fd_1=open(TMP_USER_CERT_DER, O_WRONLY | O_CREAT | O_TRUNC, S_IRGRP|S_IWGRP);
	if ( fd_1 == -1 ) 
	{
		ERR_PRINT("iAS Serverjopen %s error.\n", TMP_USER_CERT_DER);//Added for test
		toRet=FAILED;
		goto err;
	}

	size=req->asueCert.certLen;
	ret=write(fd_1, (void *)req->asueCert.certData, size);
	DEBUG("%s(%d),ret=%d, size=%d\n",__FUNCTION__,__LINE__,ret, size);//Added for test
	if((ret==FAILED)||(ret< size))
	{
		ERR_PRINT("%s(%d),iAS Serverjerror: write file failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	if(fd_1!=-1)
		close(fd_1);

	//To store ae cert into temp ap cert file
	fd_2=open(TMP_AP_CERT_DER, O_WRONLY | O_CREAT | O_TRUNC, S_IRGRP|S_IWGRP);
	if ( fd_2== -1 ) 
	{
		ERR_PRINT("iAS Serverjopen %s error.\n", TMP_AP_CERT_DER);//Added for test
		toRet=FAILED;
		goto err;
	}

	size=req->aeCert.certLen;
	ret=write(fd_2, (void *)req->aeCert.certData, size);
	DEBUG("%s(%d),ret=%d, size=%d\n",__FUNCTION__,__LINE__,ret, size);//Added for test
	if((ret==FAILED)||(ret< size))
	{
		ERR_PRINT("%s(%d),iAS Serverjerror: write file failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	if(fd_2!=-1)
		close(fd_2);

	get_wifi_bin_dir(path, sizeof(path));
	strcat(path, "/");

	//To change cert format from DER to PEM
#if 1
	sprintf(cmdline, ECDSATEST" -der2pem -in %s -out %s", TMP_USER_CERT_DER,TMP_USER_CERT);
	DEBUG("iAS Serverjscmdline=%s\n",cmdline);//Added for test
	system(cmdline);

	sprintf(cmdline, ECDSATEST" -der2pem -in %s -out %s", TMP_AP_CERT_DER,TMP_AP_CERT);
	//sprintf(cmdline, "%s%s", path, tmpBuf);
	DEBUG("iAS Serverjscmdline=%s\n",cmdline);//Added for test
	system(cmdline);
#else
	sprintf(cmdline, OPENSSL" x509 -inform DER -in %s -outform PEM -out %s", TMP_USER_CERT_DER,TMP_USER_CERT);
	//sprintf(cmdline, "%s%s", path, tmpBuf);
	system(cmdline);

	sprintf(cmdline, OPENSSL" x509 -inform DER -in %s -outform PEM -out %s", TMP_AP_CERT_DER,TMP_AP_CERT);
	//sprintf(cmdline, "%s%s", path, tmpBuf);
	system(cmdline);
#endif
	
	//To verify user cert
	//Initial
	userCertState=RES_CERT_ERR_UNKNOWN;
	//memset(tmpBuf, 0, sizeof(tmpBuf));

	//To check CA_CERT if exist
	if(isFileExist(CA_CERT)!=1)
	{
		ERR_PRINT("%s(%d),iAS Serverj%s is not exist, please initial AS at our system.\n",__FUNCTION__,__LINE__,CA_CERT);//Added for test
		toRet=FAILED;
		goto err;
	}
	
	sprintf(cmdline, OPENSSL" verify -CAfile %s %s", CA_CERT,TMP_USER_CERT);
	DEBUG(cmdline);
	system(cmdline);
//	sleep(1);
	fd_res=open(CERT_VERIFY_RESULT, O_RDONLY);
	if (fd_res== -1 ) 
	{
		ERR_PRINT("iAS Serverjcan not open %s.\n", CERT_VERIFY_RESULT);//Added for test
		//toRet=FAILED;
		//goto err;
		//userCertState=RES_CERT_ERR_UNKNOWN;
	}
	else
	{
		memset(buffer, 0, sizeof(buffer));
		size=read(fd_res, (void *)buffer, sizeof(buffer));
//		DEBUG("%s(%d),size=%d, buffer=%s, strlen=%d\n",__FUNCTION__,__LINE__,size, buffer, strlen(buffer));//Added for test
		if(size==-1)
		{
			ERR_PRINT("%s(%d),iAS Serverjread file failed.\n",__FUNCTION__,__LINE__);//Added for test
			//toRet=FAILED;
			//goto err;
			//userCertState=RES_CERT_ERR_UNKNOWN;
		}
		else
		{
			if(buffer[0]=='0')
			{
				userCertState=RES_CERT_VALID;
			}
			else if(buffer[0]=='3')
			{
				userCertState=RES_CERT_INVALID;
			}
			else if(buffer[0]=='5')
			{
				userCertState=RES_CERT_REVOKED;
			}
			//else
			//to do
		}
	}

	//DEBUG("#######%s(%d),userCertState=%d############\n",__FUNCTION__,__LINE__,userCertState);//Added for test
	//userCertState=RES_CERT_VALID;//For test!!!!!!!!!!!!!!!!!!!
	
	if(fd_res!=-1)
		close(fd_res);

	//To verify ap cert
	//Initial
	apCertState=RES_CERT_ERR_UNKNOWN;
	memset(cmdline, 0, sizeof(tmpBuf));
	sprintf(cmdline, OPENSSL" verify -CAfile %s %s", CA_CERT,TMP_AP_CERT);
	//sprintf(cmdline, "%s%s", path, tmpBuf);
	system(cmdline);
//	sleep(1);
	
	fd_res=open(CERT_VERIFY_RESULT, O_RDONLY);
	if (fd_res== -1 ) 
	{
		ERR_PRINT("iAS Serverjcan not open %s.\n", CERT_VERIFY_RESULT);//Added for test
		//toRet=FAILED;
		//goto err;
		//apCertState=RES_CERT_ERR_UNKNOWN;
	}
	else
	{
		memset(buffer, 0, sizeof(buffer));
		size=read(fd_res, (void *)buffer, sizeof(buffer));
		DEBUG("size=%d, buffer=%s, strlen=%d\n",size, buffer, strlen(buffer));//Added for test
		if(size==-1)
		{
			ERR_PRINT("%s(%d),iAS Serverjread file failed.\n",__FUNCTION__,__LINE__);//Added for test
			//toRet=FAILED;
			//goto err;
			//apCertState=RES_CERT_ERR_UNKNOWN;
		}
		else
		{
			if(buffer[0]=='0')
			{
				apCertState=RES_CERT_VALID;
			}
			else if(buffer[0]=='3')
			{
				apCertState=RES_CERT_INVALID;
			}
			else if(buffer[0]=='5')
			{
				apCertState=RES_CERT_REVOKED;
			}
			//else
			//to do
		}
	}
	if(fd_res!=-1)
		close(fd_res);

	DEBUG("#######%s(%d),userCertState=%d, apCertState=%d############\n",__FUNCTION__,__LINE__,userCertState, apCertState);//Added for test

	//To genereate wapi cert verify response
	tmpLen=0;//Initial, to record length of  buffer of wapi cert verify response
	
	memcpy(res->addID,req->addID,12);
	tmpLen+=12;
	
	res->certVerifyResult.type=2;	// 2: for cert verify result
	
	memcpy(res->certVerifyResult.rand_1,req->aeChallenge,32);
	memcpy(res->certVerifyResult.rand_2,req->asueChallenge,32);
	res->certVerifyResult.result_1=userCertState;//result of ASUE cert
	memcpy((void *)(&(res->certVerifyResult.cert_1.certFlag)), (void *)(&(req->asueCert.certFlag)),2);
	memcpy((void *)(&(res->certVerifyResult.cert_1.certLen)), (void *)(&(req->asueCert.certLen)),2);
	DEBUG("iAS Serverj cert_1.certLen=%d\n",res->certVerifyResult.cert_1.certLen);
	
	
	memcpy((void *)(res->certVerifyResult.cert_1.certData), (void *)(req->asueCert.certData),res->certVerifyResult.cert_1.certLen);
	res->certVerifyResult.result_2=apCertState;//result of AE cert
	memcpy((void *)(&(res->certVerifyResult.cert_2.certFlag)), (void *)(&(req->aeCert.certFlag)),2);
	memcpy((void *)(&(res->certVerifyResult.cert_2.certLen)), (void *)(&(req->aeCert.certLen)),2);
	DEBUG("iAS Serverj cert_2.certLen=%d\n",res->certVerifyResult.cert_2.certLen);
	memcpy((void *)((res->certVerifyResult.cert_2.certData)), (void *)((req->aeCert.certData)), res->certVerifyResult.cert_2.certLen);

	//res->certVerifyResult.length=sizeof(WAPI_CERT_VERIFY_RESULT_T)-3;	//??????????
	res->certVerifyResult.length=74+res->certVerifyResult.cert_1.certLen+res->certVerifyResult.cert_2.certLen;//?????????
	DEBUG("iAS Serverjres->certVerifyResult.length=%d, res->certVerifyResult.cert_1.certLen=%d, res->certVerifyResult.cert_2.certLen=%d\n",res->certVerifyResult.length, res->certVerifyResult.cert_1.certLen, res->certVerifyResult.cert_2.certLen);//Added for test

	tmpLen+=(res->certVerifyResult.length+3);
	

	///////////////////////////////////
	//To malloc memory
	tmpBuf4CertVerifyResult=(char *)malloc(CERT_VERIFY_RESULT_MAX_LEN);
	if(tmpBuf4CertVerifyResult==NULL)
	{
		ERR_PRINT("%s(%d),iAS Serverjmalloc failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	//To change structure cert verify result into buffer
	ret=certVerifyResult2Buf((unsigned char *)tmpBuf4CertVerifyResult, &tmpBufLen, &(res->certVerifyResult));
//	DEBUG("%s(%d),ret=%d, tmpBufLen=%d, res->certVerifyResult.length=%d\n",__FUNCTION__,__LINE__,ret, tmpBufLen, res->certVerifyResult.length);//Added for test
	if(ret==FAILED)
	{
		ERR_PRINT("%s(%d),iAS ServerjcertVerifyResult2Buf failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}
	
	//Use signMsg2 instead
	//use TMP_CA_CERT(include ca cert and ca private key, just for signMsg2) instead of CA_PRIV_KEY
	sprintf(tmpBuf, "cp %s %s/", CA_CERT, WIFI_WAPI_TMP_DIR);
	system(tmpBuf);
	sprintf(tmpBuf, "cat %s >> %s", CA_PRIV_KEY, TMP_CA_CERT);
	system(tmpBuf);

	memset(tmpBuf, 0, sizeof(tmpBuf));//for test
	ret=signMsg2(tmpBuf4CertVerifyResult, tmpBufLen, TMP_CA_CERT, tmpBuf, &size);
	if ( ret== FAILED) 
	{
		ERR_PRINT("%s(%d),iAS ServerjsignMsg failed\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}




	if(tmpBuf4CertVerifyResult!=NULL)
	{
		free(tmpBuf4CertVerifyResult);
		tmpBuf4CertVerifyResult=NULL;
	}
	////////////////////////////////

	//Note: only support signature by server trusted by AE, now!!!
#if 0
	if(res->certVerifyResult.result_1==RES_CERT_ISSUER_UNKNOWN)
#endif
	{
		signLen=0;//Initial
		
		//certVerifyResult not contain asueTrustServerSign, only contain aeTrustServerSign
//		DEBUG("%s(%d),ASUE cert verify result is RES_CERT_ISSUER_UNKNOWN\n",__FUNCTION__,__LINE__);//Added for test
		res->aeTrustServerSign.signVal.length=size;
		signLen+=2;
		memcpy((void *)(res->aeTrustServerSign.signVal.data), (void *)tmpBuf, size);
		signLen+=size;

		res->aeTrustServerSign.type=1;	//For signature

		//To get CA ID from CA cert
#if 1
		sprintf(cmdline, ECDSATEST" -pem2der -in %s -out %s", CA_CERT, CA_CERT_DER);
#else
		sprintf(cmdline, OPENSSL" x509 -inform PEM -in %s -outform DER -out %s", CA_CERT, CA_CERT_DER);
#endif
		DEBUG("cmdline=%s%s", cmdline);
		system(cmdline);

		ret=readFile2Str(bufCAX509, &CAX509Len, CA_CERT_DER);
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d),read file failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}
		
		WapiGetParameterFromCert(bufCAX509, CAX509Len, serialNumber, &serialNumLen, issuerName, &issuerLen, subjectName,&subjectLen);
		DEBUG("%s(%d),iAS Serverj  CAX509Len=%d, serialNumLen=%d, issuerLen=%d,subjectLen=%d\n",__FUNCTION__,__LINE__,CAX509Len, serialNumLen, issuerLen, subjectLen);//Added for test

		res->aeTrustServerSign.signId.idFlag=1;
		signLen+=2;
		p=res->aeTrustServerSign.signId.idData;
		memcpy((void *)p, (void *)subjectName, subjectLen);
		signLen+=subjectLen;
		DEBUG("signLen=%d subjectLen=%d\n",signLen,subjectLen);
		memcpy((void *)(p+subjectLen), (void *)issuerName, issuerLen);
		signLen+=issuerLen;
		memcpy((void *)(p+subjectLen+issuerLen), (void *)serialNumber, serialNumLen);
		signLen+=serialNumLen;
		res->aeTrustServerSign.signId.idLen=subjectLen+issuerLen+serialNumLen;
		signLen+=2;
		//End of get CA ID from CA cert

		signAlgLen=0;//Initial
		
		//res->aeTrustServerSign.signAlg.length=sizeof(WAPI_SIGN_ALG_T)-2;//To set it at this end
		res->aeTrustServerSign.signAlg.hashAlgFlag=1;	//SHA-256
		signLen+=1;
		signAlgLen+=1;
		res->aeTrustServerSign.signAlg.signAlgFlag=1;	//ECDSA-192
		signLen+=1;
		signAlgLen+=1;
		res->aeTrustServerSign.signAlg.signAlgParams.flag=1;	// indicated by OID
		signLen+=1;
		signAlgLen+=1;
		memcpy(res->aeTrustServerSign.signAlg.signAlgParams.data, eccParamters, sizeof(eccParamters));	//??????????
		signLen+=sizeof(eccParamters);
		signAlgLen+=sizeof(eccParamters);
		res->aeTrustServerSign.signAlg.signAlgParams.length=sizeof(eccParamters);//????????
		signLen+=2;
		signAlgLen+=2;
		
		res->aeTrustServerSign.signAlg.length=signAlgLen;//To set res->aeTrustServerSign.signAlg.length here
		signLen+=2;

		res->aeTrustServerSign.length=signLen;//To set res->aeTrustServerSign.length here

		tmpLen+=(res->aeTrustServerSign.length+3);
	}

	* certVerifyResBufLen=tmpLen;
	
	toRet=SUCCESS;

err:
	if(fd_1!=-1)
		close(fd_1);
	
	if(fd_2!=-1)
		close(fd_2);

	if(tmpBuf4CertVerifyResult!=NULL)
		free(tmpBuf4CertVerifyResult);
	
	return toRet;
}

/*
*    function description: generate wapi verify activate
*
*    parameters:
*    verifyActivate (output): wapi verify activate generated
*
*    return 0: success; return -1: failed
*/
int genVerifyActivate(WAPI_VERIFY_ACTIVATE_Tp verifyActivate)
{
	int ret, toRet;
	unsigned char   serialNumber[10],issuerName[200],subjectName[200];
	int			serialNumLen,issuerLen,subjectLen;
	unsigned char bufCAX509[CERT_DATA_MAX_LEN], bufAEX509[CERT_DATA_MAX_LEN];
	int			CAX509Len, AEX509Len;
	char tmpBuf[100];
	char path[MAX_PATH];
	char cmdline[MAX_PATH];
	unsigned char *p;
	

	//?????, indicted by OID: 1.2.156.11235.1.1.2.1
	unsigned char eccParamters[11]={0x06,0x09,0x2a,0x81,0x1c,0xd7,0x63,0x01,0x01,0x02,0x01};
	
	verifyActivate->flag=0;					//used by wapi driver!!
	memset(verifyActivate->verifyFlag, 0, 32);	//used by wapi driver!!

	//To test CA4AP_CERT if exists
	if(isFileExist(CA4AP_CERT)!=1)
	{
		ERR_PRINT("%s(%d),%s not exist, should install as cert for AP.\n",__FUNCTION__,__LINE__,CA4AP_CERT);//Added for test
		toRet=FAILED;
		goto err;
	}

	//To test AP_CERT if exists
	if(isFileExist(AP_CERT)!=1)
	{
		ERR_PRINT("%s(%d),%s not exist, should install user cert for AP.\n",__FUNCTION__,__LINE__,AP_CERT);//Added for test
		toRet=FAILED;
		goto err;
	}

	get_wifi_bin_dir(path, sizeof(path));
	strcat(path, "/");
	
	//////////////////////
	//To get CA ID from ca cert
#if 1
	sprintf(cmdline, ECDSATEST" -pem2der -in %s -out %s", CA4AP_CERT, CA4AP_DER);
	DEBUG("cmdline=%s\n", cmdline);
	system(cmdline);
	
	sprintf(cmdline, ECDSATEST" -pem2der -in %s -out %s", AP_CERT, AP_CERT_DER);
	DEBUG("cmdline=%s\n", cmdline);
	system(cmdline);
#else
	sprintf(cmdline, OPENSSL" x509 -inform PEM -in %s -outform DER -out %s", CA4AP_CERT, CA4AP_DER);
	//sprintf(cmdline, "%s%s", path, tmpBuf);
	system(cmdline);
	
	sprintf(cmdline, OPENSSL" x509 -inform PEM -in %s -outform DER -out %s", AP_CERT, AP_CERT_DER);
	//sprintf(cmdline, "%s%s", path, tmpBuf);
	system(cmdline);
#endif

	ret=readFile2Str(bufCAX509, &CAX509Len, CA4AP_DER);
	if(ret==FAILED)
	{
		ERR_PRINT("%s(%d),read file failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}
	
	WapiGetParameterFromCert(bufCAX509, CAX509Len, serialNumber, &serialNumLen, issuerName, &issuerLen, subjectName,&subjectLen);
	DEBUG("CAX509Len=%d, serialNumLen=%d, issuerLen=%d,subjectLen=%d\n",CAX509Len, serialNumLen, issuerLen, subjectLen);//Added for test
	//End of get CA ID from ca cert

	ret=readFile2Str(bufAEX509, &AEX509Len, AP_CERT_DER);
	if(ret==FAILED)
	{
		ERR_PRINT("%s(%d),read file failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	//ASU ID (that is CA ID here) get from CA_CERT_DER
	verifyActivate->asuID.idFlag=1;	//For X.509 V3
	p=verifyActivate->asuID.idData;
	memcpy((void *)p, (void *)subjectName, subjectLen);
	memcpy((void *)(p+subjectLen), issuerName, issuerLen);
	memcpy((void *)(p+subjectLen+issuerLen), serialNumber, serialNumLen);
	verifyActivate->asuID.idLen=subjectLen+issuerLen+serialNumLen;

	verifyActivate->aeCert.certFlag=1;	//For X.509 V3
	memcpy(verifyActivate->aeCert.certData, bufAEX509, AEX509Len);
	verifyActivate->aeCert.certLen=AEX509Len;

	verifyActivate->ecdhParms.flag=1;
	memcpy(verifyActivate->ecdhParms.data, eccParamters, sizeof(eccParamters));
	verifyActivate->ecdhParms.length=sizeof(eccParamters);
	///////////////////////////

	toRet=SUCCESS;
err:
	DEBUG("%s(%d)iAS Clientj : toRet=%d\n",__FUNCTION__,__LINE__,toRet);
	return toRet;
}


#if 1
/*
*    function description: generate wapi access verify response into buf
*
*    parameters:
*    buf (output): wapi access verify response generated at buf
*    bufLen(output): length of wapi access verify response generated
*    accessVerifyReq (input): wapi access verify request
*    certVerifyRes (input): wapi cert verify response
*    certVerifyReq (input): wapi cert verify request
*
*    return 0: success; return -1: failed
*/
int genAccessVerifyRes2Buf(unsigned char *buf, int * bufLen, WAPI_ACCESS_VERIFY_REQ_Tp accessVerifyReq, WAPI_CERT_VERIFY_RES_Tp certVerifyRes, WAPI_CERT_VERIFY_REQ_Tp certVerifyReq)
{
	int ret, toRet;
	unsigned char buffer[100];
	int readSize;
	unsigned char   serialNumber[10],issuerName[200],subjectName[200];
	int			serialNumLen,issuerLen,subjectLen;
	unsigned char bufAEX509[CERT_DATA_MAX_LEN];
	int			AEX509Len;
	
	int size;
	int tmpLen, tmpIndex, signAlgLenIndex;

	char tmpBuf[100];
	char path[MAX_PATH];
	char cmdline[MAX_PATH];
	unsigned char *p;
	unsigned char tmpChar;
	unsigned short tmpShort, len, signAlgLen;
	int tmpInt;

	//Initial
	*bufLen=0;

	//?????, indicted by OID: 1.2.156.11235.1.1.2.1
	unsigned char eccParamters[11]={0x06,0x09,0x2a,0x81,0x1c,0xd7,0x63,0x01,0x01,0x02,0x01};

	buf[0]=0;//Initial
	buf[0] |=(accessVerifyReq->flag & 0x03); //set B0, B1
	if((accessVerifyReq->flag & 0x04) == 0x04) 
	{

		//At accessVerifyReq, if B2==1, to verify AE cert
		buf[0] |= 0x08;	//To set B3: use optional compoundCertVerifyRes
	}
	tmpLen=1;

	memcpy((void *)(buf+tmpLen), (void *)(accessVerifyReq->asueChallenge),32);
	tmpLen+=32;

	memcpy((void *)(buf+tmpLen), (void *)(certVerifyReq->aeChallenge),32);
	tmpLen+=32;

	if(certVerifyRes->certVerifyResult.result_1==RES_CERT_VALID)
	{
		tmpChar=RES_ACCESS_SUCCESS;
	}
	else if(certVerifyRes->certVerifyResult.result_1==RES_CERT_ISSUER_UNKNOWN)
	{
		tmpChar=RES_CANNOT_VERIFY_CERT;
	}
	else
	{
		tmpChar=RES_WRONG_CERT;
	}
	//???: when tmpChar=RES_LOCAL_POLICY_FORBID

	memcpy((void *)(buf+tmpLen), (void *)&tmpChar,1);
	tmpLen+=1;

	memcpy((void *)(buf+tmpLen), (void *)&(accessVerifyReq->asueKey.length),1);
	tmpLen+=1;
	
	memcpy((void *)(buf+tmpLen), (void *)(accessVerifyReq->asueKey.content),accessVerifyReq->asueKey.length);
	tmpLen+=accessVerifyReq->asueKey.length;
	DEBUG("iAS Clientj tmpLen=%d asueKey.length=%d\n", tmpLen ,accessVerifyReq->asueKey.length);


	DEBUG("iAS Clientj certFlag=%d asueKey.length=%d\n",accessVerifyReq->asueCert.certFlag,accessVerifyReq->asueKey.length);
	if(certVerifyRes->certVerifyResult.result_1==RES_CERT_VALID)
	{
		//ASUE CERT valid
		ret=readFile2Str(buffer, &tmpInt, TMP_LOCAL_PUB_KEY);
		tmpChar=(unsigned char)tmpInt;
		DEBUG("tmpInt=%d, PUB_KEY_len=%d.\n", tmpInt, tmpChar);//Added for test
		
		if(ret==FAILED)
		{
			ERR_PRINT(",iAS Clientjread file failed.\n");//Added for test
			toRet=FAILED;
			goto err;
		}
		
		memcpy((void *)(buf+tmpLen), (void *)&tmpChar,1);
		tmpLen+=1;
		memcpy((void *)(buf+tmpLen), (void *)buffer,tmpChar);
		tmpLen+=tmpChar;
		DEBUG("iAS Clientj AE kEY_len=%d\n",tmpChar);
	}
	else
	{
		//ASUE CERT not valid
		//AE sec data is set arbitrary
		memset(tmpBuf,0,sizeof(tmpBuf));
		tmpChar=49;
		memcpy((void *)(buf+tmpLen), (void *)&tmpChar,1);
		tmpLen+=1;
		memcpy((void *)(buf+tmpLen), (void *)tmpBuf,tmpChar);
		
		tmpLen+=tmpChar;
		DEBUG("iAS Clientj ASUE CERT not valid\n");
	}



	//To set ae id
	//memcpy((void *)(buf+tmpLen), (void *)&(accessVerifyReq->aeID.idFlag),2);
	*((unsigned short *)(buf+tmpLen))= htons( accessVerifyReq->aeID.idFlag );
	tmpLen+=2;
	DEBUG("iAS Clientj accessVerifyReq->aeID.idFlag=%04x\n",accessVerifyReq->aeID.idFlag);
	
	
	//memcpy((void *)(buf+tmpLen), (void *)(&tmpShort) ,2);
	*((unsigned short *)(buf+tmpLen))=htons(*((unsigned short *)&(accessVerifyReq->aeID.idLen)));
	tmpLen+=2;
	DEBUG("iAS Clientj accessVerifyReq->aeID.idLen=%d\n",accessVerifyReq->aeID.idLen);
	

	memcpy((void *)(buf+tmpLen), (void *)(accessVerifyReq->aeID.idData),accessVerifyReq->aeID.idLen);
	//dumpHex( (const unsigned char *)(buf+tmpLen) , accessVerifyReq->aeID.idLen );	
	tmpLen+=accessVerifyReq->aeID.idLen;


	//To get asue id from accessVerifyReq
	if(accessVerifyReq->asueCert.certFlag==1)
	{
		//X.509 V3
		WapiGetParameterFromCert(accessVerifyReq->asueCert.certData, accessVerifyReq->asueCert.certLen, serialNumber, &serialNumLen, issuerName, &issuerLen, subjectName,&subjectLen);
//		DEBUG(",  accessVerifyReq->asueCert.certLen=%d, serialNumLen=%d, issuerLen=%d,subjectLen=%d\n",accessVerifyReq->asueCert.certLen, serialNumLen, issuerLen, subjectLen);//Added for test

		//tmpShort=1;
		//memcpy((void *)(buf+tmpLen), (void *)&tmpShort,2);
		*((unsigned short *)(buf+tmpLen))= htons( 1 );//asue id
		DEBUG("iAS Clientj tmpShort=%04x %02x-%02x\n",tmpShort,*(char *)(buf+tmpLen),*(char *)(buf+tmpLen+1) );
		
		tmpLen+=2;

		//tmpShort=subjectLen+issuerLen+serialNumLen;
		//memcpy((void *)(buf+tmpLen), (void *)&tmpShort,2);
		*((unsigned short *)(buf+tmpLen))= htons( subjectLen + issuerLen + serialNumLen );
		DEBUG(",subjectLen=%d %issuerLen=d =serialNumLen%d total=%04x\n", subjectLen,issuerLen,serialNumLen,subjectLen+issuerLen+serialNumLen);//Added for test
		tmpLen+=2;
		DEBUG(",iAS Clientjasue id len=%d.\n", subjectLen+issuerLen+serialNumLen);//Added for test
		

		memcpy((void *)(buf+tmpLen), (void *)subjectName,subjectLen);
		tmpLen+=subjectLen;

		memcpy((void *)(buf+tmpLen), (void *)issuerName,issuerLen);
		tmpLen+=issuerLen;

		memcpy((void *)(buf+tmpLen), (void *)serialNumber,serialNumLen);
		tmpLen+=serialNumLen;

		DEBUG("iAS Clientj subjectLen=%d\n",subjectLen);
		DEBUG("iAS Clientj issuerLen=%d\n",issuerLen);
		DEBUG("iAS Clientj serialNumLen=%d\n",serialNumLen);
	}
	else
	{
		ERR_PRINT(",iAS Clientjnon-X.509 not supported now.\n");//Added for test
		toRet=FAILED;
		goto err;
	}

//	DEBUG(", buf[0]=0x%x******************.\n", buf[0]);//Added for test

	if((buf[0] & 0x08) == 0x08)
	{

#if 1
		//To set B3: use optional compoundCertVerifyRes
		//To set certVerifyResult
		DEBUG(",iAS Clientjuse optional compoundCertVerifyRes.\n");//Added for test
		memcpy((void *)(buf+tmpLen), (void *)&(certVerifyRes->certVerifyResult.type),1);
		DEBUG("iAS Clientj certVerifyResult.type=%d\n",certVerifyRes->certVerifyResult.type);
		tmpLen+=1;
		
		//memcpy((void *)(buf+tmpLen), (void *)&(certVerifyRes->certVerifyResult.length),2);//To do: sync cert verify resquest and response process
		*((unsigned short *)(buf+tmpLen))= htons( certVerifyRes->certVerifyResult.length );
		DEBUG("iAS Clientj certVerifyResult.length=%d mem=%02x-%02x\n",certVerifyRes->certVerifyResult.length,*((unsigned char *)(buf+tmpLen)),*((unsigned char *)(buf+tmpLen+1)));
		tmpLen+=2;
		memcpy((void *)(buf+tmpLen), (void *)(certVerifyRes->certVerifyResult.rand_1),32);
		tmpLen+=32;
		memcpy((void *)(buf+tmpLen), (void *)(certVerifyRes->certVerifyResult.rand_2),32);
		tmpLen+=32;
		tmpChar=(unsigned char)(certVerifyRes->certVerifyResult.result_1);
		memcpy((void *)(buf+tmpLen), (void *)&tmpChar,1);
		tmpLen+=1;

		//memcpy((void *)(buf+tmpLen), (void *)&(certVerifyRes->certVerifyResult.cert_1.certFlag),2);
		*((unsigned short *)(buf+tmpLen))= htons( certVerifyRes->certVerifyResult.cert_1.certFlag );
		DEBUG("iAS Clientj cert_1.certFlag=%04x mem=%02x-%02x\n",certVerifyRes->certVerifyResult.cert_1.certFlag,*((unsigned char *)(buf+tmpLen)),*((unsigned char *)(buf+tmpLen+1)));
		tmpLen+=2;
		
		//memcpy((void *)(buf+tmpLen), (void *)&(certVerifyRes->certVerifyResult.cert_1.certLen),2);
		*((unsigned short *)(buf+tmpLen))= htons( certVerifyRes->certVerifyResult.cert_1.certLen );
		DEBUG(",iAS Clientj cert_1.certLen=%d mem=%02x-%02x\n", certVerifyRes->certVerifyResult.cert_1.certLen,*((unsigned char *)(buf+tmpLen)),*((unsigned char *)(buf+tmpLen+1)));
		tmpLen+=2;

		if( certVerifyRes->certVerifyResult.cert_1.certLen )
		{
			memcpy((void *)(buf+tmpLen), (void *)(certVerifyRes->certVerifyResult.cert_1.certData),certVerifyRes->certVerifyResult.cert_1.certLen);
			tmpLen+=certVerifyRes->certVerifyResult.cert_1.certLen;
		}

		tmpChar=(unsigned char)(certVerifyRes->certVerifyResult.result_2);
		memcpy((void *)(buf+tmpLen), (void *)&tmpChar,1);
		tmpLen+=1;
		
		//memcpy((void *)(buf+tmpLen), (void *)&(certVerifyRes->certVerifyResult.cert_2.certFlag),2);
		*((unsigned short *)(buf+tmpLen))= htons( certVerifyRes->certVerifyResult.cert_2.certFlag );
		DEBUG(",iAS Clientjcert_2.certFlag=%04x mem=%02x-%02x\n", certVerifyRes->certVerifyResult.cert_2.certFlag,*((unsigned char *)(buf+tmpLen)),*((unsigned char *)(buf+tmpLen+1)));
		tmpLen+=2;
		
		
		//memcpy((void *)(buf+tmpLen), (void *)&(certVerifyRes->certVerifyResult.cert_2.certLen),2);
		*((unsigned short *)(buf+tmpLen))= htons( certVerifyRes->certVerifyResult.cert_2.certLen );
		DEBUG(",iAS Clientjcert_2.certLen=%d mem=%02x-%02x\n", certVerifyRes->certVerifyResult.cert_2.certLen , *((unsigned char *)(buf+tmpLen)) , *((unsigned char *)(buf+tmpLen+1)) );
		tmpLen+=2;

		if( certVerifyRes->certVerifyResult.cert_2.certLen )
		{
			//DEBUG(",iAS ClientjcertVerifyRes->certVerifyResult.cert_2.certLen=%d.  tmpLen=%d\n", certVerifyRes->certVerifyResult.cert_2.certLen,tmpLen);
			memcpy((void *)(buf+tmpLen), (void *)(certVerifyRes->certVerifyResult.cert_2.certData),certVerifyRes->certVerifyResult.cert_2.certLen);
			tmpLen+=certVerifyRes->certVerifyResult.cert_2.certLen;
		}
		
		//DEBUG(" dump cert_2\n");
		//dumpHex( (const unsigned char *)(buf) , tmpLen );
		


#endif
#if 0
		if(certVerifyRes->certVerifyResult.result_1==RES_CERT_ISSUER_UNKNOWN)
#endif


//timym_dbg
#if 1
		{
			//DEBUG(",only contain aeTrustServerSign\n");//Added for test
			//certVerifyResult not contain asueTrustServerSign, only contain aeTrustServerSign
			memcpy((void *)(buf+tmpLen), (void *)&(certVerifyRes->aeTrustServerSign.type),1);
			tmpLen+=1;
			
			//memcpy((void *)(buf+tmpLen), (void *)&(certVerifyRes->aeTrustServerSign.length),2);
			*((unsigned short *)(buf+tmpLen))= htons( certVerifyRes->aeTrustServerSign.length );
			DEBUG("iAS ClientjaeTrustServerSign.length=%d mem=%02x-%02x\n",certVerifyRes->aeTrustServerSign.length, *((unsigned char *)(buf+tmpLen)) , *((unsigned char *)(buf+tmpLen+1)));
			tmpLen+=2;
			//memcpy((void *)(buf+tmpLen), (void *)&(certVerifyRes->aeTrustServerSign.signId.idFlag),2);
			*((unsigned short *)(buf+tmpLen))= htons( certVerifyRes->aeTrustServerSign.signId.idFlag );
			DEBUG("iAS ClientjsignId.idFlag=%d mem=%02x-%02x\n",certVerifyRes->aeTrustServerSign.signId.idFlag, *((unsigned char *)(buf+tmpLen)) , *((unsigned char *)(buf+tmpLen+1)));
			tmpLen+=2;
			//memcpy((void *)(buf+tmpLen), (void *)&(certVerifyRes->aeTrustServerSign.signId.idLen),2);
			*((unsigned short *)(buf+tmpLen))= htons( certVerifyRes->aeTrustServerSign.signId.idLen );
			DEBUG("iAS ClientjsignId.idLen=%d mem=%02x-%02x\n",certVerifyRes->aeTrustServerSign.signId.idLen, *((unsigned char *)(buf+tmpLen)) , *((unsigned char *)(buf+tmpLen+1)));
			tmpLen+=2;
			
			if( certVerifyRes->aeTrustServerSign.signId.idLen )
			{
				memcpy((void *)(buf+tmpLen), (void *)(certVerifyRes->aeTrustServerSign.signId.idData),certVerifyRes->aeTrustServerSign.signId.idLen);
				tmpLen+=certVerifyRes->aeTrustServerSign.signId.idLen;
			}
			//memcpy((void *)(buf+tmpLen), (void *)&(certVerifyRes->aeTrustServerSign.signAlg.length),2);
			*((unsigned short *)(buf+tmpLen))= htons( certVerifyRes->aeTrustServerSign.signAlg.length );
			DEBUG("iAS ClientjsignAlg.length=%d mem=%02x-%02x\n",certVerifyRes->aeTrustServerSign.signAlg.length, *((unsigned char *)(buf+tmpLen)) , *((unsigned char *)(buf+tmpLen+1)));
			tmpLen+=2;
			memcpy((void *)(buf+tmpLen), (void *)&(certVerifyRes->aeTrustServerSign.signAlg.hashAlgFlag),1);
			tmpLen+=1;
			memcpy((void *)(buf+tmpLen), (void *)&(certVerifyRes->aeTrustServerSign.signAlg.signAlgFlag),1);
			tmpLen+=1;
			memcpy((void *)(buf+tmpLen), (void *)&(certVerifyRes->aeTrustServerSign.signAlg.signAlgParams.flag),1);
			tmpLen+=1;
			//memcpy((void *)(buf+tmpLen), (void *)&(certVerifyRes->aeTrustServerSign.signAlg.signAlgParams.length),2);
			*((unsigned short *)(buf+tmpLen))= htons( certVerifyRes->aeTrustServerSign.signAlg.signAlgParams.length );
			DEBUG(", iAS ClientjsignAlgParams.length=%d %02x-%02x \n",certVerifyRes->aeTrustServerSign.signAlg.signAlgParams.length, *((unsigned short *)(buf+tmpLen))  , *((unsigned short *)(buf+tmpLen+1)) );
			tmpLen+=2;
			
			if( certVerifyRes->aeTrustServerSign.signAlg.signAlgParams.length )
			{
				memcpy((void *)(buf+tmpLen), (void *)(certVerifyRes->aeTrustServerSign.signAlg.signAlgParams.data),certVerifyRes->aeTrustServerSign.signAlg.signAlgParams.length);
				tmpLen+=certVerifyRes->aeTrustServerSign.signAlg.signAlgParams.length;
				
			}
			//memcpy((void *)(buf+tmpLen), (void *)&(certVerifyRes->aeTrustServerSign.signVal.length),2);
			*((unsigned short *)(buf+tmpLen))= htons( certVerifyRes->aeTrustServerSign.signVal.length );
			DEBUG(",iAS Clientj signVal.length=%d mem=%02x-%02x \n",certVerifyRes->aeTrustServerSign.signVal.length,*((unsigned char *)(buf+tmpLen)),*((unsigned char *)(buf+tmpLen+1)));
			tmpLen+=2;
			
			if( certVerifyRes->aeTrustServerSign.signVal.length )
			{
				memcpy((void *)(buf+tmpLen), (void *)(certVerifyRes->aeTrustServerSign.signVal.data),certVerifyRes->aeTrustServerSign.signVal.length);
				tmpLen+=certVerifyRes->aeTrustServerSign.signVal.length;
				
			}
//			DEBUG(",certVerifyRes->aeTrustServerSign.signVal.length=%d###################\n", certVerifyRes->aeTrustServerSign.signVal.length);//Added for test
//			dumpHex(certVerifyRes->aeTrustServerSign.signVal.data, certVerifyRes->aeTrustServerSign.signVal.length);
//			DEBUG(",###################\n");//Added for test
		}
#endif
	}

	ret=signMsg2((char *)buf,tmpLen, AP_CERT, (char *)buffer, &size);

	if ( ret== FAILED)
	{
		ERR_PRINT("%s(%d),signMsg2 failed\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	tmpChar=1;	//signByAe.type=1
	memcpy((void *)(buf+tmpLen), (void *)&tmpChar,1);
	DEBUG("iAS ClientjsignByAe.type=%d\n",*(char *)(buf+tmpLen));
	tmpLen+=1;

	tmpIndex=tmpLen;//To set signByAe.length at last, and use len to record signByAe.length
	len=0;	//To clear it

	tmpLen+=2;	//To skip signByAe.length now!!!

	get_wifi_bin_dir(path, sizeof(path));
	strcat(path, "/");

	//To get AE ID from ap cert
#if 1
	sprintf(cmdline, ECDSATEST" -pem2der -in %s -out %s", AP_CERT,AP_CERT_DER);
#else
	sprintf(cmdline, OPENSSL" x509 -inform PEM -in %s -outform DER -out %s", AP_CERT,AP_CERT_DER);
#endif
	//sprintf(cmdline, "%s%s", path, tmpBuf);
	system(cmdline);
	
	ret=readFile2Str(bufAEX509, &AEX509Len, AP_CERT_DER);
	if(ret==FAILED)
	{
		ERR_PRINT("%s(%d),read file failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}



	WapiGetParameterFromCert(bufAEX509, AEX509Len, serialNumber, &serialNumLen, issuerName, &issuerLen, subjectName,&subjectLen);
	//End of get AE ID from ap cert
	//tmpShort=1;//signByAe.signId.idFlag=1
	//memcpy((void *)(buf+tmpLen), (void *)&tmpShort,2);
	*((unsigned short *)(buf+tmpLen))= htons( 1 );
	DEBUG("AS Clientj signId.idFlag=%04x  \n",*(char *)(buf+tmpLen) );
	tmpLen+=2;
	len+=2;



	tmpShort=subjectLen+issuerLen+serialNumLen;
	//memcpy((void *)(buf+tmpLen), (void *)&tmpShort,2);
	*((unsigned short *)(buf+tmpLen))= htons( tmpShort );
	DEBUG(" subjectLen+issuerLen+serialNumLen=%d\n",tmpShort);
	tmpLen+=2;
	len+=2;


	memcpy((void *)(buf+tmpLen), (void *)subjectName,subjectLen);
	//DEBUG(" dump subjectName,subjectLen=%d\n",issuerLen);
	//dumpHex( (const unsigned char *)(buf+tmpLen) , subjectLen );
	tmpLen+=subjectLen;
	len+=subjectLen;


	memcpy((void *)(buf+tmpLen), (void *)issuerName,issuerLen);
	//DEBUG(" dump issuerName,issuerLen=%d\n",issuerLen);
	//dumpHex( (const unsigned char *)(buf+tmpLen) , issuerLen );
	tmpLen+=issuerLen;
	len+=issuerLen;


	memcpy((void *)(buf+tmpLen), (void *)serialNumber,serialNumLen);
	//DEBUG(" dump serialNumber,serialNumLen=%d\n",serialNumLen);
	//dumpHex( (const unsigned char *)(buf+tmpLen) , serialNumLen );
	tmpLen+=serialNumLen;
	len+=serialNumLen;

	
	signAlgLenIndex=tmpLen;//To set signByAe.signAlg.length afterwards and use signAlgLen to record signByAe.signAlg.length
	signAlgLen=0;		//To clear it

	tmpLen+=2;	//To skip signByAe.signAlg.length now!!!

	tmpChar=1;	//signByAe.signAlg.hashAlgFlag=1;	//SHA-256
	memcpy((void *)(buf+tmpLen), (void *)&tmpChar,1);
	tmpLen+=1;
	len+=1;
	signAlgLen+=1;

	tmpChar=1;	//signByAe.signAlg.signAlgFlag=1;	//ECDSA-192
	memcpy((void *)(buf+tmpLen), (void *)&tmpChar,1);
	tmpLen+=1;
	len+=1;
	signAlgLen+=1;

	tmpChar=1;	//signByAe.signAlg.signAlgParams.flag=1;	// indicated by OID
	memcpy((void *)(buf+tmpLen), (void *)&tmpChar,1);
	tmpLen+=1;
	len+=1;
	signAlgLen+=1;

	tmpShort=sizeof(eccParamters);	//signByAe.signAlg.signAlgParams.length
	//memcpy((void *)(buf+tmpLen), (void *)&tmpShort,2);
	*((unsigned short *)(buf+tmpLen))= htons( tmpShort );
	tmpShort=sizeof(eccParamters);
	DEBUG(" signAlgParams.length=%d\n",tmpShort);
	tmpLen+=2;
	len+=2;
	signAlgLen+=2;

	memcpy((void *)(buf+tmpLen), (void *)eccParamters, tmpShort);	//signByAe.signAlg.signAlgParams.data
	tmpLen+=tmpShort;
	
	//DEBUG("%s(%d)\n", __FUNCTION__,__LINE__);
	//dumpHex( (const unsigned char *)(buf) , tmpShort );
	
	
	len+=tmpShort;
	signAlgLen+=tmpShort;
	


	//signAlgLen = signAlgLen;
	//memcpy((void *)(buf+signAlgLenIndex), (void *)&signAlgLen,2);//To set signByAe.signAlg.length here!!!
	*((unsigned short *)(buf+signAlgLenIndex))= htons( signAlgLen );
	DEBUG("signAlgLen=%d\n",signAlgLen);
	len+=2;


	tmpShort=(unsigned short)size;//signByAe.signVal.length
	//memcpy((void *)(buf+tmpLen), (void *)&tmpShort, 2);
	*((unsigned short *)(buf+tmpLen))= htons( tmpShort );
	DEBUG("iAS Clientj signByAe.signVal.length=%d\n",tmpShort);
	tmpLen+=2;
	len+=2;
	
	
	memcpy((void *)(buf+tmpLen), (void *)buffer, tmpShort);	//To set signByAe.signVal.data
	//DEBUG("signByAe.signVal.data len=%d\n",tmpShort);
	//dumpHex( (const unsigned char *)(buffer) , tmpShort );
	tmpLen+=tmpShort;
	len+=tmpShort;
	



	//len = len;
	 //AE Server Signature length
	//memcpy((void *)(buf+tmpIndex), (void *)&len,2);//To set signByAe.length here!!!
	*((unsigned short *)(buf+tmpIndex))= htons( len );//To set signByAe.length here!!! 
	DEBUG("signByAe.length=%d mem=%02x-%02x\n",len,*((unsigned char *)(buf+tmpIndex)),*((unsigned char *)(buf+tmpIndex6+1)) );


	//DEBUG("dump tmpIndex=%d\n",tmpIndex);
	//dumpHex( (const unsigned char *)(buf) , tmpLen );

	*bufLen=tmpLen;
	toRet=SUCCESS;

//#timmy
//#endif
err:
	return toRet;
}
#endif

/*
*    return 1: AE id at accessVerifyReq matches AE id from AP_CERT_DER
*    return 0: AE id at accessVerifyReq not match AE id from AP_CERT_DER
*    return -1: failed
*/
int checkAeId(WAPI_ACCESS_VERIFY_REQ_Tp accessVerifyReq)
{
	int ret, toRet;
	unsigned char buffer[500];
	int bufLen;
	unsigned char   serialNumber[10],issuerName[200],subjectName[200];
	int			serialNumLen,issuerLen,subjectLen;
	unsigned char bufAEX509[CERT_DATA_MAX_LEN];
	int			AEX509Len;
	char tmpBuf[100];
	char path[MAX_PATH];
	char cmdline[MAX_PATH];
	int size;
	
	get_wifi_bin_dir(path, sizeof(path));
	strcat(path, "/");
	
	//To get AE ID from ap cert
#if 1
	sprintf(cmdline, ECDSATEST" -pem2der -in %s -out %s", AP_CERT,AP_CERT_DER);
#else
	sprintf(cmdline, OPENSSL" x509 -inform PEM -in %s -outform DER -out %s", AP_CERT,AP_CERT_DER);
#endif
	DEBUG("cmdline=%s\n", cmdline);
	system(cmdline);
	
	ret=readFile2Str(bufAEX509, &AEX509Len, AP_CERT_DER);
	if(ret==FAILED)
	{
		ERR_PRINT("%s(%d),read file failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	WapiGetParameterFromCert(bufAEX509, AEX509Len, serialNumber, &serialNumLen, issuerName, &issuerLen, subjectName,&subjectLen);
	DEBUG("%s(%d),  AEX509Len=%d, serialNumLen=%d, issuerLen=%d,subjectLen=%d\n",__FUNCTION__,__LINE__,AEX509Len, serialNumLen, issuerLen, subjectLen);//Added for test
	//End of get AE ID from ap cert

	if(accessVerifyReq->aeID.idFlag!=1)
	{
		ERR_PRINT("%s(%d),not x.509 v3, not supported now.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	bufLen=0;
	memcpy((void *)buffer, (void *)subjectName, subjectLen);
	bufLen+=subjectLen;
	memcpy((void *)(buffer+bufLen), (void *)issuerName, issuerLen);
	bufLen+=issuerLen;
	memcpy((void *)(buffer+bufLen), (void *)serialNumber, serialNumLen);
	bufLen+=serialNumLen;

	if(accessVerifyReq->aeID.idLen==(unsigned short)bufLen)
	{
		if(memcmp((void *)(accessVerifyReq->aeID.idData), (void *)buffer, bufLen)==0)
		{
			DEBUG("%s(%d),AE id matches that at accessVerifyReq.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=1;
			goto err;
		}
	}

	toRet=0;
	
err:
	return toRet;
	
}

/*
*     function description: get ASUE (user) public key from ASUE cert and store it into TMP_USER_PUB_KEY
*
*     return 0: success; return -1: failed
*/
int getAsuePubKeyFromAsueCert(WAPI_CERT_Tp asueCert)
{
	int ret, toRet;
	unsigned char tmpBuf[100];
	char path[MAX_PATH];
	char cmdline[MAX_PATH];

	DEBUG("iAS Clientj  (0x%p)---------------\n",  asueCert);
	if(asueCert->certFlag!=1)
	{
		ERR_PRINT("iAS Clientjnot X.509 v3, not supported now.\n");//Added for test
		toRet=1;
		goto err;
	}

	DEBUG("iAS Clientj---------------certLen=%d\n"asueCert->certLen);
	ret=storeStr2File(TMP_USER_CERT_DER, (const unsigned char *)(asueCert->certData), (const int)(asueCert->certLen));
	if(ret==FAILED)
	{
		ERR_PRINT("iAS ClientjstoreStr2File failed.\n");//Added for test
		toRet=1;
		goto err;
	}
	
	get_wifi_bin_dir(path, sizeof(path));
	strcat(path, "/");


	//To change cert format from DER to PEM
#if 1
	sprintf(cmdline, ECDSATEST" -der2pem -in %s -out %s", TMP_USER_CERT_DER,TMP_USER_CERT);
#else
	sprintf(cmdline, OPENSSL" x509 -inform DER -in %s -outform PEM -out %s", TMP_USER_CERT_DER,TMP_USER_CERT);
#endif
	DEBUG("cmdline=%s\n",cmdline);
	system(cmdline);


	toRet=SUCCESS;
err:
	return toRet;
}

/*
*    function description: parse msg into struct WAPI_ACCESS_VERIFY_REQ_T
*
*    parameters: 
*    accessVerifyReq (output): struct WAPI_ACCESS_VERIFY_REQ_T
*    infoLen (output): length of infomation to be signatured
*    msg (input): message to parse
*    msg(input): length of message to parse
*
*    return 0: success; return -1: failed
*/
int parseBuf2AccessVerifyReq(WAPI_ACCESS_VERIFY_REQ_Tp accessVerifyReq, int * infoLen, const unsigned char * msg, int msgLen)
{
	int ret, toRet;
	int tmpLen;
	int i, len;

	* infoLen=0;//Initial
	
	tmpLen=0;

	DEBUG("iAS ClientjmsgLen=%d---------------\n",msgLen);
	memcpy(&(accessVerifyReq->flag), msg+tmpLen, 1);
	tmpLen+=1;

	DEBUG(")---------------\n");

	memcpy(accessVerifyReq->verifyFlag, msg+tmpLen, 32);
	tmpLen+=32;

	memcpy(accessVerifyReq->asueChallenge, msg+tmpLen, 32);
	tmpLen+=32;

	DEBUG("---------------\n");

	memcpy(&accessVerifyReq->asueKey.length, msg+tmpLen, 1);
	tmpLen+=1;

	memcpy(accessVerifyReq->asueKey.content, msg+tmpLen, accessVerifyReq->asueKey.length);
	tmpLen+=accessVerifyReq->asueKey.length;
//	DEBUG("%s(%d)---------------\n", __FUNCTION__,__LINE__);
//	dumpHex(accessVerifyReq->asueKey.content, (int)(accessVerifyReq->asueKey.length));
//	DEBUG("%s(%d)---------------\n", __FUNCTION__,__LINE__);

	//memcpy(&accessVerifyReq->aeID.idFlag, msg+tmpLen, 2);
	accessVerifyReq->aeID.idFlag=htons(*(unsigned short *)(msg+tmpLen));
	tmpLen+=2;

	//memcpy(&accessVerifyReq->aeID.idLen, msg+tmpLen, 2);
	accessVerifyReq->aeID.idLen=htons(*(unsigned short *)(msg+tmpLen));
	tmpLen+=2;

	memcpy(accessVerifyReq->aeID.idData, msg+tmpLen, accessVerifyReq->aeID.idLen);
	tmpLen+=accessVerifyReq->aeID.idLen;

//	DEBUG("%s(%d)---------------\n", __FUNCTION__,__LINE__);

	//memcpy(&accessVerifyReq->asueCert.certFlag, msg+tmpLen, 2);
	accessVerifyReq->asueCert.certFlag=htons(*(unsigned short *)(msg+tmpLen));
	tmpLen+=2;

	//memcpy(&accessVerifyReq->asueCert.certLen, msg+tmpLen, 2);
	accessVerifyReq->asueCert.certLen=htons(*(unsigned short *)(msg+tmpLen));
	tmpLen+=2;
	
	DEBUG("iAS Clientj asueCert.certLen=%d\n"accessVerifyReq->asueCert.certLen);
	

	memcpy(accessVerifyReq->asueCert.certData, msg+tmpLen, accessVerifyReq->asueCert.certLen);
	tmpLen+=accessVerifyReq->asueCert.certLen;

	memcpy(&accessVerifyReq->ecdhParms.flag, msg+tmpLen, 1);
	tmpLen+=1;

	//memcpy(&accessVerifyReq->ecdhParms.length, msg+tmpLen, 2);
	accessVerifyReq->ecdhParms.length=htons(*(unsigned short *)(msg+tmpLen));
	tmpLen+=2;

	memcpy(accessVerifyReq->ecdhParms.data, msg+tmpLen, accessVerifyReq->ecdhParms.length);
	tmpLen+=accessVerifyReq->ecdhParms.length;

	if((accessVerifyReq->flag & 0x08) == 0x08)
	{
		DEBUG("%s(%d),use optional segment: ASU list trusted by ASUE!\n", __FUNCTION__,__LINE__);
		//B3 is 1, use optional segment: ASU list trusted by ASUE
		memcpy(&accessVerifyReq->asuTrustedbyAsue.type, msg+tmpLen, 1);
		tmpLen+=1;

		//memcpy(&accessVerifyReq->asuTrustedbyAsue.length, msg+tmpLen, 2);//?????
		accessVerifyReq->asuTrustedbyAsue.length=htons(*(unsigned short *)(msg+tmpLen));
		tmpLen+=2;

		memcpy(&accessVerifyReq->asuTrustedbyAsue.reserved, msg+tmpLen, 1);
		tmpLen+=1;

		//memcpy(&accessVerifyReq->asuTrustedbyAsue.idNumber, msg+tmpLen, 2);
		accessVerifyReq->asuTrustedbyAsue.idNumber=htons(*(unsigned short *)(msg+tmpLen));
		tmpLen+=2;

		if(ntohs(accessVerifyReq->asuTrustedbyAsue.idNumber)>ID_MAX_NUMBER )
		{
			ERR_PRINT("%s(%d),error: accessVerifyReq.asuTrustedbyAsue.idNumber>ID_MAX_NUMBER\n",__FUNCTION__,__LINE__);//Added for test
			toRet=1;
			goto err;
		}
		
		for(i=0; i<ntohs(accessVerifyReq->asuTrustedbyAsue.idNumber); i++ )
		{
			//memcpy(&accessVerifyReq->asuTrustedbyAsue.idListData[i].idFlag, msg+tmpLen, 2);
			accessVerifyReq->asuTrustedbyAsue.idListData[i].idFlag=htons(*(unsigned short *)(msg+tmpLen));
			tmpLen+=2;

			//memcpy(&accessVerifyReq->asuTrustedbyAsue.idListData[i].idLen, msg+tmpLen, 2);
			accessVerifyReq->asuTrustedbyAsue.idListData[i].idLen=htons(*(unsigned short *)(msg+tmpLen));
			tmpLen+=2;

			memcpy(accessVerifyReq->asuTrustedbyAsue.idListData[i].idData, msg+tmpLen, accessVerifyReq->asuTrustedbyAsue.idListData[i].idLen);
			tmpLen+=accessVerifyReq->asuTrustedbyAsue.idListData[i].idLen;
		}
	}

//	DEBUG("%s(%d)---------------\n", __FUNCTION__,__LINE__);
	
	if(tmpLen>=msgLen)
	{
		ERR_PRINT("%s(%d),error: tmpLen>=msgLen\n",__FUNCTION__,__LINE__);//Added for test
		toRet=1;
		goto err;
	}

	* infoLen=tmpLen;
//	DEBUG("%s(%d), tmpLen=%d, msgLen=%d---------------\n", __FUNCTION__,__LINE__, tmpLen, msgLen);

	memcpy(&accessVerifyReq->signByAsue.type, msg+tmpLen, 1);
	tmpLen+=1;

	memcpy(&accessVerifyReq->signByAsue.length, msg+tmpLen, 2);
	tmpLen+=2;

	memcpy(&accessVerifyReq->signByAsue.signId.idFlag, msg+tmpLen, 2);
	tmpLen+=2;

	memcpy(&accessVerifyReq->signByAsue.signId.idLen, msg+tmpLen, 2);
	tmpLen+=2;

	memcpy(accessVerifyReq->signByAsue.signId.idData, msg+tmpLen, ntohs(accessVerifyReq->signByAsue.signId.idLen));
	tmpLen+=ntohs(accessVerifyReq->signByAsue.signId.idLen);

//	DEBUG("%s(%d)---------------\n", __FUNCTION__,__LINE__);

	memcpy(&accessVerifyReq->signByAsue.signAlg.length, msg+tmpLen, 2);
	tmpLen+=2;

	memcpy(&accessVerifyReq->signByAsue.signAlg.hashAlgFlag, msg+tmpLen, 1);
	tmpLen+=1;

	memcpy(&accessVerifyReq->signByAsue.signAlg.signAlgFlag, msg+tmpLen, 1);
	tmpLen+=1;

	memcpy(&accessVerifyReq->signByAsue.signAlg.signAlgParams.flag, msg+tmpLen, 1);
	tmpLen+=1;

	memcpy(&accessVerifyReq->signByAsue.signAlg.signAlgParams.length, msg+tmpLen, 2);
	tmpLen+=2;

	memcpy(accessVerifyReq->signByAsue.signAlg.signAlgParams.data, msg+tmpLen, ntohs(accessVerifyReq->signByAsue.signAlg.signAlgParams.length));
	tmpLen+=ntohs(accessVerifyReq->signByAsue.signAlg.signAlgParams.length);

	memcpy(&accessVerifyReq->signByAsue.signVal.length, msg+tmpLen, 2);
	tmpLen+=2;
//	DEBUG("%s(%d), accessVerifyReq->signByAsue.signVal.length=%d---------------\n", __FUNCTION__,__LINE__, accessVerifyReq->signByAsue.signVal.length);

	memcpy(accessVerifyReq->signByAsue.signVal.data, msg+tmpLen, ntohs(accessVerifyReq->signByAsue.signVal.length));
	tmpLen+=ntohs(accessVerifyReq->signByAsue.signVal.length);

	if(tmpLen>msgLen)
	{
		ERR_PRINT("%s(%d),error:tmpLen>msgLen\n",__FUNCTION__,__LINE__);//Added for test
		toRet=1;
		goto err;
	}

	DEBUG("iAS Clientj tmpLen=%d, msgLen=%d---------------\n",tmpLen, msgLen);

	toRet=SUCCESS;
err:
	return toRet;
}
